/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jss;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.net.jss.IPasswordStore;
import org.apache.tomcat.util.net.jss.PlainPasswordFile;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.InitializationValues;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.ssl.SSLHandshakeCompletedEvent;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocketListener;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TomcatJSS
implements SSLSocketListener {
    public static final Logger logger = LoggerFactory.getLogger(TomcatJSS.class);
    public static final TomcatJSS INSTANCE = new TomcatJSS();
    public static final int MAX_LOGIN_ATTEMPTS = 3;
    public static final String CATALINA_BASE = "catalina.base";
    Collection<SSLSocketListener> socketListeners = new ArrayList<SSLSocketListener>();
    String certdbDir;
    CryptoManager manager;
    String passwordClass;
    String passwordFile;
    IPasswordStore passwordStore;
    String serverCertNickFile;
    String serverCertNick;
    String clientAuth = "want";
    boolean requireClientAuth;
    boolean wantClientAuth;
    boolean enableOCSP;
    String ocspResponderURL;
    String ocspResponderCertNickname;
    int ocspCacheSize = 1000;
    int ocspMinCacheEntryDuration = 3600;
    int ocspMaxCacheEntryDuration = 86400;
    int ocspTimeout = 60;
    String strictCiphers;
    boolean boolStrictCiphers;
    String sslRangeCiphers;
    String sslOptions;
    String ssl2Ciphers;
    String ssl3Ciphers;
    String tlsCiphers;
    boolean initialized;

    public static TomcatJSS getInstance() {
        return INSTANCE;
    }

    public void addSocketListener(SSLSocketListener listener) {
        this.socketListeners.add(listener);
    }

    public void removeSocketListener(SSLSocketListener listener) {
        this.socketListeners.remove(listener);
    }

    public Collection<SSLSocketListener> getSocketListeners() {
        return this.socketListeners;
    }

    public String getCertdbDir() {
        return this.certdbDir;
    }

    public void setCertdbDir(String certdbDir) {
        this.certdbDir = certdbDir;
    }

    public String getPasswordClass() {
        return this.passwordClass;
    }

    public void setPasswordClass(String passwordClass) {
        this.passwordClass = passwordClass;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public String getServerCertNickFile() {
        return this.serverCertNickFile;
    }

    public IPasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setPasswordStore(IPasswordStore passwordStore) {
        this.passwordStore = passwordStore;
    }

    public void setServerCertNickFile(String serverCertNickFile) {
        this.serverCertNickFile = serverCertNickFile;
    }

    public String getServerCertNick() {
        return this.serverCertNick;
    }

    public void setServerCertNick(String serverCertNick) {
        this.serverCertNick = serverCertNick;
    }

    public String getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(String clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean getRequireClientAuth() {
        return this.requireClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public boolean getEnableOCSP() {
        return this.enableOCSP;
    }

    public void setEnableOCSP(boolean enableOCSP) {
        this.enableOCSP = enableOCSP;
    }

    public String getOcspResponderURL() {
        return this.ocspResponderURL;
    }

    public void setOcspResponderURL(String ocspResponderURL) {
        this.ocspResponderURL = ocspResponderURL;
    }

    public String getOcspResponderCertNickname() {
        return this.ocspResponderCertNickname;
    }

    public void setOcspResponderCertNickname(String ocspResponderCertNickname) {
        this.ocspResponderCertNickname = ocspResponderCertNickname;
    }

    public int getOcspCacheSize() {
        return this.ocspCacheSize;
    }

    public void setOcspCacheSize(int ocspCacheSize) {
        this.ocspCacheSize = ocspCacheSize;
    }

    public int getOcspMinCacheEntryDuration() {
        return this.ocspMinCacheEntryDuration;
    }

    public void setOcspMinCacheEntryDuration(int ocspMinCacheEntryDuration) {
        this.ocspMinCacheEntryDuration = ocspMinCacheEntryDuration;
    }

    public int getOcspMaxCacheEntryDuration() {
        return this.ocspMaxCacheEntryDuration;
    }

    public void setOcspMaxCacheEntryDuration(int ocspMaxCacheEntryDuration) {
        this.ocspMaxCacheEntryDuration = ocspMaxCacheEntryDuration;
    }

    public int getOcspTimeout() {
        return this.ocspTimeout;
    }

    public void setOcspTimeout(int ocspTimeout) {
        this.ocspTimeout = ocspTimeout;
    }

    public void loadJSSConfig(String jssConf) throws IOException {
        File configFile = new File(jssConf);
        this.loadJSSConfig(configFile);
    }

    public void loadJSSConfig(File configFile) throws IOException {
        Properties config = new Properties();
        try (FileReader fr = new FileReader(configFile);){
            config.load(fr);
            this.loadJSSConfig(config);
        }
    }

    public void loadJSSConfig(Properties config) {
        String ocspTimeoutProp;
        String ocspMaxCacheEntryDurationProp;
        String ocspMinCacheEntryDurationProp;
        String ocspCacheSizeProp;
        String ocspResponderCertNicknameProp;
        String ocspResponderURLProp;
        String enableOCSPProp;
        String passwordFileProp;
        String passwordClassProp;
        String certdbDirProp = config.getProperty("certdbDir");
        if (certdbDirProp != null) {
            this.setCertdbDir(certdbDirProp);
        }
        if ((passwordClassProp = config.getProperty("passwordClass")) != null) {
            this.setPasswordClass(passwordClassProp);
        }
        if ((passwordFileProp = config.getProperty("passwordFile")) != null) {
            this.setPasswordFile(passwordFileProp);
        }
        if ((enableOCSPProp = config.getProperty("enableOCSP")) != null) {
            this.setEnableOCSP(Boolean.parseBoolean(enableOCSPProp));
        }
        if ((ocspResponderURLProp = config.getProperty("ocspResponderURL")) != null) {
            this.setOcspResponderURL(ocspResponderURLProp);
        }
        if ((ocspResponderCertNicknameProp = config.getProperty("ocspResponderCertNickname")) != null) {
            this.setOcspResponderCertNickname(ocspResponderCertNicknameProp);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspCacheSizeProp = config.getProperty("ocspCacheSize")))) {
            this.setOcspCacheSize(Integer.parseInt(ocspCacheSizeProp));
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspMinCacheEntryDurationProp = config.getProperty("ocspMinCacheEntryDuration")))) {
            this.setOcspMinCacheEntryDuration(Integer.parseInt(ocspMinCacheEntryDurationProp));
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspMaxCacheEntryDurationProp = config.getProperty("ocspMaxCacheEntryDuration")))) {
            this.setOcspMaxCacheEntryDuration(Integer.parseInt(ocspMaxCacheEntryDurationProp));
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspTimeoutProp = config.getProperty("ocspTimeout")))) {
            this.setOcspTimeout(Integer.parseInt(ocspTimeoutProp));
        }
    }

    public void loadTomcatConfig(String serverXml) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        File configFile = new File(serverXml);
        this.loadTomcatConfig(configFile);
    }

    public void loadTomcatConfig(File configFile) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(configFile);
        this.loadTomcatConfig(document);
    }

    public void loadTomcatConfig(Document document) throws XPathExpressionException {
        String ocspTimeoutProp;
        String ocspMaxCacheEntryDurationProp;
        String ocspMinCacheEntryDurationProp;
        String ocspCacheSizeProp;
        String ocspResponderCertNicknameProp;
        String ocspResponderURLProp;
        String enableOCSPProp;
        String serverCertNickFileProp;
        String passwordFileProp;
        String passwordClassProp;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        Element connector = (Element)xpath.evaluate("/Server/Service[@name='Catalina']/Connector[@SSLEnabled='true']", document, XPathConstants.NODE);
        String certDbProp = connector.getAttribute("certdbDir");
        if (certDbProp != null) {
            this.setCertdbDir(certDbProp);
        }
        if ((passwordClassProp = connector.getAttribute("passwordClass")) != null) {
            this.setPasswordClass(passwordClassProp);
        }
        if ((passwordFileProp = connector.getAttribute("passwordFile")) != null) {
            this.setPasswordFile(passwordFileProp);
        }
        if ((serverCertNickFileProp = connector.getAttribute("serverCertNickFile")) != null) {
            this.setServerCertNickFile(serverCertNickFileProp);
        }
        if ((enableOCSPProp = connector.getAttribute("enableOCSP")) != null) {
            this.setEnableOCSP(Boolean.parseBoolean(enableOCSPProp));
        }
        if ((ocspResponderURLProp = connector.getAttribute("ocspResponderURL")) != null) {
            this.setOcspResponderURL(ocspResponderURLProp);
        }
        if ((ocspResponderCertNicknameProp = connector.getAttribute("ocspResponderCertNickname")) != null) {
            this.setOcspResponderCertNickname(ocspResponderCertNicknameProp);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspCacheSizeProp = connector.getAttribute("ocspCacheSize")))) {
            this.setOcspCacheSize(Integer.parseInt(ocspCacheSizeProp));
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspMinCacheEntryDurationProp = connector.getAttribute("ocspMinCacheEntryDuration")))) {
            this.setOcspMinCacheEntryDuration(Integer.parseInt(ocspMinCacheEntryDurationProp));
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspMaxCacheEntryDurationProp = connector.getAttribute("ocspMaxCacheEntryDuration")))) {
            this.setOcspMaxCacheEntryDuration(Integer.parseInt(ocspMaxCacheEntryDurationProp));
        }
        if (StringUtils.isNotEmpty((CharSequence)(ocspTimeoutProp = connector.getAttribute("ocspTimeout")))) {
            this.setOcspTimeout(Integer.parseInt(ocspTimeoutProp));
        }
    }

    public void loadConfig() throws IOException, XPathExpressionException, ParserConfigurationException, SAXException {
        String catalinaBase = System.getProperty(CATALINA_BASE);
        String jssConf = catalinaBase + "/conf/jss.conf";
        File configFile = new File(jssConf);
        if (configFile.exists()) {
            logger.info("TomcatJSS: Loading JSS configuration from {}", (Object)jssConf);
            this.loadJSSConfig(configFile);
        } else {
            String serverXml = catalinaBase + "/conf/server.xml";
            logger.info("TomcatJSS: Loading JSS configuration from {}", (Object)serverXml);
            this.loadTomcatConfig(serverXml);
        }
    }

    public void init() throws KeyDatabaseException, CertDatabaseException, GeneralSecurityException, NotInitializedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, IOException, NoSuchTokenException, TokenException, ConfigurationException {
        if (this.initialized) {
            return;
        }
        logger.info("TomcatJSS: initialization");
        if (this.certdbDir == null) {
            this.certdbDir = System.getProperty(CATALINA_BASE) + File.separator + "alias";
        }
        logger.debug("TomcatJSS: certdbDir: {}", (Object)this.certdbDir);
        if (this.passwordClass == null) {
            this.passwordClass = PlainPasswordFile.class.getName();
        }
        logger.debug("TomcatJSS: passwordClass: {}", (Object)this.passwordClass);
        if (this.passwordFile == null) {
            this.passwordFile = System.getProperty(CATALINA_BASE) + File.separator + "conf" + File.separator + "password.conf";
        }
        logger.debug("TomcatJSS: passwordFile: {}", (Object)this.passwordFile);
        if (StringUtils.isNotEmpty((CharSequence)this.serverCertNickFile)) {
            logger.debug("TomcatJSS: serverCertNickFile: {}", (Object)this.serverCertNickFile);
        }
        InitializationValues vals = new InitializationValues(this.certdbDir);
        vals.removeSunProvider = false;
        vals.installJSSProvider = true;
        try {
            CryptoManager.initialize((InitializationValues)vals);
        }
        catch (AlreadyInitializedException e) {
            logger.warn("TomcatJSS: {}", (Object)e, (Object)e);
        }
        this.manager = CryptoManager.getInstance();
        this.passwordStore = (IPasswordStore)Class.forName(this.passwordClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.passwordStore.init(this.passwordFile);
        this.login();
        if (StringUtils.isNotEmpty((CharSequence)this.serverCertNickFile)) {
            this.serverCertNick = new String(Files.readAllBytes(Paths.get(this.serverCertNickFile, new String[0]))).trim();
            logger.debug("serverCertNick: {}", (Object)this.serverCertNick);
        }
        logger.debug("clientAuth: {}", (Object)this.clientAuth);
        if (this.clientAuth.equalsIgnoreCase("true")) {
            this.requireClientAuth = true;
        } else if (this.clientAuth.equalsIgnoreCase("yes")) {
            this.requireClientAuth = true;
            logger.warn("The \"yes\" value for clientAuth has been deprecated. Use \"true\" instead.");
        } else if (this.clientAuth.equalsIgnoreCase("want")) {
            this.wantClientAuth = true;
        }
        logger.debug("requireClientAuth: {}", (Object)this.requireClientAuth);
        logger.debug("wantClientAuth: {}", (Object)this.wantClientAuth);
        if (this.requireClientAuth || this.wantClientAuth) {
            this.configureOCSP();
        }
        SSLServerSocket.configServerSessionIDCache((int)0, (int)43200, (int)43200, null);
        logger.info("TomcatJSS: initialization complete");
        this.initialized = true;
    }

    public void login() throws NoSuchTokenException, TokenException {
        logger.debug("TomcatJSS: logging into tokens");
        Enumeration<String> tags = this.passwordStore.getTags();
        while (tags.hasMoreElements()) {
            String tag = tags.nextElement();
            if (!tag.equals("internal") && !tag.startsWith("hardware-")) continue;
            this.login(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String tag) throws NoSuchTokenException, TokenException {
        CryptoToken token = this.getToken(tag);
        if (token.isLoggedIn()) {
            logger.debug("TomcatJSS: already logged into {}", (Object)tag);
            return;
        }
        logger.debug("TomcatJSS: logging into {}", (Object)tag);
        int iteration = 0;
        do {
            String strPassword;
            if ((strPassword = this.passwordStore.getPassword(tag, iteration)) == null) {
                logger.debug("TomcatJSS: no password for {}", (Object)tag);
                return;
            }
            Password password = new Password(strPassword.toCharArray());
            try {
                token.login((PasswordCallback)password);
                return;
            }
            catch (IncorrectPasswordException e) {
                logger.warn("TomcatJSS: incorrect password");
            }
            finally {
                password.clear();
            }
        } while (++iteration < 3);
        logger.error("TomcatJSS: failed to log into {}", (Object)tag);
    }

    public CryptoToken getToken(String tag) throws NoSuchTokenException {
        if (tag.equals("internal")) {
            return this.manager.getInternalKeyStorageToken();
        }
        if (tag.startsWith("hardware-")) {
            String tokenName = tag.substring(9);
            return this.manager.getTokenByName(tokenName);
        }
        return null;
    }

    public void configureOCSP() throws GeneralSecurityException, ConfigurationException {
        logger.info("configuring OCSP");
        logger.debug("enableOCSP: {}", (Object)this.enableOCSP);
        if (!this.enableOCSP) {
            return;
        }
        logger.debug("ocspResponderURL: {}", (Object)this.ocspResponderURL);
        if (StringUtils.isEmpty((CharSequence)this.ocspResponderURL)) {
            this.ocspResponderURL = null;
        }
        logger.debug("ocspResponderCertNickname: {}", (Object)this.ocspResponderCertNickname);
        if (StringUtils.isEmpty((CharSequence)this.ocspResponderCertNickname)) {
            this.ocspResponderCertNickname = null;
        }
        if (this.ocspResponderURL == null && this.ocspResponderCertNickname != null) {
            throw new ConfigurationException("Missing OCSP responder URL");
        }
        if (this.ocspResponderURL != null && this.ocspResponderCertNickname == null) {
            throw new ConfigurationException("Missing OCSP responder certificate nickname");
        }
        this.manager.configureOCSP(true, this.ocspResponderURL, this.ocspResponderCertNickname);
        logger.debug("ocspCacheSize: {}", (Object)this.ocspCacheSize);
        logger.debug("ocspMinCacheEntryDuration: {}", (Object)this.ocspMinCacheEntryDuration);
        logger.debug("ocspMaxCacheEntryDuration: {}", (Object)this.ocspMaxCacheEntryDuration);
        this.manager.OCSPCacheSettings(this.ocspCacheSize, this.ocspMinCacheEntryDuration, this.ocspMaxCacheEntryDuration);
        logger.debug("ocspTimeout: {}", (Object)this.ocspTimeout);
        this.manager.setOCSPTimeout(this.ocspTimeout);
    }

    public void alertReceived(SSLAlertEvent event) {
        for (SSLSocketListener listener : this.socketListeners) {
            listener.alertReceived(event);
        }
    }

    public void alertSent(SSLAlertEvent event) {
        for (SSLSocketListener listener : this.socketListeners) {
            listener.alertSent(event);
        }
    }

    public void handshakeCompleted(SSLHandshakeCompletedEvent event) {
        for (SSLSocketListener listener : this.socketListeners) {
            listener.handshakeCompleted(event);
        }
    }
}

