# Authors:
#     Endi S. Dewata <edewata@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright (C) 2013 Red Hat, Inc.
# All rights reserved.
#

from __future__ import absolute_import
import os
from lxml import etree

import pki.server.upgrade


class EnableSessionInAuthenticator(
        pki.server.upgrade.PKIServerUpgradeScriptlet):

    def __init__(self):
        super(EnableSessionInAuthenticator, self).__init__()
        self.message = 'Enable session in authenticator'
        self.parser = etree.XMLParser(remove_blank_text=True)

    def upgrade_subsystem(self, instance, subsystem):

        context_xml = os.path.join(
            instance.base_dir, 'webapps', subsystem.name, 'META-INF', 'context.xml')
        self.backup(context_xml)

        document = etree.parse(context_xml, self.parser)

        self.enable_session(document)

        with open(context_xml, 'wb') as f:
            document.write(f, pretty_print=True, encoding='utf-8')

    def enable_session(self, document):

        context = document.getroot()
        valves = context.findall('Valve')
        authenticator = None

        # Find existing authenticator
        for valve in valves:
            className = valve.get('className')
            if className != 'com.netscape.cms.tomcat.SSLAuthenticatorWithFallback':
                continue

            # Found existing authenticator
            authenticator = valve
            break

        if authenticator is None:
            raise Exception('Missing SSLAuthenticatorWithFallback')

        # Update authenticator's attributes
        authenticator.set('alwaysUseSession', 'true')
