[Glean](README.md)

# User Guides

- [Adding Glean to your project](user/adding-glean-to-your-project/index.md)
  - [Kotlin](user/adding-glean-to-your-project/kotlin.md)
  - [Swift](user/adding-glean-to-your-project/swift.md)
  - [Python](user/adding-glean-to-your-project/python.md)
  - [Rust](user/adding-glean-to-your-project/rust.md)
  - [JavaScript](user/adding-glean-to-your-project/javascript.md)
  - [Qt/QML](user/adding-glean-to-your-project/qt.md)
  - [Enable data ingestion](user/adding-glean-to-your-project/enable-data-ingestion.md)
- [Integrating Glean for project managers](user/integrating-glean-for-product-managers.md)
- [Metrics](user/metrics/adding-new-metrics.md)
    - [Adding new metrics](user/metrics/adding-new-metrics.md)
    - [Testing metrics](user/metrics/testing-metrics.md)
    - [Validating metrics](user/metrics/validation-checklist.md)
    - [Error reporting](user/metrics/error-reporting.md)
    - [Metrics collected by the Glean SDKs](user/collected-metrics/metrics.md)
    - [Enable and Disable metrics using Nimbus](user/metrics/metrics-remote-settings.md)
- [Pings](user/pings/index.md)
    - [Adding new custom pings](user/pings/custom.md)
    - [Testing custom pings](user/pings/testing-custom-pings.md)
    - [Pings sent by Glean](user/pings/sent-by-glean.md)
        - [Baseline Ping](user/pings/baseline.md)
        - [Deletion Request Ping](user/pings/deletion-request.md)
        - [Events Ping](user/pings/events.md)
        - [Metrics Ping](user/pings/metrics.md)
        - [Schedules and timings overview](user/pings/ping-schedules-and-timings.md)
- [Debugging products using Glean](user/debugging/index.md)
    - [Android](user/debugging/android.md)
    - [iOS](user/debugging/ios.md)
    - [Python](user/debugging/python.md)
    - [JavaScript](user/debugging/javascript.md)
# API Reference

- [YAML Registry Format](reference/yaml/index.md)
    - [Metrics](reference/yaml/metrics.md)
    - [Pings](reference/yaml/pings.md)
    - [Tags](reference/yaml/tags.md)
- [General API](reference/general/index.md)
    - [Initializing](reference/general/initializing.md)
    - [Toggling upload status](reference/general/toggling-upload-status.md)
    - [Annotating experiments](reference/general/experiments-api.md)
    - [Registering custom pings](reference/general/register-custom-pings.md)
    - [Shut down](reference/general/shutdown.md)
- [Debugging](reference/debug/index.md)
    - [Log pings](reference/debug/logPings.md)
    - [Debug View Tag](reference/debug/debugViewTag.md)
    - [Source Tags](reference/debug/sourceTags.md)
- [Metric types](reference/metrics/index.md)
    - [Boolean](reference/metrics/boolean.md)
    - [Labeled Booleans](reference/metrics/labeled_booleans.md)
    - [Counter](reference/metrics/counter.md)
    - [Labeled Counters](reference/metrics/labeled_counters.md)
    - [String](reference/metrics/string.md)
    - [Labeled Strings](reference/metrics/labeled_strings.md)
    - [String List](reference/metrics/string_list.md)
    - [Timespan](reference/metrics/timespan.md)
    - [Timing Distribution](reference/metrics/timing_distribution.md)
    - [Memory Distribution](reference/metrics/memory_distribution.md)
    - [UUID](reference/metrics/uuid.md)
    - [URL](reference/metrics/url.md)
    - [Datetime](reference/metrics/datetime.md)
    - [Event](reference/metrics/event.md)
    - [Custom Distribution](reference/metrics/custom_distribution.md)
    - [Quantity](reference/metrics/quantity.md)
    - [Rate](reference/metrics/rate.md)
    - [Text](reference/metrics/text.md)
- [Pings](reference/pings/index.md)

# SDK Specific Information

- [Overview](language-bindings/index.md)
- [Android](language-bindings/android/index.md)
    - [Android build configuration options](language-bindings/android/android-build-configuration-options.md)
    - [Android offline builds](language-bindings/android/android-offline-builds.md)
    - [Instrumenting Android crashes with Glean](language-bindings/android/instrument-android-crashes-example.md)
- [iOS](language-bindings/ios/index.md)
    - [iOS build configuration options](language-bindings/ios/ios-build-configuration-options.md)
- [JavaScript](language-bindings/javascript/index.md)
    - [Command Line Interface](language-bindings/javascript/cli.md)
    - [Plugins](language-bindings/javascript/plugins/index.md)
        - [Ping Encryption Plugin](language-bindings/javascript/plugins/encryption.md)
# Appendix

- [Glossary](appendix/glossary.md)
- [Changelog](appendix/changelog/index.md)
    - [mozilla/glean](appendix/changelog/sdk.md)
    - [mozilla/glean.js](appendix/changelog/js.md)
- [This Week in Glean](appendix/twig.md)
- [Contribution Guidelines](appendix/contribution-guidelines.md)
