; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK

define arm_aapcs_vfpcc i32 @and_v2i32(<2 x i32> %x) {
; CHECK-LABEL: and_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.and.v2i32(<2 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @and_v4i32(<4 x i32> %x) {
; CHECK-LABEL: and_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @and_v8i32(<8 x i32> %x) {
; CHECK-LABEL: and_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.and.v8i32(<8 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i16 @and_v4i16(<4 x i16> %x) {
; CHECK-LABEL: and_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.and.v4i16(<4 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i16 @and_v8i16(<8 x i16> %x) {
; CHECK-LABEL: and_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.and.v8i16(<8 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i16 @and_v16i16(<16 x i16> %x) {
; CHECK-LABEL: and_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i8 @and_v8i8(<8 x i8> %x) {
; CHECK-LABEL: and_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.and.v8i8(<8 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i8 @and_v16i8(<16 x i8> %x) {
; CHECK-LABEL: and_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.u8 r1, q0[8]
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov.u8 r1, q0[4]
; CHECK-NEXT:    vmov.u8 r2, q0[0]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.and.v16i8(<16 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i8 @and_v32i8(<32 x i8> %x) {
; CHECK-LABEL: and_v32i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.u8 r1, q0[8]
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    vmov.u8 r1, q0[4]
; CHECK-NEXT:    vmov.u8 r2, q0[0]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.and.v32i8(<32 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i64 @and_v1i64(<1 x i64> %x) {
; CHECK-LABEL: and_v1i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.and.v1i64(<1 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @and_v2i64(<2 x i64> %x) {
; CHECK-LABEL: and_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    ands r0, r2
; CHECK-NEXT:    ands r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.and.v2i64(<2 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @and_v4i64(<4 x i64> %x) {
; CHECK-LABEL: and_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    ands r0, r2
; CHECK-NEXT:    ands r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.and.v4i64(<4 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i32 @and_v2i32_acc(<2 x i32> %x, i32 %y) {
; CHECK-LABEL: and_v2i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, s2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.and.v2i32(<2 x i32> %x)
  %r = and i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @and_v4i32_acc(<4 x i32> %x, i32 %y) {
; CHECK-LABEL: and_v4i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %x)
  %r = and i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @and_v8i32_acc(<8 x i32> %x, i32 %y) {
; CHECK-LABEL: and_v8i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.and.v8i32(<8 x i32> %x)
  %r = and i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i16 @and_v4i16_acc(<4 x i16> %x, i16 %y) {
; CHECK-LABEL: and_v4i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.and.v4i16(<4 x i16> %x)
  %r = and i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i16 @and_v8i16_acc(<8 x i16> %x, i16 %y) {
; CHECK-LABEL: and_v8i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.and.v8i16(<8 x i16> %x)
  %r = and i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i16 @and_v16i16_acc(<16 x i16> %x, i16 %y) {
; CHECK-LABEL: and_v16i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %x)
  %r = and i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i8 @and_v8i8_acc(<8 x i8> %x, i8 %y) {
; CHECK-LABEL: and_v8i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.and.v8i8(<8 x i8> %x)
  %r = and i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i8 @and_v16i8_acc(<16 x i8> %x, i8 %y) {
; CHECK-LABEL: and_v16i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u8 r1, q0[12]
; CHECK-NEXT:    vmov.u8 r2, q0[8]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov.u8 r2, q0[4]
; CHECK-NEXT:    vmov.u8 r3, q0[0]
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.and.v16i8(<16 x i8> %x)
  %r = and i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i8 @and_v32i8_acc(<32 x i8> %x, i8 %y) {
; CHECK-LABEL: and_v32i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov.u8 r1, q0[12]
; CHECK-NEXT:    vmov.u8 r2, q0[8]
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    vmov.u8 r2, q0[4]
; CHECK-NEXT:    vmov.u8 r3, q0[0]
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.and.v32i8(<32 x i8> %x)
  %r = and i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i64 @and_v1i64_acc(<1 x i64> %x, i64 %y) {
; CHECK-LABEL: and_v1i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    ands r0, r2
; CHECK-NEXT:    ands r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.and.v1i64(<1 x i64> %x)
  %r = and i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @and_v2i64_acc(<2 x i64> %x, i64 %y) {
; CHECK-LABEL: and_v2i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    vmov r3, lr, d0
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r0, r2
; CHECK-NEXT:    and.w r2, lr, r12
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %z = call i64 @llvm.vector.reduce.and.v2i64(<2 x i64> %x)
  %r = and i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @and_v4i64_acc(<4 x i64> %x, i64 %y) {
; CHECK-LABEL: and_v4i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vand q0, q0, q1
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    vmov r3, lr, d0
; CHECK-NEXT:    ands r2, r3
; CHECK-NEXT:    ands r0, r2
; CHECK-NEXT:    and.w r2, lr, r12
; CHECK-NEXT:    ands r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %z = call i64 @llvm.vector.reduce.and.v4i64(<4 x i64> %x)
  %r = and i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i32 @or_v2i32(<2 x i32> %x) {
; CHECK-LABEL: or_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.or.v2i32(<2 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @or_v4i32(<4 x i32> %x) {
; CHECK-LABEL: or_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.or.v4i32(<4 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @or_v8i32(<8 x i32> %x) {
; CHECK-LABEL: or_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.or.v8i32(<8 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i16 @or_v4i16(<4 x i16> %x) {
; CHECK-LABEL: or_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.or.v4i16(<4 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i16 @or_v8i16(<8 x i16> %x) {
; CHECK-LABEL: or_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.or.v8i16(<8 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i16 @or_v16i16(<16 x i16> %x) {
; CHECK-LABEL: or_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.or.v16i16(<16 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i8 @or_v8i8(<8 x i8> %x) {
; CHECK-LABEL: or_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.or.v8i8(<8 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i8 @or_v16i8(<16 x i8> %x) {
; CHECK-LABEL: or_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.u8 r1, q0[8]
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov.u8 r1, q0[4]
; CHECK-NEXT:    vmov.u8 r2, q0[0]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.or.v16i8(<16 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i8 @or_v32i8(<32 x i8> %x) {
; CHECK-LABEL: or_v32i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.u8 r1, q0[8]
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    vmov.u8 r1, q0[4]
; CHECK-NEXT:    vmov.u8 r2, q0[0]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.or.v32i8(<32 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i64 @or_v1i64(<1 x i64> %x) {
; CHECK-LABEL: or_v1i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.or.v1i64(<1 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @or_v2i64(<2 x i64> %x) {
; CHECK-LABEL: or_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.or.v2i64(<2 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @or_v4i64(<4 x i64> %x) {
; CHECK-LABEL: or_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.or.v4i64(<4 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i32 @or_v2i32_acc(<2 x i32> %x, i32 %y) {
; CHECK-LABEL: or_v2i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, s2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.or.v2i32(<2 x i32> %x)
  %r = or i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @or_v4i32_acc(<4 x i32> %x, i32 %y) {
; CHECK-LABEL: or_v4i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.or.v4i32(<4 x i32> %x)
  %r = or i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @or_v8i32_acc(<8 x i32> %x, i32 %y) {
; CHECK-LABEL: or_v8i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.or.v8i32(<8 x i32> %x)
  %r = or i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i16 @or_v4i16_acc(<4 x i16> %x, i16 %y) {
; CHECK-LABEL: or_v4i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.or.v4i16(<4 x i16> %x)
  %r = or i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i16 @or_v8i16_acc(<8 x i16> %x, i16 %y) {
; CHECK-LABEL: or_v8i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.or.v8i16(<8 x i16> %x)
  %r = or i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i16 @or_v16i16_acc(<16 x i16> %x, i16 %y) {
; CHECK-LABEL: or_v16i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.or.v16i16(<16 x i16> %x)
  %r = or i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i8 @or_v8i8_acc(<8 x i8> %x, i8 %y) {
; CHECK-LABEL: or_v8i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.or.v8i8(<8 x i8> %x)
  %r = or i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i8 @or_v16i8_acc(<16 x i8> %x, i8 %y) {
; CHECK-LABEL: or_v16i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u8 r1, q0[12]
; CHECK-NEXT:    vmov.u8 r2, q0[8]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov.u8 r2, q0[4]
; CHECK-NEXT:    vmov.u8 r3, q0[0]
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.or.v16i8(<16 x i8> %x)
  %r = or i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i8 @or_v32i8_acc(<32 x i8> %x, i8 %y) {
; CHECK-LABEL: or_v32i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov.u8 r1, q0[12]
; CHECK-NEXT:    vmov.u8 r2, q0[8]
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    vmov.u8 r2, q0[4]
; CHECK-NEXT:    vmov.u8 r3, q0[0]
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.or.v32i8(<32 x i8> %x)
  %r = or i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i64 @or_v1i64_acc(<1 x i64> %x, i64 %y) {
; CHECK-LABEL: or_v1i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    orrs r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.or.v1i64(<1 x i64> %x)
  %r = or i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @or_v2i64_acc(<2 x i64> %x, i64 %y) {
; CHECK-LABEL: or_v2i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    vmov r3, lr, d0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    orr.w r2, lr, r12
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %z = call i64 @llvm.vector.reduce.or.v2i64(<2 x i64> %x)
  %r = or i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @or_v4i64_acc(<4 x i64> %x, i64 %y) {
; CHECK-LABEL: or_v4i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vorr q0, q0, q1
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    vmov r3, lr, d0
; CHECK-NEXT:    orrs r2, r3
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    orr.w r2, lr, r12
; CHECK-NEXT:    orrs r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %z = call i64 @llvm.vector.reduce.or.v4i64(<4 x i64> %x)
  %r = or i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i32 @xor_v2i32(<2 x i32> %x) {
; CHECK-LABEL: xor_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmov r1, s0
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.xor.v2i32(<2 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @xor_v4i32(<4 x i32> %x) {
; CHECK-LABEL: xor_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.xor.v4i32(<4 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i32 @xor_v8i32(<8 x i32> %x) {
; CHECK-LABEL: xor_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.xor.v8i32(<8 x i32> %x)
  ret i32 %z
}

define arm_aapcs_vfpcc i16 @xor_v4i16(<4 x i16> %x) {
; CHECK-LABEL: xor_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov r1, r2, d0
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.xor.v4i16(<4 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i16 @xor_v8i16(<8 x i16> %x) {
; CHECK-LABEL: xor_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.xor.v8i16(<8 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i16 @xor_v16i16(<16 x i16> %x) {
; CHECK-LABEL: xor_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.xor.v16i16(<16 x i16> %x)
  ret i16 %z
}

define arm_aapcs_vfpcc i8 @xor_v8i8(<8 x i8> %x) {
; CHECK-LABEL: xor_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov.u16 r1, q0[4]
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov.u16 r1, q0[2]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.xor.v8i8(<8 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i8 @xor_v16i8(<16 x i8> %x) {
; CHECK-LABEL: xor_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.u8 r1, q0[8]
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov.u8 r1, q0[4]
; CHECK-NEXT:    vmov.u8 r2, q0[0]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.xor.v16i8(<16 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i8 @xor_v32i8(<32 x i8> %x) {
; CHECK-LABEL: xor_v32i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.u8 r1, q0[8]
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    vmov.u8 r1, q0[4]
; CHECK-NEXT:    vmov.u8 r2, q0[0]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.xor.v32i8(<32 x i8> %x)
  ret i8 %z
}

define arm_aapcs_vfpcc i64 @xor_v1i64(<1 x i64> %x) {
; CHECK-LABEL: xor_v1i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.xor.v1i64(<1 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @xor_v2i64(<2 x i64> %x) {
; CHECK-LABEL: xor_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    eors r0, r2
; CHECK-NEXT:    eors r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.xor.v2i64(<2 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i64 @xor_v4i64(<4 x i64> %x) {
; CHECK-LABEL: xor_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    eors r0, r2
; CHECK-NEXT:    eors r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.xor.v4i64(<4 x i64> %x)
  ret i64 %z
}

define arm_aapcs_vfpcc i32 @xor_v2i32_acc(<2 x i32> %x, i32 %y) {
; CHECK-LABEL: xor_v2i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, s2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.xor.v2i32(<2 x i32> %x)
  %r = xor i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @xor_v4i32_acc(<4 x i32> %x, i32 %y) {
; CHECK-LABEL: xor_v4i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.xor.v4i32(<4 x i32> %x)
  %r = xor i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i32 @xor_v8i32_acc(<8 x i32> %x, i32 %y) {
; CHECK-LABEL: xor_v8i32_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.xor.v8i32(<8 x i32> %x)
  %r = xor i32 %y, %z
  ret i32 %r
}

define arm_aapcs_vfpcc i16 @xor_v4i16_acc(<4 x i16> %x, i16 %y) {
; CHECK-LABEL: xor_v4i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r1, r2, d1
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.xor.v4i16(<4 x i16> %x)
  %r = xor i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i16 @xor_v8i16_acc(<8 x i16> %x, i16 %y) {
; CHECK-LABEL: xor_v8i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.xor.v8i16(<8 x i16> %x)
  %r = xor i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i16 @xor_v16i16_acc(<16 x i16> %x, i16 %y) {
; CHECK-LABEL: xor_v16i16_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.xor.v16i16(<16 x i16> %x)
  %r = xor i16 %y, %z
  ret i16 %r
}

define arm_aapcs_vfpcc i8 @xor_v8i8_acc(<8 x i8> %x, i8 %y) {
; CHECK-LABEL: xor_v8i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u16 r1, q0[6]
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r3, q0[0]
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.xor.v8i8(<8 x i8> %x)
  %r = xor i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i8 @xor_v16i8_acc(<16 x i8> %x, i8 %y) {
; CHECK-LABEL: xor_v16i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u8 r1, q0[12]
; CHECK-NEXT:    vmov.u8 r2, q0[8]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov.u8 r2, q0[4]
; CHECK-NEXT:    vmov.u8 r3, q0[0]
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.xor.v16i8(<16 x i8> %x)
  %r = xor i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i8 @xor_v32i8_acc(<32 x i8> %x, i8 %y) {
; CHECK-LABEL: xor_v32i8_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev16.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vrev32.8 q1, q0
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov.u8 r1, q0[12]
; CHECK-NEXT:    vmov.u8 r2, q0[8]
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    vmov.u8 r2, q0[4]
; CHECK-NEXT:    vmov.u8 r3, q0[0]
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    eors r0, r1
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.xor.v32i8(<32 x i8> %x)
  %r = xor i8 %y, %z
  ret i8 %r
}

define arm_aapcs_vfpcc i64 @xor_v1i64_acc(<1 x i64> %x, i64 %y) {
; CHECK-LABEL: xor_v1i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    eors r0, r2
; CHECK-NEXT:    eors r1, r3
; CHECK-NEXT:    bx lr
entry:
  %z = call i64 @llvm.vector.reduce.xor.v1i64(<1 x i64> %x)
  %r = xor i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @xor_v2i64_acc(<2 x i64> %x, i64 %y) {
; CHECK-LABEL: xor_v2i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    vmov r3, lr, d0
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r0, r2
; CHECK-NEXT:    eor.w r2, lr, r12
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %z = call i64 @llvm.vector.reduce.xor.v2i64(<2 x i64> %x)
  %r = xor i64 %y, %z
  ret i64 %r
}

define arm_aapcs_vfpcc i64 @xor_v4i64_acc(<4 x i64> %x, i64 %y) {
; CHECK-LABEL: xor_v4i64_acc:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    veor q0, q0, q1
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    vmov r3, lr, d0
; CHECK-NEXT:    eors r2, r3
; CHECK-NEXT:    eors r0, r2
; CHECK-NEXT:    eor.w r2, lr, r12
; CHECK-NEXT:    eors r1, r2
; CHECK-NEXT:    pop {r7, pc}
entry:
  %z = call i64 @llvm.vector.reduce.xor.v4i64(<4 x i64> %x)
  %r = xor i64 %y, %z
  ret i64 %r
}

declare i16 @llvm.vector.reduce.and.v16i16(<16 x i16>)
declare i16 @llvm.vector.reduce.and.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.and.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.or.v16i16(<16 x i16>)
declare i16 @llvm.vector.reduce.or.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.or.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.xor.v16i16(<16 x i16>)
declare i16 @llvm.vector.reduce.xor.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.xor.v8i16(<8 x i16>)
declare i32 @llvm.vector.reduce.and.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.and.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.and.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.or.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.or.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.or.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.xor.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.xor.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.xor.v8i32(<8 x i32>)
declare i64 @llvm.vector.reduce.and.v1i64(<1 x i64>)
declare i64 @llvm.vector.reduce.and.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.and.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.or.v1i64(<1 x i64>)
declare i64 @llvm.vector.reduce.or.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.or.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.xor.v1i64(<1 x i64>)
declare i64 @llvm.vector.reduce.xor.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.xor.v4i64(<4 x i64>)
declare i8 @llvm.vector.reduce.and.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.and.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.and.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.or.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.or.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.or.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.xor.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.xor.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.xor.v8i8(<8 x i8>)
