var index = require('./index.development.js');
var React = require('react');
require('@grafana/data');
require('react-dom');
require('@grafana/e2e-selectors');
require('tty');
require('util');
require('os');
require('moment');
require('crypto');
require('jquery');
require('@grafana/aws-sdk');
var monaco = require('monaco-editor/esm/vs/editor/editor.api');
var ReactMonaco = require('react-monaco-editor');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var ReactMonaco__default = /*#__PURE__*/_interopDefaultLegacy(ReactMonaco);

/**
 * @internal -- only exported for tests
 */
function findInsertIndex(line) {
    for (var i = line.length - 1; i > 0; i--) {
        var ch = line.charAt(i);
        if (ch === '$') {
            return {
                index: i,
                prefix: line.substring(i),
            };
        }
        // Keep these seperators
        if (ch === ' ' || ch === '\t' || ch === '"' || ch === "'") {
            return {
                index: i + 1,
                prefix: line.substring(i + 1),
            };
        }
    }
    return {
        index: 0,
        prefix: line,
    };
}
function getCompletionItems(prefix, suggestions, range) {
    var e_1, _a;
    var _b;
    var items = [];
    try {
        for (var suggestions_1 = index.__values(suggestions), suggestions_1_1 = suggestions_1.next(); !suggestions_1_1.done; suggestions_1_1 = suggestions_1.next()) {
            var suggestion = suggestions_1_1.value;
            if (prefix && !suggestion.label.startsWith(prefix)) {
                continue; // skip non-matching suggestions
            }
            items.push(index.__assign(index.__assign({}, suggestion), { kind: mapKinds(suggestion.kind), range: range, insertText: (_b = suggestion.insertText) !== null && _b !== void 0 ? _b : suggestion.label }));
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (suggestions_1_1 && !suggestions_1_1.done && (_a = suggestions_1.return)) _a.call(suggestions_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return items;
}
function mapKinds(sug) {
    switch (sug) {
        case index.CodeEditorSuggestionItemKind.Method:
            return monaco.languages.CompletionItemKind.Method;
        case index.CodeEditorSuggestionItemKind.Field:
            return monaco.languages.CompletionItemKind.Field;
        case index.CodeEditorSuggestionItemKind.Property:
            return monaco.languages.CompletionItemKind.Property;
        case index.CodeEditorSuggestionItemKind.Constant:
            return monaco.languages.CompletionItemKind.Constant;
        case index.CodeEditorSuggestionItemKind.Text:
            return monaco.languages.CompletionItemKind.Text;
    }
    return monaco.languages.CompletionItemKind.Text;
}
/**
 * @alpha
 */
function registerSuggestions(language, getSuggestions) {
    if (!language || !getSuggestions) {
        return undefined;
    }
    return monaco.languages.registerCompletionItemProvider(language, {
        triggerCharacters: ['$'],
        provideCompletionItems: function (model, position, context) {
            var range = {
                startLineNumber: position.lineNumber,
                endLineNumber: position.lineNumber,
                startColumn: position.column,
                endColumn: position.column,
            };
            // Simple check if this was triggered by pressing `$`
            if (context.triggerCharacter === '$') {
                range.startColumn = position.column - 1;
                return {
                    suggestions: getCompletionItems('$', getSuggestions(), range),
                };
            }
            // Find the replacement region
            var currentLine = model.getValueInRange({
                startLineNumber: position.lineNumber,
                startColumn: 1,
                endLineNumber: position.lineNumber,
                endColumn: position.column,
            });
            var _a = findInsertIndex(currentLine), index = _a.index, prefix = _a.prefix;
            range.startColumn = index + 1;
            var suggestions = getCompletionItems(prefix, getSuggestions(), range);
            if (suggestions.length) {
                // NOTE, this will replace any language provided suggestions
                return { suggestions: suggestions };
            }
            // Default language suggestions
            return undefined;
        },
    });
}

var UnthemedCodeEditor = /** @class */ (function (_super) {
    index.__extends(UnthemedCodeEditor, _super);
    function UnthemedCodeEditor() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // This is replaced with a real function when the actual editor mounts
        _this.getEditorValue = function () { return ''; };
        _this.onBlur = function () {
            var onBlur = _this.props.onBlur;
            if (onBlur) {
                onBlur(_this.getEditorValue());
            }
        };
        _this.editorWillMount = function (m) {
            var _a = _this.props, language = _a.language, getSuggestions = _a.getSuggestions;
            if (getSuggestions) {
                _this.completionCancel = registerSuggestions(language, getSuggestions);
            }
        };
        _this.editorDidMount = function (editor) {
            var _a = _this.props, onSave = _a.onSave, onEditorDidMount = _a.onEditorDidMount;
            _this.getEditorValue = function () { return editor.getValue(); };
            if (onSave) {
                editor.addCommand(monaco.KeyMod.CtrlCmd | monaco.KeyCode.KEY_S, function () {
                    onSave(_this.getEditorValue());
                });
            }
            if (onEditorDidMount) {
                onEditorDidMount(editor);
            }
        };
        return _this;
    }
    UnthemedCodeEditor.prototype.componentWillUnmount = function () {
        if (this.completionCancel) {
            this.completionCancel.dispose();
        }
    };
    UnthemedCodeEditor.prototype.componentDidUpdate = function (oldProps) {
        var _a = this.props, getSuggestions = _a.getSuggestions, language = _a.language;
        if (getSuggestions) {
            // Language changed
            if (language !== oldProps.language) {
                if (this.completionCancel) {
                    this.completionCancel.dispose();
                }
                this.completionCancel = registerSuggestions(language, getSuggestions);
            }
        }
    };
    UnthemedCodeEditor.prototype.render = function () {
        var _a;
        var _b = this.props, theme = _b.theme, language = _b.language, width = _b.width, height = _b.height, showMiniMap = _b.showMiniMap, showLineNumbers = _b.showLineNumbers, readOnly = _b.readOnly;
        var value = (_a = this.props.value) !== null && _a !== void 0 ? _a : '';
        var longText = value.length > 100;
        var options = {
            wordWrap: 'off',
            codeLens: false,
            minimap: {
                enabled: longText && showMiniMap,
                renderCharacters: false,
            },
            readOnly: readOnly,
            lineNumbersMinChars: 4,
            lineDecorationsWidth: 0,
            overviewRulerBorder: false,
            automaticLayout: true,
        };
        if (!showLineNumbers) {
            options.glyphMargin = false;
            options.folding = false;
            options.lineNumbers = 'off';
            options.lineDecorationsWidth = 5; // left margin when not showing line numbers
            options.lineNumbersMinChars = 0;
        }
        return (React__default['default'].createElement("div", { onBlur: this.onBlur },
            React__default['default'].createElement(ReactMonaco__default['default'], { width: width, height: height, language: language, theme: theme.isDark ? 'vs-dark' : 'vs-light', value: value, options: options, editorWillMount: this.editorWillMount, editorDidMount: this.editorDidMount })));
    };
    return UnthemedCodeEditor;
}(React__default['default'].PureComponent));
var CodeEditor = index.withTheme(UnthemedCodeEditor);

exports.default = CodeEditor;
//# sourceMappingURL=CodeEditor.development.js.map
