/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.MidiInDevice;
import com.sun.media.sound.Platform;
import javax.sound.midi.MidiDevice;

public final class MidiInDeviceProvider
extends AbstractMidiDeviceProvider {
    private static AbstractMidiDeviceProvider.Info[] infos = null;
    private static MidiDevice[] devices = null;
    private static final boolean enabled;

    @Override
    AbstractMidiDeviceProvider.Info createInfo(int n) {
        if (!enabled) {
            return null;
        }
        return new MidiInDeviceInfo(n, MidiInDeviceProvider.class);
    }

    @Override
    MidiDevice createDevice(AbstractMidiDeviceProvider.Info info) {
        if (enabled && info instanceof MidiInDeviceInfo) {
            return new MidiInDevice(info);
        }
        return null;
    }

    @Override
    int getNumDevices() {
        if (!enabled) {
            return 0;
        }
        int n = MidiInDeviceProvider.nGetNumDevices();
        return n;
    }

    @Override
    MidiDevice[] getDeviceCache() {
        return devices;
    }

    @Override
    void setDeviceCache(MidiDevice[] midiDeviceArray) {
        devices = midiDeviceArray;
    }

    @Override
    AbstractMidiDeviceProvider.Info[] getInfoCache() {
        return infos;
    }

    @Override
    void setInfoCache(AbstractMidiDeviceProvider.Info[] infoArray) {
        infos = infoArray;
    }

    private static native int nGetNumDevices();

    private static native String nGetName(int var0);

    private static native String nGetVendor(int var0);

    private static native String nGetDescription(int var0);

    private static native String nGetVersion(int var0);

    static {
        Platform.initialize();
        enabled = Platform.isMidiIOEnabled();
    }

    static final class MidiInDeviceInfo
    extends AbstractMidiDeviceProvider.Info {
        private final Class providerClass;

        private MidiInDeviceInfo(int n, Class clazz) {
            super(MidiInDeviceProvider.nGetName(n), MidiInDeviceProvider.nGetVendor(n), MidiInDeviceProvider.nGetDescription(n), MidiInDeviceProvider.nGetVersion(n), n);
            this.providerClass = clazz;
        }
    }
}

