/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter;

import java.io.IOException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.support.Zlib;

public class CompressionFilter
extends IoFilterAdapter {
    public static final int COMPRESSION_MAX = 9;
    public static final int COMPRESSION_MIN = 1;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_DEFAULT = -1;
    private static final String DEFLATER = CompressionFilter.class.getName() + ".Deflater";
    private static final String INFLATER = CompressionFilter.class.getName() + ".Inflater";
    public static final String DISABLE_COMPRESSION_ONCE = CompressionFilter.class.getName() + ".DisableCompressionOnce";
    private boolean compressInbound = true;
    private boolean compressOutbound = true;
    private int compressionLevel;

    public CompressionFilter() {
        this(true, true, -1);
    }

    public CompressionFilter(int compressionLevel) {
        this(true, true, compressionLevel);
    }

    public CompressionFilter(boolean compressInbound, boolean compressOutbound, int compressionLevel) {
        this.compressionLevel = compressionLevel;
        this.compressInbound = compressInbound;
        this.compressOutbound = compressOutbound;
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!this.compressInbound) {
            nextFilter.messageReceived(session, message);
            return;
        }
        Zlib inflater = (Zlib)session.getAttribute(INFLATER);
        if (inflater == null) {
            throw new IllegalStateException();
        }
        ByteBuffer inBuffer = (ByteBuffer)message;
        ByteBuffer outBuffer = inflater.inflate(inBuffer);
        inBuffer.release();
        nextFilter.messageReceived(session, outBuffer);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws IOException {
        if (!this.compressOutbound) {
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        if (session.containsAttribute(DISABLE_COMPRESSION_ONCE)) {
            session.removeAttribute(DISABLE_COMPRESSION_ONCE);
            nextFilter.filterWrite(session, writeRequest);
            return;
        }
        Zlib deflater = (Zlib)session.getAttribute(DEFLATER);
        if (deflater == null) {
            throw new IllegalStateException();
        }
        ByteBuffer inBuffer = (ByteBuffer)writeRequest.getMessage();
        ByteBuffer outBuf = deflater.deflate(inBuffer);
        inBuffer.release();
        nextFilter.filterWrite(session, new IoFilter.WriteRequest(outBuf, writeRequest.getFuture()));
    }

    public void onPreAdd(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        if (parent.contains(CompressionFilter.class)) {
            throw new IllegalStateException("A filter chain cannot contain more than one Stream Compression filter.");
        }
        Zlib deflater = new Zlib(this.compressionLevel, 1);
        Zlib inflater = new Zlib(this.compressionLevel, 2);
        IoSession session = parent.getSession();
        session.setAttribute(DEFLATER, deflater);
        session.setAttribute(INFLATER, inflater);
    }

    public boolean isCompressInbound() {
        return this.compressInbound;
    }

    public void setCompressInbound(boolean compressInbound) {
        this.compressInbound = compressInbound;
    }

    public boolean isCompressOutbound() {
        return this.compressOutbound;
    }

    public void setCompressOutbound(boolean compressOutbound) {
        this.compressOutbound = compressOutbound;
    }

    public void onPostRemove(IoFilterChain parent, String name, IoFilter.NextFilter nextFilter) throws Exception {
        super.onPostRemove(parent, name, nextFilter);
        IoSession session = parent.getSession();
        if (session == null) {
            return;
        }
        Zlib inflater = (Zlib)session.getAttribute(INFLATER);
        Zlib deflater = (Zlib)session.getAttribute(DEFLATER);
        if (deflater != null) {
            deflater.cleanUp();
        }
        if (inflater != null) {
            inflater.cleanUp();
        }
    }
}

