/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.io.File;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.EquinoxProtectionDomain;
import org.eclipse.osgi.internal.permadmin.EquinoxSecurityManager;
import org.eclipse.osgi.internal.permadmin.PermissionAdminTable;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurePermissionStorage;
import org.eclipse.osgi.internal.permadmin.SecurityAdminUtils;
import org.eclipse.osgi.internal.permadmin.SecurityInfoBase;
import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.eclipse.osgi.internal.permadmin.SecurityTable;
import org.eclipse.osgi.internal.permadmin.SecurityTableUpdate;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfoBase;
import org.osgi.service.condpermadmin.ConditionalPermissionsUpdate;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class SecurityAdmin
implements PermissionAdmin,
ConditionalPermissionAdmin {
    private static final PermissionCollection DEFAULT_DEFAULT;
    private static final String ADMIN_IMPLIED_ACTIONS = "resource,metadata,class";
    private final PermissionAdminTable permAdminTable = new PermissionAdminTable();
    private SecurityTable condAdminTable;
    private PermissionInfoCollection permAdminDefaults;
    private long timeStamp = 0L;
    private long nextID = System.currentTimeMillis();
    private final PermissionStorage permissionStorage;
    private final Object lock = new Object();
    private final Framework framework;
    private final PermissionInfo[] impliedPermissionInfos;
    private final EquinoxSecurityManager supportedSecurityManager;
    static /* synthetic */ Class class$0;

    static {
        AllPermission allPerm = new AllPermission();
        DEFAULT_DEFAULT = allPerm.newPermissionCollection();
        if (DEFAULT_DEFAULT != null) {
            DEFAULT_DEFAULT.add(allPerm);
        }
    }

    public SecurityAdmin(EquinoxSecurityManager supportedSecurityManager, Framework framework, PermissionStorage permissionStorage) throws IOException {
        String[] encodedCondPermInfos;
        String[] locations;
        this.supportedSecurityManager = supportedSecurityManager;
        this.framework = framework;
        this.permissionStorage = new SecurePermissionStorage(permissionStorage);
        this.impliedPermissionInfos = SecurityAdminUtils.getPermissionInfos(this.getClass().getResource("implied.permissions"), framework);
        String[] encodedDefaultInfos = permissionStorage.getPermissionData(null);
        PermissionInfo[] defaultInfos = SecurityAdmin.getPermissionInfos(encodedDefaultInfos);
        if (defaultInfos != null) {
            this.permAdminDefaults = new PermissionInfoCollection(defaultInfos);
        }
        if ((locations = permissionStorage.getLocations()) != null) {
            int i = 0;
            while (i < locations.length) {
                String[] encodedLocationInfos = permissionStorage.getPermissionData(locations[i]);
                if (encodedLocationInfos != null) {
                    PermissionInfo[] locationInfos = SecurityAdmin.getPermissionInfos(encodedLocationInfos);
                    this.permAdminTable.setPermissions(locations[i], locationInfos);
                }
                ++i;
            }
        }
        if ((encodedCondPermInfos = permissionStorage.getConditionalPermissionInfos()) == null) {
            this.condAdminTable = new SecurityTable(this, new SecurityRow[0]);
        } else {
            SecurityRow[] rows = new SecurityRow[encodedCondPermInfos.length];
            int i = 0;
            while (i < rows.length) {
                rows[i] = SecurityRow.createSecurityRow(this, encodedCondPermInfos[i]);
                ++i;
            }
            this.condAdminTable = new SecurityTable(this, rows);
        }
    }

    private static PermissionInfo[] getPermissionInfos(String[] encodedInfos) {
        if (encodedInfos == null) {
            return null;
        }
        PermissionInfo[] results = new PermissionInfo[encodedInfos.length];
        int i = 0;
        while (i < results.length) {
            results[i] = new PermissionInfo(encodedInfos[i]);
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkPermission(Permission permission, BundlePermissions bundlePermissions) {
        PermissionInfoCollection curPermAdminDefaults;
        SecurityTable curCondAdminTable;
        PermissionInfoCollection locationCollection;
        Object object = this.lock;
        synchronized (object) {
            locationCollection = this.permAdminTable.getCollection(bundlePermissions.getBundle().getBundleData().getLocation());
            curCondAdminTable = this.condAdminTable;
            curPermAdminDefaults = this.permAdminDefaults;
        }
        if (locationCollection != null) {
            return locationCollection.implies(permission);
        }
        if (curCondAdminTable.isEmpty()) {
            return curPermAdminDefaults != null ? curPermAdminDefaults.implies(permission) : DEFAULT_DEFAULT.implies(permission);
        }
        int result = curCondAdminTable.evaluate(bundlePermissions, permission);
        if ((result & 1) != 0) {
            return true;
        }
        if ((result & 2) != 0) {
            return false;
        }
        return (result & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo[] getDefaultPermissions() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.permAdminDefaults != null) break block4;
                return null;
            }
            return this.permAdminDefaults.getPermissionInfos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocations() {
        Object object = this.lock;
        synchronized (object) {
            String[] results = this.permAdminTable.getLocations();
            return results.length == 0 ? null : results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo[] getPermissions(String location) {
        Object object = this.lock;
        synchronized (object) {
            return this.permAdminTable.getPermissions(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultPermissions(PermissionInfo[] permissions) {
        SecurityAdmin.checkAllPermission();
        Object object = this.lock;
        synchronized (object) {
            this.permAdminDefaults = permissions == null ? null : new PermissionInfoCollection(permissions);
            try {
                this.permissionStorage.setPermissionData(null, SecurityAdmin.getEncodedPermissionInfos(permissions));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkAllPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
    }

    private static String[] getEncodedPermissionInfos(PermissionInfo[] permissions) {
        if (permissions == null) {
            return null;
        }
        String[] encoded = new String[permissions.length];
        int i = 0;
        while (i < encoded.length) {
            encoded[i] = permissions[i].getEncoded();
            ++i;
        }
        return encoded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String location, PermissionInfo[] permissions) {
        SecurityAdmin.checkAllPermission();
        Object object = this.lock;
        synchronized (object) {
            this.permAdminTable.setPermissions(location, permissions);
            try {
                this.permissionStorage.setPermissionData(location, SecurityAdmin.getEncodedPermissionInfos(permissions));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(SecurityRow securityRow, boolean firstTry) {
        ConditionalPermissionsUpdate update = this.createConditionalPermissionsUpdate();
        List rows = update.getConditionalPermissionInfoBases();
        Iterator iRows = rows.iterator();
        while (iRows.hasNext()) {
            ConditionalPermissionInfoBase info = (ConditionalPermissionInfoBase)iRows.next();
            if (!securityRow.getName().equals(info.getName())) continue;
            iRows.remove();
            Object object = this.lock;
            synchronized (object) {
                if (!update.commit() && firstTry) {
                    this.delete(securityRow, false);
                }
                break;
            }
        }
    }

    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conds, PermissionInfo[] perms) {
        return this.setConditionalPermissionInfo(null, conds, perms, true);
    }

    public ConditionalPermissionInfoBase createConditionalPermissionInfoBase(String name, ConditionInfo[] conditions, PermissionInfo[] permissions, String decision) {
        return new SecurityInfoBase(name, conditions, permissions, decision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalPermissionsUpdate createConditionalPermissionsUpdate() {
        Object object = this.lock;
        synchronized (object) {
            return new SecurityTableUpdate(this, this.condAdminTable.getRows(), this.timeStamp);
        }
    }

    public AccessControlContext getAccessControlContext(String[] signers) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalPermissionInfo getConditionalPermissionInfo(String name) {
        Object object = this.lock;
        synchronized (object) {
            return this.condAdminTable.getRow(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getConditionalPermissionInfos() {
        Object object = this.lock;
        synchronized (object) {
            SecurityRow[] rows = this.condAdminTable.getRows();
            Vector<SecurityRow> vRows = new Vector<SecurityRow>(rows.length);
            int i = 0;
            while (i < rows.length) {
                vRows.add(rows[i]);
                ++i;
            }
            return vRows.elements();
        }
    }

    public ConditionalPermissionInfo setConditionalPermissionInfo(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        return this.setConditionalPermissionInfo(name, conds, perms, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConditionalPermissionInfo setConditionalPermissionInfo(String name, ConditionInfo[] conds, PermissionInfo[] perms, boolean firstTry) {
        ConditionalPermissionsUpdate update = this.createConditionalPermissionsUpdate();
        List rows = update.getConditionalPermissionInfoBases();
        ConditionalPermissionInfoBase infoBase = this.createConditionalPermissionInfoBase(name, conds, perms, "allow");
        int index = -1;
        if (name == null) {
            rows.add(infoBase);
            index = rows.size() - 1;
        } else {
            int i = 0;
            while (i < rows.size() && index < 0) {
                ConditionalPermissionInfoBase info = (ConditionalPermissionInfoBase)rows.get(i);
                if (name.equals(info.getName())) {
                    rows.set(i, infoBase);
                    index = i;
                }
                ++i;
            }
            if (index < 0) {
                rows.add(infoBase);
                index = rows.size() - 1;
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (!update.commit() && firstTry) {
                this.setConditionalPermissionInfo(name, conds, perms, false);
            }
            return this.condAdminTable.getRow(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean commit(List rows, long updateStamp) {
        SecurityAdmin.checkAllPermission();
        Object object = this.lock;
        synchronized (object) {
            block10: {
                if (updateStamp == this.timeStamp) break block10;
                return false;
            }
            SecurityRow[] newRows = new SecurityRow[rows.size()];
            ArrayList names = new ArrayList();
            int i = 0;
            while (i < newRows.length) {
                Object rowObj = rows.get(i);
                if (!(rowObj instanceof ConditionalPermissionInfoBase)) {
                    throw new IllegalStateException("Invalid type \"" + rowObj.getClass().getName() + "\" at row: " + i);
                }
                ConditionalPermissionInfoBase infoBaseRow = (ConditionalPermissionInfoBase)rowObj;
                String name = infoBaseRow.getName();
                if (name == null) {
                    name = this.generateName();
                }
                if (names.contains(name)) {
                    throw new IllegalStateException("Duplicate name \"" + name + "\" at row: " + i);
                }
                newRows[i] = new SecurityRow(this, name, infoBaseRow.getConditionInfos(), infoBaseRow.getPermissionInfos(), infoBaseRow.getGrantDecision());
                ++i;
            }
            this.condAdminTable = new SecurityTable(this, newRows);
            try {
                this.permissionStorage.saveConditionalPermissionInfos(this.condAdminTable.getEncodedRows());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.timeStamp;
            return true;
        }
    }

    private String generateName() {
        return "generated_" + Long.toString(this.nextID++);
    }

    public EquinoxProtectionDomain createProtectionDomain(AbstractBundle bundle) {
        PermissionInfoCollection impliedPermissions = this.getImpliedPermission(bundle);
        PermissionInfo[] restrictedInfos = this.getFileRelativeInfos(SecurityAdminUtils.getPermissionInfos(bundle.getEntry("OSGI-INF/permissions.perm"), this.framework), bundle);
        PermissionInfoCollection restrictedPermissions = restrictedInfos == null ? null : new PermissionInfoCollection(restrictedInfos);
        BundlePermissions bundlePermissions = new BundlePermissions(bundle, this, impliedPermissions, restrictedPermissions);
        return new EquinoxProtectionDomain(bundlePermissions);
    }

    private PermissionInfoCollection getImpliedPermission(AbstractBundle bundle) {
        if (this.impliedPermissionInfos == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.framework.AdminPermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PermissionInfo impliedAdminPermission = new PermissionInfo(clazz.getName(), "(id=" + bundle.getBundleId() + ")", ADMIN_IMPLIED_ACTIONS);
        PermissionInfo[] bundleImpliedInfos = new PermissionInfo[this.impliedPermissionInfos.length + 1];
        System.arraycopy(this.impliedPermissionInfos, 0, bundleImpliedInfos, 0, this.impliedPermissionInfos.length);
        bundleImpliedInfos[this.impliedPermissionInfos.length] = impliedAdminPermission;
        return new PermissionInfoCollection(this.getFileRelativeInfos(bundleImpliedInfos, bundle));
    }

    private PermissionInfo[] getFileRelativeInfos(PermissionInfo[] permissionInfos, AbstractBundle bundle) {
        if (permissionInfos == null) {
            return null;
        }
        PermissionInfo[] results = new PermissionInfo[permissionInfos.length];
        int i = 0;
        while (i < permissionInfos.length) {
            File target;
            File file;
            results[i] = permissionInfos[i];
            if ("java.io.FilePermission".equals(permissionInfos[i].getType()) && !(file = new File(permissionInfos[i].getName())).isAbsolute() && (target = bundle.getBundleData().getDataFile(permissionInfos[i].getName())) != null) {
                results[i] = new PermissionInfo(permissionInfos[i].getType(), target.getPath(), permissionInfos[i].getActions());
            }
            ++i;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        SecurityRow[] condAdminRows;
        PermissionInfoCollection[] permAdminCollections;
        Object object = this.lock;
        synchronized (object) {
            permAdminCollections = this.permAdminTable.getCollections();
            condAdminRows = this.condAdminTable.getRows();
        }
        int i = 0;
        while (i < permAdminCollections.length) {
            permAdminCollections[i].clearPermissionCache();
            ++i;
        }
        i = 0;
        while (i < condAdminRows.length) {
            condAdminRows[i].clearCaches();
            ++i;
        }
    }

    EquinoxSecurityManager getSupportedSecurityManager() {
        return this.supportedSecurityManager != null ? this.supportedSecurityManager : SecurityAdmin.getSupportedSystemSecurityManager();
    }

    private static EquinoxSecurityManager getSupportedSystemSecurityManager() {
        try {
            EquinoxSecurityManager equinoxManager = (EquinoxSecurityManager)System.getSecurityManager();
            return equinoxManager != null && equinoxManager.inCheckPermission() ? equinoxManager : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

