/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.methods.lattices;

import org.jquantlib.lang.annotation.NonNegative;
import org.jquantlib.lang.annotation.Price;
import org.jquantlib.lang.annotation.Time;
import org.jquantlib.methods.lattices.Tree;
import org.jquantlib.processes.StochasticProcess1D;

public abstract class BinomialTree
extends Tree {
    public static final Tree.Branches branches = Tree.Branches.BINOMIAL;
    @Price
    protected final double x0;
    @Price
    protected final double driftPerStep;
    @Time
    protected final double dt;

    protected BinomialTree(StochasticProcess1D process, @Time double end, @NonNegative int steps) {
        super(steps + 1);
        this.x0 = process.x0();
        this.dt = end / (double)steps;
        this.driftPerStep = process.drift(0.0, this.x0) * this.dt;
    }

    @Override
    public final int size(int i) {
        return i + 1;
    }

    @Override
    public final int descendant(int unused, int index, int branch) {
        return index + branch;
    }
}

