/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.jquantlib.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesDouble {
    private static final Logger logger = LoggerFactory.getLogger(TimeSeriesDouble.class);
    private final NavigableMap<Date, Double> map = new TreeMap<Date, Double>();

    public TimeSeriesDouble() {
    }

    public TimeSeriesDouble(Date[] dates, double[] values) {
        this();
        if (dates.length != values.length) {
            throw new IllegalArgumentException("sizes mismatch");
        }
        for (int i = 0; i < dates.length; ++i) {
            this.map.put(dates[i], values[i]);
        }
    }

    public TimeSeriesDouble(Date startingDate, double[] values) {
        this();
        Date tmp = startingDate;
        for (int i = 0; i < values.length; ++i) {
            this.map.put(tmp, values[i]);
            tmp = startingDate.getDateAfter(i);
        }
    }

    public Date firstDate() {
        return (Date)this.map.firstKey();
    }

    public Date lastDate() {
        return (Date)this.map.lastKey();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public double find(Date d) {
        return (Double)this.map.get(d);
    }

    public void add(Date date, double dt) {
        this.map.put(date, dt);
    }

    public Date[] dates() {
        return this.map.keySet().toArray(new Date[0]);
    }

    public double[] values() {
        Double[] tmp = this.map.values().toArray(new Double[0]);
        double[] values = new double[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            values[i] = tmp[i];
        }
        return values;
    }
}

