/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.math.randomnumbers;

import java.util.Date;
import org.jquantlib.math.randomnumbers.MersenneTwisterUniformRng;

public class SeedGenerator {
    private static volatile SeedGenerator instance;
    private MersenneTwisterUniformRng rng_;

    private SeedGenerator() {
        if (System.getProperty("EXPERIMENTAL") == null) {
            throw new UnsupportedOperationException("Work in progress");
        }
        this.rng_ = new MersenneTwisterUniformRng(42L);
        this.initialize();
    }

    private void initialize() {
        Date now = new Date();
        long firstSeed = now.getTime();
        MersenneTwisterUniformRng first = new MersenneTwisterUniformRng(firstSeed);
        long secondSeed = first.nextInt32();
        MersenneTwisterUniformRng second = new MersenneTwisterUniformRng(secondSeed);
        long skip = second.nextInt32() % 1000L;
        long[] init = new long[]{second.nextInt32(), second.nextInt32(), second.nextInt32(), second.nextInt32()};
        this.rng_ = new MersenneTwisterUniformRng(init);
        for (long i = 0L; i < skip; ++i) {
            this.rng_.nextInt32();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SeedGenerator getInstance() {
        if (instance != null) return instance;
        Class<SeedGenerator> clazz = SeedGenerator.class;
        synchronized (SeedGenerator.class) {
            if (instance != null) return instance;
            instance = new SeedGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long get() {
        return this.rng_.nextInt32();
    }
}

