/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.framework.resolver.CandidateComparator;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.resolver.ResolverImpl;
import org.apache.felix.framework.resolver.ResolverWire;
import org.apache.felix.framework.util.ShrinkableCollection;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.apache.felix.framework.wiring.BundleWireImpl;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatefulResolver {
    private final Logger m_logger;
    private final Felix m_felix;
    private final Resolver m_resolver;
    private final ResolverStateImpl m_resolverState;
    private final List<ResolverHook> m_hooks = new ArrayList<ResolverHook>();
    private boolean m_isResolving = false;
    private Collection<BundleRevision> m_whitelist = null;
    static /* synthetic */ Class class$org$osgi$framework$hooks$resolver$ResolverHookFactory;
    static /* synthetic */ Class class$org$osgi$framework$wiring$BundleRevision;

    StatefulResolver(Felix felix) {
        this.m_felix = felix;
        this.m_logger = this.m_felix.getLogger();
        this.m_resolver = new ResolverImpl(this.m_logger);
        this.m_resolverState = new ResolverStateImpl((String)this.m_felix.getConfig().get("org.osgi.framework.executionenvironment"));
    }

    void addRevision(BundleRevision br) {
        this.m_resolverState.addRevision(br);
    }

    void removeRevision(BundleRevision br) {
        this.m_resolverState.removeRevision(br);
    }

    Set<BundleCapability> getCandidates(BundleRequirementImpl req, boolean obeyMandatory) {
        return this.m_resolverState.getCandidates(req, obeyMandatory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolve(Set<BundleRevision> mandatory, Set<BundleRevision> optional) throws ResolveException, BundleException {
        boolean locked = this.m_felix.acquireGlobalLock();
        if (!locked) {
            throw new ResolveException("Unable to acquire global lock for resolve.", null, null);
        }
        if (this.m_isResolving) {
            this.m_felix.releaseGlobalLock();
            throw new IllegalStateException("Nested resolve operations not allowed.");
        }
        this.m_isResolving = true;
        Map<BundleRevision, List<ResolverWire>> wireMap = null;
        try {
            BundleImpl bundle;
            BundleRevision br;
            mandatory = mandatory.isEmpty() ? mandatory : new HashSet<BundleRevision>(mandatory);
            optional = optional.isEmpty() ? optional : new HashSet<BundleRevision>(optional);
            Set<ServiceReference<ResolverHookFactory>> hookRefs = this.prepareResolverHooks(mandatory, optional);
            this.m_resolverState.selectSingletons();
            Iterator it = mandatory.iterator();
            while (it.hasNext()) {
                br = (BundleRevision)it.next();
                bundle = (BundleImpl)br.getBundle();
                if (bundle.isExtension()) {
                    it.remove();
                    continue;
                }
                if (!Util.isSingleton(br) || this.m_resolverState.isSelectedSingleton(br)) continue;
                throw new ResolveException("Singleton conflict.", br, null);
            }
            it = optional.iterator();
            while (it.hasNext()) {
                br = (BundleRevision)it.next();
                bundle = (BundleImpl)br.getBundle();
                if (bundle.isExtension()) {
                    it.remove();
                    continue;
                }
                if (!Util.isSingleton(br) || this.m_resolverState.isSelectedSingleton(br)) continue;
                it.remove();
            }
            ResolveException rethrow = null;
            try {
                wireMap = this.m_resolver.resolve((Resolver.ResolverState)this.m_resolverState, mandatory, optional, this.m_resolverState.getFragments());
            }
            catch (ResolveException ex) {
                rethrow = ex;
            }
            this.releaseResolverHooks(hookRefs);
            if (rethrow != null) {
                throw rethrow;
            }
            this.markResolvedRevisions(wireMap);
        }
        finally {
            this.m_isResolving = false;
            this.m_whitelist = null;
            this.m_hooks.clear();
            this.m_felix.releaseGlobalLock();
        }
        this.fireResolvedEvents(wireMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BundleRevision resolve(BundleRevision revision, String pkgName) throws ResolveException, BundleException {
        BundleRevision provider = null;
        if (revision.getWiring() != null && this.isAllowedDynamicImport(revision, pkgName)) {
            Map<BundleRevision, List<ResolverWire>> wireMap;
            block11: {
                boolean locked = this.m_felix.acquireGlobalLock();
                if (!locked) {
                    throw new ResolveException("Unable to acquire global lock for resolve.", revision, null);
                }
                if (this.m_isResolving) {
                    this.m_felix.releaseGlobalLock();
                    throw new IllegalStateException("Nested resolve operations not allowed.");
                }
                this.m_isResolving = true;
                wireMap = null;
                try {
                    provider = ((BundleWiringImpl)revision.getWiring()).getImportedPackageSource(pkgName);
                    if (provider != null) break block11;
                    Set<ServiceReference<ResolverHookFactory>> hookRefs = this.prepareResolverHooks(Collections.singleton(revision), Collections.EMPTY_SET);
                    this.m_resolverState.selectSingletons();
                    ResolveException rethrow = null;
                    try {
                        wireMap = this.m_resolver.resolve((Resolver.ResolverState)this.m_resolverState, revision, pkgName, this.m_resolverState.getFragments());
                    }
                    catch (ResolveException ex) {
                        rethrow = ex;
                    }
                    this.releaseResolverHooks(hookRefs);
                    if (rethrow != null) {
                        throw rethrow;
                    }
                    if (wireMap != null && wireMap.containsKey(revision)) {
                        List<ResolverWire> dynamicWires = wireMap.remove(revision);
                        ResolverWire dynamicWire = dynamicWires.get(0);
                        this.markResolvedRevisions(wireMap);
                        if (dynamicWire != null) {
                            BundleWireImpl bw = new BundleWireImpl(dynamicWire.getRequirer(), dynamicWire.getRequirement(), dynamicWire.getProvider(), dynamicWire.getCapability());
                            this.m_felix.getDependencies().addDependent(bw);
                            ((BundleWiringImpl)revision.getWiring()).addDynamicWire(bw);
                            this.m_felix.getLogger().log(4, new StringBuffer().append("DYNAMIC WIRE: ").append(dynamicWire).toString());
                            provider = ((BundleWiringImpl)revision.getWiring()).getImportedPackageSource(pkgName);
                        }
                    }
                }
                finally {
                    this.m_isResolving = false;
                    this.m_whitelist = null;
                    this.m_hooks.clear();
                    this.m_felix.releaseGlobalLock();
                }
            }
            this.fireResolvedEvents(wireMap);
        }
        return provider;
    }

    private Set<ServiceReference<ResolverHookFactory>> prepareResolverHooks(Set<BundleRevision> mandatory, Set<BundleRevision> optional) throws BundleException {
        Set<ServiceReference<ResolverHookFactory>> hookRefs = this.m_felix.getHooks(class$org$osgi$framework$hooks$resolver$ResolverHookFactory == null ? (class$org$osgi$framework$hooks$resolver$ResolverHookFactory = StatefulResolver.class$("org.osgi.framework.hooks.resolver.ResolverHookFactory")) : class$org$osgi$framework$hooks$resolver$ResolverHookFactory);
        if (!hookRefs.isEmpty()) {
            Set<BundleRevision> triggers;
            if (!mandatory.isEmpty() && !optional.isEmpty()) {
                triggers = new HashSet<BundleRevision>(mandatory);
                triggers.addAll(optional);
            } else {
                triggers = mandatory.isEmpty() ? optional : mandatory;
            }
            triggers = Collections.unmodifiableSet(triggers);
            for (ServiceReference<ResolverHookFactory> ref : hookRefs) {
                try {
                    ResolverHook hook;
                    ResolverHookFactory rhf = this.m_felix.getService(this.m_felix, ref);
                    if (rhf == null || (hook = Felix.m_secureAction.invokeResolverHookFactory(rhf, triggers)) == null) continue;
                    this.m_hooks.add(hook);
                }
                catch (Throwable ex) {
                    throw new BundleException(new StringBuffer().append("Resolver hook exception: ").append(ex.getMessage()).toString(), 12, ex);
                }
            }
            this.m_whitelist = new ShrinkableCollection<BundleRevision>(this.m_resolverState.getUnresolvedRevisions());
            int originalSize = this.m_whitelist.size();
            for (ResolverHook hook : this.m_hooks) {
                try {
                    Felix.m_secureAction.invokeResolverHookResolvable(hook, this.m_whitelist);
                }
                catch (Throwable ex) {
                    throw new BundleException(new StringBuffer().append("Resolver hook exception: ").append(ex.getMessage()).toString(), 12, ex);
                }
            }
            if (this.m_whitelist.size() == originalSize) {
                this.m_whitelist = null;
            }
            if (this.m_whitelist != null && (mandatory.isEmpty() || !optional.isEmpty() || mandatory.iterator().next().getWiring() == null)) {
                mandatory.retainAll(this.m_whitelist);
                optional.retainAll(this.m_whitelist);
                if (mandatory.isEmpty() && optional.isEmpty()) {
                    throw new ResolveException("Resolver hook prevented resolution.", null, null);
                }
            }
        } else {
            this.m_hooks.clear();
        }
        return hookRefs;
    }

    private void releaseResolverHooks(Set<ServiceReference<ResolverHookFactory>> hookRefs) throws BundleException {
        if (!hookRefs.isEmpty()) {
            for (ResolverHook hook : this.m_hooks) {
                try {
                    Felix.m_secureAction.invokeResolverHookEnd(hook);
                }
                catch (Throwable th) {
                    this.m_logger.log(2, "Resolver hook exception.", th);
                }
            }
            boolean invalid = false;
            for (ServiceReference<ResolverHookFactory> ref : hookRefs) {
                if (ref.getBundle() == null) {
                    invalid = true;
                }
                this.m_felix.ungetService(this.m_felix, ref);
            }
            if (invalid) {
                throw new BundleException("Resolver hook service unregistered during resolve.", 12);
            }
        }
    }

    boolean isAllowedDynamicImport(BundleRevision revision, String pkgName) {
        if (revision.getWiring() == null || pkgName.length() == 0) {
            return false;
        }
        List<BundleRequirement> dynamics = Util.getDynamicRequirements(revision.getWiring().getRequirements(null));
        if (dynamics == null || dynamics.isEmpty()) {
            return false;
        }
        for (BundleCapability cap : revision.getWiring().getCapabilities(null)) {
            if (!cap.getNamespace().equals("osgi.wiring.package") || !cap.getAttributes().get("osgi.wiring.package").equals(pkgName)) continue;
            return false;
        }
        if (((BundleWiringImpl)revision.getWiring()).hasPackageSource(pkgName)) {
            return false;
        }
        Map<String, Object> attrs = Collections.singletonMap("osgi.wiring.package", pkgName);
        BundleRequirementImpl req = new BundleRequirementImpl(revision, "osgi.wiring.package", Collections.EMPTY_MAP, attrs);
        SortedSet<BundleCapability> candidates = this.m_resolverState.getCandidates(req, false);
        return !candidates.isEmpty();
    }

    private void markResolvedRevisions(Map<BundleRevision, List<ResolverWire>> wireMap) throws ResolveException {
        if (wireMap != null) {
            BundleRevision revision;
            HashMap<BundleRevision, ArrayList<BundleRevision>> hosts = new HashMap<BundleRevision, ArrayList<BundleRevision>>();
            for (Map.Entry<BundleRevision, List<ResolverWire>> entry : wireMap.entrySet()) {
                BundleRevision bundleRevision = entry.getKey();
                List<ResolverWire> wires = entry.getValue();
                if (!Util.isFragment(bundleRevision)) continue;
                for (ResolverWire w : wires) {
                    ArrayList<BundleRevision> fragments = (ArrayList<BundleRevision>)hosts.get(w.getProvider());
                    if (fragments == null) {
                        fragments = new ArrayList<BundleRevision>();
                        hosts.put(w.getProvider(), fragments);
                    }
                    fragments.add(w.getRequirer());
                }
            }
            HashMap<BundleRevision, BundleWiringImpl> wirings = new HashMap<BundleRevision, BundleWiringImpl>(wireMap.size());
            for (Map.Entry<BundleRevision, List<ResolverWire>> entry : wireMap.entrySet()) {
                revision = entry.getKey();
                List<ResolverWire> resolverWires = entry.getValue();
                ArrayList<BundleWire> bundleWires = new ArrayList<BundleWire>(resolverWires.size());
                if (revision.getWiring() != null && Util.isFragment(revision)) {
                    bundleWires.addAll(revision.getWiring().getRequiredWires(null));
                }
                HashMap<String, BundleRevision> importedPkgs = new HashMap<String, BundleRevision>();
                HashMap<String, List<BundleRevision>> requiredPkgs = new HashMap<String, List<BundleRevision>>();
                for (ResolverWire rw : resolverWires) {
                    BundleWireImpl bw = new BundleWireImpl(rw.getRequirer(), rw.getRequirement(), rw.getProvider(), rw.getCapability());
                    bundleWires.add(bw);
                    if (Util.isFragment(revision)) {
                        this.m_felix.getLogger().log(4, new StringBuffer().append("FRAGMENT WIRE: ").append(rw.toString()).toString());
                        continue;
                    }
                    this.m_felix.getLogger().log(4, new StringBuffer().append("WIRE: ").append(rw.toString()).toString());
                    if (rw.getCapability().getNamespace().equals("osgi.wiring.package")) {
                        importedPkgs.put((String)rw.getCapability().getAttributes().get("osgi.wiring.package"), rw.getProvider());
                        continue;
                    }
                    if (!rw.getCapability().getNamespace().equals("osgi.wiring.bundle")) continue;
                    Set<String> pkgs = StatefulResolver.calculateExportedAndReexportedPackages(rw.getProvider(), wireMap, new HashSet<String>(), new HashSet<BundleRevision>());
                    for (String pkg : pkgs) {
                        ArrayList<BundleRevision> revs = (ArrayList<BundleRevision>)requiredPkgs.get(pkg);
                        if (revs == null) {
                            revs = new ArrayList<BundleRevision>();
                            requiredPkgs.put(pkg, revs);
                        }
                        revs.add(rw.getProvider());
                    }
                }
                List fragments = (List)hosts.get(revision);
                try {
                    wirings.put(revision, new BundleWiringImpl(this.m_felix.getLogger(), this.m_felix.getConfig(), this, (BundleRevisionImpl)revision, fragments, bundleWires, importedPkgs, requiredPkgs));
                }
                catch (Exception ex) {
                    for (Map.Entry wiringEntry : wirings.entrySet()) {
                        try {
                            ((BundleWiringImpl)wiringEntry.getValue()).dispose();
                        }
                        catch (Exception ex2) {
                            RuntimeException rte = new RuntimeException("Unable to clean up resolver failure.", ex2);
                            this.m_felix.getLogger().log(1, rte.getMessage(), ex2);
                            throw rte;
                        }
                    }
                    ResolveException re = new ResolveException(new StringBuffer().append("Unable to resolve ").append(revision).toString(), revision, null);
                    re.initCause(ex);
                    this.m_felix.getLogger().log(1, re.getMessage(), ex);
                    throw re;
                }
            }
            for (Map.Entry<BundleRevision, List<ResolverWire>> entry : wirings.entrySet()) {
                revision = (BundleRevisionImpl)entry.getKey();
                BundleWiring wiring = (BundleWiring)((Object)entry.getValue());
                ((BundleRevisionImpl)revision).resolve((BundleWiringImpl)((Object)entry.getValue()));
                for (BundleWire bw : wiring.getRequiredWires(null)) {
                    this.m_felix.getDependencies().addDependent(bw);
                }
                this.m_resolverState.addRevision(revision);
                this.markBundleResolved(revision);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBundleResolved(BundleRevision revision) {
        BundleImpl bundle = (BundleImpl)revision.getBundle();
        try {
            try {
                this.m_felix.acquireBundleLock(bundle, 38);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (bundle.adapt(class$org$osgi$framework$wiring$BundleRevision == null ? (class$org$osgi$framework$wiring$BundleRevision = StatefulResolver.class$("org.osgi.framework.wiring.BundleRevision")) : class$org$osgi$framework$wiring$BundleRevision) == revision) {
                if (bundle.getState() != 2) {
                    this.m_felix.getLogger().log(bundle, 2, "Received a resolve event for a bundle that has already been resolved.");
                } else {
                    this.m_felix.setBundleStateAndNotify(bundle, 4);
                }
            }
        }
        finally {
            this.m_felix.releaseBundleLock(bundle);
        }
    }

    private void fireResolvedEvents(Map<BundleRevision, List<ResolverWire>> wireMap) {
        if (wireMap != null) {
            for (Map.Entry<BundleRevision, List<ResolverWire>> entry : wireMap.entrySet()) {
                BundleRevision revision = entry.getKey();
                List<BundleRevision> fragments = Util.getFragments(revision.getWiring());
                for (int i = 0; i < fragments.size(); ++i) {
                    this.m_felix.fireBundleEvent(32, fragments.get(i).getBundle());
                }
                this.m_felix.fireBundleEvent(32, revision.getBundle());
            }
        }
    }

    private static Set<String> calculateExportedAndReexportedPackages(BundleRevision br, Map<BundleRevision, List<ResolverWire>> wireMap, Set<String> pkgs, Set<BundleRevision> cycles) {
        block5: {
            if (cycles.contains(br)) break block5;
            cycles.add(br);
            for (BundleCapability cap : br.getDeclaredCapabilities(null)) {
                if (!cap.getNamespace().equals("osgi.wiring.package")) continue;
                pkgs.add((String)cap.getAttributes().get("osgi.wiring.package"));
            }
            if (br.getWiring() == null) {
                for (ResolverWire rw : wireMap.get(br)) {
                    String dir;
                    if (!rw.getCapability().getNamespace().equals("osgi.wiring.bundle") || (dir = rw.getRequirement().getDirectives().get("visibility")) == null || !dir.equals("reexport")) continue;
                    StatefulResolver.calculateExportedAndReexportedPackages(rw.getProvider(), wireMap, pkgs, cycles);
                }
            } else {
                for (BundleWire bw : br.getWiring().getRequiredWires(null)) {
                    String dir;
                    if (!bw.getCapability().getNamespace().equals("osgi.wiring.bundle") || (dir = bw.getRequirement().getDirectives().get("visibility")) == null || !dir.equals("reexport")) continue;
                    StatefulResolver.calculateExportedAndReexportedPackages(bw.getProviderWiring().getRevision(), wireMap, pkgs, cycles);
                }
            }
        }
        return pkgs;
    }

    private static Set<String> parseExecutionEnvironments(String fwkExecEnvStr) {
        HashSet<String> newSet = new HashSet<String>();
        if (fwkExecEnvStr != null) {
            StringTokenizer tokens = new StringTokenizer(fwkExecEnvStr, ",");
            while (tokens.hasMoreTokens()) {
                newSet.add(tokens.nextToken().trim());
            }
        }
        return newSet;
    }

    private static void addToSingletonMap(Map<String, List<BundleRevision>> singletons, BundleRevision br) {
        List<BundleRevision> revisions = singletons.get(br.getSymbolicName());
        if (revisions == null) {
            revisions = new ArrayList<BundleRevision>();
        }
        revisions.add(br);
        singletons.put(br.getSymbolicName(), revisions);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResolverStateImpl
    implements Resolver.ResolverState {
        private final Set<BundleRevision> m_revisions = new HashSet<BundleRevision>();
        private final Set<BundleRevision> m_fragments = new HashSet<BundleRevision>();
        private final Map<String, CapabilitySet> m_capSets = new HashMap<String, CapabilitySet>();
        private final Map<String, List<BundleRevision>> m_singletons = new HashMap<String, List<BundleRevision>>();
        private final Set<BundleRevision> m_selectedSingletons = new HashSet<BundleRevision>();
        private final String m_fwkExecEnvStr;
        private final Set<String> m_fwkExecEnvSet;

        ResolverStateImpl(String fwkExecEnvStr) {
            this.m_fwkExecEnvStr = fwkExecEnvStr != null ? fwkExecEnvStr.trim() : null;
            this.m_fwkExecEnvSet = StatefulResolver.parseExecutionEnvironments(fwkExecEnvStr);
            ArrayList<String> indices = new ArrayList<String>();
            indices.add("osgi.wiring.bundle");
            this.m_capSets.put("osgi.wiring.bundle", new CapabilitySet(indices, true));
            indices = new ArrayList();
            indices.add("osgi.wiring.package");
            this.m_capSets.put("osgi.wiring.package", new CapabilitySet(indices, true));
            indices = new ArrayList();
            indices.add("osgi.wiring.host");
            this.m_capSets.put("osgi.wiring.host", new CapabilitySet(indices, true));
        }

        synchronized Set<BundleRevision> getUnresolvedRevisions() {
            HashSet<BundleRevision> unresolved = new HashSet<BundleRevision>();
            for (BundleRevision revision : this.m_revisions) {
                if (revision.getWiring() != null) continue;
                unresolved.add(revision);
            }
            return unresolved;
        }

        synchronized void addRevision(BundleRevision br) {
            this.removeRevision(br);
            this.m_revisions.add(br);
            if (Util.isSingleton(br)) {
                StatefulResolver.addToSingletonMap(this.m_singletons, br);
            } else {
                if (Util.isFragment(br)) {
                    this.m_fragments.add(br);
                }
                this.indexCapabilities(br);
            }
        }

        private synchronized void indexCapabilities(BundleRevision br) {
            List<BundleCapability> caps;
            List<BundleCapability> list = caps = Util.isFragment(br) || br.getWiring() == null ? br.getDeclaredCapabilities(null) : br.getWiring().getCapabilities(null);
            if (caps != null) {
                for (BundleCapability cap : caps) {
                    if (cap.getRevision() != br) continue;
                    CapabilitySet capSet = this.m_capSets.get(cap.getNamespace());
                    if (capSet == null) {
                        capSet = new CapabilitySet(null, true);
                        this.m_capSets.put(cap.getNamespace(), capSet);
                    }
                    capSet.addCapability(cap);
                }
            }
        }

        private synchronized void deindexCapabilities(BundleRevision br) {
            List<BundleCapability> caps = br.getDeclaredCapabilities(null);
            if (caps != null) {
                for (BundleCapability cap : caps) {
                    CapabilitySet capSet = this.m_capSets.get(cap.getNamespace());
                    if (capSet == null) continue;
                    capSet.removeCapability(cap);
                }
            }
        }

        synchronized void removeRevision(BundleRevision br) {
            if (this.m_revisions.remove(br)) {
                this.m_fragments.remove(br);
                this.deindexCapabilities(br);
                List<BundleRevision> revisions = this.m_singletons.get(br.getSymbolicName());
                if (revisions != null) {
                    revisions.remove(br);
                    if (revisions.isEmpty()) {
                        this.m_singletons.remove(br.getSymbolicName());
                    }
                }
            }
        }

        synchronized Set<BundleRevision> getFragments() {
            return new HashSet<BundleRevision>(this.m_fragments);
        }

        synchronized boolean isSelectedSingleton(BundleRevision br) {
            return this.m_selectedSingletons.contains(br);
        }

        synchronized void selectSingletons() throws BundleException {
            this.m_selectedSingletons.clear();
            for (Map.Entry<String, List<BundleRevision>> entry : this.m_singletons.entrySet()) {
                for (BundleRevision singleton : entry.getValue()) {
                    if (singleton.getWiring() != null) continue;
                    this.deindexCapabilities(singleton);
                    this.m_fragments.remove(singleton);
                }
            }
            if (StatefulResolver.this.m_hooks.isEmpty()) {
                this.selectDefaultSingletons();
            } else {
                this.selectSingletonsUsingHooks();
            }
        }

        private void selectDefaultSingletons() {
            for (Map.Entry<String, List<BundleRevision>> entry : this.m_singletons.entrySet()) {
                this.selectSingleton(entry.getValue());
            }
        }

        private void selectSingletonsUsingHooks() throws BundleException {
            HashMap<BundleCapability, Collection<BundleCapability>> allCollisions = new HashMap<BundleCapability, Collection<BundleCapability>>();
            for (Map.Entry<String, List<BundleRevision>> entry : this.m_singletons.entrySet()) {
                ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
                for (BundleRevision br : entry.getValue()) {
                    List<BundleCapability> caps = br.getDeclaredCapabilities("osgi.wiring.bundle");
                    if (caps.isEmpty()) continue;
                    arrayList.add(caps.get(0));
                }
                for (BundleCapability bc : arrayList) {
                    ShrinkableCollection capCopy = new ShrinkableCollection(new ArrayList(arrayList));
                    capCopy.remove(bc);
                    allCollisions.put(bc, capCopy);
                }
            }
            for (ResolverHook hook : StatefulResolver.this.m_hooks) {
                for (Map.Entry entry : allCollisions.entrySet()) {
                    try {
                        Felix.m_secureAction.invokeResolverHookSingleton(hook, (BundleCapability)entry.getKey(), (Collection)entry.getValue());
                    }
                    catch (Throwable ex) {
                        throw new BundleException(new StringBuffer().append("Resolver hook exception: ").append(ex.getMessage()).toString(), 12, ex);
                    }
                }
            }
            ArrayList<List<BundleRevision>> groups = new ArrayList<List<BundleRevision>>();
            while (!allCollisions.isEmpty()) {
                BundleCapability target = (BundleCapability)allCollisions.entrySet().iterator().next().getKey();
                groups.add(this.groupSingletons(allCollisions, target, new ArrayList<BundleRevision>()));
            }
            for (List list : groups) {
                this.selectSingleton(list);
            }
        }

        private List<BundleRevision> groupSingletons(Map<BundleCapability, Collection<BundleCapability>> allCollisions, BundleCapability target, List<BundleRevision> group) {
            if (!group.contains(target.getRevision())) {
                boolean repeat;
                group.add(target.getRevision());
                Collection<BundleCapability> collisions = allCollisions.remove(target);
                for (BundleCapability collision : collisions) {
                    this.groupSingletons(allCollisions, collision, group);
                }
                block1: do {
                    repeat = false;
                    for (Map.Entry<BundleCapability, Collection<BundleCapability>> entry : allCollisions.entrySet()) {
                        if (!entry.getValue().contains(target)) continue;
                        repeat = true;
                        this.groupSingletons(allCollisions, entry.getKey(), group);
                        continue block1;
                    }
                } while (repeat);
            }
            return group;
        }

        private void selectSingleton(List<BundleRevision> singletons) {
            BundleRevision selected = null;
            for (BundleRevision singleton : singletons) {
                if (singleton.getWiring() != null) {
                    selected = null;
                    break;
                }
                if (StatefulResolver.this.m_whitelist != null && !StatefulResolver.this.m_whitelist.contains(singleton) || selected != null && selected.getVersion().compareTo(singleton.getVersion()) <= 0) continue;
                selected = singleton;
            }
            if (selected != null) {
                this.m_selectedSingletons.add(selected);
                this.indexCapabilities(selected);
                if (Util.isFragment(selected)) {
                    this.m_fragments.add(selected);
                }
            }
        }

        @Override
        public boolean isEffective(BundleRequirement req) {
            String effective = req.getDirectives().get("effective");
            return effective == null || effective.equals("resolve");
        }

        @Override
        public synchronized SortedSet<BundleCapability> getCandidates(BundleRequirement req, boolean obeyMandatory) {
            BundleRevisionImpl reqRevision = (BundleRevisionImpl)req.getRevision();
            TreeSet<BundleCapability> result = new TreeSet<BundleCapability>(new CandidateComparator());
            CapabilitySet capSet = this.m_capSets.get(req.getNamespace());
            if (capSet != null) {
                String filter;
                SimpleFilter sf = null;
                sf = req instanceof BundleRequirementImpl ? ((BundleRequirementImpl)req).getFilter() : ((filter = req.getDirectives().get("filter")) == null ? new SimpleFilter(null, null, 0) : SimpleFilter.parse(filter));
                Set<BundleCapability> matches = capSet.match(sf, obeyMandatory);
                for (BundleCapability cap : matches) {
                    if (this.filteredBySecurity(req, cap) || req.getNamespace().equals("osgi.wiring.host") && cap.getRevision().getWiring() != null) continue;
                    result.add(cap);
                }
            }
            if (!result.isEmpty() && !StatefulResolver.this.m_hooks.isEmpty()) {
                if (StatefulResolver.this.m_whitelist != null) {
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        if (StatefulResolver.this.m_whitelist.contains(((BundleCapability)it.next()).getRevision())) continue;
                        it.remove();
                    }
                }
                ShrinkableCollection<BundleCapability> shrinkable = new ShrinkableCollection<BundleCapability>(result);
                for (ResolverHook hook : StatefulResolver.this.m_hooks) {
                    try {
                        Felix.m_secureAction.invokeResolverHookMatches(hook, req, shrinkable);
                    }
                    catch (Throwable th) {
                        StatefulResolver.this.m_logger.log(2, "Resolver hook exception.", th);
                    }
                }
            }
            return result;
        }

        private boolean filteredBySecurity(BundleRequirement req, BundleCapability cap) {
            if (System.getSecurityManager() != null) {
                BundleRevisionImpl reqRevision = (BundleRevisionImpl)req.getRevision();
                if (req.getNamespace().equals("osgi.wiring.package") ? (!((BundleProtectionDomain)((BundleRevisionImpl)cap.getRevision()).getProtectionDomain()).impliesDirect(new PackagePermission((String)cap.getAttributes().get("osgi.wiring.package"), "exportonly")) || reqRevision != null && !((BundleProtectionDomain)reqRevision.getProtectionDomain()).impliesDirect(new PackagePermission((String)cap.getAttributes().get("osgi.wiring.package"), cap.getRevision().getBundle(), "import"))) && reqRevision != cap.getRevision() : (req.getNamespace().equals("osgi.wiring.bundle") ? !((BundleProtectionDomain)((BundleRevisionImpl)cap.getRevision()).getProtectionDomain()).impliesDirect(new BundlePermission(cap.getRevision().getSymbolicName(), "provide")) || reqRevision != null && !((BundleProtectionDomain)reqRevision.getProtectionDomain()).impliesDirect(new BundlePermission(reqRevision.getSymbolicName(), "require")) : (req.getNamespace().equals("osgi.wiring.host") ? !((BundleProtectionDomain)reqRevision.getProtectionDomain()).impliesDirect(new BundlePermission(reqRevision.getSymbolicName(), "fragment")) || !((BundleProtectionDomain)((BundleRevisionImpl)cap.getRevision()).getProtectionDomain()).impliesDirect(new BundlePermission(cap.getRevision().getSymbolicName(), "host")) : !req.getNamespace().equals("osgi.ee") && (!((BundleProtectionDomain)((BundleRevisionImpl)cap.getRevision()).getProtectionDomain()).impliesDirect(new CapabilityPermission(req.getNamespace(), "provide")) || reqRevision != null && !((BundleProtectionDomain)reqRevision.getProtectionDomain()).impliesDirect(new CapabilityPermission(req.getNamespace(), cap.getAttributes(), cap.getRevision().getBundle(), "require")))))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void checkExecutionEnvironment(BundleRevision revision) throws ResolveException {
            String bundleExecEnvStr = (String)((BundleRevisionImpl)revision).getHeaders().get("Bundle-RequiredExecutionEnvironment");
            if (bundleExecEnvStr != null && !(bundleExecEnvStr = bundleExecEnvStr.trim()).equals("") && this.m_fwkExecEnvStr != null && this.m_fwkExecEnvStr.length() > 0) {
                StringTokenizer tokens = new StringTokenizer(bundleExecEnvStr, ",");
                boolean found = false;
                while (tokens.hasMoreTokens() && !found) {
                    if (!this.m_fwkExecEnvSet.contains(tokens.nextToken().trim())) continue;
                    found = true;
                }
                if (!found) {
                    throw new ResolveException(new StringBuffer().append("Execution environment not supported: ").append(bundleExecEnvStr).toString(), revision, null);
                }
            }
        }

        @Override
        public void checkNativeLibraries(BundleRevision revision) throws ResolveException {
            List<R4Library> libs = ((BundleRevisionImpl)revision).getDeclaredNativeLibraries();
            if (libs != null) {
                String msg = null;
                for (int libIdx = 0; msg == null && libIdx < libs.size(); ++libIdx) {
                    String entryName = libs.get(libIdx).getEntryName();
                    if (entryName == null || ((BundleRevisionImpl)revision).getContent().hasEntry(entryName)) continue;
                    msg = new StringBuffer().append("Native library does not exist: ").append(entryName).toString();
                }
                if (libs.isEmpty()) {
                    msg = "No matching native libraries found.";
                }
                if (msg != null) {
                    throw new ResolveException(msg, revision, null);
                }
            }
        }
    }
}

