/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import net.jini.io.context.AcknowledgmentSource;

abstract class Request {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private static final int UNUSED = 0;
    private static final int OPEN = 1;
    private static final int EOF = 2;
    private static final int CLOSED = 3;
    private static final int INVALID = 4;
    private final Object stateLock = new Object();
    private final Object outLock = new Object();
    private final Object inLock = new Object();
    private final ContentOutputStream out = new ContentOutputStream();
    private final ContentInputStream in = new ContentInputStream();
    private boolean aborted = false;
    private int outState = 0;
    private int inState = 0;
    private IOException outException;
    private IOException inException;

    Request() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDeliveryStatus() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.outState > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.aborted || this.outState >= 3 && this.inState >= 2) {
                return;
            }
            this.aborted = true;
        }
        Runnable reaper = new Runnable(){

            public void run() {
                Request.this.finish();
            }
        };
        systemThreadPool.execute(reaper, "Request reaper");
    }

    void finish() {
        try {
            this.out.close(false);
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            this.in.close(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    InputStream getInputStream() {
        return this.in;
    }

    abstract void startOutput() throws IOException;

    abstract void write(byte[] var1, int var2, int var3) throws IOException;

    abstract void endOutput() throws IOException;

    abstract boolean startInput() throws IOException;

    abstract int read(byte[] var1, int var2, int var3) throws IOException;

    abstract int available() throws IOException;

    abstract void endInput() throws IOException;

    abstract void addAckListener(AcknowledgmentSource.Listener var1);

    abstract void done(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean addAcknowledgmentListener(AcknowledgmentSource.Listener l) {
        Object object = this.outLock;
        synchronized (object) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (this.aborted || this.outState >= 3) {
                    return false;
                }
            }
            this.addAckListener(l);
        }
        return true;
    }

    private class ContentInputStream
    extends InputStream {
        private ContentInputStream() {
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) != -1 ? b[0] & 0xFF : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = Request.this.inLock;
            synchronized (object) {
                if (!this.checkOpen()) {
                    return -1;
                }
                try {
                    int n = Request.this.read(b, off, len);
                    if (n == -1) {
                        Request.this.endInput();
                        Object object2 = Request.this.stateLock;
                        synchronized (object2) {
                            Request.this.inState = 2;
                            if (Request.this.outState >= 3) {
                                Request.this.done(Request.this.outState == 4);
                            }
                        }
                    }
                    return n;
                }
                catch (Throwable th) {
                    this.invalidate(th);
                    throw new InternalError();
                }
            }
        }

        public int available() throws IOException {
            Object object = Request.this.inLock;
            synchronized (object) {
                if (!this.checkOpen()) {
                    return 0;
                }
                try {
                    return Request.this.available();
                }
                catch (Throwable th) {
                    this.invalidate(th);
                    throw new InternalError();
                }
            }
        }

        public void close() throws IOException {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkOpen() throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.aborted) {
                    throw new IOException("request aborted");
                }
                switch (Request.this.inState) {
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        throw new IOException("stream closed");
                    }
                    case 4: {
                        throw Request.this.inException;
                    }
                }
                Request.this.inState = 1;
            }
            try {
                if (Request.this.startInput()) {
                    return true;
                }
                Request.this.endInput();
                object = Request.this.stateLock;
                synchronized (object) {
                    Request.this.inState = 2;
                    if (Request.this.outState >= 3) {
                        Request.this.done(Request.this.outState == 4);
                    }
                }
                return false;
            }
            catch (Throwable th) {
                this.invalidate(th);
                throw new InternalError();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean checkAbort) throws IOException {
            Object object = Request.this.inLock;
            synchronized (object) {
                Object object2 = Request.this.stateLock;
                synchronized (object2) {
                    if (checkAbort && Request.this.aborted) {
                        throw new IOException("request aborted");
                    }
                    switch (Request.this.inState) {
                        case 2: {
                            Request.this.inState = 3;
                        }
                        case 3: {
                            return;
                        }
                        case 4: {
                            throw Request.this.inException;
                        }
                    }
                }
                try {
                    if (Request.this.inState == 0) {
                        Request.this.startInput();
                    }
                    Request.this.endInput();
                }
                catch (Throwable th) {
                    this.invalidate(th);
                }
                object2 = Request.this.stateLock;
                synchronized (object2) {
                    Request.this.inState = 3;
                    if (Request.this.outState >= 3) {
                        Request.this.done(Request.this.outState == 4);
                    }
                }
            }
        }

        private void invalidate(Throwable cause) throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.inState != 4) {
                    if (Request.this.inState <= 1 && Request.this.outState >= 3) {
                        Request.this.done(true);
                    }
                    Request.this.inState = 4;
                    Request.this.inException = new IOException("stream invalid");
                    Request.this.inException.initCause(cause);
                }
                throw Request.this.inException;
            }
        }
    }

    private class ContentOutputStream
    extends OutputStream {
        private ContentOutputStream() {
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = Request.this.outLock;
            synchronized (object) {
                this.checkOpen();
                try {
                    Request.this.write(b, off, len);
                }
                catch (Throwable th) {
                    this.invalidate(th);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Object object = Request.this.outLock;
            synchronized (object) {
                this.checkOpen();
            }
        }

        public void close() throws IOException {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkOpen() throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.aborted) {
                    throw new IOException("request aborted");
                }
                switch (Request.this.outState) {
                    case 1: {
                        return;
                    }
                    case 3: {
                        throw new IOException("stream closed");
                    }
                    case 4: {
                        throw Request.this.outException;
                    }
                }
                Request.this.outState = 1;
            }
            try {
                Request.this.startOutput();
            }
            catch (Throwable th) {
                this.invalidate(th);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close(boolean checkAbort) throws IOException {
            Object object = Request.this.outLock;
            synchronized (object) {
                Object object2 = Request.this.stateLock;
                synchronized (object2) {
                    if (checkAbort && Request.this.aborted) {
                        throw new IOException("request aborted");
                    }
                    if (Request.this.outState == 3) {
                        return;
                    }
                    if (Request.this.outState == 4) {
                        throw Request.this.outException;
                    }
                }
                try {
                    if (Request.this.outState == 0) {
                        Request.this.startOutput();
                    }
                    Request.this.endOutput();
                }
                catch (Throwable th) {
                    this.invalidate(th);
                }
                object2 = Request.this.stateLock;
                synchronized (object2) {
                    Request.this.outState = 3;
                    if (Request.this.inState >= 2) {
                        Request.this.done(Request.this.inState == 4);
                    }
                }
            }
        }

        private void invalidate(Throwable cause) throws IOException {
            Object object = Request.this.stateLock;
            synchronized (object) {
                if (Request.this.outState != 4) {
                    if (Request.this.outState <= 1 && Request.this.inState >= 2) {
                        Request.this.done(true);
                    }
                    Request.this.outState = 4;
                    Request.this.outException = new IOException("stream invalid");
                    Request.this.outException.initCause(cause);
                }
                throw Request.this.outException;
            }
        }
    }
}

