/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.PinDirection;
import java.util.EnumSet;

public enum PinMode {
    DIGITAL_INPUT(0, "input", PinDirection.IN),
    DIGITAL_OUTPUT(1, "output", PinDirection.OUT),
    PWM_OUTPUT(2, "pwm_output", PinDirection.OUT),
    ANALOG_INPUT(3, "analog_input", PinDirection.IN),
    ANALOG_OUTPUT(4, "analog_output", PinDirection.OUT);

    private final int value;
    private final String name;
    private final PinDirection direction;

    private PinMode(int value, String name, PinDirection direction) {
        this.value = value;
        this.name = name;
        this.direction = direction;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public PinDirection getDirection() {
        return this.direction;
    }

    public String toString() {
        return this.name.toUpperCase();
    }

    public static EnumSet<PinMode> allDigital() {
        return EnumSet.of(DIGITAL_INPUT, DIGITAL_OUTPUT);
    }

    public static EnumSet<PinMode> allAnalog() {
        return EnumSet.of(ANALOG_INPUT, ANALOG_OUTPUT);
    }

    public static EnumSet<PinMode> all() {
        return EnumSet.of(DIGITAL_INPUT, DIGITAL_OUTPUT, ANALOG_INPUT, ANALOG_OUTPUT, PWM_OUTPUT);
    }

    public static EnumSet<PinMode> allInputs() {
        return EnumSet.of(DIGITAL_INPUT, ANALOG_INPUT);
    }

    public static EnumSet<PinMode> allOutput() {
        return EnumSet.of(DIGITAL_OUTPUT, ANALOG_OUTPUT, PWM_OUTPUT);
    }
}

