/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.termstructures.yieldcurves;

import org.jquantlib.daycounters.DayCounter;
import org.jquantlib.quotes.Handle;
import org.jquantlib.quotes.Quote;
import org.jquantlib.termstructures.Compounding;
import org.jquantlib.termstructures.InterestRate;
import org.jquantlib.termstructures.YieldTermStructure;
import org.jquantlib.termstructures.yieldcurves.ZeroYieldStructure;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Frequency;
import org.jquantlib.util.Date;

public class ZeroSpreadedTermStructure
extends ZeroYieldStructure {
    private Handle<YieldTermStructure> originalCurve_;
    private Handle<Quote> spread_;
    private Compounding comp_;
    private Frequency freq_;

    public ZeroSpreadedTermStructure(Handle<YieldTermStructure> h, Handle<Quote> spread, Compounding comp, Frequency freq, DayCounter dc) {
        this.originalCurve_ = h;
        this.spread_ = spread;
        this.comp_ = comp;
        this.freq_ = freq;
    }

    @Override
    protected double zeroYieldImpl(double t) {
        InterestRate zeroRate = this.originalCurve_.getLink().zeroRate(t, this.comp_, this.freq_, true);
        InterestRate spreadedRate = new InterestRate(zeroRate.rate() + this.spread_.getLink().evaluate(), zeroRate.dayCounter(), zeroRate.compounding(), zeroRate.frequency());
        return spreadedRate.equivalentRate(t, Compounding.CONTINUOUS, Frequency.NO_FREQUENCY).rate();
    }

    public double forwardImpl(double t) {
        return this.originalCurve_.getLink().forwardRate(t, t, this.comp_, this.freq_, true).rate() + this.spread_.getLink().evaluate();
    }

    @Override
    public Calendar calendar() {
        return this.originalCurve_.getLink().calendar();
    }

    @Override
    public Date referenceDate() {
        return this.originalCurve_.getLink().referenceDate();
    }

    @Override
    public Date maxDate() {
        return this.originalCurve_.getLink().maxDate();
    }

    @Override
    public double maxTime() {
        return this.originalCurve_.getLink().maxTime();
    }
}

