; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=2 -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

; Should not propagate the result of a weak function.
; PR2411

define weak i32 @foo() nounwind  {
; CHECK: Function Attrs: nounwind
; CHECK-LABEL: define {{[^@]+}}@foo
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 1
;
entry:
  ret i32 1
}

define i32 @main() nounwind  {
; TUNIT: Function Attrs: norecurse nounwind
; TUNIT-LABEL: define {{[^@]+}}@main
; TUNIT-SAME: () #[[ATTR1:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[R:%.*]] = call i32 @foo() #[[ATTR0]]
; TUNIT-NEXT:    ret i32 [[R]]
;
; CGSCC: Function Attrs: nounwind
; CGSCC-LABEL: define {{[^@]+}}@main
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[R:%.*]] = call i32 @foo() #[[ATTR0]]
; CGSCC-NEXT:    ret i32 [[R]]
;
entry:
  %r = call i32 @foo( ) nounwind
  ret i32 %r
}

;.
; TUNIT: attributes #[[ATTR0]] = { nounwind }
; TUNIT: attributes #[[ATTR1]] = { norecurse nounwind }
;.
; CGSCC: attributes #[[ATTR0]] = { nounwind }
;.
