; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k-linux -verify-machineinstrs | FileCheck %s

declare i8 @llvm.fshr.i8(i8, i8, i8)
declare i16 @llvm.fshr.i16(i16, i16, i16)
declare i32 @llvm.fshr.i32(i32, i32, i32)

; op reg, reg

define zeroext i8 @rorb(i8 zeroext %a, i8 zeroext %b) nounwind {
; CHECK-LABEL: rorb:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.b (11,%sp), %d0
; CHECK-NEXT:    move.b (7,%sp), %d1
; CHECK-NEXT:    ror.b %d0, %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    rts
  %1 = tail call i8 @llvm.fshr.i8(i8 %a, i8 %a, i8 %b)
  ret i8 %1
}

define zeroext i16 @rorw(i16 zeroext %a, i16 zeroext %b) nounwind {
; CHECK-LABEL: rorw:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.w (10,%sp), %d0
; CHECK-NEXT:    move.w (6,%sp), %d1
; CHECK-NEXT:    ror.w %d0, %d1
; CHECK-NEXT:    move.l %d1, %d0
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    rts
  %1 = tail call i16 @llvm.fshr.i16(i16 %a, i16 %a, i16 %b)
  ret i16 %1
}

define i32 @rorl(i32 %a, i32 %b) nounwind {
; CHECK-LABEL: rorl:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.l (8,%sp), %d1
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    ror.l %d1, %d0
; CHECK-NEXT:    rts
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 %b)
  ret i32 %1
}

; op reg, imm

define zeroext i8 @rorib(i8 zeroext %a) nounwind {
; CHECK-LABEL: rorib:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.b (7,%sp), %d0
; CHECK-NEXT:    ror.b #3, %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    rts
  %1 = tail call i8 @llvm.fshr.i8(i8 %a, i8 %a, i8 3)
  ret i8 %1
}

define zeroext i16 @roriw(i16 zeroext %a) nounwind {
; CHECK-LABEL: roriw:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.w (6,%sp), %d0
; CHECK-NEXT:    ror.w #5, %d0
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    rts
  %1 = tail call i16 @llvm.fshr.i16(i16 %a, i16 %a, i16 5)
  ret i16 %1
}

define i32 @roril(i32 %a) nounwind {
; CHECK-LABEL: roril:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    ror.l #7, %d0
; CHECK-NEXT:    rts
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 7)
  ret i32 %1
}
