"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bundlePlugin = void 0;
const tslib_1 = require("tslib");
const clearConsole_1 = tslib_1.__importDefault(require("react-dev-utils/clearConsole"));
const formatWebpackMessages_1 = tslib_1.__importDefault(require("react-dev-utils/formatWebpackMessages"));
const webpack_1 = tslib_1.__importDefault(require("webpack"));
const webpack_plugin_config_1 = require("../../../config/webpack.plugin.config");
const bundlePlugin = ({ watch, production, preserveConsole }) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    const compiler = (0, webpack_1.default)(yield (0, webpack_plugin_config_1.loadWebpackConfig)({
        watch,
        production,
        preserveConsole,
    }));
    const webpackPromise = new Promise((resolve, reject) => {
        if (watch) {
            console.log('Started watching plugin for changes...');
            compiler.watch({}, (err, stats) => { });
            // @ts-ignore
            compiler.hooks.invalid.tap('invalid', () => {
                (0, clearConsole_1.default)();
                console.log('Compiling...');
            });
            compiler.hooks.done.tap('done', (stats) => {
                (0, clearConsole_1.default)();
                const json = stats.toJson();
                const output = (0, formatWebpackMessages_1.default)(json);
                if (!output.errors.length && !output.warnings.length) {
                    console.log('Compiled successfully!\n');
                    console.log(stats.toString({ colors: true }));
                }
                if (output.errors.length) {
                    console.log('Compilation failed!');
                    output.errors.forEach((e) => console.log(e));
                    if (output.warnings.length) {
                        console.log('Warnings:');
                        output.warnings.forEach((w) => console.log(w));
                    }
                }
                if (output.errors.length === 0 && output.warnings.length) {
                    console.log('Compiled with warnings!');
                    output.warnings.forEach((w) => console.log(w));
                }
            });
        }
        else {
            compiler.run((err, stats) => {
                if (err) {
                    reject(err);
                    return;
                }
                if (stats === null || stats === void 0 ? void 0 : stats.hasErrors()) {
                    stats.compilation.errors.forEach((e) => {
                        console.log(e.message);
                    });
                    reject('Build failed');
                    return;
                }
                console.log('\n', stats === null || stats === void 0 ? void 0 : stats.toString({ colors: true }), '\n');
                resolve();
            });
        }
    });
    return webpackPromise;
});
exports.bundlePlugin = bundlePlugin;
//# sourceMappingURL=bundle.js.map