#
# DO NOT MODIFY!!!!
# This file is automatically generated by Racc 1.5.2
# from Racc grammar file "".
#

require 'racc/parser.rb'
module RBS
  class Parser < Racc::Parser

module_eval(<<'...end parser.y/module_eval...', 'parser.y', 1394)

Types = RBS::Types
Namespace = RBS::Namespace
TypeName = RBS::TypeName
Declarations = RBS::AST::Declarations
Members = RBS::AST::Members
MethodType = RBS::MethodType
Annotation = RBS::AST::Annotation

class LocatedValue
  attr_reader :location
  attr_reader :value

  def initialize(location:, value:)
    @location = location
    @value = value
  end
end

attr_reader :input
attr_reader :buffer
attr_reader :eof_re

def initialize(type, buffer:, eof_re:)
  super()
  @type = type
  @buffer = buffer
  @input = CharScanner.new(buffer.content)
  @eof_re = eof_re
  @eof = false
  @bound_variables_stack = []
  @comments = {}
  @ascii_only = buffer.content.ascii_only?
end

def start_merged_variables_scope
  set = @bound_variables_stack.last&.dup || Set.new
  @bound_variables_stack.push set
end

def start_new_variables_scope
  @bound_variables_stack.push Set.new
end

def reset_variable_scope
  @bound_variables_stack.pop
end

def insert_bound_variable(var)
  @bound_variables_stack.last << var
end

def is_bound_variable?(var)
  (@bound_variables_stack.last || Set.new).member?(var)
end

def self.parse_signature(input, eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:SIGNATURE, buffer: buffer, eof_re: eof_re).do_parse
end

def self.parse_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:TYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def self.parse_method_type(input, variables: [], eof_re: nil)
  case input
  when RBS::Buffer
    buffer = input
  else
    buffer = RBS::Buffer.new(name: nil, content: input.to_s)
  end

  self.new(:METHODTYPE, buffer: buffer, eof_re: eof_re).yield_self do |parser|
    parser.start_new_variables_scope

    variables.each do |var|
      parser.insert_bound_variable var
    end

    parser.do_parse
  ensure
    parser.reset_variable_scope
  end
end

def leading_comment(location)
  @comments[location.start_line-1]
end

def push_comment(string, location)
  if (comment = leading_comment(location)) && comment.location.start_column == location.start_column
    comment.concat(string: "#{string}\n", location: location)
    @comments[comment.location.end_line] = comment
  else
    new_comment = AST::Comment.new(string: "#{string}\n", location: location)
    @comments[new_comment.location.end_line] = new_comment
  end
end

def new_token(type, value = input.matched)
  charpos = charpos(input)
  matched = input.matched

  if matched
    start_index = charpos - matched.size
    end_index = charpos

    location = RBS::Location.new(buffer: buffer,
                                 start_pos: start_index,
                                 end_pos: end_index)

    [type, LocatedValue.new(location: location, value: value)]
  else
    # scanner hasn't matched yet
    [false, nil]
  end
end

def charpos(scanner)
  scanner.charpos
end

def empty_params_result
  [
    [],
    [],
    nil,
    [],
    {},
    {},
    nil
  ]
end

KEYWORDS = {
  "class" => :kCLASS,
  "type" => :kTYPE,
  "def" => :kDEF,
  "self" => :kSELF,
  "void" => :kVOID,
  "any" => :kANY,
  "untyped" => :kUNTYPED,
  "top" => :kTOP,
  "bot" => :kBOT,
  "instance" => :kINSTANCE,
  "bool" => :kBOOL,
  "nil" => :kNIL,
  "true" => :kTRUE,
  "false" => :kFALSE,
  "singleton" => :kSINGLETON,
  "interface" => :kINTERFACE,
  "end" => :kEND,
  "include" => :kINCLUDE,
  "extend" => :kEXTEND,
  "prepend" => :kPREPEND,
  "module" => :kMODULE,
  "attr_reader" => :kATTRREADER,
  "attr_writer" => :kATTRWRITER,
  "attr_accessor" => :kATTRACCESSOR,
  "public" => :kPUBLIC,
  "private" => :kPRIVATE,
  "alias" => :kALIAS,
  "extension" => :kEXTENSION,
  "incompatible" => :kINCOMPATIBLE,
  "unchecked" => :kUNCHECKED,
  "overload" => :kOVERLOAD,
  "out" => :kOUT,
  "in" => :kIN,
}
KEYWORDS_RE = /#{Regexp.union(*KEYWORDS.keys)}\b/

PUNCTS = {
  "===" => :tOPERATOR,
  "==" => :tOPERATOR,
  "=~" => :tOPERATOR,
  "!~" => :tOPERATOR,
  "!=" => :tOPERATOR,
  ">=" => :tOPERATOR,
  "<<" => :tOPERATOR,
  "<=>" => :tOPERATOR,
  "<=" => :tOPERATOR,
  ">>" => :tOPERATOR,
  ">" => :tOPERATOR,
  "~" => :tOPERATOR,
  "+@" => :tOPERATOR,
  "+" => :tOPERATOR,
  "[]=" => :tOPERATOR,
  "[]" => :tOPERATOR,
  "::" => :kCOLON2,
  ":" => :kCOLON,
  "(" => :kLPAREN,
  ")" => :kRPAREN,
  "[" => :kLBRACKET,
  "]" => :kRBRACKET,
  "{" => :kLBRACE,
  "}" => :kRBRACE,
  "," => :kCOMMA,
  "|" => :kBAR,
  "&" => :kAMP,
  "^" => :kHAT,
  "->" => :kARROW,
  "=>" => :kFATARROW,
  "=" => :kEQ,
  "?" => :kQUESTION,
  "!" => :kEXCLAMATION,
  "**" => :kSTAR2,
  "*" => :kSTAR,
  "..." => :kDOT3,
  "." => :kDOT,
  "<" => :kLT,
  "-@" => :tOPERATOR,
  "-" => :tOPERATOR,
  "/" => :tOPERATOR,
  "`" => :tOPERATOR,
  "%" => :tOPERATOR,
}
PUNCTS_RE = Regexp.union(*PUNCTS.keys)

ANNOTATION_RE = Regexp.union(/%a\{.*?\}/,
                             /%a\[.*?\]/,
                             /%a\(.*?\)/,
                             /%a\<.*?\>/,
                             /%a\|.*?\|/)

escape_sequences = %w[a b e f n r s t v "].map { |l| "\\\\#{l}" }
DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE = /(#{escape_sequences.join("|")})/

def next_token
  if @type
    type = @type
    @type = nil
    return [:"type_#{type}", nil]
  end

  return new_token(false, '') if @eof

  while true
    return new_token(false, '') if input.eos?

    case
    when input.scan(/\s+/)
      # skip
    when input.scan(/#(( *)|( ?(?<string>.*)))\n/)
      charpos = charpos(input)
      start_index = charpos - input.matched.size
      end_index = charpos-1

      location = RBS::Location.new(buffer: buffer,
                                               start_pos: start_index,
                                               end_pos: end_index)

      push_comment input[:string] || "", location
    else
      break
    end
  end

  case
  when eof_re && input.scan(eof_re)
    @eof = true
    [:tEOF, input.matched]
  when input.scan(/`[a-zA-Z_]\w*`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }
    new_token(:tQUOTEDIDENT, s)
  when input.scan(/`(\\`|[^` :])+`/)
    s = input.matched.yield_self {|s| s[1, s.length-2] }.gsub(/\\`/, '`')
    new_token(:tQUOTEDMETHOD, s)
  when input.scan(ANNOTATION_RE)
    s = input.matched.yield_self {|s| s[3, s.length-4] }.strip
    new_token(:tANNOTATION, s)
  when input.scan(/self\?/)
    new_token(:kSELFQ, "self?")
  when input.scan(/(([a-zA-Z]\w*)|(_\w+))=/)
    new_token(:tWRITE_ATTR)
  when input.scan(KEYWORDS_RE)
    new_token(KEYWORDS[input.matched], input.matched.to_sym)
  when input.scan(/:((@{,2}|\$)?\w+(\?|\!)?|[|&\/%~`^]|<=>|={2,3}|=~|[<>]{2}|[<>]=?|[-+]@?|\*{1,2}|\[\]=?|![=~]?)\b?/)
    s = input.matched.yield_self {|s| s[1, s.length] }.to_sym
    new_token(:tSYMBOL, s)
  when input.scan(/[+-]?\d[\d_]*/)
    new_token(:tINTEGER, input.matched.to_i)
  when input.scan(PUNCTS_RE)
    new_token(PUNCTS[input.matched])
  when input.scan(/(::)?([A-Z]\w*::)+/)
    new_token(:tNAMESPACE)
  when input.scan(/[a-z_]\w*:/)
    new_token(:tLKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[a-z_]\w*[?!]:/)
    new_token(:tLKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*:/)
    new_token(:tUKEYWORD, input.matched.chop.to_sym)
  when input.scan(/[A-Z]\w*[?!]:/)
    new_token(:tUKEYWORD_Q_E, input.matched.chop.to_sym)
  when input.scan(/\$([A-Za-z_]\w*|[~*$?!@\/\\;,.=:<>"&`'+]|\d+|-[0-9_A-Za-z])/)
    new_token(:tGLOBALIDENT)
  when input.scan(/@[a-zA-Z_]\w*/)
    new_token(:tIVAR, input.matched.to_sym)
  when input.scan(/@@[a-zA-Z_]\w*/)
    new_token(:tCLASSVAR, input.matched.to_sym)
  when input.scan(/_[A-Z]\w*\b/)
    new_token(:tINTERFACEIDENT)
  when input.scan(/[A-Z]\w*\b/)
    new_token(:tUIDENT)
  when input.scan(/[a-z]\w*\b/)
    new_token(:tLIDENT)
  when input.scan(/_[a-z]\w*\b/)
    new_token(:tUNDERSCOREIDENT)
  when input.scan(/_\w*\b/)
    new_token(:tPARAMNAME)
  when input.scan(/"(\\"|[^"])*"/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }
                     .gsub(DBL_QUOTE_STR_ESCAPE_SEQUENCES_RE) do |match|
                       case match
                       when '\\a' then "\a"
                       when '\\b' then "\b"
                       when '\\e' then "\e"
                       when '\\f' then "\f"
                       when '\\n' then "\n"
                       when '\\r' then "\r"
                       when '\\s' then "\s"
                       when '\\t' then "\t"
                       when '\\v' then "\v"
                       when '\\"' then '"'
                       end
                     end
    new_token(:tSTRING, s)
  when input.scan(/'(\\'|[^'])*'/)
    s = input.matched.yield_self {|s| s[1, s.length - 2] }.gsub(/\\'/, "'")
    new_token(:tSTRING, s)
  else
    text = input.peek(10)
    start_index = charpos(input)
    end_index = start_index + text.length
    location = RBS::Location.new(buffer: buffer, start_pos: start_index, end_pos: end_index)
    raise LexerError.new(input: text, location: location)
  end
end

def on_error(token_id, error_value, value_stack)
  raise SyntaxError.new(token_str: token_to_str(token_id), error_value: error_value, value_stack: value_stack)
end

def split_kw_loc(loc)
  buf = loc.buffer
  start_pos = loc.start_pos
  end_pos = loc.end_pos
  [
    Location.new(buffer: buf, start_pos: start_pos, end_pos: end_pos - 1),
    Location.new(buffer: buf, start_pos: end_pos - 1, end_pos: end_pos)
  ]
end

class SyntaxError < ParsingError
  attr_reader :token_str, :error_value, :value_stack

  def initialize(token_str:, error_value:, value_stack: nil)
    @token_str = token_str
    @error_value = error_value
    @value_stack = value_stack

    super "parse error on value: #{error_value.inspect} (#{token_str})"
  end
end

class SemanticsError < ParsingError
  attr_reader :subject, :location, :original_message

  def initialize(message, subject:, location:)
    @subject = subject
    @location = location
    @original_message = message

    super "parse error on #{location}: #{message}"
  end
end

class LexerError < ParsingError
  attr_reader :location, :input

  def initialize(input:, location:)
    @input = input
    @location = location

    super "Unexpected string: #{input}..."
  end
end

...end parser.y/module_eval...
##### State transition tables begin ###

clist = [
'192,195,33,193,192,195,33,193,192,195,33,193,113,192,195,33,193,192',
'195,5,193,40,41,192,195,33,193,-4,160,-245,185,33,33,33,117,33,-245',
'33,49,228,33,113,37,32,33,40,41,32,33,40,41,32,283,40,41,186,32,161',
'40,41,293,334,40,41,229,42,32,194,40,41,53,194,32,32,32,194,32,284,32',
'196,194,32,49,196,194,32,186,196,367,32,194,324,196,351,352,354,196',
'353,40,41,399,43,196,338,39,209,209,40,41,350,322,336,48,186,53,104',
'55,56,57,58,59,60,61,62,356,186,63,54,64,65,66,77,67,68,69,83,39,53',
'53,346,340,341,411,412,344,342,345,2,3,4,126,343,82,70,71,72,74,76,75',
'339,348,349,73,78,80,40,41,186,186,84,85,81,86,351,352,354,408,353,40',
'41,174,180,39,177,407,175,180,120,179,350,101,102,125,264,103,165,55',
'56,57,58,59,60,61,62,79,176,63,54,64,65,66,77,67,68,69,83,40,41,166',
'346,340,341,40,41,344,342,345,40,41,40,41,343,82,70,71,72,74,76,75,339',
'348,349,73,78,80,40,41,40,41,84,85,81,86,351,352,354,167,353,168,96',
'97,98,99,40,41,40,41,40,41,350,40,41,286,287,370,371,55,56,57,58,59',
'60,61,62,79,170,63,54,64,65,66,77,67,68,69,83,40,41,171,346,340,341',
'40,41,344,342,345,386,387,40,41,343,82,70,71,72,74,76,75,339,348,349',
'73,78,80,40,41,40,41,84,85,81,86,351,352,354,172,353,113,96,97,98,99',
'40,41,40,41,40,41,350,40,41,178,181,184,41,55,56,57,58,59,60,61,62,79',
'187,63,54,64,65,66,77,67,68,69,83,189,180,190,346,340,341,-105,-106',
'344,342,345,-107,-108,-109,-110,343,82,70,71,72,74,76,75,339,348,349',
'73,78,80,-111,-112,-113,-114,84,85,81,86,351,352,354,-115,353,48,96',
'97,98,99,-130,197,198,199,200,201,350,202,210,211,42,212,230,55,56,57',
'58,59,60,61,62,79,244,63,54,64,65,66,77,67,68,69,83,253,254,255,346',
'340,341,257,259,344,342,345,260,42,262,262,343,82,70,71,72,74,76,75',
'339,348,349,73,78,80,262,266,42,230,84,85,81,86,351,352,354,270,353',
'274,276,291,292,315,274,317,291,330,331,332,350,358,358,358,366,368',
'369,55,56,57,58,59,60,61,62,79,372,63,54,64,65,66,77,67,68,69,83,374',
'381,382,346,340,341,383,391,344,342,345,391,391,403,404,343,82,70,71',
'72,74,76,75,339,348,349,73,78,80,405,406,409,410,84,85,81,86,351,352',
'354,415,353,416,96,97,98,99,417,419,422,415,,,350,,,,,,,55,56,57,58',
'59,60,61,62,79,,63,54,64,65,66,77,67,68,69,83,,,,346,340,341,,,344,342',
'345,,,,,343,82,70,71,72,74,76,75,339,348,349,73,78,80,,,,,84,85,81,86',
'351,352,354,,353,,,,,,,,,,,,350,,,,,,,55,56,57,58,59,60,61,62,79,,63',
'54,64,65,66,77,67,68,69,83,,,,346,340,341,,,344,342,345,,,,,343,82,70',
'71,72,74,76,75,339,348,349,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99',
',,,22,23,21,,26,-220,25,,30,,131,132,133,134,135,136,137,138,142,16',
'139,130,140,141,66,77,67,68,69,83,,32,,,,28,,156,,157,159,,,,,,82,70',
'71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23',
'21,,26,,25,,30,,131,132,133,134,135,136,137,138,142,16,139,130,140,141',
'66,77,67,68,69,83,,32,,,,28,,,,,,,,,,,82,70,71,72,74,76,75,,,,73,78',
'80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23,21,,26,-220,25,,30,,131',
'132,133,134,135,136,137,138,142,16,139,130,140,141,66,77,67,68,69,83',
',32,,,,28,,156,,157,159,,,,,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84',
'85,81,86,33,,,96,97,98,99,,,,22,23,21,,26,-220,25,,30,,131,132,133,134',
'135,136,137,138,142,16,139,130,140,141,66,77,67,68,69,83,,32,,,,28,',
'156,,157,159,,,,,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33',
',,96,97,98,99,,,,22,23,21,,26,-220,25,,30,,131,132,133,134,135,136,137',
'138,142,16,139,130,140,141,66,77,67,68,69,83,,32,,,,28,,236,,,159,,',
',,,82,70,71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99',
',,,22,23,21,,26,-220,25,,30,,131,132,133,134,135,136,137,138,142,16',
'139,130,140,141,66,77,67,68,69,83,,32,,,,28,,156,,157,159,,,,,,82,70',
'71,72,74,76,75,,,,73,78,80,,,,,84,85,81,86,33,,,96,97,98,99,,,,22,23',
'21,,26,-220,25,,30,,131,132,133,134,135,136,137,138,142,16,139,130,140',
'141,66,77,67,68,69,83,,32,,,,28,,236,,,159,,,,,,82,70,71,72,74,76,75',
',,,73,78,80,,,,,84,85,81,86,96,97,98,99,,,,90,89,91,,,,,,,,55,56,57',
'58,59,60,61,62,79,,63,54,64,65,66,77,67,68,69,83,,,,,,,,,,,,,,,,,82',
'70,71,72,74,76,75,,95,94,73,78,80,,,,,84,85,81,86,96,97,98,99,,,,90',
'89,91,,,,,,,,55,56,57,58,59,60,61,62,79,,63,54,64,65,66,77,67,68,69',
'83,,,,,,,,,,,,,,,,,82,70,71,72,74,76,75,,95,94,73,78,80,96,97,98,99',
'84,85,81,86,,,,,,,,,,55,56,57,58,59,60,61,62,79,,63,54,64,65,66,77,67',
'68,69,83,,,,,,,,236,,,159,,,,,,82,70,71,72,74,76,75,,,,73,78,80,96,97',
'98,99,84,85,81,86,,,,,,,,,,55,56,57,58,59,60,61,62,79,,63,54,64,65,66',
'77,67,68,69,83,,,,,,,,236,,,159,,,,,,82,70,71,72,74,76,75,,,,73,78,80',
'96,97,98,99,84,85,81,86,,,,,,,,,,55,56,57,58,59,60,61,62,79,,63,54,64',
'65,66,77,67,68,69,83,-245,,,33,,117,,-245,,,312,313,113,,,,82,70,71',
'72,74,76,75,,,,73,78,80,,,314,,84,85,81,86,,,,309,308,-245,,32,33,,117',
',-245,,,312,313,113,,-245,,,33,300,117,,-245,,,312,313,113,,,,,314,',
',,,,,,,309,308,,,32,314,,,,,,,,,309,308,,33,32,,318,,,,,,,22,23,21,',
'26,,25,319,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,',
',,28,22,23,21,,26,,25,45,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16',
'17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10',
'13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12',
'19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25',
',30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23',
'21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32',
',,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27',
',,33,,,,,32,,,,28,22,23,21,,26,,25,-249,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8',
'12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26',
',25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,,32,,,,28,22',
'23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11,27,,,33,,,,',
'32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15,16,17,18,11',
'27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9,10,13,14,15',
'16,17,18,11,27,,,33,,,,,32,,,,28,22,23,21,,26,,25,,30,,8,12,19,20,9',
'10,13,14,15,16,17,18,11,27,174,,,177,,175,,32,324,,,28,,,,,,,,,,,,,',
'176,,322,328,325,326,327,,,,329' ]
        racc_action_table = arr = ::Array.new(3154, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

clist = [
'143,143,48,143,203,203,177,203,205,205,220,205,280,206,206,221,206,207',
'207,1,207,44,44,240,240,222,240,34,51,34,123,264,34,270,34,276,34,291',
'28,183,322,34,5,48,328,143,143,177,329,203,203,220,271,205,205,123,221',
'51,206,206,280,321,207,207,183,7,222,143,240,240,28,203,264,34,270,205',
'276,271,291,143,206,322,119,203,207,328,321,205,333,329,240,298,206',
'324,324,324,207,324,169,169,384,24,240,323,34,160,210,6,6,324,298,323',
'27,333,119,32,324,324,324,324,324,324,324,324,324,384,324,324,324,324',
'324,324,324,324,324,324,6,160,210,324,324,324,396,397,324,324,324,0',
'0,0,47,324,324,324,324,324,324,324,324,324,324,324,324,324,324,188,188',
'396,397,324,324,324,324,357,357,357,391,357,47,47,114,116,35,114,391',
'114,250,36,116,357,31,31,46,250,31,87,357,357,357,357,357,357,357,357',
'357,114,357,357,357,357,357,357,357,357,357,357,214,214,89,357,357,357',
'215,215,357,357,357,216,216,217,217,357,357,357,357,357,357,357,357',
'357,357,357,357,357,357,218,218,219,219,357,357,357,357,359,359,359',
'90,359,91,359,359,359,359,225,225,226,226,227,227,359,267,267,273,273',
'347,347,359,359,359,359,359,359,359,359,359,93,359,359,359,359,359,359',
'359,359,359,359,364,364,94,359,359,359,365,365,359,359,359,369,369,389',
'389,359,359,359,359,359,359,359,359,359,359,359,359,359,359,392,392',
'394,394,359,359,359,359,360,360,360,95,360,113,360,360,360,360,398,398',
'418,418,420,420,360,421,421,115,117,120,121,360,360,360,360,360,360',
'360,360,360,124,360,360,360,360,360,360,360,360,360,360,127,128,129',
'360,360,360,130,131,360,360,360,132,133,134,135,360,360,360,360,360',
'360,360,360,360,360,360,360,360,360,136,137,138,139,360,360,360,360',
'361,361,361,140,361,141,361,361,361,361,142,145,146,148,150,153,361',
'154,161,162,163,164,190,361,361,361,361,361,361,361,361,361,208,361',
'361,361,361,361,361,361,361,361,361,223,224,229,361,361,361,234,245',
'361,361,361,246,247,248,249,361,361,361,361,361,361,361,361,361,361',
'361,361,361,361,251,252,256,259,361,361,361,361,372,372,372,261,372',
'262,263,277,279,282,284,285,289,312,313,314,372,325,326,327,332,335',
'337,372,372,372,372,372,372,372,372,372,356,372,372,372,372,372,372',
'372,372,372,372,358,362,363,372,372,372,366,376,372,372,372,378,380',
'386,387,372,372,372,372,372,372,372,372,372,372,372,372,372,372,388',
'390,393,395,372,372,372,372,385,385,385,400,385,402,385,385,385,385',
'405,408,414,422,,,385,,,,,,,385,385,385,385,385,385,385,385,385,,385',
'385,385,385,385,385,385,385,385,385,,,,385,385,385,,,385,385,385,,,',
',385,385,385,385,385,385,385,385,385,385,385,385,385,385,,,,,385,385',
'385,385,417,417,417,,417,,,,,,,,,,,,417,,,,,,,417,417,417,417,417,417',
'417,417,417,,417,417,417,417,417,417,417,417,417,417,,,,417,417,417',
',,417,417,417,,,,,417,417,417,417,417,417,417,417,417,417,417,417,417',
'417,,,,,417,417,417,417,49,,,49,49,49,49,,,,49,49,49,,49,49,49,,49,',
'49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,,49,,,,49',
',49,,49,49,,,,,,49,49,49,49,49,49,49,,,,49,49,49,,,,,49,49,49,49,156',
',,156,156,156,156,,,,156,156,156,,156,,156,,156,,156,156,156,156,156',
'156,156,156,156,156,156,156,156,156,156,156,156,156,156,156,,156,,,',
'156,,,,,,,,,,,156,156,156,156,156,156,156,,,,156,156,156,,,,,156,156',
'156,156,198,,,198,198,198,198,,,,198,198,198,,198,198,198,,198,,198',
'198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198',
'198,198,,198,,,,198,,198,,198,198,,,,,,198,198,198,198,198,198,198,',
',,198,198,198,,,,,198,198,198,198,199,,,199,199,199,199,,,,199,199,199',
',199,199,199,,199,,199,199,199,199,199,199,199,199,199,199,199,199,199',
'199,199,199,199,199,199,199,,199,,,,199,,199,,199,199,,,,,,199,199,199',
'199,199,199,199,,,,199,199,199,,,,,199,199,199,199,200,,,200,200,200',
'200,,,,200,200,200,,200,200,200,,200,,200,200,200,200,200,200,200,200',
'200,200,200,200,200,200,200,200,200,200,200,200,,200,,,,200,,200,,,200',
',,,,,200,200,200,200,200,200,200,,,,200,200,200,,,,,200,200,200,200',
'209,,,209,209,209,209,,,,209,209,209,,209,209,209,,209,,209,209,209',
'209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209,209',
',209,,,,209,,209,,209,209,,,,,,209,209,209,209,209,209,209,,,,209,209',
'209,,,,,209,209,209,209,257,,,257,257,257,257,,,,257,257,257,,257,257',
'257,,257,,257,257,257,257,257,257,257,257,257,257,257,257,257,257,257',
'257,257,257,257,257,,257,,,,257,,257,,,257,,,,,,257,257,257,257,257',
'257,257,,,,257,257,257,,,,,257,257,257,257,30,30,30,30,,,,30,30,30,',
',,,,,,30,30,30,30,30,30,30,30,30,,30,30,30,30,30,30,30,30,30,30,,,,',
',,,,,,,,,,,,30,30,30,30,30,30,30,,30,30,30,30,30,,,,,30,30,30,30,165',
'165,165,165,,,,165,165,165,,,,,,,,165,165,165,165,165,165,165,165,165',
',165,165,165,165,165,165,165,165,165,165,,,,,,,,,,,,,,,,,165,165,165',
'165,165,165,165,,165,165,165,165,165,201,201,201,201,165,165,165,165',
',,,,,,,,,201,201,201,201,201,201,201,201,201,,201,201,201,201,201,201',
'201,201,201,201,,,,,,,,201,,,201,,,,,,201,201,201,201,201,201,201,,',
',201,201,201,202,202,202,202,201,201,201,201,,,,,,,,,,202,202,202,202',
'202,202,202,202,202,,202,202,202,202,202,202,202,202,202,202,,,,,,,',
'202,,,202,,,,,,202,202,202,202,202,202,202,,,,202,202,202,236,236,236',
'236,202,202,202,202,,,,,,,,,,236,236,236,236,236,236,236,236,236,,236',
'236,236,236,236,236,236,236,236,236,281,,,281,,281,,281,,,281,281,281',
',,,236,236,236,236,236,236,236,,,,236,236,236,,,281,,236,236,236,236',
',,,281,281,288,,281,288,,288,,288,,,288,288,288,,290,,,290,281,290,',
'290,,,290,290,290,,,,,288,,,,,,,,,288,288,,,288,290,,,,,,,,,290,290',
',2,290,,288,,,,,,,2,2,2,,2,,2,290,2,,2,2,2,2,2,2,2,2,2,2,2,2,2,2,,,25',
',,,,2,,,,2,25,25,25,,25,,25,25,25,,25,25,25,25,25,25,25,25,25,25,25',
'25,25,25,,,26,,,,,25,,,,25,26,26,26,,26,,26,,26,,26,26,26,26,26,26,26',
'26,26,26,26,26,26,26,,,40,,,,,26,,,,26,40,40,40,,40,,40,,40,,40,40,40',
'40,40,40,40,40,40,40,40,40,40,40,,,41,,,,,40,,,,40,41,41,41,,41,,41',
',41,,41,41,41,41,41,41,41,41,41,41,41,41,41,41,,,43,,,,,41,,,,41,43',
'43,43,,43,,43,,43,,43,43,43,43,43,43,43,43,43,43,43,43,43,43,,,53,,',
',,43,,,,43,53,53,53,,53,,53,,53,,53,53,53,53,53,53,53,53,53,53,53,53',
'53,53,,,92,,,,,53,,,,53,92,92,92,,92,,92,,92,,92,92,92,92,92,92,92,92',
'92,92,92,92,92,92,,,125,,,,,92,,,,92,125,125,125,,125,,125,125,125,',
'125,125,125,125,125,125,125,125,125,125,125,125,125,125,,,157,,,,,125',
',,,125,157,157,157,,157,,157,,157,,157,157,157,157,157,157,157,157,157',
'157,157,157,157,157,,,158,,,,,157,,,,157,158,158,158,,158,,158,,158',
',158,158,158,158,158,158,158,158,158,158,158,158,158,158,,,159,,,,,158',
',,,158,159,159,159,,159,,159,,159,,159,159,159,159,159,159,159,159,159',
'159,159,159,159,159,,,166,,,,,159,,,,159,166,166,166,,166,,166,,166',
',166,166,166,166,166,166,166,166,166,166,166,166,166,166,,,167,,,,,166',
',,,166,167,167,167,,167,,167,,167,,167,167,167,167,167,167,167,167,167',
'167,167,167,167,167,,,168,,,,,167,,,,167,168,168,168,,168,,168,,168',
',168,168,168,168,168,168,168,168,168,168,168,168,168,168,,,170,,,,,168',
',,,168,170,170,170,,170,,170,,170,,170,170,170,170,170,170,170,170,170',
'170,170,170,170,170,,,171,,,,,170,,,,170,171,171,171,,171,,171,,171',
',171,171,171,171,171,171,171,171,171,171,171,171,171,171,,,172,,,,,171',
',,,171,172,172,172,,172,,172,,172,,172,172,172,172,172,172,172,172,172',
'172,172,172,172,172,,,178,,,,,172,,,,172,178,178,178,,178,,178,,178',
',178,178,178,178,178,178,178,178,178,178,178,178,178,178,,,179,,,,,178',
',,,178,179,179,179,,179,,179,,179,,179,179,179,179,179,179,179,179,179',
'179,179,179,179,179,,,181,,,,,179,,,,179,181,181,181,,181,,181,,181',
',181,181,181,181,181,181,181,181,181,181,181,181,181,181,,,186,,,,,181',
',,,181,186,186,186,,186,,186,,186,,186,186,186,186,186,186,186,186,186',
'186,186,186,186,186,,,204,,,,,186,,,,186,204,204,204,,204,,204,,204',
',204,204,204,204,204,204,204,204,204,204,204,204,204,204,,,211,,,,,204',
',,,204,211,211,211,,211,,211,,211,,211,211,211,211,211,211,211,211,211',
'211,211,211,211,211,,,230,,,,,211,,,,211,230,230,230,,230,,230,,230',
',230,230,230,230,230,230,230,230,230,230,230,230,230,230,,,253,,,,,230',
',,,230,253,253,253,,253,,253,,253,,253,253,253,253,253,253,253,253,253',
'253,253,253,253,253,,,292,,,,,253,,,,253,292,292,292,,292,,292,,292',
',292,292,292,292,292,292,292,292,292,292,292,292,292,292,,,315,,,,,292',
',,,292,315,315,315,,315,,315,,315,,315,315,315,315,315,315,315,315,315',
'315,315,315,315,315,,,330,,,,,315,,,,315,330,330,330,,330,,330,,330',
',330,330,330,330,330,330,330,330,330,330,330,330,330,330,,,331,,,,,330',
',,,330,331,331,331,,331,,331,,331,,331,331,331,331,331,331,331,331,331',
'331,331,331,331,331,,,368,,,,,331,,,,331,368,368,368,,368,,368,,368',
',368,368,368,368,368,368,368,368,368,368,368,368,368,368,,,375,,,,,368',
',,,368,375,375,375,,375,,375,,375,,375,375,375,375,375,375,375,375,375',
'375,375,375,375,375,,,377,,,,,375,,,,375,377,377,377,,377,,377,,377',
',377,377,377,377,377,377,377,377,377,377,377,377,377,377,,,379,,,,,377',
',,,377,379,379,379,,379,,379,,379,,379,379,379,379,379,379,379,379,379',
'379,379,379,379,379,,,381,,,,,379,,,,379,381,381,381,,381,,381,,381',
',381,381,381,381,381,381,381,381,381,381,381,381,381,381,,,382,,,,,381',
',,,381,382,382,382,,382,,382,,382,,382,382,382,382,382,382,382,382,382',
'382,382,382,382,382,,,383,,,,,382,,,,382,383,383,383,,383,,383,,383',
',383,383,383,383,383,383,383,383,383,383,383,383,383,383,,,406,,,,,383',
',,,383,406,406,406,,406,,406,,406,,406,406,406,406,406,406,406,406,406',
'406,406,406,406,406,,,409,,,,,406,,,,406,409,409,409,,409,,409,,409',
',409,409,409,409,409,409,409,409,409,409,409,409,409,409,,,410,,,,,409',
',,,409,410,410,410,,410,,410,,410,,410,410,410,410,410,410,410,410,410',
'410,410,410,410,410,299,,,299,,299,,410,299,,,410,,,,,,,,,,,,,,299,',
'299,299,299,299,299,,,,299' ]
        racc_action_check = arr = ::Array.new(3154, nil)
        idx = 0
        clist.each do |str|
          str.split(',', -1).each do |i|
            arr[idx] = i.to_i unless i.empty?
            idx += 1
          end
        end

racc_action_pointer = [
    73,    19,  1675,   nil,   nil,    42,    59,    13,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    80,  1711,  1747,    93,    19,   nil,
  1264,   188,   110,   nil,    27,   105,   166,   nil,   nil,   nil,
  1783,  1819,   nil,  1855,   -27,   nil,   145,   130,    -3,   728,
   nil,     5,   nil,  1891,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   148,   nil,   162,
   200,   202,  1927,   240,   253,   291,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   324,   144,   307,   179,   308,   nil,    63,
   352,   306,   nil,     8,   343,  1963,   nil,   356,   375,   358,
   337,   338,   342,   343,   344,   345,   360,   361,   362,   363,
   371,   399,   378,    -3,   nil,   379,   378,   nil,   379,   nil,
   380,   nil,   nil,   381,   383,   nil,   805,  1999,  2035,  2071,
    86,   408,   381,   381,   410,  1338,  2107,  2143,  2179,    50,
  2215,  2251,  2287,   nil,   nil,   nil,   nil,     1,  2323,  2359,
   nil,  2395,   nil,    17,   nil,   nil,  2431,   nil,   117,   nil,
   384,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   882,   959,
  1036,  1404,  1470,     1,  2467,     5,    10,    14,   421,  1113,
    87,  2503,   nil,   nil,   168,   174,   179,   181,   197,   199,
     5,    10,    20,   399,   454,   215,   217,   219,   nil,   456,
  2539,   nil,   nil,   nil,   415,   nil,  1536,   nil,   nil,   nil,
    20,   nil,   nil,   nil,   nil,   443,   443,   416,   448,   449,
   184,   464,   480,  2575,   nil,   nil,   435,  1190,   nil,   437,
   nil,   436,   418,   454,    26,   nil,   nil,   222,   nil,   nil,
    28,    30,   nil,   194,   nil,   nil,    30,   453,   nil,   480,
    -2,  1579,   481,   nil,   423,   502,   nil,   nil,  1621,   458,
  1635,    32,  2611,   nil,   nil,   nil,   nil,   nil,    47,  3082,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   461,   462,   450,  2647,   nil,   nil,   nil,   nil,
   nil,    39,    35,    30,    91,   477,   478,   479,    39,    43,
  2683,  2719,   501,    66,   nil,   493,   nil,   475,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   222,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   467,   171,   478,   251,
   331,   411,   516,   517,   248,   254,   497,   nil,  2755,   274,
   nil,   nil,   491,   nil,   nil,  2791,   524,  2827,   528,  2863,
   529,  2899,  2935,  2971,    78,   571,   491,   492,   532,   261,
   521,   164,   277,   522,   279,   523,   120,   121,   295,   nil,
   517,   nil,   533,   nil,   nil,   525,  3007,   nil,   564,  3043,
  3079,   nil,   nil,   nil,   537,   nil,   nil,   651,   297,   nil,
   299,   302,   527,   nil,   nil ]

racc_action_default = [
  -251,  -251,  -245,    -6,   -15,  -251,    -4,  -158,  -161,  -162,
  -163,  -164,  -165,  -166,  -167,  -168,  -169,  -170,  -171,  -172,
  -173,  -174,  -175,  -176,  -177,  -245,  -245,  -251,   -80,  -185,
  -251,  -251,  -246,  -248,   -16,    -4,  -148,   425,    -1,    -5,
  -245,  -245,  -184,  -245,  -186,  -179,  -250,  -251,  -245,  -245,
  -183,  -251,  -205,  -245,  -105,  -106,  -107,  -108,  -109,  -110,
  -111,  -112,  -113,  -114,  -115,  -116,  -117,  -118,  -119,  -120,
  -121,  -122,  -123,  -124,  -125,  -126,  -127,  -128,  -129,  -130,
  -131,  -132,  -133,  -134,  -135,  -136,  -137,  -250,  -189,  -251,
  -251,  -251,  -245,  -251,  -251,  -251,  -200,  -201,  -202,  -203,
  -238,  -239,  -240,  -241,  -247,    -2,    -7,    -8,    -9,   -10,
   -11,   -12,   -13,   -16,  -251,  -251,  -251,  -251,    -3,   -80,
  -251,  -159,  -160,  -251,  -251,  -245,  -181,  -251,  -251,  -251,
  -171,  -161,  -165,  -172,  -173,  -162,  -163,  -166,  -167,  -170,
  -164,  -116,  -168,  -232,  -198,  -251,  -209,  -210,  -212,  -213,
  -215,  -216,  -219,  -222,  -224,  -225,  -245,  -245,  -245,  -245,
  -251,  -251,  -251,  -207,  -251,  -249,  -245,  -245,  -245,  -194,
  -245,  -245,  -245,   -17,   -14,   -14,   -14,  -245,  -245,  -245,
  -243,  -245,   -79,  -251,  -150,  -178,  -245,  -180,  -187,  -182,
   -81,  -226,  -233,  -234,  -235,  -236,  -237,  -199,  -245,  -245,
  -245,  -220,  -220,  -232,  -245,  -232,  -232,  -232,  -251,  -245,
  -251,  -245,  -188,  -190,  -191,  -192,  -193,  -195,  -196,  -197,
  -245,  -245,  -245,  -251,  -251,  -155,  -156,  -157,  -149,  -251,
  -245,  -208,  -216,  -211,  -218,  -214,  -251,  -221,  -223,  -227,
  -232,  -228,  -229,  -231,   -82,  -251,  -251,  -204,  -138,  -138,
  -251,  -138,  -251,  -245,  -244,  -151,  -206,  -245,  -230,  -251,
   -83,   -19,  -146,   -24,  -245,   -57,  -242,  -154,  -217,   -30,
  -245,  -251,  -140,  -143,  -147,   -30,  -245,   -30,   -26,   -29,
   -16,   -16,   -20,  -139,  -146,  -251,  -144,  -145,   -16,   -25,
   -16,  -245,  -245,   -56,   -58,   -59,   -60,   -61,   -71,   -71,
   -18,   -31,   -32,   -33,   -34,   -35,   -36,   -37,   -38,   -39,
   -40,   -41,  -251,  -251,  -251,  -245,  -141,  -142,   -22,   -23,
   -27,  -251,  -245,   -68,  -251,   -42,   -42,   -42,  -245,  -245,
  -245,  -245,  -251,  -251,   -28,   -62,   -69,  -251,   -72,   -86,
   -87,   -88,   -89,   -90,   -91,   -92,   -93,   -94,   -97,   -98,
   -99,  -100,  -101,  -102,  -103,  -104,  -130,  -251,  -251,  -251,
  -251,  -251,   -64,   -66,   -53,   -54,  -251,   -21,  -245,   -73,
   -95,   -96,  -251,  -152,   -43,  -245,   -50,  -245,   -50,  -245,
   -50,  -245,  -245,  -245,  -251,  -251,  -251,  -251,  -251,   -44,
  -251,  -251,   -46,  -251,   -48,  -251,  -251,  -251,   -55,   -63,
   -15,   -84,  -251,   -74,   -75,  -251,  -245,   -51,  -251,  -245,
  -245,   -65,   -67,   -70,   -76,   -77,   -85,  -251,   -45,   -52,
   -47,   -49,   -15,  -153,   -78 ]

racc_goto_table = [
     6,   114,   116,    93,    46,   163,    88,    92,   127,   191,
    50,   129,   204,   124,   208,   357,   128,   279,   232,   413,
   235,   272,   123,   277,    47,   234,   234,    38,   281,   279,
   261,   263,     1,   265,   288,   289,   290,    34,   121,   122,
    35,   424,   106,   316,   279,   237,   238,   143,   373,   269,
   376,   378,   380,   275,   164,   105,   118,   390,   320,   393,
   295,   395,   296,   388,   246,   220,   221,   222,   297,   239,
   251,   241,   242,   243,   280,   335,   402,   268,   294,   337,
   173,   362,   363,   234,   359,   360,   361,   385,   400,   119,
   169,   162,   204,   271,   285,   183,   223,    87,   233,   100,
   nil,   182,   nil,   nil,   nil,   nil,   258,   nil,   423,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   188,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    93,   nil,
   nil,   213,    92,   nil,   nil,   224,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   203,   205,   206,   207,   nil,   nil,
   231,   nil,   nil,   247,   214,   215,   216,   nil,   217,   218,
   219,   245,   nil,   nil,   nil,   nil,   225,   226,   nil,   227,
   248,   249,   256,   nil,   188,   nil,   nil,   nil,   128,   250,
   252,   nil,   nil,   nil,   nil,   nil,   143,   143,   143,   nil,
   nil,   nil,   240,   nil,   nil,   nil,   nil,   143,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   282,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   128,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   298,   nil,   116,
   nil,   267,   nil,   nil,   nil,   143,   116,   nil,   116,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   321,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   333,   nil,   nil,   355,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   364,   365,
   355,   nil,   355,   355,   355,   nil,   375,   377,   379,   nil,
   nil,   nil,   nil,   nil,   nil,   355,   nil,   384,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   355,   nil,
   396,   397,   401,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   389,   nil,   392,   nil,   394,   nil,   nil,
   nil,   398,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   355,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   418,   nil,   nil,   420,   421 ]

racc_goto_check = [
     2,    15,    22,    53,    20,    60,    64,    35,    16,    76,
    47,    49,    65,    61,    51,    36,    22,    25,    71,    45,
    71,    55,    20,    23,     2,    66,    66,     3,    19,    25,
    17,    17,     1,    17,    19,    23,    19,     4,     2,     2,
     5,    45,     6,    55,    25,    72,    72,     2,    36,    18,
    36,    36,    36,    21,    61,     3,     3,    37,    24,    37,
    27,    37,    28,    36,    51,    13,    13,    13,    33,    76,
    38,    76,    76,    76,    39,    25,    36,    71,    40,    41,
    15,    25,    25,    66,    34,    34,    34,    43,    44,    46,
     2,    50,    65,    54,    57,    58,    59,    63,    67,    77,
   nil,    47,   nil,   nil,   nil,   nil,    76,   nil,    36,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,     2,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    53,   nil,
   nil,    64,    35,   nil,   nil,    22,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,     2,     2,     2,     2,   nil,   nil,
    49,   nil,   nil,    60,     2,     2,     2,   nil,     2,     2,
     2,    49,   nil,   nil,   nil,   nil,     2,     2,   nil,     2,
    16,    16,    60,   nil,     2,   nil,   nil,   nil,    22,    22,
    22,   nil,   nil,   nil,   nil,   nil,     2,     2,     2,   nil,
   nil,   nil,     2,   nil,   nil,   nil,   nil,     2,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
    16,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    22,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,    15,   nil,    22,
   nil,     2,   nil,   nil,   nil,     2,    22,   nil,    22,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,    20,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    20,   nil,   nil,    53,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,     2,     2,
    53,   nil,    53,    53,    53,   nil,    35,    35,    35,   nil,
   nil,   nil,   nil,   nil,   nil,    53,   nil,    20,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,    53,   nil,
    20,    20,    35,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,     2,   nil,     2,   nil,     2,   nil,   nil,
   nil,     2,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
    53,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,     2,   nil,   nil,     2,     2 ]

racc_goto_pointer = [
   nil,    32,    -2,    21,    34,    36,     8,   nil,   nil,   nil,
   nil,   nil,   nil,  -109,   nil,   -33,   -40,  -218,  -212,  -241,
   -21,  -210,   -32,  -241,  -233,  -247,   nil,  -220,  -218,   nil,
   nil,   nil,   nil,  -212,  -241,   -23,  -309,  -319,  -152,  -191,
  -202,  -244,   nil,  -282,  -297,  -381,    53,   -18,   nil,   -38,
    40,  -146,   nil,   -27,  -169,  -241,   nil,  -179,   -25,   -81,
   -48,   -33,   nil,    67,   -24,  -144,  -174,  -101,   nil,   nil,
   nil,  -180,  -156,   nil,   nil,   nil,  -134,    68 ]

racc_goto_default = [
   nil,   nil,    44,   nil,   nil,   414,   311,   107,   108,   109,
   110,   111,   112,   nil,    36,   299,   115,   nil,   nil,   nil,
   nil,   nil,    31,   nil,   278,    24,   301,   302,   303,   304,
   305,   306,   307,   310,   nil,   144,   nil,   nil,   nil,   nil,
   nil,   nil,   323,   nil,   nil,   nil,   nil,   nil,    51,   nil,
   nil,    52,   347,   145,   nil,   nil,   273,   nil,   nil,   nil,
     7,   nil,    29,   nil,   nil,   158,   146,   147,   148,   149,
   150,   151,   152,   153,   154,   155,   nil,   nil ]

racc_reduce_table = [
  0, 0, :racc_error,
  3, 84, :_reduce_1,
  3, 84, :_reduce_2,
  3, 84, :_reduce_3,
  0, 86, :_reduce_none,
  1, 86, :_reduce_none,
  0, 87, :_reduce_6,
  2, 87, :_reduce_7,
  1, 89, :_reduce_none,
  1, 89, :_reduce_none,
  1, 89, :_reduce_none,
  1, 89, :_reduce_none,
  1, 89, :_reduce_none,
  1, 89, :_reduce_none,
  0, 96, :_reduce_14,
  0, 97, :_reduce_15,
  0, 98, :_reduce_16,
  2, 98, :_reduce_17,
  8, 95, :_reduce_18,
  0, 101, :_reduce_19,
  2, 101, :_reduce_20,
  5, 101, :_reduce_21,
  8, 94, :_reduce_22,
  8, 94, :_reduce_23,
  0, 104, :_reduce_24,
  2, 104, :_reduce_25,
  1, 106, :_reduce_26,
  3, 106, :_reduce_27,
  4, 107, :_reduce_28,
  1, 107, :_reduce_29,
  0, 102, :_reduce_30,
  2, 102, :_reduce_31,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  1, 109, :_reduce_38,
  1, 109, :_reduce_39,
  1, 109, :_reduce_none,
  1, 109, :_reduce_none,
  0, 117, :_reduce_42,
  2, 117, :_reduce_43,
  5, 115, :_reduce_44,
  7, 115, :_reduce_45,
  5, 115, :_reduce_46,
  7, 115, :_reduce_47,
  5, 115, :_reduce_48,
  7, 115, :_reduce_49,
  0, 120, :_reduce_50,
  2, 120, :_reduce_51,
  3, 120, :_reduce_52,
  3, 114, :_reduce_53,
  3, 114, :_reduce_54,
  5, 114, :_reduce_55,
  7, 93, :_reduce_56,
  0, 122, :_reduce_57,
  2, 122, :_reduce_58,
  1, 123, :_reduce_59,
  1, 123, :_reduce_60,
  1, 123, :_reduce_none,
  3, 111, :_reduce_62,
  6, 111, :_reduce_63,
  3, 112, :_reduce_64,
  6, 112, :_reduce_65,
  3, 113, :_reduce_66,
  6, 113, :_reduce_67,
  0, 124, :_reduce_68,
  1, 124, :_reduce_69,
  7, 110, :_reduce_70,
  0, 125, :_reduce_none,
  2, 125, :_reduce_72,
  0, 126, :_reduce_73,
  2, 126, :_reduce_74,
  2, 126, :_reduce_75,
  1, 128, :_reduce_76,
  1, 128, :_reduce_77,
  3, 128, :_reduce_78,
  3, 88, :_reduce_79,
  0, 131, :_reduce_80,
  3, 131, :_reduce_81,
  3, 133, :_reduce_82,
  4, 133, :_reduce_83,
  1, 127, :_reduce_84,
  2, 127, :_reduce_85,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  2, 119, :_reduce_95,
  2, 119, :_reduce_96,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 119, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 135, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  1, 136, :_reduce_none,
  0, 100, :_reduce_138,
  3, 100, :_reduce_139,
  1, 137, :_reduce_140,
  3, 137, :_reduce_141,
  3, 138, :_reduce_142,
  0, 140, :_reduce_143,
  1, 140, :_reduce_144,
  1, 140, :_reduce_145,
  0, 139, :_reduce_146,
  1, 139, :_reduce_147,
  0, 129, :_reduce_148,
  3, 129, :_reduce_149,
  1, 141, :_reduce_150,
  3, 141, :_reduce_151,
  4, 116, :_reduce_152,
  8, 116, :_reduce_153,
  5, 90, :_reduce_154,
  3, 91, :_reduce_155,
  3, 91, :_reduce_156,
  3, 92, :_reduce_157,
  1, 85, :_reduce_none,
  3, 85, :_reduce_159,
  3, 85, :_reduce_160,
  1, 143, :_reduce_161,
  1, 143, :_reduce_162,
  1, 143, :_reduce_163,
  1, 143, :_reduce_164,
  1, 143, :_reduce_165,
  1, 143, :_reduce_166,
  1, 143, :_reduce_167,
  1, 143, :_reduce_168,
  1, 143, :_reduce_169,
  1, 143, :_reduce_170,
  1, 143, :_reduce_171,
  1, 143, :_reduce_172,
  1, 143, :_reduce_173,
  1, 143, :_reduce_174,
  1, 143, :_reduce_175,
  1, 143, :_reduce_176,
  1, 143, :_reduce_177,
  4, 143, :_reduce_178,
  2, 143, :_reduce_179,
  4, 143, :_reduce_180,
  3, 143, :_reduce_181,
  4, 143, :_reduce_182,
  2, 143, :_reduce_183,
  2, 143, :_reduce_184,
  1, 143, :_reduce_none,
  1, 103, :_reduce_186,
  3, 103, :_reduce_187,
  4, 145, :_reduce_188,
  1, 146, :_reduce_189,
  3, 146, :_reduce_190,
  3, 147, :_reduce_191,
  3, 147, :_reduce_192,
  3, 147, :_reduce_193,
  2, 147, :_reduce_194,
  3, 147, :_reduce_195,
  3, 147, :_reduce_196,
  3, 147, :_reduce_197,
  1, 148, :_reduce_none,
  2, 148, :_reduce_199,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  1, 118, :_reduce_none,
  4, 130, :_reduce_204,
  1, 130, :_reduce_205,
  5, 134, :_reduce_206,
  2, 134, :_reduce_207,
  3, 132, :_reduce_208,
  1, 132, :_reduce_209,
  1, 132, :_reduce_none,
  3, 150, :_reduce_211,
  1, 150, :_reduce_212,
  1, 150, :_reduce_none,
  3, 152, :_reduce_214,
  1, 152, :_reduce_215,
  1, 152, :_reduce_none,
  3, 154, :_reduce_217,
  1, 154, :_reduce_218,
  1, 154, :_reduce_none,
  0, 155, :_reduce_220,
  3, 155, :_reduce_221,
  1, 155, :_reduce_222,
  3, 155, :_reduce_223,
  1, 155, :_reduce_224,
  1, 155, :_reduce_225,
  2, 149, :_reduce_226,
  3, 151, :_reduce_227,
  3, 153, :_reduce_228,
  3, 156, :_reduce_229,
  4, 157, :_reduce_230,
  3, 158, :_reduce_231,
  0, 159, :_reduce_none,
  1, 159, :_reduce_none,
  1, 159, :_reduce_none,
  1, 159, :_reduce_none,
  1, 159, :_reduce_none,
  1, 159, :_reduce_none,
  2, 108, :_reduce_238,
  1, 160, :_reduce_none,
  1, 160, :_reduce_none,
  1, 160, :_reduce_none,
  2, 121, :_reduce_242,
  2, 99, :_reduce_243,
  2, 142, :_reduce_244,
  0, 105, :_reduce_245,
  1, 105, :_reduce_246,
  2, 105, :_reduce_247,
  1, 105, :_reduce_248,
  1, 144, :_reduce_none,
  0, 144, :_reduce_none ]

racc_reduce_n = 251

racc_shift_n = 425

racc_token_table = {
  false => 0,
  :error => 1,
  :tUIDENT => 2,
  :tLIDENT => 3,
  :tUNDERSCOREIDENT => 4,
  :tNAMESPACE => 5,
  :tINTERFACEIDENT => 6,
  :tGLOBALIDENT => 7,
  :tLKEYWORD => 8,
  :tUKEYWORD => 9,
  :tLKEYWORD_Q_E => 10,
  :tUKEYWORD_Q_E => 11,
  :tIVAR => 12,
  :tCLASSVAR => 13,
  :tANNOTATION => 14,
  :tSTRING => 15,
  :tSYMBOL => 16,
  :tINTEGER => 17,
  :tWRITE_ATTR => 18,
  :kLPAREN => 19,
  :kRPAREN => 20,
  :kLBRACKET => 21,
  :kRBRACKET => 22,
  :kLBRACE => 23,
  :kRBRACE => 24,
  :kVOID => 25,
  :kNIL => 26,
  :kTRUE => 27,
  :kFALSE => 28,
  :kANY => 29,
  :kUNTYPED => 30,
  :kTOP => 31,
  :kBOT => 32,
  :kSELF => 33,
  :kSELFQ => 34,
  :kINSTANCE => 35,
  :kCLASS => 36,
  :kBOOL => 37,
  :kSINGLETON => 38,
  :kTYPE => 39,
  :kDEF => 40,
  :kMODULE => 41,
  :kPRIVATE => 42,
  :kPUBLIC => 43,
  :kALIAS => 44,
  :kCOLON => 45,
  :kCOLON2 => 46,
  :kCOMMA => 47,
  :kBAR => 48,
  :kAMP => 49,
  :kHAT => 50,
  :kARROW => 51,
  :kQUESTION => 52,
  :kEXCLAMATION => 53,
  :kSTAR => 54,
  :kSTAR2 => 55,
  :kFATARROW => 56,
  :kEQ => 57,
  :kDOT => 58,
  :kDOT3 => 59,
  :kLT => 60,
  :kINTERFACE => 61,
  :kEND => 62,
  :kINCLUDE => 63,
  :kEXTEND => 64,
  :kATTRREADER => 65,
  :kATTRWRITER => 66,
  :kATTRACCESSOR => 67,
  :tOPERATOR => 68,
  :tQUOTEDMETHOD => 69,
  :tQUOTEDIDENT => 70,
  :kPREPEND => 71,
  :kEXTENSION => 72,
  :kINCOMPATIBLE => 73,
  :type_TYPE => 74,
  :type_SIGNATURE => 75,
  :type_METHODTYPE => 76,
  :tEOF => 77,
  :kOUT => 78,
  :kIN => 79,
  :kUNCHECKED => 80,
  :kOVERLOAD => 81,
  :tPARAMNAME => 82 }

racc_nt_base = 83

racc_use_result_var = true

Racc_arg = [
  racc_action_table,
  racc_action_check,
  racc_action_default,
  racc_action_pointer,
  racc_goto_table,
  racc_goto_check,
  racc_goto_default,
  racc_goto_pointer,
  racc_nt_base,
  racc_reduce_table,
  racc_token_table,
  racc_shift_n,
  racc_reduce_n,
  racc_use_result_var ]

Racc_token_to_s_table = [
  "$end",
  "error",
  "tUIDENT",
  "tLIDENT",
  "tUNDERSCOREIDENT",
  "tNAMESPACE",
  "tINTERFACEIDENT",
  "tGLOBALIDENT",
  "tLKEYWORD",
  "tUKEYWORD",
  "tLKEYWORD_Q_E",
  "tUKEYWORD_Q_E",
  "tIVAR",
  "tCLASSVAR",
  "tANNOTATION",
  "tSTRING",
  "tSYMBOL",
  "tINTEGER",
  "tWRITE_ATTR",
  "kLPAREN",
  "kRPAREN",
  "kLBRACKET",
  "kRBRACKET",
  "kLBRACE",
  "kRBRACE",
  "kVOID",
  "kNIL",
  "kTRUE",
  "kFALSE",
  "kANY",
  "kUNTYPED",
  "kTOP",
  "kBOT",
  "kSELF",
  "kSELFQ",
  "kINSTANCE",
  "kCLASS",
  "kBOOL",
  "kSINGLETON",
  "kTYPE",
  "kDEF",
  "kMODULE",
  "kPRIVATE",
  "kPUBLIC",
  "kALIAS",
  "kCOLON",
  "kCOLON2",
  "kCOMMA",
  "kBAR",
  "kAMP",
  "kHAT",
  "kARROW",
  "kQUESTION",
  "kEXCLAMATION",
  "kSTAR",
  "kSTAR2",
  "kFATARROW",
  "kEQ",
  "kDOT",
  "kDOT3",
  "kLT",
  "kINTERFACE",
  "kEND",
  "kINCLUDE",
  "kEXTEND",
  "kATTRREADER",
  "kATTRWRITER",
  "kATTRACCESSOR",
  "tOPERATOR",
  "tQUOTEDMETHOD",
  "tQUOTEDIDENT",
  "kPREPEND",
  "kEXTENSION",
  "kINCOMPATIBLE",
  "type_TYPE",
  "type_SIGNATURE",
  "type_METHODTYPE",
  "tEOF",
  "kOUT",
  "kIN",
  "kUNCHECKED",
  "kOVERLOAD",
  "tPARAMNAME",
  "$start",
  "target",
  "type",
  "eof",
  "signatures",
  "method_type",
  "signature",
  "type_decl",
  "const_decl",
  "global_decl",
  "interface_decl",
  "module_decl",
  "class_decl",
  "start_new_scope",
  "start_merged_scope",
  "annotations",
  "class_name",
  "module_type_params",
  "super_class",
  "class_members",
  "type_list",
  "colon_module_self_types",
  "namespace",
  "module_self_types",
  "module_self_type",
  "qualified_name",
  "class_member",
  "method_member",
  "include_member",
  "extend_member",
  "prepend_member",
  "var_type_member",
  "attribute_member",
  "alias_member",
  "attribute_kind",
  "keyword",
  "method_name",
  "attr_var_opt",
  "interface_name",
  "interface_members",
  "interface_member",
  "overload",
  "attributes",
  "method_kind",
  "def_name",
  "method_types",
  "type_params",
  "proc_type",
  "params_opt",
  "params",
  "block",
  "simple_function_type",
  "method_name0",
  "identifier_keywords",
  "module_type_params0",
  "module_type_param",
  "type_param_check",
  "type_param_variance",
  "type_params0",
  "type_alias_name",
  "simple_type",
  "comma_opt",
  "record_type",
  "record_fields",
  "record_field",
  "keyword_name",
  "required_positional",
  "optional_positional_params",
  "optional_positional",
  "rest_positional_param",
  "rest_positional",
  "trailing_positional_params",
  "keyword_params",
  "required_keyword",
  "optional_keyword",
  "rest_keyword",
  "var_name_opt",
  "simple_name" ]

Racc_debug_parser = false

##### State transition tables end #####

# reduce 0 omitted

module_eval(<<'.,.,', 'parser.y', 29)
  def _reduce_1(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 32)
  def _reduce_2(val, _values, result)
            result = val[1]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 35)
  def _reduce_3(val, _values, result)
            result = val[1]

    result
  end
.,.,

# reduce 4 omitted

# reduce 5 omitted

module_eval(<<'.,.,', 'parser.y', 41)
  def _reduce_6(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 43)
  def _reduce_7(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 8 omitted

# reduce 9 omitted

# reduce 10 omitted

# reduce 11 omitted

# reduce 12 omitted

# reduce 13 omitted

module_eval(<<'.,.,', 'parser.y', 54)
  def _reduce_14(val, _values, result)
     start_new_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 55)
  def _reduce_15(val, _values, result)
     start_merged_variables_scope
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 58)
  def _reduce_16(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 60)
  def _reduce_17(val, _values, result)
            result = val[1].unshift(Annotation.new(string: val[0].value, location: val[0].location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 65)
  def _reduce_18(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        location = location.with_children(
          required: {
            keyword: val[1].location,
            name: val[3].location,
            end: val[7].location
          },
          optional: {
            type_params: val[4]&.location,
            lt: val[5]&.location
          }
        )
        result = Declarations::Class.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          super_class: val[5]&.value,
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 91)
  def _reduce_19(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 93)
  def _reduce_20(val, _values, result)
            loc = val[1].location.with_children(
          required: { name: val[1].location },
          optional: { args: nil }
        )
        sup = Declarations::Class::Super.new(name: val[1].value, args: [], location: loc)
        result = LocatedValue.new(value: sup, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 101)
  def _reduce_21(val, _values, result)
            loc = (val[1].location + val[4].location).with_children(
          required: { name: val[1].location },
          optional: { args: val[2].location + val[4].location }
        )
        sup = Declarations::Class::Super.new(name: val[1].value, args: val[3], location: loc)
        result = LocatedValue.new(value: sup, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 111)
  def _reduce_22(val, _values, result)
            reset_variable_scope

        colon_loc = val[5].location
        self_loc = val[5].value.yield_self do |params|
          case params.size
          when 0
            nil
          when 1
            params[0].location
          else
            params.first.location + params.last.location
          end
        end

        location = val[1].location + val[7].location
        location = location.with_children(
          required: {
            keyword: val[1].location,
            name: val[3].location,
            end: val[7].location
          },
          optional: {
            type_params: val[4]&.location,
            colon: colon_loc,
            self_types: self_loc
          }
        )
        result = Declarations::Module.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          self_types: val[5].value,
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 149)
  def _reduce_23(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[7].location
        name_loc, colon_loc = split_kw_loc(val[4].location)
        self_loc = case val[5].size
                   when 0
                     nil
                   when 1
                     val[5][0].location
                   else
                     val[5].first.location + val[5].last.location
                   end
        location = location.with_children(
          required: { keyword: val[1].location, name: name_loc, end: val[7].location },
          optional: { colon: colon_loc, type_params: nil, self_types: self_loc }
        )

        result = Declarations::Module.new(
          name: RBS::TypeName.new(name: val[4].value, namespace: val[3]&.value || RBS::Namespace.empty),
          type_params: Declarations::ModuleTypeParams.empty,
          self_types: val[5],
          members: val[6],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 178)
  def _reduce_24(val, _values, result)
     result = LocatedValue.new(value: [], location: nil)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 180)
  def _reduce_25(val, _values, result)
            result = LocatedValue.new(value: val[1], location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 185)
  def _reduce_26(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 188)
  def _reduce_27(val, _values, result)
            result = val[0].push(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 193)
  def _reduce_28(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location
        location = location.with_children(
          required: { name: val[0].location },
          optional: { args: val[1].location + val[3].location }
        )

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 211)
  def _reduce_29(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location.with_children(
          required: { name: val[0].location },
          optional: { args: nil }
        )

        case
        when name.class?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        when name.interface?
          result = Declarations::Module::Self.new(name: name, args: args, location: location)
        else
          raise SemanticsError.new("Module self type should be instance or interface", subject: val[0], location: val[0].location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 229)
  def _reduce_30(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 231)
  def _reduce_31(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

# reduce 32 omitted

# reduce 33 omitted

# reduce 34 omitted

# reduce 35 omitted

# reduce 36 omitted

# reduce 37 omitted

module_eval(<<'.,.,', 'parser.y', 242)
  def _reduce_38(val, _values, result)
            result = Members::Public.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 245)
  def _reduce_39(val, _values, result)
            result = Members::Private.new(location: val[0].location)

    result
  end
.,.,

# reduce 40 omitted

# reduce 41 omitted

module_eval(<<'.,.,', 'parser.y', 251)
  def _reduce_42(val, _values, result)
     result = LocatedValue.new(value: :instance, location: nil)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 252)
  def _reduce_43(val, _values, result)
     result = LocatedValue.new(value: :singleton, location: val[0].location + val[1].location)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 256)
  def _reduce_44(val, _values, result)
            location = val[1].location + val[4].location
        name_loc, colon_loc = split_kw_loc(val[3].location)
        location = location.with_children(
          required: { keyword: val[1].location, name: name_loc, colon: colon_loc },
          optional: { ivar: nil, ivar_name: nil, kind: val[2].location }
        )
        result = Members::AttrReader.new(name: val[3].value,
                                         ivar_name: nil,
                                         type: val[4],
                                         kind: val[2].value,
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 271)
  def _reduce_45(val, _values, result)
            location = val[1].location + val[6].location
        ivar_loc = val[4]&.location
        case name_value = val[4]&.value
        when LocatedValue
          ivar_name = name_value.value
          ivar_name_loc = name_value.location
        when false
          ivar_name = false
          ivar_name_loc = nil
        else
          ivar_name = nil
          ivar_loc = nil
        end
        location = location.with_children(
          required: { keyword: val[1].location, name: val[3].location, colon: val[5].location },
          optional: { ivar: ivar_loc, ivar_name: ivar_name_loc, kind: val[2].location }
        )
        result = Members::AttrReader.new(name: val[3].value.to_sym,
                                         ivar_name: ivar_name,
                                         type: val[6],
                                         kind: val[2].value,
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 297)
  def _reduce_46(val, _values, result)
            location = val[1].location + val[4].location
        name_loc, colon_loc = split_kw_loc(val[3].location)
        location = location.with_children(
          required: { keyword: val[1].location, name: name_loc, colon: colon_loc },
          optional: { ivar: nil, ivar_name: nil, kind: val[2].location }
        )
        result = Members::AttrWriter.new(name: val[3].value,
                                         ivar_name: nil,
                                         kind: val[2].value,
                                         type: val[4],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 312)
  def _reduce_47(val, _values, result)
            location = val[1].location + val[6].location
        ivar_loc = val[4]&.location
        case name_value = val[4]&.value
        when LocatedValue
          ivar_name = name_value.value
          ivar_name_loc = name_value.location
        when false
          ivar_name = false
          ivar_name_loc = nil
        else
          ivar_name = nil
          ivar_loc = nil
        end
        location = location.with_children(
          required: { keyword: val[1].location, name: val[3].location, colon: val[5].location },
          optional: { ivar: ivar_loc, ivar_name: ivar_name_loc, kind: val[2].location }
        )

        result = Members::AttrWriter.new(name: val[3].value.to_sym,
                                         ivar_name: ivar_name,
                                         kind: val[2].value,
                                         type: val[6],
                                         annotations: val[0],
                                         location: location,
                                         comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 339)
  def _reduce_48(val, _values, result)
            location = val[1].location + val[4].location
        name_loc, colon_loc = split_kw_loc(val[3].location)
        location = location.with_children(
          required: { keyword: val[1].location, name: name_loc, colon: colon_loc },
          optional: { ivar: nil, ivar_name: nil, kind: val[2].location }
        )

        result = Members::AttrAccessor.new(name: val[3].value,
                                           ivar_name: nil,
                                           kind: val[2].value,
                                           type: val[4],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 355)
  def _reduce_49(val, _values, result)
            location = val[1].location + val[6].location
        ivar_loc = val[4]&.location
        case name_value = val[4]&.value
        when LocatedValue
          ivar_name = name_value.value
          ivar_name_loc = name_value.location
        when false
          ivar_name = false
          ivar_name_loc = nil
        else
          ivar_name = nil
          ivar_loc = nil
        end
        location = location.with_children(
          required: { keyword: val[1].location, name: val[3].location, colon: val[5].location },
          optional: { ivar: ivar_loc, ivar_name: ivar_name_loc, kind: val[2].location }
        )

        result = Members::AttrAccessor.new(name: val[3].value.to_sym,
                                           ivar_name: ivar_name,
                                           kind: val[2].value,
                                           type: val[6],
                                           annotations: val[0],
                                           location: location,
                                           comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 383)
  def _reduce_50(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 384)
  def _reduce_51(val, _values, result)
     result = LocatedValue.new(value: false, location: val[0].location + val[1].location)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 386)
  def _reduce_52(val, _values, result)
            result = LocatedValue.new(
          value: val[1],
          location: val[0].location + val[2].location
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 394)
  def _reduce_53(val, _values, result)
            location = (val[0].location + val[2].location).with_children(
          required: { name: val[0].location, colon: val[1].location },
          optional: { kind: nil }
        )

        result = Members::InstanceVariable.new(
          name: val[0].value,
          type: val[2],
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 407)
  def _reduce_54(val, _values, result)
            type = val[2]

        if type.is_a?(Types::Variable)
          type = Types::ClassInstance.new(
            name: TypeName.new(name: type.name, namespace: Namespace.empty),
            args: [],
            location: type.location
          )
        end

        location = (val[0].location + val[2].location).with_children(
          required: { name: val[0].location, colon: val[1].location },
          optional: { kind: nil }
        )

        result = Members::ClassVariable.new(
          name: val[0].value,
          type: type,
          location: location,
          comment: leading_comment(location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 430)
  def _reduce_55(val, _values, result)
          type = val[4]

      if type.is_a?(Types::Variable)
        type = Types::ClassInstance.new(
          name: TypeName.new(name: type.name, namespace: Namespace.empty),
          args: [],
          location: type.location
        )
      end

      location = (val[0].location + val[4].location).with_children(
        required: { name: val[2].location, colon: val[3].location },
        optional: { kind: val[0].location + val[1].location }
      )

      result = Members::ClassInstanceVariable.new(
        name: val[2].value,
        type: type,
        location: location,
        comment: leading_comment(location)
      )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 455)
  def _reduce_56(val, _values, result)
            reset_variable_scope

        location = val[1].location + val[6].location
        location = location.with_children(
          required: { keyword: val[1].location, name: val[3].location, end: val[6].location },
          optional: { type_params: val[4]&.location }
        )
        result = Declarations::Interface.new(
          name: val[3].value,
          type_params: val[4]&.value || Declarations::ModuleTypeParams.empty,
          members: val[5],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 473)
  def _reduce_57(val, _values, result)
     result = []
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 475)
  def _reduce_58(val, _values, result)
            result = val[0].push(val[1])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 480)
  def _reduce_59(val, _values, result)
            unless val[0].kind == :instance
          raise SemanticsError.new("Interface cannot have singleton method", subject: val[0], location: val[0].location)
        end

        if val[0].types.last == :super
          raise SemanticsError.new("Interface method cannot have `super` type", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 491)
  def _reduce_60(val, _values, result)
            unless val[0].name.interface?
          raise SemanticsError.new("Interface should include an interface", subject: val[0], location: val[0].location)
        end

        result = val[0]

    result
  end
.,.,

# reduce 61 omitted

module_eval(<<'.,.,', 'parser.y', 501)
  def _reduce_62(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end

        location = (val[1].location + val[2].location).with_children(
          required: { keyword: val[1].location, name: val[2].location },
          optional: { args: nil }
        )

        result = Members::Include.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 517)
  def _reduce_63(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should include module or interface", subject: val[2].value, location: val[2].location)
        end

        location = (val[1].location + val[5].location).with_children(
          required: { keyword: val[1].location, name: val[2].location },
          optional: { args: val[3].location + val[5].location }
        )

        result = Members::Include.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 535)
  def _reduce_64(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end

        location = (val[1].location + val[2].location).with_children(
          required: { keyword: val[1].location, name: val[2].location },
          optional: { args: nil }
        )

        result = Members::Extend.new(name: val[2].value,
                                     args: [],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 551)
  def _reduce_65(val, _values, result)
            if val[2].value.alias?
          raise SemanticsError.new("Should extend module or interface", subject: val[2].value, location: val[2].location)
        end

        location = (val[1].location + val[5].location).with_children(
          required: { keyword: val[1].location, name: val[2].location },
          optional: { args: val[3].location + val[5].location }
        )

        result = Members::Extend.new(name: val[2].value,
                                     args: val[4],
                                     annotations: val[0],
                                     location: location,
                                     comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 569)
  def _reduce_66(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end

        location = (val[1].location + val[2].location).with_children(
          required: { keyword: val[1].location, name: val[2].location },
          optional: { args: nil }
        )

        result = Members::Prepend.new(name: val[2].value,
                                      args: [],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 585)
  def _reduce_67(val, _values, result)
            unless val[2].value.class?
          raise SemanticsError.new("Should prepend module", subject: val[2].value, location: val[2].location)
        end

        location = (val[1].location + val[5].location).with_children(
          required: { keyword: val[1].location, name: val[2].location },
          optional: { args: val[3].location + val[5].location }
        )

        result = Members::Prepend.new(name: val[2].value,
                                      args: val[4],
                                      annotations: val[0],
                                      location: location,
                                      comment: leading_comment(val[0].first&.location || location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 602)
  def _reduce_68(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 604)
  def _reduce_69(val, _values, result)
            RBS.logger.warn "`overload def` syntax is deprecated. Use `...` syntax instead."
        result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 610)
  def _reduce_70(val, _values, result)
            location = val[3].location + val[6].last.location

        required_children = { keyword: val[3].location, name: val[5].location }
        optional_children = { kind: nil, overload: nil }

        if val[4]
          kind = val[4].value
          optional_children[:kind] = val[4].location
        else
          kind = :instance
        end

        last_type = val[6].last
        if last_type.is_a?(LocatedValue) && last_type.value == :dot3
          overload = true
          optional_children[:overload] = last_type.location
          val[6].pop
        else
          overload = false
        end

        result = Members::MethodDefinition.new(
          name: val[5].value,
          kind: kind,
          types: val[6],
          annotations: val[0],
          location: location.with_children(required: required_children, optional: optional_children),
          comment: leading_comment(val[0].first&.location || val[2]&.location || val[3].location),
          overload: overload || !!val[2]
        )

    result
  end
.,.,

# reduce 71 omitted

module_eval(<<'.,.,', 'parser.y', 644)
  def _reduce_72(val, _values, result)
            RBS.logger.warn "`incompatible` method attribute is deprecated and ignored."

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 648)
  def _reduce_73(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 649)
  def _reduce_74(val, _values, result)
     result = LocatedValue.new(value: :singleton, location: val[0].location + val[1].location)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 650)
  def _reduce_75(val, _values, result)
     result = LocatedValue.new(value: :singleton_instance, location: val[0].location + val[1].location)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 653)
  def _reduce_76(val, _values, result)
     result = [val[0]]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 654)
  def _reduce_77(val, _values, result)
     result = [LocatedValue.new(value: :dot3, location: val[0].location)]
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 656)
  def _reduce_78(val, _values, result)
            result = val[2].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 661)
  def _reduce_79(val, _values, result)
            reset_variable_scope

        location = (val[1] || val[2]).location + val[2].location
        type_params = val[1]&.value || []

        type, block = val[2].value

        result = MethodType.new(type_params: type_params,
                                type: type,
                                block: block,
                                location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 675)
  def _reduce_80(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 677)
  def _reduce_81(val, _values, result)
            result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 682)
  def _reduce_82(val, _values, result)
            block = Types::Block.new(type: val[1].value, required: true)
        result = LocatedValue.new(value: block, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 686)
  def _reduce_83(val, _values, result)
            block = Types::Block.new(type: val[2].value, required: false)
        result = LocatedValue.new(value: block, location: val[0].location + val[3].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 692)
  def _reduce_84(val, _values, result)
            loc = val[0].location

        result = LocatedValue.new(
          value: val[0].value,
          location: Location.new(buffer: loc.buffer, start_pos: loc.start_pos, end_pos: loc.end_pos - 1)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 700)
  def _reduce_85(val, _values, result)
            result = LocatedValue.new(value: val[0].value.to_sym,
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 86 omitted

# reduce 87 omitted

# reduce 88 omitted

# reduce 89 omitted

# reduce 90 omitted

# reduce 91 omitted

# reduce 92 omitted

# reduce 93 omitted

# reduce 94 omitted

module_eval(<<'.,.,', 'parser.y', 709)
  def _reduce_95(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kQUESTION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}?",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 717)
  def _reduce_96(val, _values, result)
            unless val[0].location.pred?(val[1].location)
          raise SyntaxError.new(token_str: "kEXCLAMATION", error_value: val[1])
        end

        result = LocatedValue.new(value: "#{val[0].value}!",
                                  location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 97 omitted

# reduce 98 omitted

# reduce 99 omitted

# reduce 100 omitted

# reduce 101 omitted

# reduce 102 omitted

# reduce 103 omitted

# reduce 104 omitted

# reduce 105 omitted

# reduce 106 omitted

# reduce 107 omitted

# reduce 108 omitted

# reduce 109 omitted

# reduce 110 omitted

# reduce 111 omitted

# reduce 112 omitted

# reduce 113 omitted

# reduce 114 omitted

# reduce 115 omitted

# reduce 116 omitted

# reduce 117 omitted

# reduce 118 omitted

# reduce 119 omitted

# reduce 120 omitted

# reduce 121 omitted

# reduce 122 omitted

# reduce 123 omitted

# reduce 124 omitted

# reduce 125 omitted

# reduce 126 omitted

# reduce 127 omitted

# reduce 128 omitted

# reduce 129 omitted

# reduce 130 omitted

# reduce 131 omitted

# reduce 132 omitted

# reduce 133 omitted

# reduce 134 omitted

# reduce 135 omitted

# reduce 136 omitted

# reduce 137 omitted

module_eval(<<'.,.,', 'parser.y', 737)
  def _reduce_138(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 739)
  def _reduce_139(val, _values, result)
            val[1].each {|p| insert_bound_variable(p.name) }

        result = LocatedValue.new(value: val[1], location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 746)
  def _reduce_140(val, _values, result)
            result = Declarations::ModuleTypeParams.new()
        result.add(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 750)
  def _reduce_141(val, _values, result)
            result = val[0].add(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 755)
  def _reduce_142(val, _values, result)
            loc = case
              when l0 = val[0].location
                l0 + val[2].location
              when l1 = val[1].location
                l1 + val[2].location
              else
                val[2].location
              end
        loc = loc.with_children(
          required: { name: val[2].location },
          optional: { variance: val[1].location, unchecked: val[0].location }
        )
        result = Declarations::ModuleTypeParams::TypeParam.new(
          name: val[2].value.to_sym,
          variance: val[1].value,
          skip_validation: val[0].value,
          location: loc
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 776)
  def _reduce_143(val, _values, result)
     result = LocatedValue.new(value: :invariant, location: nil)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 777)
  def _reduce_144(val, _values, result)
     result = LocatedValue.new(value: :covariant, location: val[0].location)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 778)
  def _reduce_145(val, _values, result)
     result = LocatedValue.new(value: :contravariant, location: val[0].location)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 781)
  def _reduce_146(val, _values, result)
     result = LocatedValue.new(value: false, location: nil)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 782)
  def _reduce_147(val, _values, result)
     result = LocatedValue.new(value: true, location: val[0].location)
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 785)
  def _reduce_148(val, _values, result)
     result = nil
    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 787)
  def _reduce_149(val, _values, result)
            val[1].each {|var| insert_bound_variable(var) }

        result = LocatedValue.new(value: val[1],
                                  location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 795)
  def _reduce_150(val, _values, result)
            result = [val[0].value.to_sym]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 798)
  def _reduce_151(val, _values, result)
            result = val[0].push(val[2].value.to_sym)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 803)
  def _reduce_152(val, _values, result)
            location = val[1].location + val[3].location
        location = location.with_children(
          required: { keyword: val[1].location, new_name: val[2].location, old_name: val[3].location },
          optional: { new_kind: nil, old_kind: nil }
        )
        result = Members::Alias.new(
          new_name: val[2].value.to_sym,
          old_name: val[3].value.to_sym,
          kind: :instance,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 818)
  def _reduce_153(val, _values, result)
            location = val[1].location + val[7].location
        location = location.with_children(
          required: { keyword: val[1].location, new_name: val[4].location, old_name: val[7].location },
          optional: {
            new_kind: val[2].location + val[3].location,
            old_kind: val[5].location + val[6].location
          }
        )
        result = Members::Alias.new(
          new_name: val[4].value.to_sym,
          old_name: val[7].value.to_sym,
          kind: :singleton,
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 838)
  def _reduce_154(val, _values, result)
            location = val[1].location + val[4].location
        location = location.with_children(
          required: { keyword: val[1].location, name: val[2].location, eq: val[3].location }
        )
        result = Declarations::Alias.new(
          name: val[2].value,
          type: val[4],
          annotations: val[0],
          location: location,
          comment: leading_comment(val[0].first&.location || location)
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 853)
  def _reduce_155(val, _values, result)
            location = val[0].location + val[2].location
        location = location.with_children(
          required: { name: val[0].location, colon: val[1].location }
        )
        result = Declarations::Constant.new(name: val[0].value,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 863)
  def _reduce_156(val, _values, result)
            location = (val[0] || val[1]).location + val[2].location

        lhs_loc = (val[0] || val[1]).location + val[1].location
        name_loc, colon_loc = split_kw_loc(lhs_loc)
        location = location.with_children(
          required: { name: name_loc, colon: colon_loc }
        )

        name = TypeName.new(name: val[1].value, namespace: val[0]&.value || Namespace.empty)
        result = Declarations::Constant.new(name: name,
                                            type: val[2],
                                            location: location,
                                            comment: leading_comment(location))

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 880)
  def _reduce_157(val, _values, result)
            location = val[0].location + val[2].location
        location = location.with_children(
          required: { name: val[0].location, colon: val[1].location }
        )
        result = Declarations::Global.new(name: val[0].value.to_sym,
                                          type: val[2],
                                          location: location,
                                          comment: leading_comment(location))

    result
  end
.,.,

# reduce 158 omitted

module_eval(<<'.,.,', 'parser.y', 893)
  def _reduce_159(val, _values, result)
            types = case l = val[0]
                when Types::Union
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Union.new(types: types, location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 903)
  def _reduce_160(val, _values, result)
            types = case l = val[0]
                when Types::Intersection
                  l.types + [val[2]]
                else
                  [l, val[2]]
                end

        result = Types::Intersection.new(types: types,
                                         location: val[0].location + val[2].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 916)
  def _reduce_161(val, _values, result)
            result = Types::Bases::Void.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 919)
  def _reduce_162(val, _values, result)
            RBS.logger.warn "`any` type is deprecated. Use `untyped` instead. (#{val[0].location.to_s})"
        result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 923)
  def _reduce_163(val, _values, result)
            result = Types::Bases::Any.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 926)
  def _reduce_164(val, _values, result)
            result = Types::Bases::Bool.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 929)
  def _reduce_165(val, _values, result)
            result = Types::Bases::Nil.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 932)
  def _reduce_166(val, _values, result)
            result = Types::Bases::Top.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 935)
  def _reduce_167(val, _values, result)
            result = Types::Bases::Bottom.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 938)
  def _reduce_168(val, _values, result)
            result = Types::Bases::Self.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 941)
  def _reduce_169(val, _values, result)
            result = Types::Optional.new(type: Types::Bases::Self.new(location: val[0].location),
                                     location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 945)
  def _reduce_170(val, _values, result)
            result = Types::Bases::Instance.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 948)
  def _reduce_171(val, _values, result)
            result = Types::Bases::Class.new(location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 951)
  def _reduce_172(val, _values, result)
            result = Types::Literal.new(literal: true, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 954)
  def _reduce_173(val, _values, result)
            result = Types::Literal.new(literal: false, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 957)
  def _reduce_174(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 960)
  def _reduce_175(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 963)
  def _reduce_176(val, _values, result)
            result = Types::Literal.new(literal: val[0].value, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 966)
  def _reduce_177(val, _values, result)
            name = val[0].value
        args = []
        location = val[0].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            result = Types::Variable.new(name: name.name, location: location)
          else
            location = location.with_children(
              required: { name: val[0].location },
              optional: { args: nil }
            )
            result = Types::ClassInstance.new(name: name, args: args, location: location)
          end
        when name.alias?
          location = location.with_children(
            required: { name: val[0].location },
            optional: { args: nil }
          )
          result = Types::Alias.new(name: name, location: location)
        when name.interface?
          location = location.with_children(
            required: { name: val[0].location },
            optional: { args: nil }
          )
          result = Types::Interface.new(name: name, args: args, location: location)
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 996)
  def _reduce_178(val, _values, result)
            name = val[0].value
        args = val[2]
        location = val[0].location + val[3].location

        case
        when name.class?
          if is_bound_variable?(name.name)
            raise SemanticsError.new("#{name.name} is type variable and cannot be applied", subject: name, location: location)
          end
          location = location.with_children(
            required: { name: val[0].location },
            optional: { args: val[1].location + val[3].location }
          )
          result = Types::ClassInstance.new(name: name, args: args, location: location)
        when name.interface?
          location = location.with_children(
            required: { name: val[0].location },
            optional: { args: val[1].location + val[3].location }
          )
          result = Types::Interface.new(name: name, args: args, location: location)
        else
          raise SyntaxError.new(token_str: "kLBRACKET", error_value: val[1])
        end

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1021)
  def _reduce_179(val, _values, result)
            location = val[0].location + val[1].location
        result = Types::Tuple.new(types: [], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1025)
  def _reduce_180(val, _values, result)
            location = val[0].location + val[3].location
        types = val[1]
        result = Types::Tuple.new(types: types, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1030)
  def _reduce_181(val, _values, result)
            type = val[1].dup
        type.instance_eval do
          @location = val[0].location + val[2].location
        end
        result = type

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1037)
  def _reduce_182(val, _values, result)
            location = val[0].location + val[3].location
        location = location.with_children(
          required: { name: val[2].location }
        )
        result = Types::ClassSingleton.new(name: val[2].value, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1044)
  def _reduce_183(val, _values, result)
            type, block = val[1].value
        result = Types::Proc.new(type: type, block: block, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1048)
  def _reduce_184(val, _values, result)
            result = Types::Optional.new(type: val[0], location: val[0].location + val[1].location)

    result
  end
.,.,

# reduce 185 omitted

module_eval(<<'.,.,', 'parser.y', 1054)
  def _reduce_186(val, _values, result)
            result = [val[0]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1057)
  def _reduce_187(val, _values, result)
            result = val[0] + [val[2]]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1062)
  def _reduce_188(val, _values, result)
            result = Types::Record.new(
          fields: val[1],
          location: val[0].location + val[3].location
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1070)
  def _reduce_189(val, _values, result)
            result = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1073)
  def _reduce_190(val, _values, result)
            result = val[0].merge!(val[2])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1078)
  def _reduce_191(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1081)
  def _reduce_192(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1084)
  def _reduce_193(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1087)
  def _reduce_194(val, _values, result)
            result = { val[0].value => val[1] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1090)
  def _reduce_195(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1093)
  def _reduce_196(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1096)
  def _reduce_197(val, _values, result)
            result = { val[0].value => val[2] }

    result
  end
.,.,

# reduce 198 omitted

module_eval(<<'.,.,', 'parser.y', 1102)
  def _reduce_199(val, _values, result)
            result = val[0]

    result
  end
.,.,

# reduce 200 omitted

# reduce 201 omitted

# reduce 202 omitted

# reduce 203 omitted

module_eval(<<'.,.,', 'parser.y', 1109)
  def _reduce_204(val, _values, result)
            location = (val[0] || val[1] || val[2]).location + val[3].location

        params = val[0]&.value || [[], [], nil, [], {}, {}, nil]

        type = Types::Function.new(
          required_positionals: params[0],
          optional_positionals: params[1],
          rest_positionals: params[2],
          trailing_positionals: params[3],
          required_keywords: params[4],
          optional_keywords: params[5],
          rest_keywords: params[6],
          return_type: val[3]
        )

        block = val[1].value

        result = LocatedValue.new(value: [type, block], location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1129)
  def _reduce_205(val, _values, result)
            result = LocatedValue.new(value: [val[0].value, nil], location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1134)
  def _reduce_206(val, _values, result)
            location = val[0].location + val[4].location
        type = Types::Function.new(
          required_positionals: val[1][0],
          optional_positionals: val[1][1],
          rest_positionals: val[1][2],
          trailing_positionals: val[1][3],
          required_keywords: val[1][4],
          optional_keywords: val[1][5],
          rest_keywords: val[1][6],
          return_type: val[4],
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1149)
  def _reduce_207(val, _values, result)
            location = val[0].location + val[1].location
        type = Types::Function.new(
          required_positionals: [],
          optional_positionals: [],
          rest_positionals: nil,
          trailing_positionals: [],
          required_keywords: {},
          optional_keywords: {},
          rest_keywords: nil,
          return_type: val[1]
        )

        result = LocatedValue.new(value: type, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1166)
  def _reduce_208(val, _values, result)
            result = val[2]
        result[0].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1170)
  def _reduce_209(val, _values, result)
            result = empty_params_result
        result[0].unshift(val[0])

    result
  end
.,.,

# reduce 210 omitted

module_eval(<<'.,.,', 'parser.y', 1177)
  def _reduce_211(val, _values, result)
            result = val[2]
        result[1].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1181)
  def _reduce_212(val, _values, result)
            result = empty_params_result
        result[1].unshift(val[0])

    result
  end
.,.,

# reduce 213 omitted

module_eval(<<'.,.,', 'parser.y', 1188)
  def _reduce_214(val, _values, result)
            result = val[2]
        result[2] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1192)
  def _reduce_215(val, _values, result)
            result = empty_params_result
        result[2] = val[0]

    result
  end
.,.,

# reduce 216 omitted

module_eval(<<'.,.,', 'parser.y', 1199)
  def _reduce_217(val, _values, result)
            result = val[2]
        result[3].unshift(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1203)
  def _reduce_218(val, _values, result)
            result = empty_params_result
        result[3].unshift(val[0])

    result
  end
.,.,

# reduce 219 omitted

module_eval(<<'.,.,', 'parser.y', 1210)
  def _reduce_220(val, _values, result)
            result = empty_params_result

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1213)
  def _reduce_221(val, _values, result)
            result = val[2]
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1217)
  def _reduce_222(val, _values, result)
            result = empty_params_result
        result[4].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1221)
  def _reduce_223(val, _values, result)
            result = val[2]
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1225)
  def _reduce_224(val, _values, result)
            result = empty_params_result
        result[5].merge!(val[0])

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1229)
  def _reduce_225(val, _values, result)
            result = empty_params_result
        result[6] = val[0]

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1235)
  def _reduce_226(val, _values, result)
            loc = val[0].location
        if var_name = val[1]
          loc = loc + var_name.location
        end
        loc = loc.with_children(optional: { name: var_name&.location })

        result = Types::Function::Param.new(
          type: val[0],
          name: var_name&.value&.to_sym,
          location: loc
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1250)
  def _reduce_227(val, _values, result)
            loc = val[0].location + val[1].location
        if var_name = val[2]
          loc = loc + var_name.location
        end
        loc = loc.with_children(optional: { name: var_name&.location })

        result = Types::Function::Param.new(
          type: val[1],
          name: val[2]&.value&.to_sym,
          location: loc
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1265)
  def _reduce_228(val, _values, result)
            loc = val[0].location + val[1].location
        if var_name = val[2]
          loc = loc + var_name.location
        end
        loc = loc.with_children(optional: { name: var_name&.location })

        result = Types::Function::Param.new(
          type: val[1],
          name: val[2]&.value&.to_sym,
          location: loc
        )

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1280)
  def _reduce_229(val, _values, result)
            loc = val[0].location + val[1].location
        if var_name = val[2]
          loc = loc + var_name.location
        end

        loc = loc.with_children(optional: { name: var_name&.location })

        param = Types::Function::Param.new(
          type: val[1],
          name: val[2]&.value&.to_sym,
          location: loc
        )
        result = { val[0].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1297)
  def _reduce_230(val, _values, result)
            loc = val[0].location + val[2].location
        if var_name = val[3]
          loc = loc + var_name.location
        end

        loc = loc.with_children(optional: { name: var_name&.location })

        param = Types::Function::Param.new(
          type: val[2],
          name: val[3]&.value&.to_sym,
          location: loc
        )
        result = { val[1].value => param }

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1314)
  def _reduce_231(val, _values, result)
            loc = val[0].location + val[1].location
        if var_name = val[2]
          loc = loc + var_name.location
        end

        loc = loc.with_children(optional: { name: var_name&.location })

        result = Types::Function::Param.new(
          type: val[1],
          name: val[2]&.value&.to_sym,
          location: loc
        )

    result
  end
.,.,

# reduce 232 omitted

# reduce 233 omitted

# reduce 234 omitted

# reduce 235 omitted

# reduce 236 omitted

# reduce 237 omitted

module_eval(<<'.,.,', 'parser.y', 1333)
  def _reduce_238(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

# reduce 239 omitted

# reduce 240 omitted

# reduce 241 omitted

module_eval(<<'.,.,', 'parser.y', 1345)
  def _reduce_242(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1354)
  def _reduce_243(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1363)
  def _reduce_244(val, _values, result)
            namespace = val[0]&.value || Namespace.empty
        name = val[1].value.to_sym
        type_name = TypeName.new(namespace: namespace, name: name)
        location = (loc0 = val[0]&.location) ? loc0 + val[1].location : val[1].location
        result = LocatedValue.new(value: type_name, location: location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1373)
  def _reduce_245(val, _values, result)
            result = nil

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1376)
  def _reduce_246(val, _values, result)
            result = LocatedValue.new(value: Namespace.root, location: val[0].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1379)
  def _reduce_247(val, _values, result)
            namespace = Namespace.parse(val[1].value).absolute!
        result = LocatedValue.new(value: namespace, location: val[0].location + val[1].location)

    result
  end
.,.,

module_eval(<<'.,.,', 'parser.y', 1383)
  def _reduce_248(val, _values, result)
            namespace = Namespace.parse(val[0].value)
        result = LocatedValue.new(value: namespace, location: val[0].location)

    result
  end
.,.,

# reduce 249 omitted

# reduce 250 omitted

def _reduce_none(val, _values, result)
  val[0]
end

  end   # class Parser
end   # module RBS


