### CA Params -- used by QUICKINSTALL and all topologies ######
ROOTCA_OCSP_SIGNING_KEY_TYPE=rsa      
ROOTCA_OCSP_SIGNING_KEY_SIZE=2048   
ROOTCA_OCSP_SIGNING_KEY_ALGORITHM=SHA512withRSA      
ROOTCA_OCSP_SIGNING_SIGNING_ALGORITHM=SHA512withRSA      
ROOTCA_OCSP_SIGNING_TOKEN="Internal"
ROOTCA_OCSP_SIGNING_NICKNAME="caocspsigningcert"
ROOTCA_OCSP_SIGNING_CERT_SUBJECT_NAME="CN=PKI ROOTCA OCSP Signing Certificate,O=Redhat"
ROOTCA_AUDIT_SIGNING_KEY_TYPE=rsa
ROOTCA_AUDIT_SIGNING_KEY_SIZE=2048   
ROOTCA_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
ROOTCA_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
ROOTCA_AUDIT_SIGNING_TOKEN=Internal 
ROOTCA_AUDIT_SIGNING_NICKNAME="caauditsigningcert" 
ROOTCA_AUDIT_SIGNING_CERT_SUBJECT_NAME="CN=PKI ROOTCA AUDIT Signing Certificate,O=Redhat"
ROOTCA_SUBSYSTEM_KEY_TYPE=rsa
ROOTCA_SUBYSTEM_KEY_SIZE=2048
ROOTCA_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA
ROOTCA_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
ROOTCA_SUBSYSTEM_TOKEN=Internal
ROOTCA_SUBSYTEM_NICKNAME="casubsystemcert"
ROOTCA_SUBSYSTEM_CERT_SUBJECT_NAME="CN=PKI ROOTCA SUBSYSTEM Certificate,O=Redhat"
#Following 7 lines are commented due to bug https://fedorahosted.org/pki/ticket/1052, installation fails otherwise.
ROOTCA_SSL_SERVER_KEY_TYPE=rsa
ROOTCA_SSL_SERVER_KEY_SIZE=2048   
ROOTCA_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA      
ROOTCA_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
ROOTCA_SSL_SERVER_TOKEN=Internal
ROOTCA_SSL_SERVER_NICKNAME="Server-Cert cert-pki-RootCA"
ROOTCA_SSL_SERVER_CERT_SUBJECT_NAME="CN=`hostname`,O=Redhat"
ROOTCA_TOMCAT_INSTANCE_NAME="pki-master"
ROOTCA_SECURE_PORT=30042
ROOTCA_UNSECURE_PORT=30044
ROOTCA_AJP_PORT=30049
ROOTCA_TOMCAT_SERVER_PORT=30045
ROOTCA_SUBSYSTEM_NAME="rhcs-acceptance-ca"
ROOTCA_ADMIN_USER="caadmin"
ROOTCA_ADMIN_PASSWORD="Secret123"
ROOTCA_TOKEN_NAME="Internal"
ROOTCA_TOKEN_PASSWORD="Secret123"
ROOTCA_CLIENT_PKCS12_PASSWORD="Secret123"
ROOTCA_KEY_TYPE="rsa"
ROOTCA_KEY_SIZE=2048
ROOTCA_SIGNING_KEY_ALGORITHM=SHA512withRSA
ROOTCA_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
ROOTCA_SIGNING_TOKEN=Internal
ROOTCA_SIGNING_NICKNAME=casigningcert
ROOTCA_SIGNING_CERT_SUBJECT_NAME="CN=PKI ROOTCA Signing Cert,O=redhat"
ROOTCA_ADMIN_EMAIL=example@redhat.com
ROOTCA_ADMIN_DUAL_KEY=True
ROOTCA_ADMIN_KEY_SIZE=2048
ROOTCA_ADMIN_KEY_TYPE="rsa"
ROOTCA_ADMIN_CERT_SUBJECT_NAME="CN=PKI ROOTCA ADMIN CERT,O=redhat"
ROOTCA_ADMIN_CERT_NICKNAME="caadmincert"
ROOTCA_ADMIN_IMPORT_CERT=False
ROOTCA_BACKUP=True
ROOTCA_BACKUP_PASSWORD="Secret123"
ROOTCA_SECURITY_DOMAIN_PASSWORD="Secret123"
ROOTCA_LDAP_PORT=389
ROOTCA_DB_SUFFIX="dc=pki-ca"
ROOTCA_LDAP_INSTANCE_NAME=pki-ca-ldap
ROOTCA_CERTDB_DIR="/opt/rhqa_pki/rootca/certs_db"
ROOTCA_CERTDB_DIR_PASSWORD="Secret123"
ROOTCA_INSTANCE_CREATED_STATUS=False
########End CA params########

######## KRA1 Params used by topology 2,3,4,5, 6 and 8###########
KRA1_TOMCAT_INSTANCE_NAME="pki-subca1"
KRA1_SECURE_PORT=31000
KRA1_UNSECURE_PORT=31001
KRA1_AJP_PORT=31002
KRA1_TOMCAT_SERVER_PORT=31003
KRA1_AUDIT_SIGNING_KEY_TYPE=rsa
KRA1_AUDIT_SIGNING_KEY_SIZE=2048   
KRA1_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
KRA1_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
KRA1_AUDIT_SIGNING_TOKEN=Internal
KRA1_AUDIT_SIGNING_NICKNAME="kra1auditsigningcert" 
KRA1_AUDIT_SIGNING_SUBJECT_DN="CN=PKI KRA1 AUDIT Signing Certificate, O=Redhat"
KRA1_SUBSYSTEM_KEY_TYPE="rsa"
KRA1_SUBYSTEM_KEY_SIZE=2048
KRA1_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA
KRA1_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
KRA1_SUBSYSTEM_TOKEN="Internal"
KRA1_SUBSYTEM_NICKNAME="kra1subsystemcert"
KRA1_SUBSYSTEM_SUBJECT_DN="cn=PKI KRA1 SUBSYSTEM CERT,O=redhat"
KRA1_STORAGE_KEY_TYPE="rsa"
KRA1_STORAGE_KEY_SIZE=2048
KRA1_STORAGE_KEY_ALGORITHM=SHA512withRSA
KRA1_STORAGE_SIGNING_ALGORITHM=SHA512withRSA
KRA1_STORAGE_TOKEN="Internal"
KRA1_STORAGE_NICKNAME="kra1storagecert"
KRA1_STORAGE_SUBJECT_DN="cn=PKI KRA1 STORAGE CERT,O=redhat"
KRA1_TRANSPORT_KEY_TYPE="rsa"
KRA1_TRANSPORT_KEY_SIZE=2048
KRA1_TRANSPORT_KEY_ALGORITHM=SHA512withRSA
KRA1_TRANSPORT_SIGNING_ALGORITHM=SHA512withRSA
KRA1_TRANSPORT_TOKEN="Internal"
KRA1_TRANSPORT_NICKNAME="kra1transportcert"
KRA1_TRANSPORT_SUBJECT_DN="cn=PKI KRA1 TRANSPORT CERT"
KRA1_SSL_SERVER_KEY_TYPE=rsa
KRA1_SSL_SERVER_KEY_SIZE=2048
KRA1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
KRA1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
KRA1_SSL_SERVER_TOKEN=Internal
KRA1_SSL_SERVER_NICKNAME=subca1sslservercert
KRA1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
KRA1_ADMIN_USER="kra1admin"
KRA1_ADMIN_PASSWORD="Secret123"
KRA1_ADMIN_EMAIL="example@redhat.com"
KRA1_ADMIN_DUAL_KEY=True
KRA1_ADMIN_KEY_SIZE=2048
KRA1_ADMIN_SUBJECT_DN="cn=PKI KRA1 ADMIN CERT,O=redhat"
KRA1_ADMIN_CERT_NICKNAME="kra1admincert"
KRA1_ADMIN_KEY_TYPE=rsa
KRA1_LDAP_PORT=1601
KRA1_DB_SUFFIX="dc=pki-kra1"
KRA1_LDAP_INSTANCE_NAME=pki-kra1-ldap
KRA1_CLIENT_PKCS12_PASSWORD="Secret123"
KRA1_BACKUP_PASSWORD="Secret123"
KRA1_INSTANCE_CREATED_STATUS=False
####### End KRA1 params########

###### KRA 2 params used by topology 5 and 6####
KRA2_TOMCAT_INSTANCE_NAME="pki-subca2"
KRA2_SECURE_PORT=31020
KRA2_UNSECURE_PORT=31021
KRA2_AJP_PORT=31022
KRA2_TOMCAT_SERVER_PORT=31023
KRA2_AUDIT_SIGNING_KEY_TYPE=rsa
KRA2_AUDIT_SIGNING_KEY_SIZE=2048   
KRA2_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
KRA2_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
KRA2_AUDIT_SIGNING_TOKEN=Internal
KRA2_AUDIT_SIGNING_NICKNAME="kra2auditsigningcert" 
KRA2_AUDIT_SIGNING_SUBJECT_DN="CN=PKI KRA2 AUDIT Signing Certificate, O=Redhat"
KRA2_SUBSYSTEM_KEY_TYPE="rsa"
KRA2_SUBYSTEM_KEY_SIZE=2048
KRA2_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA
KRA2_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
KRA2_SUBSYSTEM_TOKEN="Internal"
KRA2_SUBSYTEM_NICKNAME="kra2subsystemcert"
KRA2_SUBSYSTEM_SUBJECT_DN="cn=PKI KRA2 SUBSYSTEM CERT,O=redhat"
KRA2_STORAGE_KEY_TYPE="rsa"
KRA2_STORAGE_KEY_SIZE=2048
KRA2_STORAGE_KEY_ALGORITHM=SHA512withRSA
KRA2_STORAGE_SIGNING_ALGORITHM=SHA512withRSA
KRA2_STORAGE_TOKEN="Internal"
KRA2_STORAGE_NICKNAME="kra2storagecert"
KRA2_STORAGE_SUBJECT_DN="cn=PKI KRA2 STORAGE CERT,O=redhat"
KRA2_SSL_SERVER_KEY_TYPE=rsa
KRA2_SSL_SERVER_KEY_SIZE=2048
KRA2_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
KRA2_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
KRA2_SSL_SERVER_TOKEN=Internal
KRA2_SSL_SERVER_NICKNAME=subca2sslservercert
KRA2_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"

KRA2_TRANSPORT_KEY_TYPE="rsa"
KRA2_TRANSPORT_KEY_SIZE=2048
KRA2_TRANSPORT_KEY_ALGORITHM=SHA512withRSA
KRA2_TRANSPORT_SIGNING_ALGORITHM=SHA512withRSA
KRA2_TRANSPORT_TOKEN="Internal"
KRA2_TRANSPORT_NICKNAME="kra2transportcert"
KRA2_TRANSPORT_SUBJECT_DN="cn=PKI KRA2 TRANSPORT CERT"
KRA2_ADMIN_USER="kra2admin"
KRA2_ADMIN_PASSWORD=Secret123
KRA2_ADMIN_EMAIL="example@redhat.com"
KRA2_ADMIN_DUAL_KEY=True
KRA2_ADMIN_KEY_SIZE=2048
KRA2_ADMIN_KEY_TYPE="rsa"
KRA2_ADMIN_SUBJECT_DN="cn=PKI KRA2 ADMIN CERT,O=redhat"
KRA2_ADMIN_CERT_NICKNAME="kra2admincert"
KRA2_LDAP_PORT=1601
KRA2_DB_SUFFIX="dc=pki-kra2"
KRA2_LDAP_INSTANCE_NAME=pki-kra2-ldap
KRA2_CLIENT_PKCS12_PASSWORD="Secret123"
KRA2_BACKUP_PASSWORD="Secret123"
KRA2_INSTANCE_CREATED_STATUS=False
############## End KRA 2 Params######

############# KRA3 Params used by QUICKINSTALL and topology1 ############
KRA3_TOMCAT_INSTANCE_NAME="pki-master"
KRA3_SECURE_PORT=30042
KRA3_UNSECURE_PORT=30044
KRA3_AJP_PORT=30049
KRA3_TOMCAT_SERVER_PORT=30045
KRA3_AUDIT_SIGNING_KEY_TYPE=rsa
KRA3_AUDIT_SIGNING_KEY_SIZE=2048   
KRA3_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
KRA3_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
KRA3_AUDIT_SIGNING_TOKEN=Internal
KRA3_AUDIT_SIGNING_NICKNAME="kra3auditsigningcert" 
KRA3_AUDIT_SIGNING_SUBJECT_DN="CN=PKI KRA3 AUDIT Signing Certificate, O=Redhat"
KRA3_SUBSYSTEM_KEY_TYPE="rsa"
KRA3_SUBYSTEM_KEY_SIZE=2048
KRA3_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA
KRA3_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
KRA3_SUBSYSTEM_TOKEN="Internal"
KRA3_SUBSYTEM_NICKNAME="kra3subsystemcert"
KRA3_SUBSYSTEM_SUBJECT_DN="cn=PKI KRA1 SUBSYSTEM CERT,O=redhat"
KRA3_STORAGE_KEY_TYPE="rsa"
KRA3_STORAGE_KEY_SIZE=2048
KRA3_STORAGE_KEY_ALGORITHM=SHA512withRSA
KRA3_STORAGE_SIGNING_ALGORITHM=SHA512withRSA
KRA3_STORAGE_TOKEN="Internal"
KRA3_STORAGE_NICKNAME="kra3storagecert"
KRA3_STORAGE_SUBJECT_DN="cn=PKI KRA3 STORAGE CERT,O=redhat"
KRA3_TRANSPORT_KEY_TYPE="rsa"
KRA3_TRANSPORT_KEY_SIZE=2048
KRA3_TRANSPORT_KEY_ALGORITHM=SHA512withRSA
KRA3_TRANSPORT_SIGNING_ALGORITHM=SHA512withRSA
KRA3_TRANSPORT_TOKEN="Internal"
KRA3_TRANSPORT_NICKNAME="kra3transportcert"
KRA3_TRANSPORT_SUBJECT_DN="cn=PKI KRA1 TRANSPORT CERT"

KRA3_SSL_SERVER_KEY_TYPE=rsa
KRA3_SSL_SERVER_KEY_SIZE=2048
KRA3_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
KRA3_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
KRA3_SSL_SERVER_TOKEN=Internal
KRA3_SSL_SERVER_NICKNAME="Server-Cert cert-pki-RootCA"
KRA3_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
KRA3_ADMIN_USER="kra3admin"
KRA3_ADMIN_EMAIL="example@redhat.com"
KRA3_ADMIN_DUAL_KEY=True
KRA3_ADMIN_KEY_SIZE=2048
KRA3_ADMIN_SUBJECT_DN="cn=PKI KRA3 ADMIN CERT,O=redhat"
KRA3_ADMIN_CERT_NICKNAME="kra3admincert"
KRA3_ADMIN_KEY_TYPE=rsa
KRA3_LDAP_PORT=1601
KRA3_DB_SUFFIX="dc=pki-kra3"
KRA3_LDAP_INSTANCE_NAME=pki-kra3-ldap
KRA3_CLIENT_PKCS12_PASSWORD="Secret123"
KRA3_BACKUP_PASSWORD="Secret123"
KRA3_ADMIN_PASSWORD="Secret123"
KRA3_INSTANCE_CREATED_STATUS=False
######### KRA3 Params################

##### OCSP1 Params -- used by topology 2, 3, 4, 5, 6 and 8 #############
OCSP1_TOMCAT_INSTANCE_NAME="pki-subca1"
OCSP1_SECURE_PORT=31000
OCSP1_UNSECURE_PORT=31001
OCSP1_AJP_PORT=31002
OCSP1_TOMCAT_SERVER_PORT=31003
OCSP1_SUBSYSTEM_KEY_TYPE=rsa
OCSP1_SUBSYSTEM_KEY_SIZE=2048   
OCSP1_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA      
OCSP1_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
OCSP1_SUBSYSTEM_TOKEN=Internal
OCSP1_SUBSYSTEM_CERT_NICKNAME=ocsp1subsystemcert     
OCSP1_SUBSYSTEM_SUBJECT_DN="CN=PKI OCSP1 SUBSYSTEM Signing Certificate, O=Redhat"
OCSP1_AUDIT_SIGNING_KEY_TYPE=rsa
OCSP1_AUDIT_SIGNING_KEY_SIZE=2048   
OCSP1_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
OCSP1_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
OCSP1_AUDIT_SIGNING_TOKEN=Internal
OCSP1_AUDIT_SIGNING_CERT_NICKNAME="ocsp1auditsigningcert"      
OCSP1_AUDIT_SIGNING_SUBJECT_DN="CN=PKI OCSP1 AUDIT Signing Certificate, O=Redhat"
OCSP1_SIGNING_KEY_TYPE="rsa"
OCSP1_SIGNING_KEY_SIZE=2048
OCSP1_SIGNING_KEY_ALGORITHM=SHA512withRSA
OCSP1_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
OCSP1_SIGNING_TOKEN="Internal"
OCSP1_SIGNING_CERT_NICKNAME="ocsp1signingcert"
OCSP1_SIGNING_SUBJECT_DN="cn=PKI OCSP1 SIGNING CERT,O=redhat"

OCSP1_SSL_SERVER_KEY_TYPE=rsa
OCSP1_SSL_SERVER_KEY_SIZE=2048
OCSP1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
OCSP1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
OCSP1_SSL_SERVER_TOKEN=Internal
OCSP1_SSL_SERVER_NICKNAME=subca1sslservercert
OCSP1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
OCSP1_ADMIN_USER="ocsp1admin"
OCSP1_ADMIN_PASSWORD="Secret123"
OCSP1_ADMIN_EMAIL="example@redhat.com"
OCSP1_ADMIN_DUAL_KEY=True
OCSP1_ADMIN_KEY_SIZE=2048
OCSP1_ADMIN_KEY_TYPE=rsa
OCSP1_ADMIN_SUBJECT_DN="cn=PKI OCSP1 ADMIN,O=redhat"
OCSP1_ADMIN_CERT_NICKNAME="ocsp1admincert"
OCSP1_LDAP_PORT=1602
OCSP1_DB_SUFFIX="dc=pki-ocsp1"
OCSP1_LDAP_INSTANCE_NAME=pki-ocsp1-ldap
OCSP1_BACKUP_PASSWORD="Secret123"
OCSP1_CLIENT_PKCS12_PASSWORD="Secret123"
OCSP1_INSTANCE_CREATED_STATUS=False
###### End OCSP1 Params #########

######## OCSP2 Params ##########
OCSP2_TOMCAT_INSTANCE_NAME="pki-subca2"
OCSP2_SECURE_PORT=31020
OCSP2_UNSECURE_PORT=31021
OCSP2_AJP_PORT=31022
OCSP2_TOMCAT_SERVER_PORT=31023
OCSP2_SUBSYSTEM_KEY_TYPE=rsa
OCSP2_SUBSYSTEM_KEY_SIZE=2048   
OCSP2_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA      
OCSP2_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
OCSP2_SUBSYSTEM_TOKEN=Internal
OCSP2_SUBSYSTEM_CERT_NICKNAME=ocsp2subsystemcert     
OCSP2_SUBSYSTEM_SUBJECT_DN="CN=PKI OCSP2 SUBSYSTEM Signing Certificate, O=Redhat"
OCSP2_AUDIT_SIGNING_KEY_TYPE=rsa
OCSP2_AUDIT_SIGNING_KEY_SIZE=2048   
OCSP2_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
OCSP2_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
OCSP2_AUDIT_SIGNING_TOKEN=Internal
OCSP2_AUDIT_SIGNING_CERT_NICKNAME="ocspa2uditsigningcert"      
OCSP2_AUDIT_SIGNING_SUBJECT_DN="CN=PKI OCSP2 AUDIT Signing Certificate, O=Redhat"

OCSP2_SSL_SERVER_KEY_TYPE=rsa
OCSP2_SSL_SERVER_KEY_SIZE=2048
OCSP2_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
OCSP2_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
OCSP2_SSL_SERVER_TOKEN=Internal
OCSP2_SSL_SERVER_NICKNAME=subca2sslservercert
OCSP2_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
OCSP2_SIGNING_KEY_TYPE="rsa"
OCSP2_SIGNING_KEY_SIZE=2048
OCSP2_SIGNING_KEY_ALGORITHM=SHA512withRSA
OCSP2_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
OCSP2_SIGNING_TOKEN="Internal"
OCSP2_SIGNING_CERT_NICKNAME="ocsp2signingcert"
OCSP2_SIGNING_SUBJECT_DN="cn=PKI OCSP2 SIGNING CERT,O=redhat"
OCSP2_ADMIN_USER="ocsp2admin"
OCSP2_ADMIN_PASSWORD="Secret123"
OCSP2_ADMIN_EMAIL="example@redhat.com"
OCSP2_ADMIN_DUAL_KEY=True
OCSP2_ADMIN_KEY_SIZE=2048
OCSP2_ADMIN_KEY_TYPE=rsa
OCSP2_ADMIN_SUBJECT_DN="cn=PKI OCSP2 ADMIN,O=redhat"
OCSP2_ADMIN_CERT_NICKNAME="ocsp2admincert"
OCSP2_LDAP_PORT=1602
OCSP2_DB_SUFFIX="dc=pki-ocsp2"
OCSP2_LDAP_INSTANCE_NAME=pki-ocsp2-ldap
OCSP2_BACKUP_PASSWORD="Secret123"
OCSP2_CLIENT_PKCS12_PASSWORD="Secret123"
OCSP2_INSTANCE_CREATED_STATUS=False
##### End OCSP2 Params ##########

#####OCSP3 Params used in QUICKINSTALL and topology1#############
OCSP3_TOMCAT_INSTANCE_NAME="pki-master"
OCSP3_SECURE_PORT=30042
OCSP3_UNSECURE_PORT=30044
OCSP3_AJP_PORT=30049
OCSP3_TOMCAT_SERVER_PORT=30045
OCSP3_SUBSYSTEM_KEY_TYPE=rsa
OCSP3_SUBSYSTEM_KEY_SIZE=2048   
OCSP3_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA      
OCSP3_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
OCSP3_SUBSYSTEM_TOKEN=Internal
OCSP3_SUBSYSTEM_CERT_NICKNAME=ocsp3subsystemcert     
OCSP3_SUBSYSTEM_SUBJECT_DN="CN=PKI OCSP1 SUBSYSTEM Signing Certificate, O=Redhat"
OCSP3_AUDIT_SIGNING_KEY_TYPE=rsa
OCSP3_AUDIT_SIGNING_KEY_SIZE=2048   
OCSP3_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
OCSP3_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
OCSP3_AUDIT_SIGNING_TOKEN=Internal
OCSP3_AUDIT_SIGNING_CERT_NICKNAME="ocsp3auditsigningcert"      
OCSP3_AUDIT_SIGNING_SUBJECT_DN="CN=PKI OCSP3 AUDIT Signing Certificate, O=Redhat"
OCSP3_SSL_SERVER_KEY_TYPE=rsa
OCSP3_SSL_SERVER_KEY_SIZE=2048
OCSP3_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
OCSP3_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
OCSP3_SSL_SERVER_TOKEN=Internal
OCSP3_SSL_SERVER_NICKNAME="Server-Cert cert-pki-RootCA"
OCSP3_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
OCSP3_SIGNING_KEY_TYPE="rsa"
OCSP3_SIGNING_KEY_SIZE=2048
OCSP3_SIGNING_KEY_ALGORITHM=SHA512withRSA
OCSP3_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
OCSP3_SIGNING_TOKEN="Internal"
OCSP3_SIGNING_CERT_NICKNAME="ocsp3signingcert"
OCSP3_SIGNING_SUBJECT_DN="cn=PKI OCSP3 SIGNING CERT,O=redhat"
OCSP3_ADMIN_USER="ocsp3admin"
OCSP3_ADMIN_PASSWORD="Secret123"
OCSP3_ADMIN_EMAIL="example@redhat.com"
OCSP3_ADMIN_DUAL_KEY=True
OCSP3_ADMIN_KEY_SIZE=2048
OCSP3_ADMIN_KEY_TYPE=rsa
OCSP3_ADMIN_SUBJECT_DN="cn=PKI OCSP3 ADMIN,O=redhat"
OCSP3_ADMIN_CERT_NICKNAME="ocsp3admincert"
OCSP3_LDAP_PORT=1602
OCSP3_DB_SUFFIX="dc=pki-ocsp3"
OCSP3_LDAP_INSTANCE_NAME=pki-ocsp3-ldap
OCSP3_BACKUP_PASSWORD="Secret123"
OCSP3_CLIENT_PKCS12_PASSWORD="Secret123"
OCSP3_INSTANCE_CREATED_STATUS=False
########End OCSP3 Params#####

######### TKS1 Parmams used in QUICKINSTALL and topology1 #########
TKS1_TOMCAT_INSTANCE_NAME="pki-master"
TKS1_SECURE_PORT=30042
TKS1_UNSECURE_PORT=30044
TKS1_AJP_PORT=30049
TKS1_TOMCAT_SERVER_PORT=30045
TKS1_AUDIT_SIGNING_KEY_TYPE=rsa
TKS1_AUDIT_SIGNING_KEY_SIZE=2048   
TKS1_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
TKS1_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
TKS1_AUDIT_SIGNING_TOKEN=Internal
TKS1_AUDIT_SIGNING_CERT_NICKNAME="tks1auditsigningcert"      
TKS1_AUDIT_SIGNING_SUBJECT_DN="CN=PKI TKS1 AUDIT Signing Certificate, O=Redhat"

TKS1_SSL_SERVER_KEY_TYPE=rsa
TKS1_SSL_SERVER_KEY_SIZE=2048
TKS1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
TKS1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
TKS1_SSL_SERVER_TOKEN=Internal
TKS1_SSL_SERVER_NICKNAME="Server-Cert cert-pki-RootCA"
TKS1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
TKS1_SUBSYSTEM_KEY_TYPE="rsa"
TKS1_SUBSYSTEM_KEY_SIZE=2048
TKS1_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA
TKS1_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
TKS1_SUBSYSTEM_TOKEN="Internal"
TKS1_SUBSYSTEM_CERT_NICKNAME="tks1subsystemcert"
TKS1_SUBSYSTEM_SUBJECT_DN="cn=PKI TKS1 SUBSYSTEM CERT,O=redhat"
TKS1_ADMIN_USER="tks1admin"
TKS1_ADMIN_PASSWORD="Secret123"
TKS1_ADMIN_EMAIL="example@redhat.com"
TKS1_ADMIN_DUAL_KEY=True
TKS1_ADMIN_KEY_SIZE=2048
TKS1_ADMIN_KEY_TYPE="rsa"
TKS1_ADMIN_SUBJECT_DN="cn=PKI TKS1 ADMIN,O=redhat"
TKS1_ADMIN_CERT_NICKNAME="tks1admincert"
TKS1_LDAP_PORT=1603
TKS1_LDAP_INSTANCE_NAME=pki-tks1-ldap
TKS1_DB_SUFFIX="dc=pki-tks1"
TKS1_BACKUP_PASSWORD="Secret123"
TKS1_CLIENT_PKCS12_PASSWORD="Secret123"
TKS1_INSTANCE_CREATED_STATUS=False
########End TKS Params#######

####### TKS2 Params - this set of params not used in any topology ##########
TKS2_TOMCAT_INSTANCE_NAME="pki-tks2"
TKS2_SECURE_PORT=31092
TKS2_UNSECURE_PORT=31094
TKS2_AJP_PORT=31099
TKS2_TOMCAT_SERVER_PORT=31095
TKS2_AUDIT_SIGNING_KEY_TYPE=rsa
TKS2_AUDIT_SIGNING_KEY_SIZE=2048   
TKS2_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
TKS2_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
TKS2_AUDIT_SIGNING_TOKEN=Internal
TKS2_AUDIT_SIGNING_CERT_NICKNAME="tks2aditsigningcert"      
TKS2_AUDIT_SIGNING_SUBJECT_DN="CN=PKI TKS2 AUDIT Signing Certificate, O=Redhat"
TKS2_SSL_SERVER_KEY_TYPE=rsa
TKS2_SSL_SERVER_KEY_SIZE=2048
TKS2_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
TKS2_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
TKS2_SSL_SERVER_TOKEN=Internal
TKS2_SSL_SERVER_NICKNAME="tks2sslservercert"
TKS2_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
TKS2_SUBSYSTEM_KEY_TYPE="rsa"
TKS2_SUBSYSTEM_KEY_SIZE=2048
TKS2_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA
TKS2_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
TKS2_SUBSYSTEM_TOKEN="Internal"
TKS2_SUBSYSTEM_CERT_NICKNAME="tks2subsystemcert"
TKS2_SUBSYSTEM_SUBJECT_DN="cn=PKI TKS2 SUBSYSTEM CERT,O=redhat"
TKS2_ADMIN_USER="tks2admin"
TKS2_ADMIN_EMAIL="example@redhat.com"
TKS2_ADMIN_DUAL_KEY=True
TKS2_ADMIN_KEY_SIZE=2048
TKS2_ADMIN_KEY_TYPE="rsa"
TKS2_ADMIN_SUBJECT_DN="cn=PKI TKS2 ADMIN,O=redhat"
TKS2_ADMIN_CERT_NICKNAME="tks2admincert"
TKS2_LDAP_PORT=1603
TKS2_LDAP_INSTANCE_NAME=pki-tks2-ldap
TKS2_DB_SUFFIX="dc=pki-tks2"
TKS2_BACKUP_PASSWORD="Secret123"
TKS2_ADMIN_PASSWORD="Secret123"
TKS2_CLIENT_PKCS12_PASSWORD=Secret123
TKS2_INSTANCE_CREATED_STATUS=False
####### End TKS2 Params ######

######### TPS1 Parmams used in QUICKINSTALL and topology1 #########
TPS1_TOMCAT_INSTANCE_NAME="pki-master"
TPS1_SECURE_PORT=30042
TPS1_UNSECURE_PORT=30044
TPS1_AJP_PORT=30049
TPS1_TOMCAT_SERVER_PORT=30045
TPS1_AUDIT_SIGNING_KEY_TYPE=rsa
TPS1_AUDIT_SIGNING_KEY_SIZE=2048
TPS1_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA
TPS1_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
TPS1_AUDIT_SIGNING_TOKEN=Internal
TPS1_AUDIT_SIGNING_CERT_NICKNAME="tps1auditsigningcert"
TPS1_AUDIT_SIGNING_SUBJECT_DN="CN=PKI TPS1 AUDIT Signing Certificate, O=Redhat"

TPS1_SSL_SERVER_KEY_TYPE=rsa
TPS1_SSL_SERVER_KEY_SIZE=2048
TPS1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
TPS1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
TPS1_SSL_SERVER_TOKEN=Internal
TPS1_SSL_SERVER_NICKNAME="Server-Cert cert-pki-RootCA"
TPS1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`, O=Redhat"
TPS1_SUBSYSTEM_KEY_TYPE="rsa"
TPS1_SUBSYSTEM_KEY_SIZE=2048
TPS1_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA
TPS1_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
TPS1_SUBSYSTEM_TOKEN="Internal"
TPS1_SUBSYSTEM_CERT_NICKNAME="tps1subsystemcert"
TPS1_SUBSYSTEM_SUBJECT_DN="cn=PKI TPS1 SUBSYSTEM CERT,O=redhat"
TPS1_ADMIN_USER="tps1admin"
TPS1_ADMIN_PASSWORD="Secret123"
TPS1_ADMIN_EMAIL="example@redhat.com"
TPS1_ADMIN_DUAL_KEY=True
TPS1_ADMIN_KEY_SIZE=2048
TPS1_ADMIN_KEY_TYPE="rsa"
TPS1_ADMIN_SUBJECT_DN="cn=PKI TPS1 ADMIN,O=redhat"
TPS1_ADMIN_CERT_NICKNAME="tps1admincert"
TPS1_LDAP_PORT=1604
TPS1_LDAP_INSTANCE_NAME=pki-tps1-ldap
TPS1_DB_SUFFIX="dc=pki-tps1"
TPS1_BACKUP_PASSWORD="Secret123"
TPS1_CLIENT_PKCS12_PASSWORD="Secret123"
TPS1_SERVER_KEYGEN=True
TPS1_AUTHDB_HOST="`hostname`"
TPS1_INSTANCE_CREATED_STATUS=False
########End TPS Params#######

##### GENERIC PARAMS #####
CLIENT_DIR="/opt/rhqa_pki"
CERTDB_DIR="/opt/rhqa_pki/certs_db"
CERTDB_DIR_PASSWORD="Secret123"
UNTRUSTED_CERT_DB_LOCATION="/tmp/untrusted_cert_db"
UNTRUSTED_CERT_DB_PASSWORD="Password"
CLIENT_DB_PURGE=True
LDAP_HOSTNAME=localhost
LDAP_ROOTDN="cn=Directory Manager"
LDAP_ROOTDNPWD="Secret123"
SECURE_CONN=False
REMOVE_DATA=True
RESTART_INSTANCE=True
SKIP_CONFIG=False
SKIP_INSTALL=False
ENABLE_ACCESS_LOG=True
ENABLE_JAVA_DEBUG=False
SECURITY_MANAGER=True
IMPORT_ADMIN_CERT_NONCA=True
#USER and GROUP names can not be changed to something else due to bug https://fedorahosted.org/pki/ticket/1025
USER="pkiuser"
GROUP="pkiuser"
GROUP_AUDIT="pkiaudit"
TIMESOURCE="clock.corp.redhat.com"
XMLSTARLET_PATH="http://download.devel.redhat.com/brewroot/packages/xmlstarlet/1.4.2/1.el7/x86_64/xmlstarlet-1.4.2-1.el7.x86_64.rpm"
JACOCO_PATH="http://download.devel.redhat.com/released/F-20/GOLD/Everything/x86_64/os/"

##### SUBCA1 params -- used by QUICKINSTALL and all topologies ############
SUBCA1_TOMCAT_INSTANCE_NAME=pki-subca1
SUBCA1_SECURE_PORT=31000     
SUBCA1_UNSECURE_PORT=31001   
SUBCA1_AJP_PORT=31002
SUBCA1_TOMCAT_SERVER_PORT=31003      
SUBCA1_USER=pkiuser
SUBCA1_GROUP=pkiuser
SUBCA1_GROUP_AUDIT=pkiaudit     
SUBCA1_TOKEN_NAME=Internal
SUBCA1_TOKEN_PASSWORD=Secret123   
SUBCA1_CLIENT_PKCS12_PASSWORD=Secret123     
SUBCA1_ADMIN_PASSWORD=Secret123
SUBCA1_DS_PASSWORD=Secret123
SUBCA1_ADMIN_USER=subcaadmin
SUBCA1_ADMIN_EMAIL=example@redhat.com
SUBCA1_ADMIN_DUAL_KEY=True
SUBCA1_ADMIN_KEY_SIZE=2048  
SUBCA1_ADMIN_KEY_TYPE=rsa  
SUBCA1_ADMIN_SUBJECT_DN="cn=PKI SUBCA1 ADMIN Certificate,O = redhat"
SUBCA1_ADMIN_CERT_NICKNAME=subcaadmincert
SUBCA1_ADMIN_IMPORT_CERT=False
SUBCA1_SUBSYSTEM_KEY_TYPE=rsa  
SUBCA1_SUBYSTEM_KEY_SIZE=2048   
SUBCA1_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA      
SUBCA1_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
SUBCA1_SUBSYSTEM_TOKEN=Internal
SUBCA1_SUBSYTEM_NICKNAME=subcasubsystemcert
SUBCA1_SUBSYSTEM_SUBJECT_DN="cn=PKI SUBSYTEM CA Certificate,O=redhat"
SUBCA1_KEY_TYPE=rsa
SUBCA1_KEY_SIZE=2048   
SUBCA1_SIGNING_ALGORITHM=SHA512withRSA      
SUBCA1_SIGNING_SIGNING_ALGORITHM=SHA512withRSA 
SUBCA1_SIGNING_TOKEN=Internal
SUBCA1_SIGNING_NICKNAME=subcasigningcert
SUBCA1_SIGNING_CERT_SUBJECT_NAME="CN=PKI SUBCA1 Signing Certificate,O=redhat"      
SUBCA1_OCSP_SIGNING_KEY_SIZE=2048
SUBCA1_OCSP_SIGNING_KEY_ALGORITHM=SHA512withRSA
SUBCA1_OCSP_SIGNING_SIGNING_ALGORITHM=SHA512withRSA      
SUBCA1_OCSP_SIGNING_TOKEN=Internal
SUBCA1_OCSP_SIGNING_NICKNAME=subcaocspsigningcert
SUBCA1_OCSP_SIGNING_CERT_SUBJECT_NAME="cn=PKI CA OCSP Signing Certificate, O=redhat"
SUBCA1_OCSP_SIGNING_KEY_TYPE=rsa
SUBCA1_AUDIT_SIGNING_KEY_TYPE=rsa      
SUBCA1_AUDIT_SIGNING_KEY_SIZE=2048    
SUBCA1_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
SUBCA1_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
SUBCA1_AUDIT_SIGNING_TOKEN=Internal
SUBCA1_AUDIT_SIGNING_NICKNAME=subcaauditsigningcert 
SUBCA1_AUDIT_SIGNING_CERT_SUBJECT_NAME="cn=PKI SUBCA1 Audit Signing Certificate, O=redhat"
SUBCA1_SSL_SERVER_KEY_TYPE=rsa
SUBCA1_SSL_SERVER_KEY_SIZE=2048   
SUBCA1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA      
SUBCA1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
SUBCA1_SSL_SERVER_TOKEN=Internal
SUBCA1_SSL_SERVER_NICKNAME=subca1sslservercert 
SUBCA1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`,O=redhat"
SUBCA1_SECURITY_DOMAIN_PASSWORD=Secret123
SUBCA1_DS_HOSTNAME=localhost
SUBCA1_LDAP_PORT=2100
SUBCA1_LDAP_ROOTDN="cn=DS Manager"
SUBCA1_LDAP_ROOTDNPWD=Secret123
SUBCA1_LDAP_INSTANCE_NAME=pki-subca1
SUBCA1_SECURE_CONN=False
SUBCA1_REMOVE_DATA=True 
SUBCA1_DB_SUFFIX=dc=pki-subca
SUBCA1_BACKUP=True
SUBCA1_BACKUP_PASSWORD=Secret123      
SUBCA1_CERTDB_DIR=$CLIENT_DIR/subca1_certs_db
SUBCA1_CERTDB_DIR_PASSWORD=Secret123
SUBCA1_CLIENT_DB_PURGE=True
SUBCA1_INSTANCE_CREATED_STATUS=False
##### End of SUBCA1 params #######

###### SUBCA2 params - topology 3,4,5 and 6 #######
SUBCA2_TOMCAT_INSTANCE_NAME=pki-subca2
SUBCA2_SECURE_PORT=31020
SUBCA2_UNSECURE_PORT=31021   
SUBCA2_AJP_PORT=31022
SUBCA2_TOMCAT_SERVER_PORT=31023      
SUBCA2_USER=pkiuser
SUBCA2_GROUP=pkiuser
SUBCA2_GROUP_AUDIT=pkiaudit     
SUBCA2_TOKEN_NAME=Internal
SUBCA2_TOKEN_PASSWORD=Secret123   
SUBCA2_CLIENT_PKCS12_PASSWORD=Secret123     
SUBCA2_ADMIN_PASSWORD=Secret123
SUBCA2_DS_PASSWORD=Secret123
SUBCA2_LDAP_INSTANCE_NAME=pki-subca2
SUBCA2_ADMIN_USER=subca2admin
SUBCA2_ADMIN_EMAIL=example@redhat.com
SUBCA2_ADMIN_DUAL_KEY=True
SUBCA2_ADMIN_KEY_SIZE=2048  
SUBCA2_ADMIN_KEY_TYPE=rsa  
SUBCA2_ADMIN_SUBJECT_DN="cn=PKI SUBCA2 ADMIN Certificate,O = redhat"
SUBCA2_ADMIN_CERT_NICKNAME=subca2admincert
SUBCA2_ADMIN_IMPORT_CERT=False
SUBCA2_SUBSYSTEM_KEY_TYPE=rsa  
SUBCA2_SUBYSTEM_KEY_SIZE=2048   
SUBCA2_SUBSYSTEM_KEY_ALGORITHM=SHA512withRSA      
SUBCA2_SUBSYSTEM_SIGNING_ALGORITHM=SHA512withRSA
SUBCA2_SUBSYSTEM_TOKEN=Internal
SUBCA2_SUBSYTEM_NICKNAME=subca2subsystemcert
SUBCA2_SUBSYSTEM_SUBJECT_DN="cn=PKI SUBSYTEM CA2 Certificate,O=redhat"
SUBCA2_KEY_TYPE=rsa
SUBCA2_KEY_SIZE=2048   
SUBCA2_SIGNING_ALGORITHM=SHA512withRSA      
SUBCA2_SIGNING_SIGNING_ALGORITHM=SHA512withRSA 
SUBCA2_SIGNING_TOKEN=Internal
SUBCA2_SIGNING_NICKNAME=subca2signingcert
SUBCA2_SIGNING_CERT_SUBJECT_NAME="CN=PKI SUBCA2 Signing Certificate,O=redhat"      
SUBCA2_OCSP_SIGNING_KEY_SIZE=2048
SUBCA2_OCSP_SIGNING_KEY_ALGORITHM=SHA512withRSA
SUBCA2_OCSP_SIGNING_SIGNING_ALGORITHM=SHA512withRSA      
SUBCA2_OCSP_SIGNING_TOKEN=Internal
SUBCA2_OCSP_SIGNING_NICKNAME=subcaocspsigningcert2
SUBCA2_OCSP_SIGNING_CERT_SUBJECT_NAME="cn=PKI SUBCA2 OCSP Signing Certificate, O=redhat"
SUBCA2_OCSP_SIGNING_KEY_TYPE=rsa
SUBCA2_AUDIT_SIGNING_KEY_TYPE=rsa      
SUBCA2_AUDIT_SIGNING_KEY_SIZE=2048    
SUBCA2_AUDIT_SIGNING_KEY_ALGORITHM=SHA512withRSA      
SUBCA2_AUDIT_SIGNING_SIGNING_ALGORITHM=SHA512withRSA
SUBCA2_AUDIT_SIGNING_TOKEN=Internal
SUBCA2_AUDIT_SIGNING_NICKNAME=subcaauditsigningcert 
SUBCA2_AUDIT_SIGNING_CERT_SUBJECT_NAME="cn=PKI SUBCA2 Audit Signing Certificate, O=redhat"
SUBCA2_SSL_SERVER_KEY_TYPE=rsa
SUBCA2_SSL_SERVER_KEY_SIZE=2048   
SUBCA2_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA      
SUBCA2_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
SUBCA2_SSL_SERVER_TOKEN=Internal
SUBCA2_SSL_SERVER_NICKNAME=subca2sslservercert 
SUBCA2_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`,O=redhat"
SUBCA2_SECURITY_DOMAIN_PASSWORD=Secret123
SUBCA2_DS_HOSTNAME=localhost
SUBCA2_LDAP_PORT=3300
SUBCA2_LDAP_ROOTDN="cn=DS Manager"
SUBCA2_LDAP_ROOTDNPWD=Secret123
SUBCA2_SECURE_CONN=False
SUBCA2_REMOVE_DATA=True 
SUBCA2_DB_SUFFIX=dc=pki-subca2
SUBCA2_BACKUP=True
SUBCA2_BACKUP_PASSWORD=Secret123      
SUBCA2_CERTDB_DIR=$CLIENT_DIR/subca2_certs_db
SUBCA2_CERTDB_DIR_PASSWORD=Secret123
SUBCA2_CLIENT_DB_PURGE=True
SUBCA2_INSTANCE_CREATED_STATUS=False
######## End of SUBCA2 params #######

##### CLONE generic params #########
CLONE1_USER=pkiuser
CLONE1_GROUP=pkiuser
CLONE1_GROUP_AUDIT=pkiaudit     
REPLICATE_SCHEMA=True
REPLICATION_SEC=None
CLONE1_LDAP_ROOTDNPWD=Secret123      
CLONE1_LDAP_ROOTDN="cn=Database Manager"  
CLONE_ADMIN_IMPORT_CERT=True  
CLONE1_CERTDB_DIR_PASSWORD=Secret123
CLIENT_PKCS12_DIR=/tmp/pkcs

##### CLONE_CA1 params ############
CLONE_CA1_TOMCAT_INSTANCE_NAME=clone1
CLONE_CA1_SECURE_PORT=30002 
CLONE_CA1_UNSECURE_PORT=30009  
CLONE_CA1_AJP_PORT=30004      
CLONE_CA1_TOMCAT_SERVER_PORT=30005      
CLONE_CA1_TOKEN_NAME=Internal
CLONE_CA1_TOKEN_PASSWORD="Secret123"      
CLONE_CA1_CLIENT_PKCS12_PASSWORD=Secret123      
CLONE_CA1_ADMIN_PASSWORD=Secret123
CLONE_CA1_SSL_SERVER_KEY_TYPE=rsa
CLONE_CA1_SSL_SERVER_KEY_SIZE=2048   
CLONE_CA1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA      
CLONE_CA1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
CLONE_CA1_SSL_SERVER_TOKEN=Internal
CLONE_CA1_SSL_SERVER_NICKNAME=cloneca1sslservercert 
CLONE_CA1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`,O=redhat"
CLONE_CA1_ADMIN_USER=clonecaadmin
CLONE_CA1_ADMIN_EMAIL=example@redhat.com
CLONE_CA1_ADMIN_DUAL_KEY=True
CLONE_CA1_ADMIN_KEY_SIZE=2048  
CLONE_CA1_ADMIN_KEY_TYPE=rsa  
CLONE_CA1_ADMIN_SUBJECT_DN="cn=PKI CLONE Admin, O=redhat"    
CLONE_CA1_ADMIN_CERT_NICKNAME=clonecaadmincert
CLONE_CA1_ADMIN_IMPORT_CERT=False
CLONE_CA1_DS_HOSTNAME=localhost
CLONE_CA1_LDAP_PORT=1901
CLONE_CA1_LDAP_INSTANCE_NAME=pki-cloneca1
CLONE_CA1_SECURE_CONN=False
CLONE_CA1_REMOVE_DATA=True 
CLONE_CA1_INSTANCE_CREATED_STATUS=False
##### End of CLONE_CA1 params #######

##### CLONE_KRA1 params -- used by QUICKINSTALL, topology 1 and 8 ########
CLONE_KRA1_TOMCAT_INSTANCE_NAME=clone1
CLONE_KRA1_SECURE_PORT=30002 
CLONE_KRA1_UNSECURE_PORT=30009  
CLONE_KRA1_AJP_PORT=30004      
CLONE_KRA1_TOMCAT_SERVER_PORT=30005      
CLONE_KRA1_ADMIN_USER=clonekraadmin
CLONE_KRA1_ADMIN_EMAIL=example@redhat.com
CLONE_KRA1_ADMIN_DUAL_KEY=True
CLONE_KRA1_ADMIN_KEY_SIZE=2048  
CLONE_KRA1_ADMIN_KEY_TYPE=rsa  
CLONE_KRA1_ADMIN_SUBJECT_DN="cn=PKI CLONE KRA Admin, O=redhat"     
CLONE_KRA1_ADMIN_CERT_NICKNAME=clonekraadmincert      
CLONE_ADMIN_IMPORT_CERT=True  
CLONE_KRA1_DS_HOSTNAME=localhost
CLONE_KRA1_LDAP_PORT=2110   
CLONE_KRA1_LDAP_INSTANCE_NAME=pki-clonekra1
CLONE_KRA1_SECURE_CONN=False    
CLONE_KRA1_REMOVE_DATA=True
CLONE_KRA1_SSL_SERVER_KEY_TYPE=rsa
CLONE_KRA1_SSL_SERVER_KEY_SIZE=2048   
CLONE_KRA1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA      
CLONE_KRA1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
CLONE_KRA1_SSL_SERVER_TOKEN=Internal
CLONE_KRA1_SSL_SERVER_NICKNAME=cloneca1sslservercert 
CLONE_KRA1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`,O=redhat"
CLONE_KRA1_INSTANCE_CREATED_STATUS=False
##### End of CLONE_KRA1 params #######



##### CLONE_OCSP1 params -- used by QUICKINSTALL, topology 1 and 8 #########

CLONE_OCSP1_TOMCAT_INSTANCE_NAME=clone1
CLONE_OCSP1_SECURE_PORT=30002 
CLONE_OCSP1_UNSECURE_PORT=30009  
CLONE_OCSP1_AJP_PORT=30004      
CLONE_OCSP1_TOMCAT_SERVER_PORT=30005      
CLONE_OCSP1_ADMIN_USER=cloneocspadmin   
CLONE_OCSP1_ADMIN_EMAIL=example@redhat.com
CLONE_OCSP1_ADMIN_DUAL_KEY=True
CLONE_OCSP1_ADMIN_KEY_SIZE=2048  
CLONE_OCSP1_ADMIN_KEY_TYPE=rsa  
CLONE_OCSP1_ADMIN_SUBJECT_DN="cn=PKi Clone OCSP admin,O=redhat"
CLONE_OCSP1_ADMIN_CERT_NICKNAME=cloneocspadmincert
CLONE_OCSP1_ADMIN_PASSWORD=Secret123
CLONE_OCSP1_DS_HOSTNAME=localhost    
CLONE_OCSP1_LDAP_PORT=2400      
CLONE_OCSP1_LDAP_INSTANCE_NAME=pki-cloneocsp1
CLONE_OCSP1_SECURE_CONN=False    
CLONE_OCSP1_REMOVE_DATA=True 
CLONE_OCSP1_SSL_SERVER_KEY_TYPE=rsa
CLONE_OCSP1_SSL_SERVER_KEY_SIZE=2048   
CLONE_OCSP1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA      
CLONE_OCSP1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
CLONE_OCSP1_SSL_SERVER_TOKEN=Internal
CLONE_OCSP1_SSL_SERVER_NICKNAME=cloneca1sslservercert 
CLONE_OCSP1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`,O=redhat"
CLONE_OCSP1_INSTANCE_CREATED_STATUS=False
###### End of CLONE_OCSP1 #######

###### CLONE_TKS1 params -- used by QUICKINSTALL and topology 1 #########

CLONE_TKS1_TOMCAT_INSTANCE_NAME=clone1
CLONE_TKS1_SECURE_PORT=30002 
CLONE_TKS1_UNSECURE_PORT=30009  
CLONE_TKS1_AJP_PORT=30004      
CLONE_TKS1_TOMCAT_SERVER_PORT=30005      
CLONE_TKS1_ADMIN_USER=clonetksadmin
CLONE_TKS1_ADMIN_EMAIL=example@redhat.com
CLONE_TKS1_ADMIN_DUAL_KEY=True
CLONE_TKS1_ADMIN_KEY_SIZE=2048   
CLONE_TKS1_ADMIN_KEY_TYPE=rsa  
CLONE_TKS1_ADMIN_SUBJECT_DN="cn=PKI TKS ADMIN CLONE, O=redhat"    
CLONE_TKS1_ADMIN_CERT_NICKNAME=clonetksadmincert
CLONE_TKS1_ADMIN_PASSWORD=Secret123
CLONE_TKS1_DS_HOSTNAME=localhost
CLONE_TKS1_LDAP_PORT=2700     
CLONE_TKS1_LDAP_INSTANCE_NAME=pki-clonetks1
CLONE_TKS1_SECURE_CONN=False    
CLONE_TKS1_REMOVE_DATA=True 
CLONE_TKS1_SSL_SERVER_KEY_TYPE=rsa
CLONE_TKS1_SSL_SERVER_KEY_SIZE=2048   
CLONE_TKS1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA      
CLONE_TKS1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
CLONE_TKS1_SSL_SERVER_TOKEN=Internal
CLONE_TKS1_SSL_SERVER_NICKNAME=cloneca1sslservercert 
CLONE_TKS1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`,O=redhat"
CLONE_TKS1_INSTANCE_CREATED_STATUS=False
##### End of CLONE_TKS1 params ######

###### CLONE_TPS1 params -- used by QUICKINSTALL and topology 1 #########

CLONE_TPS1_TOMCAT_INSTANCE_NAME=clone1
CLONE_TPS1_SECURE_PORT=30002
CLONE_TPS1_UNSECURE_PORT=30009
CLONE_TPS1_AJP_PORT=30004
CLONE_TPS1_TOMCAT_SERVER_PORT=30005
CLONE_TPS1_ADMIN_USER=clonetpsadmin
CLONE_TPS1_ADMIN_EMAIL=example@redhat.com
CLONE_TPS1_ADMIN_DUAL_KEY=True
CLONE_TPS1_ADMIN_KEY_SIZE=2048
CLONE_TPS1_ADMIN_KEY_TYPE=rsa
CLONE_TPS1_ADMIN_SUBJECT_DN="cn=PKI TPS ADMIN CLONE, O=redhat"
CLONE_TPS1_ADMIN_CERT_NICKNAME=clonetpsadmincert
CLONE_TPS1_ADMIN_PASSWORD=Secret123
CLONE_TPS1_DS_HOSTNAME=`hostname`
CLONE_TPS1_LDAP_PORT=2900
CLONE_TPS1_LDAP_INSTANCE_NAME=pki-clonetps1
CLONE_TPS1_SECURE_CONN=False
CLONE_TPS1_REMOVE_DATA=True
CLONE_TPS1_SSL_SERVER_KEY_TYPE=rsa
CLONE_TPS1_SSL_SERVER_KEY_SIZE=2048
CLONE_TPS1_SSL_SERVER_KEY_ALGORITHM=SHA512withRSA
CLONE_TPS1_SSL_SERVER_SIGNING_ALGORITHM=SHA512withRSA
CLONE_TPS1_SSL_SERVER_TOKEN=Internal
CLONE_TPS1_SSL_SERVER_NICKNAME=cloneca1sslservercert
CLONE_TPS1_SSL_SERVER_CERT_SUBJECT_NAME="cn=`hostname`,O=redhat"
CLONE_TPS1_SERVER_KEYGEN=True
CLONE_TPS1_INSTANCE_CREATED_STATUS=False
##### End of CLONE_TPS1 params ######


##### CLONE2 generic params #########
CLONE2_TOMCAT_INSTANCE_NAME="pki-clone2"
CLONE2_USER=pkiuser
CLONE2_GROUP=pkiuser
CLONE2_GROUP_AUDIT=pkiaudit     
CLONE2_LDAP_ROOTDN="cn=Database Manager"  
CLONE2_LDAP_ROOTDNPWD=Secret123      
CLONE2_CA2_SECURE_CONN=False
CLONE2_CA2_REMOVE_DATA=True 
CLONE2_CERTDB_DIR_PASSWORD=Secret123

##### CLONE_CA2 params #####
CLONE_CA2_LDAP_INSTANCE_NAME=pki-cloneca2
CLONE_CA2_SECURE_PORT=30076
CLONE_CA2_UNSECURE_PORT=30075  
CLONE_CA2_AJP_PORT=30079      
CLONE_CA2_TOMCAT_SERVER_PORT=30080  
CLONE_CA2_TOKEN_NAME=Internal
CLONE_CA2_TOKEN_PASSWORD="Secret123"      
CLONE_CA2_CLIENT_PKCS12_PASSWORD=Secret123      
CLONE_CA2_ADMIN_PASSWORD=Secret123
CLONE_CA2_LDAP_PORT=1901
CLONE_CA2_ADMIN_USER=cloneca2admin
CLONE_CA2_ADMIN_EMAIL=example@redhat.com
CLONE_CA2_ADMIN_DUAL_KEY=True
CLONE_CA2_ADMIN_KEY_SIZE=2048  
CLONE_CA2_ADMIN_KEY_TYPE=rsa  
CLONE_CA2_ADMIN_SUBJECT_DN="cn=PKI CLONE2 Admin, O=redhat"    
CLONE_CA2_ADMIN_CERT_NICKNAME=cloneca2admincert
CLONE_CA2_ADMIN_IMPORT_CERT=False
CLONE_CA2_DS_HOSTNAME=localhost
CLONE_CA2_INSTANCE_CREATED_STATUS=False
###### End of CLONE_CA2 ########


##### CLONE_KRA2 params #######
CLONE_KRA2_LDAP_INSTANCE_NAME=pki-clonekra2
CLONE_KRA2_ADMIN_USER=clonekra2admin
CLONE_KRA2_ADMIN_EMAIL=example@redhat.com
CLONE_KRA2_ADMIN_DUAL_KEY=True
CLONE_KRA2_ADMIN_KEY_SIZE=2048  
CLONE_KRA2_ADMIN_KEY_TYPE=rsa  
CLONE_KRA2_ADMIN_SUBJECT_DN="cn=PKI CLONE KRA2 Admin, O=redhat"     
CLONE_KRA2_ADMIN_CERT_NICKNAME=clonekra2admincert      
CLONE_KRA2_DS_HOSTNAME=localhost
CLONE_KRA2_LDAP_PORT=3500
CLONE_KRA2_SECURE_CONN=False    
CLONE_KRA2_REMOVE_DATA=True 
CLONE_KRA2_INSTANCE_CREATED_STATUS=False
###### End of CLONE_KRA2 params #######


##### CLONE_OCSP2 params #######
CLONE_OCSP2_LDAP_INSTANCE_NAME=pki-cloneocsp2
CLONE_OCSP2_ADMIN_USER=cloneocsp2admin   
CLONE_OCSP2_ADMIN_EMAIL=example@redhat.com
CLONE_OCSP2_ADMIN_DUAL_KEY=True
CLONE_OCSP2_ADMIN_KEY_SIZE=2048  
CLONE_OCSP2_ADMIN_KEY_TYPE=rsa  
CLONE_OCSP2_ADMIN_SUBJECT_DN="cn=PKi Clone OCSP2 admin,O=redhat"
CLONE_OCSP2_ADMIN_CERT_NICKNAME=cloneocsp2admincert
CLONE_OCSP2_ADMIN_PASSWORD=Secret123
CLONE_OCSP2_DS_HOSTNAME=localhost    
CLONE_OCSP2_LDAP_PORT=3700
CLONE_OCSP2_SECURE_CONN=False    
CLONE_OCSP2_REMOVE_DATA=True 
CLONE_OCSP2_INSTANCE_CREATED_STATUS=False
####### End of CLONE_OCSP2 params ########

##### CLONE_TKS2 params #######
CLONE_TKS2_LDAP_INSTANCE_NAME=pki-clonetks2
CLONE_TKS2_LDAP_PORT=3100     
CLONE_TKS2_SECURE_CONN=False    
CLONE_TKS2_REMOVE_DATA=True 
CLONE_TKS2_ADMIN_USER=clonetksadmin2
CLONE_TKS2_ADMIN_EMAIL=example@redhat.com
CLONE_TKS2_ADMIN_DUAL_KEY=True
CLONE_TKS2_ADMIN_KEY_SIZE=2048   
CLONE_TKS2_ADMIN_KEY_TYPE=rsa  
CLONE_TKS2_ADMIN_SUBJECT_DN="cn=PKI CLONE TKS2 ADMIN CLONE, O=redhat" 
CLONE_TKS2_ADMIN_CERT_NICKNAME=clonetks2admincert
CLONE_TKS2_ADMIN_PASSWORD=Secret123
CLONE_TKS2_DS_HOSTNAME=localhost
CLONE_TKS2_INSTANCE_CREATED_STATUS=False
######## End of CLONE_TKS2 params #######

###### Microsoft ADCS params #######
MS_ipaddr="10.13.129.103"
MS_username="CORP\\Administrator"
MS_password="Secret123"
######End of MS ADCS params####


export CLONE_CA1_LDAP_INSTANCE_NAME CLONE_TKS1_LDAP_INSTANCE_NAME CLONE_OCSP1_LDAP_INSTANCE_NAME CLONE_KRA1_LDAP_INSTANCE_NAME CLONE1_GROUP_AUDIT CERTDB_DIR CERTDB_DIR_PASSWORD CLONE_CA1_TOMCAT_INSTANCE_NAME CLONE_KRA1_ADMIN_USER CLONE_KRA1_ADMIN_EMAIL CLONE_KRA1_ADMIN_DUAL_KEY CLONE_KRA1_ADMIN_KEY_SIZE CLONE_KRA1_ADMIN_KEY_TYPE CLONE_KRA1_ADMIN_SUBJECT_DN CLONE_KRA1_ADMIN_CERT_NICKNAME CLONE_ADMIN_IMPORT_CERT CLONE_KRA1_DS_HOSTNAME CLONE_KRA1_LDAP_PORT CLONE_KRA1_SECURE_CONN CLONE_KRA1_REMOVE_DATA CLONE_OCSP1_ADMIN_USER CLONE_OCSP1_ADMIN_EMAIL CLONE_OCSP1_ADMIN_DUAL_KEY CLONE_OCSP1_ADMIN_KEY_SIZE CLONE_OCSP1_ADMIN_KEY_TYPE CLONE_OCSP1_ADMIN_SUBJECT_DN CLONE_OCSP1_ADMIN_CERT_NICKNAME CLONE_OCSP1_ADMIN_PASSWORD CLONE_OCSP1_DS_HOSTNAME CLONE_OCSP1_LDAP_PORT CLONE_OCSP1_SECURE_CONN CLONE_OCSP1_REMOVE_DATA CLONE_TKS1_ADMIN_USER CLONE_TKS1_ADMIN_EMAIL CLONE_TKS1_ADMIN_DUAL_KEY CLONE_TKS1_ADMIN_KEY_SIZE CLONE_TKS1_ADMIN_KEY_TYPE CLONE_TKS1_ADMIN_SUBJECT_DN CLONE_TKS1_ADMIN_CERT_NICKNAME CLONE_TKS1_ADMIN_PASSWORD CLONE_TKS1_DS_HOSTNAME CLONE_TKS1_LDAP_PORT CLONE_TKS1_SECURE_CONN CLONE_TKS1_REMOVE_DATA ROOTCA_SUBSYSTEM_KEY_TYPE ROOTCA_SUBYSTEM_KEY_SIZE ROOTCA_SUBSYSTEM_KEY_ALGORITHM ROOTCA_SUBSYSTEM_SIGNING_ALGORITHM ROOTCA_SUBSYSTEM_TOKEN ROOTCA_SUBSYTEM_NICKNAME ROOTCA_SUBSYSTEM_SUBJECT_DN 

export ROOTCA_OCSP_SIGNING_KEY_SIZE ROOTCA_OCSP_SIGNING_KEY_ALGORITHM ROOTCA_OCSP_SIGNING_SIGNING_ALGORITHM ROOTCA_OCSP_SIGNING_TOKEN ROOTCA_OCSP_SIGNING_NICKNAME ROOTCA_OCSP_SIGNING_CERT_SUBJECT_NAME ROOTCA_AUDIT_SIGNING_KEY_TYPE ROOTCA_AUDIT_SIGNING_KEY_SIZE ROOTCA_AUDIT_SIGNING_KEY_ALGORITHM ROOTCA_AUDIT_SIGNING_SIGNING_ALGORITHM ROOTCA_AUDIT_SIGNING_TOKEN ROOTCA_AUDIT_SIGNING_NICKNAME ROOTCA_AUDIT_SIGNING_CERT_SUBJECT_NAME ROOTCA_SUBSYSTEM_NAME ROOTCA_AUDIT_SIGNING_CERT_SUBJECT_NAME ROOTCA_KEY_ALGORITHM ROOTCA_OCSP_SIGNING_CERT_SUBJECT_NAME ROOTCA_OCSP_SIGNING_ALGORITHM LDAP_BASEDN LDAP_ADMIN_PW ROOTCA_SUBSYSTEM_CERT_SUBJECT_NAME XMLSTARLET_PATH JACOCO_PATH ROOTCA_TOMCAT_INSTANCE_NAME ROOTCA_SECURE_PORT ROOTCA_UNSECURE_PORT ROOTCA_AJP_PORT ROOTCA_TOMCAT_SERVER_PORT USER GROUP ROOTCA_ADMIN_USER GROUP_AUDIT ROOTCA_TOKEN_NAME ROOTCA_TOKEN_PASSWORD ROOTCA_CLIENT_PKCS12_PASSWORD ROOTCA_ADMIN_PASSWORD ROOTCA_KEY_TYPE ROOTCA_KEY_SIZE ROOTCA_SIGNING_ALGORITHM ROOTCA_SIGNING_SIGNING_ALGORITHM ROOTCA_SIGNING_TOKEN ROOTCA_SIGNING_NICKNAME ROOTCA_SIGNING_CERT_SUBJECT_NAME ROOTCA_ADMIN_EMAIL ROOTCA_ADMIN_DUAL_KEY ROOTCA_ADMIN_KEY_SIZE ROOTCA_ADMIN_KEY_TYPE ROOTCA_ADMIN_SUBJECT_DN ROOTCA_ADMIN_CERT_NICKNAME ROOTCA_ADMIN_IMPORT_CERT CLONE_TOMCAT_INSTANCE_NAME CLONE_CA1_SECURE_PORT CLONE_CA1_UNSECURE_PORT CLONE_CA1_AJP_PORT CLONE_CA1_TOMCAT_SERVER_PORT CLONE_USER ROOTCA_ADMIN_CERT_SUBJECT_NAME

export CLONE_GROUP CLONE_GROUP_AUDIT CLONE_CA1_TOKEN_NAME CLONE_CA1_TOKEN_PASSWORD CLONE_CA1_CLIENT_PKCS12_PASSWORD CLONE_CA1_ADMIN_PASSWORD CLONE_CA1_DS_PASSWORD CLONE_CA1_LDAP_PORT REPLICATE_SCHEMA REPLICATION_SEC CLONE_CA1_ADMIN_USER CLONE_CA1_ADMIN_EMAIL CLONE_CA1_ADMIN_DUAL_KEY CLONE_CA1_ADMIN_KEY_SIZE CLONE_CA1_ADMIN_KEY_TYPE CLONE_CA1_ADMIN_SUBJECT_DN CLONE_CA1_ADMIN_CERT_NICKNAME CLONE_CA1_ADMIN_IMPORT_CERT CLONE_CA1_SUBSYSTEM_KEY_TYPE CLONE_CA1_DS_HOSTNAME CLONE_CA1_LDAP_PORT CLONE1_LDAP_ROOTDN CLONE1_LDAP_ROOTDNPWD CLONE2_LDAP_ROOTDN CLONE2_LDAP_ROOTDNPWD CLONE_CA1_SECURE_CONN CLONE_CA1_REMOVE_DATA SUBCA1_TOMCAT_INSTANCE_NAME SUBCA1_SECURE_PORT SUBCA1_UNSECURE_PORT SUBCA1_AJP_PORT SUBCA1_TOMCAT_SERVER_PORT SUBCA1_USER SUBCA1_GROUP SUBCA1_GROUP_AUDIT SUBCA1_TOKEN_NAME SUBCA1_TOKEN_PASSWORD SUBCA1_CLIENT_PKCS12_PASSWORD SUBCA1_ADMIN_PASSWORD SUBCA1_LDAP_ROOTDNPWD SUBCA1_ADMIN_USER SUBCA1_ADMIN_USER SUBCA1_ADMIN_EMAIL SUBCA1_ADMIN_DUAL_KEY SUBCA1_ADMIN_KEY_SIZE SUBCA1_ADMIN_KEY_TYPE SUBCA1_ADMIN_SUBJECT_DN SUBCA1_ADMIN_CERT_NICKNAME SUBCA1_ADMIN_IMPORT_CERT SUBCA1_SUBSYSTEM_KEY_TYPE SUBCA1_SUBYSTEM_KEY_SIZE SUBCA1_SUBSYSTEM_KEY_ALGORITHM SUBCA1_SUBSYSTEM_SIGNING_ALGORITHM SUBCA1_SUBSYSTEM_TOKEN SUBCA1_SUBSYTEM_NICKNAME SUBCA1_SUBSYSTEM_SUBJECT_DN SUBCA1_KEY_TYPE SUBCA1_KEY_SIZE SUBCA1_SIGNING_ALGORITHM SUBCA1_SIGNING_SIGNING_ALGORITHM SUBCA1_SIGNING_TOKEN SUBCA1_SIGNING_NICKNAME SUBCA1_OCSP_SIGNING_KEY_SIZE SUBCA1_OCSP_SIGNING_KEY_ALGORITHM SUBCA1_OCSP_SIGNING_SIGNING_ALGORITHM SUBCA1_OCSP_SIGNING_TOKEN SUBCA1_OCSP_SIGNING_NICKNAME SUBCA1_OCSP_SIGNING_CERT_SUBJECT_NAME SUBCA1_AUDIT_SIGNING_KEY_TYPE SUBCA1_AUDIT_SIGNING_KEY_SIZE SUBCA1_AUDIT_SIGNING_KEY_ALGORITHM SUBCA1_AUDIT_SIGNING_SIGNING_ALGORITHM SUBCA1_AUDIT_SIGNING_TOKEN SUBCA1_AUDIT_SIGNING_NICKNAME SUBCA1_AUDIT_SIGNING_CERT_SUBJECT_NAME SUBCA1_SIGNING_CERT_SUBJECT_NAME SUBCA1_SECURE_PORT SUBCA1_ADMIN_USER SUBCA1_SECURITY_DOMAIN_PASSWORD SUBCA1_DOMAIN SUBCA1_DS_HOSTNAME SUBCA1_LDAP_PORT SUBCA1_DB_SUFFIX SUBCA1_LDAP_ROOTDN SUBCA1_SECURE_CONN SUBCA1_REMOVE_DATA SUBCA1_BACKUP SUBCA1_BACKUP_PASSWORD SUBCA1_CERTDB_DIR SUBCA1_CERTDB_DIR_PASSWORD SUBCA1_CLIENT_DB_PURGE SUBCA1_RESTART_INSTANCE SUBCA1_SKIP_CONFIG SUBCA1_SKIP_INSTALL SUBCA1_ENABLE_ACCESS_LOG SUBCA1_ENABLE_JAVA_DEBUG SUBCA1_SECURITY_MANAGER  

export CLONE1_LDAP_ROOTDN IMPORT_ADMIN_CERT_NONCA ROOTCA_BACKUP ROOTCA_BACKUP_PASSWORD ROOTCA_CERTDB_DIR ROOTCA_CERTDB_DIR_PASSWORD CLIENT_DB_PURGE ROOTCA_SECURITY_DOMAIN_PASSWORD LDAP_HOSTNAME ROOTCA_LDAP_PORT LDAP_ROOTDN LDAP_ROOTDNPWD ROOTCA_DB_SUFFIX SECURE_CONN REMOVE_DATA ROOTCA_LDAP_INSTANCE_NAME RESTART_INSTANCE SKIP_CONFIG SKIP_INSTALL ENABLE_ACCESS_LOG ENABLE_JAVA_DEBUG SECURITY_MANAGER CLIENT_PKCS12_DIR


export CLONE_TKS2_LDAP_INSTANCE_NAME  CLONE_OCSP2_LDAP_INSTANCE_NAME CLONE_KRA2_LDAP_INSTANCE_NAME  CLONE_CA2_LDAP_INSTANCE_NAME CLONE_TKS2_LDAP_PORT CLONE_TKS2_SECURE_CONN CLONE_TKS2_REMOVE_DATA SUBCA2_LDAP_INSTANCE_NAME CLONE_CA2_LDAP_INSTANCE_NAME CLONE_KRA2_LDAP_INSTANCE_NAME CLONE_OCSP2_LDAP_INSTANCE_NAME CLONE_TKS2_LDAP_INSTANCE_NAME CLONE2_CA_TOMCAT_INSTANCE_NAME CLONE_CA2_SECURE_PORT CLONE_CA2_UNSECURE_PORT CLONE_CA2_AJP_PORT CLONE_CA2_TOMCAT_SERVER_PORT CLONE2_USER CLONE2_GROUP CLONE2_GROUP_AUDIT CLONE_CA2_TOKEN_NAME CLONE_CA2_TOKEN_PASSWORD CLONE_CA2_CLIENT_PKCS12_PASSWORD CLONE_CA2_ADMIN_PASSWORD CLONE2_LDAP_ROOTDNPWD CLONE_CA2_LDAP_PORT CLONE_CA2_ADMIN_USER CLONE_CA2_ADMIN_EMAIL CLONE_CA2_ADMIN_DUAL_KEY CLONE_CA2_ADMIN_KEY_SIZE CLONE_CA2_ADMIN_KEY_TYPE CLONE_CA2_ADMIN_SUBJECT_DN CLONE_CA2_ADMIN_CERT_NICKNAME CLONE_CA2_ADMIN_IMPORT_CERT CLONE_CA2_DS_HOSTNAME CLONE_CA2_SECURE_CONN CLONE_CA2_REMOVE_DATA SUBCA2_TOMCAT_INSTANCE_NAME SUBCA2_SECURE_PORT SUBCA2_UNSECURE_PORT SUBCA2_AJP_PORT SUBCA2_TOMCAT_SERVER_PORT SUBCA2_USER SUBCA2_GROUP SUBCA2_GROUP_AUDIT SUBCA2_TOKEN_NAME SUBCA2_TOKEN_PASSWORD SUBCA2_CLIENT_PKCS12_PASSWORD SUBCA2_ADMIN_PASSWORD SUBCA2_DS_PASSWORD SUBCA2_ADMIN_USER SUBCA2_ADMIN_EMAIL SUBCA2_ADMIN_DUAL_KEY SUBCA2_ADMIN_KEY_SIZE SUBCA2_ADMIN_KEY_TYPE SUBCA2_ADMIN_SUBJECT_DN SUBCA2_ADMIN_CERT_NICKNAME SUBCA2_ADMIN_IMPORT_CERT SUBCA2_SUBSYSTEM_KEY_TYPE SUBCA2_SUBYSTEM_KEY_SIZE SUBCA2_SUBSYSTEM_KEY_ALGORITHM SUBCA2_SUBSYSTEM_SIGNING_ALGORITHM SUBCA2_SUBSYSTEM_TOKEN SUBCA2_SUBSYTEM_NICKNAME SUBCA2_SUBSYSTEM_SUBJECT_DN SUBCA2_KEY_TYPE SUBCA2_KEY_SIZE SUBCA2_SIGNING_ALGORITHM SUBCA2_SIGNING_SIGNING_ALGORITHM SUBCA2_SIGNING_TOKEN SUBCA2_SIGNING_NICKNAME SUBCA2_OCSP_SIGNING_KEY_SIZE SUBCA2_OCSP_SIGNING_KEY_ALGORITHM SUBCA2_OCSP_SIGNING_SIGNING_ALGORITHM SUBCA2_OCSP_SIGNING_TOKEN SUBCA2_OCSP_SIGNING_NICKNAME SUBCA2_OCSP_SIGNING_CERT_SUBJECT_NAME SUBCA2_OCSP_SIGNING_KEY_TYPE SUBCA2_AUDIT_SIGNING_KEY_TYPE SUBCA2_AUDIT_SIGNING_KEY_SIZE SUBCA2_AUDIT_SIGNING_KEY_ALGORITHM SUBCA2_AUDIT_SIGNING_SIGNING_ALGORITHM SUBCA2_AUDIT_SIGNING_TOKEN SUBCA2_AUDIT_SIGNING_NICKNAME SUBCA2_AUDIT_SIGNING_CERT_SUBJECT_NAME  SUBCA2_SIGNING_CERT_SUBJECT_NAME  SUBCA2_SECURITY_DOMAIN_PASSWORD SUBCA2_DS_HOSTNAME SUBCA2_LDAP_PORT SUBCA2_LDAP_ROOTDN SUBCA2_LDAP_ROOTDNPWD SUBCA2_SECURE_CONN SUBCA2_REMOVE_DATA SUBCA2_DB_SUFFIX SUBCA2_BACKUP SUBCA2_BACKUP_PASSWORD SUBCA2_CERTDB_DIR_PASSWORD SUBCA2_CLIENT_DB_PURGE SUBCA2_RESTART_INSTANCE SUBCA2_SKIP_CONFIG SUBCA2_SKIP_INSTALL SUBCA2_ENABLE_ACCESS_LOG SUBCA2_ENABLE_JAVA_DEBUG SUBCA2_SECURITY_MANAGER CLONE_KRA2_ADMIN_USER CLONE_KRA2_ADMIN_EMAIL CLONE_KRA2_ADMIN_DUAL_KEY CLONE_KRA2_ADMIN_KEY_SIZE CLONE_KRA2_ADMIN_KEY_TYPE CLONE_KRA2_ADMIN_SUBJECT_DN CLONE_KRA2_ADMIN_CERT_NICKNAME CLONE_ADMIN_IMPORT_CERT CLONE_KRA2_DS_HOSTNAME CLONE_KRA2_LDAP_PORT CLONE_KRA2_SECURE_CONN CLONE_KRA2_REMOVE_DATA KRA_DB_SUFFIX OCSP_CLIENT_PKCS12_PASSWORD CLONE_OCSP2_ADMIN_USER CLONE_OCSP2_ADMIN_EMAIL CLONE_OCSP2_ADMIN_DUAL_KEY CLONE_OCSP2_ADMIN_KEY_SIZE CLONE_OCSP2_ADMIN_KEY_TYPE CLONE_OCSP2_ADMIN_SUBJECT_DN CLONE_OCSP2_ADMIN_CERT_NICKNAME CLONE_OCSP2_ADMIN_PASSWORD CLONE_OCSP2_DS_HOSTNAME CLONE_OCSP2_LDAP_PORT CLONE_OCSP2_SECURE_CONN CLONE_OCSP2_REMOVE_DATA CLIENT_PKCS12_PASSWORD CLONE_TKS2_ADMIN_USER CLONE_TKS2_ADMIN_EMAIL CLONE_TKS2_ADMIN_DUAL_KEY CLONE_TKS2_ADMIN_KEY_SIZE CLONE_TKS2_ADMIN_KEY_TYPE CLONE_TKS2_ADMIN_SUBJECT_DN CLONE_TKS2_ADMIN_CERT_NICKNAME CLONE_TKS2_ADMIN_PASSWORD CLONE_TKS2_DS_HOSTNAME

export KRA1_TOMCAT_INSTANCE_NAME KRA1_SECURE_PORT KRA1_UNSECURE_PORT KRA1_AJP_PORT KRA1_TOMCAT_SERVER_PORT KRA2_TOMCAT_INSTANCE_NAME KRA2_SECURE_PORT KRA2_UNSECURE_PORT KRA2_AJP_PORT KRA2_TOMCAT_SERVER_PORT OCSP1_TOMCAT_INSTANCE_NAME OCSP1_SECURE_PORT OCSP1_UNSECURE_PORT OCSP1_AJP_PORT OCSP1_TOMCAT_SERVER_PORT OCSP2_TOMCAT_INSTANCE_NAME OCSP2_SECURE_PORT OCSP2_UNSECURE_PORT OCSP2_AJP_PORT OCSP2_TOMCAT_SERVER_PORT TKS1_TOMCAT_INSTANCE_NAME TKS1_SECURE_PORT TKS1_UNSECURE_PORT TKS1_AJP_PORT TKS1_TOMCAT_SERVER_PORT TKS2_TOMCAT_INSTANCE_NAME TKS2_SECURE_PORT TKS2_UNSECURE_PORT TKS2_AJP_PORT TKS2_TOMCAT_SERVER_PORT


export KRA1_AUDIT_SIGNING_KEY_TYPE KRA1_AUDIT_SIGNING_KEY_SIZE KRA1_AUDIT_SIGNING_KEY_ALGORITHM KRA1_AUDIT_SIGNING_SIGNING_ALGORITHM KRA1_AUDIT_SIGNING_TOKEN KRA1_AUDIT_SIGNING_NICKNAME KRA1_AUDIT_SIGNING_SUBJECT_DN KRA1_SUBSYSTEM_KEY_TYPE KRA1_SUBYSTEM_KEY_SIZE KRA1_SUBSYSTEM_KEY_ALGORITHM KRA1_SUBSYSTEM_SIGNING_ALGORITHM KRA1_SUBSYSTEM_TOKEN KRA1_SUBSYTEM_NICKNAME KRA1_SUBSYSTEM_SUBJECT_DN KRA1_STORAGE_KEY_TYPE KRA1_STORAGE_KEY_SIZE KRA1_STORAGE_KEY_ALGORITHM KRA1_INSTANCE_ID KRA1_STORAGE_SIGNING_ALGORITHM KRA1_STORAGE_TOKEN KRA1_STORAGE_NICKNAME KRA1_STORAGE_SUBJECT_DN KRA1_TRANSPORT_KEY_TYPE KRA1_TRANSPORT_KEY_SIZE KRA1_TRANSPORT_KEY_ALGORITHM KRA1_TRANSPORT_SIGNING_ALGORITHM KRA1_TRANSPORT_TOKEN KRA1_TRANSPORT_NICKNAME KRA1_TRANSPORT_SUBJECT_DN KRA1_ADMIN_USER KRA1_ADMIN_EMAIL KRA1_ADMIN_DUAL_KEY KRA1_ADMIN_KEY_SIZE KRA1_ADMIN_KEY_TYPE KRA1_ADMIN_SUBJECT_DN KRA1_ADMIN_CERT_NICKNAME 

export KRA1_LDAP_PORT KRA1_DB_SUFFIX KRA1_LDAP_INSTANCE_NAME KRA1_CLIENT_PKCS12_PASSWORD KRA1_BACKUP_PASSWORD KRA1_ADMIN_PASSWORD KRA2_AUDIT_SIGNING_KEY_TYPE KRA2_AUDIT_SIGNING_KEY_SIZE KRA2_AUDIT_SIGNING_KEY_ALGORITHM KRA2_AUDIT_SIGNING_SIGNING_ALGORITHM KRA2_AUDIT_SIGNING_TOKEN KRA2_AUDIT_SIGNING_NICKNAME KRA2_AUDIT_SIGNING_SUBJECT_DN KRA2_SUBSYSTEM_KEY_TYPE KRA2_SUBYSTEM_KEY_SIZE KRA2_SUBSYSTEM_KEY_ALGORITHM KRA2_SUBSYSTEM_SIGNING_ALGORITHM KRA2_SUBSYSTEM_TOKEN KRA2_SUBSYTEM_NICKNAME KRA2_SUBSYSTEM_SUBJECT_DN KRA2_STORAGE_KEY_TYPE KRA2_STORAGE_KEY_SIZE KRA2_STORAGE_KEY_ALGORITHM KRA2_INSTANCE_ID KRA2_STORAGE_SIGNING_ALGORITHM KRA2_STORAGE_TOKEN KRA2_STORAGE_NICKNAME KRA2_STORAGE_SUBJECT_DN KRA2_TRANSPORT_KEY_TYPE KRA2_TRANSPORT_KEY_SIZE KRA2_TRANSPORT_KEY_ALGORITHM KRA2_TRANSPORT_SIGNING_ALGORITHM KRA2_TRANSPORT_TOKEN KRA2_TRANSPORT_NICKNAME KRA2_TRANSPORT_SUBJECT_DN KRA2_ADMIN_USER KRA2_ADMIN_EMAIL KRA2_ADMIN_DUAL_KEY KRA2_ADMIN_KEY_SIZE KRA2_ADMIN_KEY_TYPE KRA2_ADMIN_SUBJECT_DN KRA2_ADMIN_CERT_NICKNAME KRA2_LDAP_PORT KRA2_DB_SUFFIX KRA2_LDAP_INSTANCE_NAME KRA2_CLIENT_PKCS12_PASSWORD KRA2_BACKUP_PASSWORD OCSP1_SUBSYSTEM_KEY_TYPE OCSP1_SUBSYSTEM_KEY_SIZE OCSP1_SUBSYSTEM_KEY_ALGORITHM OCSP1_SUBSYSTEM_SIGNING_ALGORITHM OCSP1_SUBSYSTEM_TOKEN OCSP1_SUBSYSTEM_CERT_NICKNAME OCSP1_SUBSYSTEM_SUBJECT_DN OCSP1_AUDIT_SIGNING_KEY_TYPE OCSP1_AUDIT_SIGNING_KEY_SIZE OCSP1_AUDIT_SIGNING_KEY_ALGORITHM OCSP1_AUDIT_SIGNING_SIGNING_ALGORITHM OCSP1_AUDIT_SIGNING_TOKEN OCSP1_AUDIT_SIGNING_CERT_NICKNAME OCSP1_AUDIT_SIGNING_SUBJECT_DN OCSP1_INSTANCE_ID OCSP1_SIGNING_KEY_TYPE OCSP1_SIGNING_KEY_SIZE OCSP1_SIGNING_KEY_ALGORITHM OCSP1_SIGNING_SIGNING_ALGORITHM OCSP1_SIGNING_TOKEN OCSP1_SIGNING_CERT_NICKNAME OCSP1_SIGNING_SUBJECT_DN OCSP1_ADMIN_USER OCSP1_ADMIN_EMAIL 

export OCSP1_ADMIN_DUAL_KEY OCSP1_ADMIN_KEY_SIZE OCSP1_ADMIN_KEY_TYPE OCSP1_ADMIN_SUBJECT_DN OCSP1_ADMIN_CERT_NICKNAME  OCSP1_LDAP_PORT OCSP1_DB_SUFFIX OCSP1_LDAP_INSTANCE_NAME OCSP1_BACKUP_PASSWORD OCSP1_CLIENT_PKCS12_PASSWORD OCSP1_ADMIN_PASSWORD OCSP2_SUBSYSTEM_KEY_TYPE OCSP2_SUBSYSTEM_KEY_SIZE OCSP2_SUBSYSTEM_KEY_ALGORITHM OCSP2_SUBSYSTEM_SIGNING_ALGORITHM OCSP2_SUBSYSTEM_TOKEN OCSP2_SUBSYSTEM_CERT_NICKNAME OCSP2_SUBSYSTEM_SUBJECT_DN OCSP2_AUDIT_SIGNING_KEY_TYPE OCSP2_AUDIT_SIGNING_KEY_SIZE OCSP2_AUDIT_SIGNING_KEY_ALGORITHM OCSP2_AUDIT_SIGNING_SIGNING_ALGORITHM OCSP2_AUDIT_SIGNING_TOKEN OCSP2_AUDIT_SIGNING_CERT_NICKNAME OCSP2_AUDIT_SIGNING_SUBJECT_DN OCSP2_INSTANCE_ID OCSP2_SIGNING_KEY_TYPE OCSP2_SIGNING_KEY_SIZE OCSP2_SIGNING_KEY_ALGORITHM OCSP2_SIGNING_SIGNING_ALGORITHM OCSP2_SIGNING_TOKEN OCSP2_SIGNING_CERT_NICKNAME OCSP2_SIGNING_SUBJECT_DN OCSP2_ADMIN_USER OCSP2_ADMIN_EMAIL OCSP2_ADMIN_DUAL_KEY OCSP2_ADMIN_KEY_SIZE OCSP2_ADMIN_KEY_TYPE OCSP2_ADMIN_SUBJECT_DN OCSP2_ADMIN_CERT_NICKNAME OCSP2_LDAP_PORT OCSP2_DB_SUFFIX OCSP2_LDAP_INSTANCE_NAME OCSP2_BACKUP_PASSWORD OCSP2_CLIENT_PKCS12_PASSWORD TKS1_AUDIT_SIGNING_KEY_TYPE TKS1_AUDIT_SIGNING_KEY_SIZE TKS1_AUDIT_SIGNING_KEY_ALGORITHM TKS1_AUDIT_SIGNING_SIGNING_ALGORITHM TKS1_AUDIT_SIGNING_TOKEN TKS1_AUDIT_SIGNING_CERT_NICKNAME TKS1_AUDIT_SIGNING_SUBJECT_DN TKS1_SUBSYSTEM_KEY_TYPE TKS1_SUBSYSTEM_KEY_SIZE TKS1_SUBSYSTEM_KEY_ALGORITHM TKS1_SUBSYSTEM_SIGNING_ALGORITHM TKS1_SUBSYSTEM_TOKEN TKS1_SUBSYSTEM_CERT_NICKNAME TKS1_SUBSYSTEM_SUBJECT_DN TKS1_ADMIN_USER TKS1_ADMIN_EMAIL TKS1_ADMIN_DUAL_KEY TKS1_ADMIN_KEY_SIZE TKS1_ADMIN_KEY_TYPE TKS1_ADMIN_SUBJECT_DN TKS1_ADMIN_CERT_NICKNAME TKS1_LDAP_PORT TKS1_LDAP_INSTANCE_NAME TKS1_DB_SUFFIX TKS1_BACKUP_PASSWORD TKS1_ADMIN_PASSWORD TKS1_INSTANCE_ID TKS1_CLIENT_PKCS12_PASSWORD TKS2_AUDIT_SIGNING_KEY_TYPE TKS2_AUDIT_SIGNING_KEY_SIZE TKS2_AUDIT_SIGNING_KEY_ALGORITHM TKS2_AUDIT_SIGNING_SIGNING_ALGORITHM TKS2_AUDIT_SIGNING_TOKEN TKS2_AUDIT_SIGNING_CERT_NICKNAME TKS2_AUDIT_SIGNING_SUBJECT_DN TKS2_SUBSYSTEM_KEY_TYPE TKS2_SUBSYSTEM_KEY_SIZE TKS2_SUBSYSTEM_KEY_ALGORITHM TKS2_SUBSYSTEM_SIGNING_ALGORITHM TKS2_SUBSYSTEM_TOKEN TKS2_SUBSYSTEM_CERT_NICKNAME TKS2_SUBSYSTEM_SUBJECT_DN TKS2_ADMIN_USER TKS2_ADMIN_EMAIL TKS2_ADMIN_DUAL_KEY TKS2_ADMIN_KEY_SIZE TKS2_ADMIN_KEY_TYPE TKS2_ADMIN_SUBJECT_DN TKS2_ADMIN_CERT_NICKNAME TKS2_LDAP_PORT TKS2_LDAP_INSTANCE_NAME TKS2_DB_SUFFIX TKS2_BACKUP_PASSWORD TKS2_ADMIN_PASSWORD TKS2_INSTANCE_ID TKS2_CLIENT_PKCS12_PASSWORD


export KRA2_ADMIN_PASSWORD KRA1_ADMIN_KEY_TYPE KRA3_ADMIN_KEY_TYPE OCSP2_ADMIN_PASSWORD OCSP3_TOMCAT_INSTANCE_NAME OCSP3_SECURE_PORT OCSP3_UNSECURE_PORT OCSP3_AJP_PORT OCSP3_TOMCAT_SERVER_PORT OCSP3_SUBSYSTEM_KEY_TYPE OCSP3_SUBSYSTEM_KEY_SIZE OCSP3_SUBSYSTEM_KEY_ALGORITHM OCSP3_SUBSYSTEM_SIGNING_ALGORITHM OCSP3_SUBSYSTEM_TOKEN OCSP3_SUBSYSTEM_CERT_NICKNAME OCSP3_SUBSYSTEM_SUBJECT_DN OCSP3_AUDIT_SIGNING_KEY_TYPE OCSP3_AUDIT_SIGNING_KEY_SIZE OCSP3_AUDIT_SIGNING_KEY_ALGORITHM OCSP3_AUDIT_SIGNING_SIGNING_ALGORITHM OCSP3_AUDIT_SIGNING_TOKEN OCSP3_AUDIT_SIGNING_CERT_NICKNAME OCSP3_AUDIT_SIGNING_SUBJECT_DN OCSP3_INSTANCE_ID OCSP3_SIGNING_KEY_TYPE OCSP3_SIGNING_KEY_SIZE OCSP3_SIGNING_KEY_ALGORITHM OCSP3_SIGNING_SIGNING_ALGORITHM OCSP3_SIGNING_TOKEN OCSP3_SIGNING_CERT_NICKNAME OCSP3_SIGNING_SUBJECT_DN OCSP3_ADMIN_USER OCSP3_ADMIN_EMAIL OCSP3_ADMIN_DUAL_KEY OCSP3_ADMIN_KEY_SIZE OCSP3_ADMIN_KEY_TYPE OCSP3_ADMIN_SUBJECT_DN OCSP3_ADMIN_CERT_NICKNAME OCSP3_LDAP_PORT OCSP3_DB_SUFFIX OCSP3_LDAP_INSTANCE_NAME OCSP3_BACKUP_PASSWORD OCSP3_CLIENT_PKCS12_PASSWORD OCSP3_ADMIN_PASSWORD

export  KRA3_TOMCAT_INSTANCE_NAME KRA3_SECURE_PORT KRA3_UNSECURE_PORT KRA3_AJP_PORT KRA3_TOMCAT_SERVER_PORT KRA3_AUDIT_SIGNING_KEY_TYPE KRA3_AUDIT_SIGNING_KEY_SIZE KRA3_AUDIT_SIGNING_KEY_ALGORITHM KRA3_AUDIT_SIGNING_SIGNING_ALGORITHM KRA3_AUDIT_SIGNING_TOKEN KRA3_AUDIT_SIGNING_NICKNAME KRA3_AUDIT_SIGNING_SUBJECT_DN KRA3_SUBSYSTEM_KEY_TYPE KRA3_SUBYSTEM_KEY_SIZE KRA3_SUBSYSTEM_KEY_ALGORITHM KRA3_SUBSYSTEM_SIGNING_ALGORITHM KRA3_SUBSYSTEM_TOKEN KRA3_SUBSYTEM_NICKNAME KRA3_SUBSYSTEM_SUBJECT_DN KRA3_STORAGE_KEY_TYPE KRA3_STORAGE_KEY_SIZE KRA3_STORAGE_KEY_ALGORITHM KRA3_INSTANCE_ID KRA3_STORAGE_SIGNING_ALGORITHM KRA3_STORAGE_TOKEN KRA3_STORAGE_NICKNAME KRA3_STORAGE_SUBJECT_DN KRA3_TRANSPORT_KEY_TYPE KRA3_TRANSPORT_KEY_SIZE KRA3_TRANSPORT_KEY_ALGORITHM KRA3_TRANSPORT_SIGNING_ALGORITHM KRA3_TRANSPORT_TOKEN KRA3_TRANSPORT_NICKNAME KRA3_TRANSPORT_SUBJECT_DN KRA3_ADMIN_USER KRA3_ADMIN_EMAIL KRA3_ADMIN_DUAL_KEY KRA3_ADMIN_KEY_SIZE KRA3_ADMIN_SUBJECT_DN KRA3_ADMIN_CERT_NICKNAME KRA3_LDAP_PORT KRA3_DB_SUFFIX KRA3_LDAP_INSTANCE_NAME KRA3_CLIENT_PKCS12_PASSWORD KRA3_BACKUP_PASSWORD KRA3_ADMIN_PASSWORD

export  CLONE_KRA1_TOMCAT_INSTANCE_NAME CLONE_KRA1_SECURE_PORT CLONE_KRA1_UNSECURE_PORT CLONE_KRA1_AJP_PORT CLONE_KRA1_TOMCAT_SERVER_PORT CLONE_OCSP1_TOMCAT_INSTANCE_NAME CLONE_OCSP1_SECURE_PORT CLONE_OCSP1_UNSECURE_PORT CLONE_OCSP1_AJP_PORT CLONE_OCSP1_TOMCAT_SERVER_PORT CLONE_TKS1_TOMCAT_INSTANCE_NAME CLONE_TKS1_SECURE_PORT CLONE_TKS1_UNSECURE_PORT CLONE_TKS1_AJP_PORT CLONE_TKS1_TOMCAT_SERVER_PORT

export ROOTCA_SSL_SERVER_KEY_TYPE ROOTCA_SSL_SERVER_KEY_SIZE ROOTCA_SSL_SERVER_KEY_ALGORITHM ROOTCA_SSL_SERVER_SIGNING_ALGORITHM ROOTCA_SSL_SERVER_TOKEN ROOTCA_SSL_SERVER_NICKNAME ROOTCA_SSL_SERVER_CERT_SUBJECT_NAME SUBCA2_SSL_SERVER_KEY_TYPE SUBCA2_SSL_SERVER_KEY_SIZE SUBCA2_SSL_SERVER_KEY_ALGORITHM SUBCA2_SSL_SERVER_SIGNING_ALGORITHM SUBCA2_SSL_SERVER_TOKEN SUBCA2_SSL_SERVER_NICKNAME SUBCA2_SSL_SERVER_CERT_SUBJECT_NAME SUBCA1_SSL_SERVER_KEY_TYPE SUBCA1_SSL_SERVER_KEY_SIZE SUBCA1_SSL_SERVER_KEY_ALGORITHM SUBCA1_SSL_SERVER_SIGNING_ALGORITHM SUBCA1_SSL_SERVER_TOKEN SUBCA1_SSL_SERVER_NICKNAME SUBCA1_SSL_SERVER_CERT_SUBJECT_NAME

export KRA1_SSL_SERVER_KEY_TYPE CLIENT_DIR KRA1_SSL_SERVER_KEY_SIZE KRA1_SSL_SERVER_KEY_ALGORITHM KRA1_SSL_SERVER_SIGNING_ALGORITHM KRA1_SSL_SERVER_TOKEN KRA1_SSL_SERVER_NICKNAME KRA1_SSL_SERVER_CERT_SUBJECT_NAME KRA2_SSL_SERVER_KEY_TYPE KRA2_SSL_SERVER_KEY_SIZE KRA2_SSL_SERVER_KEY_ALGORITHM KRA2_SSL_SERVER_SIGNING_ALGORITHM KRA2_SSL_SERVER_TOKEN KRA2_SSL_SERVER_NICKNAME KRA2_SSL_SERVER_CERT_SUBJECT_NAME KRA3_SSL_SERVER_KEY_TYPE KRA3_SSL_SERVER_KEY_SIZE KRA3_SSL_SERVER_KEY_ALGORITHM KRA3_SSL_SERVER_SIGNING_ALGORITHM KRA3_SSL_SERVER_TOKEN KRA3_SSL_SERVER_NICKNAME KRA3_SSL_SERVER_CERT_SUBJECT_NAME OCSP1_SSL_SERVER_KEY_TYPE OCSP1_SSL_SERVER_KEY_SIZE OCSP1_SSL_SERVER_KEY_ALGORITHM OCSP1_SSL_SERVER_SIGNING_ALGORITHM OCSP1_SSL_SERVER_TOKEN OCSP1_SSL_SERVER_NICKNAME OCSP1_SSL_SERVER_CERT_SUBJECT_NAME OCSP2_SSL_SERVER_KEY_TYPE OCSP2_SSL_SERVER_KEY_SIZE OCSP2_SSL_SERVER_KEY_ALGORITHM OCSP2_SSL_SERVER_SIGNING_ALGORITHM OCSP2_SSL_SERVER_TOKEN OCSP2_SSL_SERVER_NICKNAME OCSP2_SSL_SERVER_CERT_SUBJECT_NAME OCSP3_SSL_SERVER_KEY_TYPE OCSP3_SSL_SERVER_KEY_SIZE OCSP3_SSL_SERVER_KEY_ALGORITHM OCSP3_SSL_SERVER_SIGNING_ALGORITHM OCSP3_SSL_SERVER_TOKEN OCSP3_SSL_SERVER_NICKNAME OCSP3_SSL_SERVER_CERT_SUBJECT_NAME TKS1_SSL_SERVER_KEY_TYPE TKS1_SSL_SERVER_KEY_SIZE TKS1_SSL_SERVER_KEY_ALGORITHM TKS1_SSL_SERVER_SIGNING_ALGORITHM TKS1_SSL_SERVER_TOKEN TKS1_SSL_SERVER_NICKNAME TKS1_SSL_SERVER_CERT_SUBJECT_NAME CLONE_CA1_SSL_SERVER_KEY_TYPE CLONE_CA1_SSL_SERVER_KEY_SIZE CLONE_CA1_SSL_SERVER_KEY_ALGORITHM CLONE_CA1_SSL_SERVER_SIGNING_ALGORITHM CLONE_CA1_SSL_SERVER_TOKEN CLONE_CA1_SSL_SERVER_NICKNAME CLONE_CA1_SSL_SERVER_CERT_SUBJECT_NAME CLONE_KRA1_SSL_SERVER_KEY_TYPE CLONE_KRA1_SSL_SERVER_KEY_SIZE CLONE_KRA1_SSL_SERVER_KEY_ALGORITHM CLONE_KRA1_SSL_SERVER_SIGNING_ALGORITHM CLONE_KRA1_SSL_SERVER_TOKEN CLONE_KRA1_SSL_SERVER_NICKNAME CLONE_KRA1_SSL_SERVER_CERT_SUBJECT_NAME CLONE_OCSP1_SSL_SERVER_KEY_TYPE CLONE_OCSP1_SSL_SERVER_KEY_SIZE CLONE_OCSP1_SSL_SERVER_KEY_ALGORITHM CLONE_OCSP1_SSL_SERVER_SIGNING_ALGORITHM CLONE_OCSP1_SSL_SERVER_TOKEN CLONE_OCSP1_SSL_SERVER_NICKNAME CLONE_OCSP1_SSL_SERVER_CERT_SUBJECT_NAME CLONE_TKS1_SSL_SERVER_KEY_TYPE CLONE_TKS1_SSL_SERVER_KEY_SIZE CLONE_TKS1_SSL_SERVER_KEY_ALGORITHM CLONE_TKS1_SSL_SERVER_SIGNING_ALGORITHM CLONE_TKS1_SSL_SERVER_TOKEN CLONE_TKS1_SSL_SERVER_NICKNAME CLONE_TKS1_SSL_SERVER_CERT_SUBJECT_NAME

export MS_ipaddr MS_username MS_password
