/*
 * Decompiled with CFR 0.152.
 */
package com.foo;

import com.foobar.Utils;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;

public class BreakIteratorProviderImpl
extends BreakIteratorProvider {
    static Locale[] avail = new Locale[]{Locale.JAPAN, new Locale("ja", "JP", "osaka"), new Locale("ja", "JP", "kyoto"), new Locale("xx", "YY")};
    static String[] dialect = new String[]{"\u3067\u3059\u3002", "\u3084\u3002", "\u3069\u3059\u3002", "-xx-YY"};

    @Override
    public Locale[] getAvailableLocales() {
        return avail;
    }

    @Override
    public BreakIterator getCharacterInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            return new FooBreakIterator(Type.CHARACTER, i);
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public BreakIterator getLineInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            return new FooBreakIterator(Type.LINE, i);
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public BreakIterator getSentenceInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            return new FooBreakIterator(Type.SENTENCE, i);
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    @Override
    public BreakIterator getWordInstance(Locale locale) {
        for (int i = 0; i < avail.length; ++i) {
            if (!Utils.supportsLocale(avail[i], locale)) continue;
            return new FooBreakIterator(Type.WORD, i);
        }
        throw new IllegalArgumentException("locale is not supported: " + locale);
    }

    class FooBreakIterator
    extends BreakIterator {
        public FooBreakIterator(Type type, int n) {
        }

        @Override
        public int current() {
            return 0;
        }

        @Override
        public int first() {
            return 0;
        }

        @Override
        public int following(int n) {
            return 0;
        }

        @Override
        public CharacterIterator getText() {
            return null;
        }

        @Override
        public boolean isBoundary(int n) {
            return true;
        }

        @Override
        public int last() {
            return 0;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public int next(int n) {
            return 0;
        }

        @Override
        public int preceding(int n) {
            return 0;
        }

        @Override
        public int previous() {
            return 0;
        }

        @Override
        public void setText(CharacterIterator characterIterator) {
        }
    }

    static enum Type {
        CHARACTER,
        LINE,
        SENTENCE,
        WORD;

    }
}

