; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x i1> @insertelt_nxv1i1(<vscale x 1 x i1> %x, i1 %elt) {
; CHECK-LABEL: insertelt_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    vsetivli zero, 3, e8, mf8, tu, mu
; CHECK-NEXT:    vslideup.vi v26, v25, 2
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 1 x i1> %x, i1 %elt, i64 2
  ret <vscale x 1 x i1> %y
}

define <vscale x 1 x i1> @insertelt_idx_nxv1i1(<vscale x 1 x i1> %x, i1 %elt, i64 %idx) {
; CHECK-LABEL: insertelt_idx_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    addi a0, a1, 1
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, mu
; CHECK-NEXT:    vslideup.vx v26, v25, a1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 1 x i1> %x, i1 %elt, i64 %idx
  ret <vscale x 1 x i1> %y
}

define <vscale x 2 x i1> @insertelt_nxv2i1(<vscale x 2 x i1> %x, i1 %elt) {
; CHECK-LABEL: insertelt_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    vsetivli zero, 3, e8, mf4, tu, mu
; CHECK-NEXT:    vslideup.vi v26, v25, 2
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 2 x i1> %x, i1 %elt, i64 2
  ret <vscale x 2 x i1> %y
}

define <vscale x 2 x i1> @insertelt_idx_nxv2i1(<vscale x 2 x i1> %x, i1 %elt, i64 %idx) {
; CHECK-LABEL: insertelt_idx_nxv2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    addi a0, a1, 1
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, mu
; CHECK-NEXT:    vslideup.vx v26, v25, a1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 2 x i1> %x, i1 %elt, i64 %idx
  ret <vscale x 2 x i1> %y
}

define <vscale x 4 x i1> @insertelt_nxv4i1(<vscale x 4 x i1> %x, i1 %elt) {
; CHECK-LABEL: insertelt_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    vsetivli zero, 3, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vi v26, v25, 2
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 4 x i1> %x, i1 %elt, i64 2
  ret <vscale x 4 x i1> %y
}

define <vscale x 4 x i1> @insertelt_idx_nxv4i1(<vscale x 4 x i1> %x, i1 %elt, i64 %idx) {
; CHECK-LABEL: insertelt_idx_nxv4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    addi a0, a1, 1
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, mu
; CHECK-NEXT:    vslideup.vx v26, v25, a1
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 4 x i1> %x, i1 %elt, i64 %idx
  ret <vscale x 4 x i1> %y
}

define <vscale x 8 x i1> @insertelt_nxv8i1(<vscale x 8 x i1> %x, i1 %elt) {
; CHECK-LABEL: insertelt_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    vsetivli zero, 3, e8, m1, tu, mu
; CHECK-NEXT:    vslideup.vi v26, v25, 2
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 8 x i1> %x, i1 %elt, i64 2
  ret <vscale x 8 x i1> %y
}

define <vscale x 8 x i1> @insertelt_idx_nxv8i1(<vscale x 8 x i1> %x, i1 %elt, i64 %idx) {
; CHECK-LABEL: insertelt_idx_nxv8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmv.s.x v25, a0
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vmerge.vim v26, v26, 1, v0
; CHECK-NEXT:    addi a0, a1, 1
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, mu
; CHECK-NEXT:    vslideup.vx v26, v25, a1
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vand.vi v25, v26, 1
; CHECK-NEXT:    vmsne.vi v0, v25, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 8 x i1> %x, i1 %elt, i64 %idx
  ret <vscale x 8 x i1> %y
}

define <vscale x 16 x i1> @insertelt_nxv16i1(<vscale x 16 x i1> %x, i1 %elt) {
; CHECK-LABEL: insertelt_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, mu
; CHECK-NEXT:    vmv.s.x v26, a0
; CHECK-NEXT:    vmv.v.i v28, 0
; CHECK-NEXT:    vmerge.vim v28, v28, 1, v0
; CHECK-NEXT:    vsetivli zero, 3, e8, m2, tu, mu
; CHECK-NEXT:    vslideup.vi v28, v26, 2
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, mu
; CHECK-NEXT:    vand.vi v26, v28, 1
; CHECK-NEXT:    vmsne.vi v0, v26, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 16 x i1> %x, i1 %elt, i64 2
  ret <vscale x 16 x i1> %y
}

define <vscale x 16 x i1> @insertelt_idx_nxv16i1(<vscale x 16 x i1> %x, i1 %elt, i64 %idx) {
; CHECK-LABEL: insertelt_idx_nxv16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m2, ta, mu
; CHECK-NEXT:    vmv.s.x v26, a0
; CHECK-NEXT:    vmv.v.i v28, 0
; CHECK-NEXT:    vmerge.vim v28, v28, 1, v0
; CHECK-NEXT:    addi a0, a1, 1
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, mu
; CHECK-NEXT:    vslideup.vx v28, v26, a1
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, mu
; CHECK-NEXT:    vand.vi v26, v28, 1
; CHECK-NEXT:    vmsne.vi v0, v26, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 16 x i1> %x, i1 %elt, i64 %idx
  ret <vscale x 16 x i1> %y
}

define <vscale x 32 x i1> @insertelt_nxv32i1(<vscale x 32 x i1> %x, i1 %elt) {
; CHECK-LABEL: insertelt_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, mu
; CHECK-NEXT:    vmv.s.x v28, a0
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    vsetivli zero, 3, e8, m4, tu, mu
; CHECK-NEXT:    vslideup.vi v8, v28, 2
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, mu
; CHECK-NEXT:    vand.vi v28, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v28, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 32 x i1> %x, i1 %elt, i64 2
  ret <vscale x 32 x i1> %y
}

define <vscale x 32 x i1> @insertelt_idx_nxv32i1(<vscale x 32 x i1> %x, i1 %elt, i64 %idx) {
; CHECK-LABEL: insertelt_idx_nxv32i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m4, ta, mu
; CHECK-NEXT:    vmv.s.x v28, a0
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    addi a0, a1, 1
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, mu
; CHECK-NEXT:    vslideup.vx v8, v28, a1
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, mu
; CHECK-NEXT:    vand.vi v28, v8, 1
; CHECK-NEXT:    vmsne.vi v0, v28, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 32 x i1> %x, i1 %elt, i64 %idx
  ret <vscale x 32 x i1> %y
}

define <vscale x 64 x i1> @insertelt_nxv64i1(<vscale x 64 x i1> %x, i1 %elt) {
; CHECK-LABEL: insertelt_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, mu
; CHECK-NEXT:    vmv.s.x v8, a0
; CHECK-NEXT:    vmv.v.i v16, 0
; CHECK-NEXT:    vmerge.vim v16, v16, 1, v0
; CHECK-NEXT:    vsetivli zero, 3, e8, m8, tu, mu
; CHECK-NEXT:    vslideup.vi v16, v8, 2
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, mu
; CHECK-NEXT:    vand.vi v8, v16, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 64 x i1> %x, i1 %elt, i64 2
  ret <vscale x 64 x i1> %y
}

define <vscale x 64 x i1> @insertelt_idx_nxv64i1(<vscale x 64 x i1> %x, i1 %elt, i64 %idx) {
; CHECK-LABEL: insertelt_idx_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a2, zero, e8, m8, ta, mu
; CHECK-NEXT:    vmv.s.x v8, a0
; CHECK-NEXT:    vmv.v.i v16, 0
; CHECK-NEXT:    vmerge.vim v16, v16, 1, v0
; CHECK-NEXT:    addi a0, a1, 1
; CHECK-NEXT:    vsetvli zero, a0, e8, m8, tu, mu
; CHECK-NEXT:    vslideup.vx v16, v8, a1
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, mu
; CHECK-NEXT:    vand.vi v8, v16, 1
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    ret
  %y = insertelement <vscale x 64 x i1> %x, i1 %elt, i64 %idx
  ret <vscale x 64 x i1> %y
}
