import { MetricReader } from './MetricReader';
import { AggregationTemporality } from './AggregationTemporality';
import { InstrumentType } from '../InstrumentDescriptor';
import { PushMetricExporter } from './MetricExporter';
export declare type PeriodicExportingMetricReaderOptions = {
    exporter: PushMetricExporter;
    exportIntervalMillis?: number;
    exportTimeoutMillis?: number;
};
/**
 * {@link MetricReader} which collects metrics based on a user-configurable time interval, and passes the metrics to
 * the configured {@link MetricExporter}
 */
export declare class PeriodicExportingMetricReader extends MetricReader {
    private _interval?;
    private _exporter;
    private readonly _exportInterval;
    private readonly _exportTimeout;
    constructor(options: PeriodicExportingMetricReaderOptions);
    private _runOnce;
    protected onInitialized(): void;
    protected onForceFlush(): Promise<void>;
    protected onShutdown(): Promise<void>;
    selectAggregationTemporality(instrumentType: InstrumentType): AggregationTemporality;
}
//# sourceMappingURL=PeriodicExportingMetricReader.d.ts.map