"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tests_1 = require("@grafana/agent-core/src/utils/tests");
var initialize_1 = require("../../initialize");
var registerOnerror_1 = require("./registerOnerror");
describe('registerOnerror', function () {
    it('will preserve the old callback', function () {
        var called = false;
        window.onerror = function () {
            called = true;
        };
        var transport = new tests_1.MockTransport();
        var config = (0, tests_1.mockConfig)({
            transports: [transport],
        });
        var agent = (0, initialize_1.initializeAgent)(config);
        (0, registerOnerror_1.registerOnerror)(agent);
        window.onerror('boo', 'some file', 10, 10, new Error('boo'));
        expect(called).toBe(true);
        expect(transport.items).toHaveLength(1);
    });
});
//# sourceMappingURL=registerOnerror.test.js.map