/**
 * Represents an ANSI-escaped string.
 */
export default class Colors {
    spans: any[];
    static names: (string | number)[];
    static rgb: {
        black: number[];
        darkGray: number[];
        lightGray: number[];
        white: number[];
        red: number[];
        lightRed: number[];
        green: number[];
        lightGreen: number[];
        yellow: number[];
        lightYellow: number[];
        blue: number[];
        lightBlue: number[];
        magenta: number[];
        lightMagenta: number[];
        cyan: number[];
        lightCyan: number[];
    };
    /**
     * @param {string} s a string containing ANSI escape codes.
     */
    constructor(s?: string);
    get str(): any;
    get parsed(): Colors & {
        spans: any[];
    };
    get asChromeConsoleLogArguments(): any[];
    get browserConsoleArguments(): any[];
    /**
     * @description installs String prototype extensions
     * @example
     * require ('ansicolor').nice
     * console.log ('foo'.bright.red)
     */
    static get nice(): typeof Colors;
    /**
     * @description parses a string containing ANSI escape codes
     * @returns {Colors} parsed representation.
     */
    static parse(s: string): Colors & {
        spans: any[];
    };
    /**
     * @description strips ANSI codes from a string
     * @param {string} s a string containing ANSI escape codes.
     * @returns {string} clean string.
     */
    static strip(s: string): string;
    /**
     * @example
     * const spans = [...ansi.parse ('\u001b[7m\u001b[7mfoo\u001b[7mbar\u001b[27m')]
     */
    [Symbol.iterator](): IterableIterator<any>;
}
