/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.profile;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authorization.EAuthzException;
import com.netscape.certsrv.base.BadRequestDataException;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.ca.CANotFoundException;
import com.netscape.certsrv.cert.CertEnrollmentRequest;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.template.ArgList;
import com.netscape.certsrv.template.ArgSet;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileOutput;
import com.netscape.cms.servlet.cert.CertEnrollmentRequestFactory;
import com.netscape.cms.servlet.cert.EnrollmentProcessor;
import com.netscape.cms.servlet.cert.RenewalProcessor;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.ProfileServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@WebServlet(name="caProfileSubmit", urlPatterns={"/ee/ca/profileSubmit"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authorityId", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="ID", value="caProfileSubmit"), @WebInitParam(name="templatePath", value="/ee/ca/ProfileSubmit.template"), @WebInitParam(name="resourceID", value="certServer.ee.profile")})
public class ProfileSubmitServlet
extends ProfileServlet {
    public static Logger logger = LoggerFactory.getLogger(ProfileSubmitServlet.class);
    private static final long serialVersionUID = 7557922703180866442L;
    private static final String SUCCESS = "0";
    private static final String FAILED = "1";

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest request = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        boolean xmlOutput = this.getXMLOutput(request);
        Locale locale = this.getLocale(request);
        HashMap<String, Object> results = null;
        String renewal = request.getParameter("renewal");
        try {
            if (renewal != null && renewal.equalsIgnoreCase("true")) {
                logger.debug("ProfileSubmitServlet: isRenewal true");
                results = this.processRenewal(cmsReq);
            } else {
                logger.debug("ProfileSubmitServlet: isRenewal false");
                results = this.processEnrollment(cmsReq);
            }
        }
        catch (BadRequestDataException e) {
            logger.error("ProfileSubmitServlet: bad data provided in processing request: " + e.getMessage(), (Throwable)e);
            this.errorExit(response, xmlOutput, e.getMessage(), null);
            return;
        }
        catch (EAuthzException e) {
            logger.error("ProfileSubmitServlet: authorization error in processing request: " + e.getMessage(), (Throwable)e);
            this.errorExit(response, xmlOutput, e.getMessage(), null);
            return;
        }
        catch (EAuthException e) {
            logger.error("ProfileSubmitServlet: authentication error in processing request: " + e.getMessage(), (Throwable)e);
            this.errorExit(response, xmlOutput, e.getMessage(), null);
            return;
        }
        catch (Exception e) {
            logger.error("ProfileSubmitServlet: error in processing request: " + e.getMessage(), (Throwable)e);
            this.errorExit(response, xmlOutput, e.getMessage(), null);
            return;
        }
        Request[] reqs = (Request[])results.get("requests");
        String errorCode = (String)results.get("errorCode");
        String errorReason = (String)results.get("errorReason");
        Profile profile = (Profile)results.get("profile");
        ArgSet args = new ArgSet();
        if (errorCode != null) {
            if (xmlOutput) {
                Object requestIds = "";
                for (Request req : reqs) {
                    requestIds = (String)requestIds + "  " + req.getRequestId().toString();
                }
                this.outputError(response, errorCode, errorReason, (String)requestIds);
            } else {
                ArgList requestlist = new ArgList();
                for (Request req : reqs) {
                    ArgSet requestset = new ArgSet();
                    requestset.set("requestId", req.getRequestId().toString());
                    requestlist.add(requestset);
                }
                args.set("requestList", requestlist);
                args.set("errorCode", errorCode);
                args.set("errorReason", errorReason);
                this.outputTemplate(request, response, args);
            }
            return;
        }
        if (xmlOutput) {
            this.xmlOutput(response, profile, locale, reqs);
        } else {
            ArgList outputlist = new ArgList();
            for (int k = 0; k < reqs.length; ++k) {
                this.setOutputIntoArgs(profile, outputlist, locale, reqs[k]);
                args.set("outputList", outputlist);
            }
            logger.debug("ProfileSubmitServlet: done serving");
            ArgList requestlist = new ArgList();
            for (int k = 0; k < reqs.length; ++k) {
                ArgSet requestset = new ArgSet();
                requestset.set("requestId", reqs[k].getRequestId().toString());
                requestlist.add(requestset);
            }
            args.set("requestList", requestlist);
            args.set("errorCode", SUCCESS);
            args.set("errorReason", "");
            try {
                String p12Str = reqs[0].getExtDataInString("req_issued_p12");
                if (p12Str == null) {
                    this.outputTemplate(request, response, args);
                } else {
                    byte[] p12blob = null;
                    HttpServletResponse p12_response = cmsReq.getHttpResp();
                    p12blob = Utils.base64decode((String)p12Str);
                    ServletOutputStream bos = p12_response.getOutputStream();
                    p12_response.setContentType("application/x-pkcs12");
                    p12_response.setContentLength(p12blob.length);
                    p12_response.setHeader("Content-disposition", "attachment; filename=serverKeyGenCert.p12");
                    bos.write(p12blob);
                    bos.flush();
                    bos.close();
                }
            }
            catch (IOException e) {
                logger.debug(e.getMessage());
                this.setError(args, e.getMessage(), request, response);
                return;
            }
        }
    }

    private void setError(ArgSet args, String reason, HttpServletRequest request, HttpServletResponse response) throws EBaseException {
        args.set("errorCode", FAILED);
        args.set("errorReason", reason);
        this.outputTemplate(request, response, args);
    }

    public HashMap<String, Object> processEnrollment(CMSRequest cmsReq) throws Exception {
        HttpServletRequest request = cmsReq.getHttpReq();
        Locale locale = this.getLocale(request);
        CAEngine engine = CAEngine.getInstance();
        EnrollmentProcessor processor = new EnrollmentProcessor("caProfileSubmit", locale);
        processor.setCMSEngine(engine);
        processor.init();
        String profileId = processor.getProfileID() == null ? request.getParameter("profileId") : processor.getProfileID();
        logger.debug("ProfileSubmitServlet: profile: " + profileId);
        ProfileSubsystem ps = processor.getProfileSubsystem();
        Profile profile = ps.getProfile(profileId);
        if (profile == null) {
            logger.error("ProfileSubmitServlet: Profile " + profileId + " not found");
            throw new BadRequestDataException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
        }
        String aidString = request.getParameter("authorityId");
        AuthorityID aid = null;
        if (aidString != null && !aidString.isEmpty()) {
            try {
                aid = new AuthorityID(aidString);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestDataException("invalid AuthorityID: " + aidString, (Exception)e);
            }
            CertificateAuthority ca = engine.getCA(aid);
            if (ca == null) {
                throw new CANotFoundException("CA not found: " + aidString);
            }
        }
        CertEnrollmentRequest data = CertEnrollmentRequestFactory.create(cmsReq, profile, locale);
        return processor.processEnrollment(data, request, aid, null);
    }

    public HashMap<String, Object> processRenewal(CMSRequest cmsReq) throws Exception {
        HttpServletRequest request = cmsReq.getHttpReq();
        Locale locale = this.getLocale(request);
        CAEngine engine = (CAEngine)this.getCMSEngine();
        RenewalProcessor processor = new RenewalProcessor("caProfileSubmit", locale);
        processor.setCMSEngine(engine);
        processor.init();
        String profileId = processor.getProfileID() == null ? request.getParameter("profileId") : processor.getProfileID();
        logger.debug("ProfileSubmitServlet: profile: " + profileId);
        ProfileSubsystem ps = processor.getProfileSubsystem();
        Profile profile = ps.getProfile(profileId);
        if (profile == null) {
            logger.error("ProfileSubmitServlet: Profile " + profileId + " not found");
            throw new BadRequestDataException(CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
        }
        CertEnrollmentRequest data = CertEnrollmentRequestFactory.create(cmsReq, profile, locale);
        String serialNumber = request.getParameter("serial_num");
        if (serialNumber != null) {
            data.setSerialNum(new CertId(serialNumber));
        }
        return processor.processRenewal(data, request, null);
    }

    private void setOutputIntoArgs(Profile profile, ArgList outputlist, Locale locale, Request req) {
        Enumeration<String> outputIds = profile.getProfileOutputIds();
        if (outputIds != null) {
            while (outputIds.hasMoreElements()) {
                String outputId = outputIds.nextElement();
                ProfileOutput profileOutput = profile.getProfileOutput(outputId);
                Enumeration<String> outputNames = profileOutput.getValueNames();
                if (outputNames == null) continue;
                while (outputNames.hasMoreElements()) {
                    ArgSet outputset = new ArgSet();
                    String outputName = outputNames.nextElement();
                    IDescriptor outputDesc = profileOutput.getValueDescriptor(locale, outputName);
                    if (outputDesc == null) continue;
                    String outputSyntax = outputDesc.getSyntax();
                    String outputConstraint = outputDesc.getConstraint();
                    String outputValueName = outputDesc.getDescription(locale);
                    String outputValue = null;
                    try {
                        outputValue = profileOutput.getValue(outputName, locale, req);
                    }
                    catch (EProfileException e) {
                        logger.warn("ProfileSubmitServlet: " + e.getMessage(), (Throwable)e);
                    }
                    outputset.set("outputId", outputName);
                    outputset.set("outputSyntax", outputSyntax);
                    outputset.set("outputConstraint", outputConstraint);
                    outputset.set("outputName", outputValueName);
                    outputset.set("outputVal", outputValue);
                    outputlist.add(outputset);
                }
            }
        }
    }

    private void errorExit(HttpServletResponse response, boolean xmlOutput, String message, String requestId) throws EBaseException {
        if (xmlOutput) {
            this.outputError(response, FAILED, message, requestId);
        } else {
            ArgSet args = new ArgSet();
            args.set("errorCode", FAILED);
            args.set("errorReason", message);
            this.outputTemplate(xmlOutput, response, args);
        }
        for (String event : this.statEvents) {
            this.endTiming(event);
        }
    }

    private boolean getXMLOutput(HttpServletRequest request) {
        boolean xmlOutput = false;
        String v = request.getParameter("xml");
        if (v != null && v.equalsIgnoreCase("true")) {
            xmlOutput = true;
        }
        if ((v = request.getParameter("xmlOutput")) != null && v.equalsIgnoreCase("true")) {
            xmlOutput = true;
        }
        if (xmlOutput) {
            logger.debug("xmlOutput true");
        } else {
            logger.debug("xmlOutput false");
        }
        return xmlOutput;
    }

    private void xmlOutput(HttpServletResponse httpResp, Profile profile, Locale locale, Request[] reqs) {
        try {
            XMLObject xmlObj = null;
            xmlObj = new XMLObject();
            Node root = xmlObj.createRoot("XMLResponse");
            xmlObj.addItemToContainer(root, "Status", SUCCESS);
            Node n = xmlObj.createContainer(root, "Requests");
            logger.debug("ProfileSubmitServlet xmlOutput: req len = " + reqs.length);
            for (int i = 0; i < reqs.length; ++i) {
                Node subnode = xmlObj.createContainer(n, "Request");
                xmlObj.addItemToContainer(subnode, "Id", reqs[i].getRequestId().toString());
                X509CertInfo certInfo = reqs[i].getExtDataInCertInfo("req_x509info");
                if (certInfo != null) {
                    String subject = "";
                    subject = certInfo.get("subject").toString();
                    xmlObj.addItemToContainer(subnode, "SubjectDN", subject);
                } else {
                    logger.warn("ProfileSubmitServlet xmlOutput: no certInfo found in request");
                }
                Enumeration<String> outputIds = profile.getProfileOutputIds();
                if (outputIds == null) continue;
                while (outputIds.hasMoreElements()) {
                    String outputId = outputIds.nextElement();
                    ProfileOutput profileOutput = profile.getProfileOutput(outputId);
                    Enumeration<String> outputNames = profileOutput.getValueNames();
                    if (outputNames == null) continue;
                    while (outputNames.hasMoreElements()) {
                        String outputName = outputNames.nextElement();
                        if (!outputName.equals("b64_cert") && !outputName.equals("der") && !outputName.equals("pkcs7")) continue;
                        try {
                            String ss;
                            String outputValue = profileOutput.getValue(outputName, locale, reqs[i]);
                            if (outputName.equals("b64_cert") || outputName.equals("der")) {
                                ss = Cert.normalizeCertStrAndReq((String)outputValue);
                                outputValue = Cert.stripBrackets((String)ss);
                                byte[] bcode = Utils.base64decode((String)outputValue);
                                X509CertImpl impl = new X509CertImpl(bcode);
                                xmlObj.addItemToContainer(subnode, "serialno", impl.getSerialNumber().toString(16));
                                xmlObj.addItemToContainer(subnode, "b64", outputValue);
                                continue;
                            }
                            if (!outputName.equals("pkcs7")) continue;
                            ss = Cert.normalizeCertStrAndReq((String)outputValue);
                            xmlObj.addItemToContainer(subnode, "pkcs7", ss);
                        }
                        catch (EProfileException e) {
                            logger.warn("ProfileSubmitServlet xmlOutput: " + e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.warn("ProfileSubmitServlet xmlOutput: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            byte[] cb = xmlObj.toByteArray();
            this.outputResult(httpResp, "application/xml", cb);
        }
        catch (Exception e) {
            logger.warn("Failed to send the XML output");
        }
    }
}

