/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.publish.mappers;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.ELdapServerDownException;
import com.netscape.certsrv.publish.Mapper;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.AVA;
import org.mozilla.jss.netscape.security.x509.RDN;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X500NameAttrMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LdapDNCompsMap
extends Mapper
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(LdapDNCompsMap.class);
    protected String mBaseDN = null;
    protected ObjectIdentifier[] mDnComps = null;
    protected ObjectIdentifier[] mFilterComps = null;
    private boolean mInited = false;
    protected ConfigStore mConfig;

    public LdapDNCompsMap(String ldapAttr, String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        this.init(baseDN, dnComps, filterComps);
    }

    public LdapDNCompsMap() {
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void init(ConfigStore config) throws EBaseException {
        this.mConfig = config;
        String baseDN = this.mConfig.getString("baseDN");
        ObjectIdentifier[] dnComps = LdapDNCompsMap.getCompsFromString(this.mConfig.getString("dnComps"));
        ObjectIdentifier[] filterComps = LdapDNCompsMap.getCompsFromString(this.mConfig.getString("filterComps"));
        this.init(baseDN, dnComps, filterComps);
    }

    public String getImplName() {
        return "LdapDNCompsMap";
    }

    public String getDescription() {
        return "LdapDNCompsMap";
    }

    public String[] getExtendedPluginInfo() {
        String[] s = new String[]{"baseDN;string;Base to search from. E.g ou=Engineering,o=Fedora", "dnComps;string;Comma-separated list of attributes to put in the DN", "filterComps;string;Comma-separated list of attributes to form the filter", "HELP_TOKEN;configuration-ldappublish-mapper-dncompsmapper", "HELP_TEXT;More complex mapper. Used when there is not enough information in the cert request to form the complete LDAP DN. Using this plugin, you can specify additional LDAP filters to narrow down the search"};
        return s;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        v.addElement("baseDN=");
        v.addElement("dnComps=");
        v.addElement("filterComps=");
        return v;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        try {
            if (this.mBaseDN == null) {
                v.addElement("baseDN=");
            } else {
                v.addElement("baseDN=" + this.mConfig.getString("baseDN"));
            }
            if (this.mDnComps == null) {
                v.addElement("dnComps=");
            } else {
                v.addElement("dnComps=" + this.mConfig.getString("dnComps"));
            }
            if (this.mFilterComps == null) {
                v.addElement("filterComps=");
            } else {
                v.addElement("filterComps=" + this.mConfig.getString("filterComps"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    protected void init(String baseDN, ObjectIdentifier[] dnComps, ObjectIdentifier[] filterComps) {
        int i;
        if (this.mInited) {
            return;
        }
        this.mBaseDN = baseDN;
        if (dnComps != null) {
            this.mDnComps = (ObjectIdentifier[])dnComps.clone();
        }
        if (filterComps != null) {
            this.mFilterComps = (ObjectIdentifier[])filterComps.clone();
        }
        for (i = 0; i < this.mDnComps.length; ++i) {
            logger.debug("LdapDNCompsMap: dnComp " + X500NameAttrMap.getDefault().getName(this.mDnComps[i]));
        }
        for (i = 0; i < this.mFilterComps.length; ++i) {
            logger.debug("LdapDNCompsMap: filterComp " + X500NameAttrMap.getDefault().getName(this.mFilterComps[i]));
        }
        this.mInited = true;
    }

    public String map(LDAPConnection conn, X500Name x500name, byte[] obj) throws ELdapException {
        try {
            if (conn == null) {
                return null;
            }
            logger.debug("LdapDNCompsMap: " + x500name.toString());
            String[] dnAndFilter = this.formDNandFilter(x500name);
            String dn = dnAndFilter[0];
            String filter = dnAndFilter[1];
            if (dn == null) {
                if (this.mBaseDN == null) {
                    logger.error(CMS.getLogMessage((String)"PUBLISH_NO_BASE", (Object[])new Object[0]));
                    throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_DN_COMPS_AND_BASEDN", (String[])new String[]{x500name.toString()}));
                }
                dn = this.mBaseDN;
            }
            int scope = 2;
            if (filter == null) {
                scope = 0;
                filter = "(objectclass=*)";
            }
            String[] attrs = new String[]{"1.1"};
            logger.info("LdapDNCompsMap: searching for " + dn + " " + filter + " " + (scope == 2 ? "sub" : "base"));
            LDAPSearchResults results = conn.search(dn, scope, filter, attrs, false);
            LDAPEntry entry = results.next();
            if (results.hasMoreElements()) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_MORE_THAN_ONE_ENTRY", (Object[])new Object[]{"", x500name.toString()}));
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_MORE_THAN_ONE_ENTRY", (String[])new String[]{x500name.toString()}));
            }
            if (entry == null) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_ENTRY_NOT_FOUND", (Object[])new Object[]{"", x500name.toString()}));
                throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{"null entry"}));
            }
            return entry.getDN();
        }
        catch (LDAPException e) {
            if (e.getLDAPResultCode() == 52) {
                logger.error(CMS.getLogMessage((String)"PUBLISH_NO_LDAP_SERVER", (Object[])new Object[0]), (Throwable)e);
                throw new ELdapServerDownException(CMS.getUserMessage((String)"CMS_LDAP_SERVER_UNAVAILABLE", (String[])new String[]{conn.getHost(), "" + conn.getPort()}), (Throwable)e);
            }
            logger.error(CMS.getLogMessage((String)"PUBLISH_DN_MAP_EXCEPTION", (Object[])new Object[]{"LDAPException", e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_NO_MATCH_FOUND", (String[])new String[]{e.toString()}), (Throwable)e);
        }
    }

    public String[] formDNandFilter(X500Name subjName) throws ELdapException {
        Vector<RDN> dnRdns = new Vector<RDN>();
        SearchFilter filter = new SearchFilter();
        X500NameAttrMap attrMap = X500NameAttrMap.getDefault();
        String dnStr = null;
        String filterStr = null;
        ObjectIdentifier EOid = attrMap.getOid("E");
        ObjectIdentifier mailOid = attrMap.getOid("MAIL");
        try {
            Enumeration n = subjName.getRDNs();
            while (n.hasMoreElements()) {
                AVA newAVA;
                DerValue val;
                int i;
                RDN rdn = (RDN)n.nextElement();
                AVA ava = rdn.getAssertion()[0];
                ObjectIdentifier oid = ava.getOid();
                for (i = 0; i < this.mDnComps.length; ++i) {
                    if (!this.mDnComps[i].equals(oid)) continue;
                    if (oid == EOid) {
                        val = ava.getValue();
                        newAVA = new AVA(mailOid, val);
                        RDN newRDN = new RDN(new AVA[]{newAVA});
                        logger.debug("LdapDNCompsMap: Converted " + rdn.toLdapDNString() + " to " + newRDN.toLdapDNString() + " in DN");
                        rdn = newRDN;
                    }
                    dnRdns.addElement(rdn);
                    logger.debug("LdapDNCompsMap: adding dn comp " + rdn.toLdapDNString());
                    break;
                }
                for (i = 0; i < this.mFilterComps.length; ++i) {
                    if (!this.mFilterComps[i].equals(oid)) continue;
                    if (oid == EOid) {
                        val = ava.getValue();
                        newAVA = new AVA(mailOid, val);
                        logger.debug("LdapDNCompsMap: Converted " + ava.toLdapDNString() + " to " + newAVA.toLdapDNString() + " in filter");
                        ava = newAVA;
                    }
                    filter.addElement(ava.toLdapDNString());
                    logger.debug("LdapDNCompsMap: adding filter comp " + ava.toLdapDNString());
                    break;
                }
                if (dnRdns.size() != 0) {
                    dnStr = new X500Name(dnRdns).toLdapDNString();
                }
                if (filter.size() == 0) continue;
                filterStr = filter.toFilterString();
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"PUBLISH_FROM_SUBJ_TO_DN", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_FORM_DN_COMPS_FAILED", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        return new String[]{dnStr, filterStr};
    }

    public ObjectIdentifier[] getDnComps() {
        return (ObjectIdentifier[])this.mDnComps.clone();
    }

    public ObjectIdentifier[] getFilterComps() {
        return (ObjectIdentifier[])this.mFilterComps.clone();
    }

    public static ObjectIdentifier[] getCompsFromString(String val) throws ELdapException {
        if (val == null || val.length() == 0) {
            return new ObjectIdentifier[0];
        }
        StringTokenizer tokens = new StringTokenizer(val, ", \t\n\r");
        ObjectIdentifier[] comps = new ObjectIdentifier[tokens.countTokens()];
        if (comps.length == 0) {
            return new ObjectIdentifier[0];
        }
        int i = 0;
        while (tokens.hasMoreTokens()) {
            ObjectIdentifier oid;
            String attr = tokens.nextToken().trim();
            if (attr.equalsIgnoreCase("mail")) {
                attr = "E";
            }
            if ((oid = X500NameAttrMap.getDefault().getOid(attr)) != null) {
                comps[i++] = oid;
                continue;
            }
            throw new ELdapException(CMS.getUserMessage((String)"CMS_LDAP_UNKNOWN_ATTR_IN_DN_FILTER_COMPS", (String[])new String[]{attr}));
        }
        return comps;
    }

    public static class SearchFilter
    extends Vector<Object> {
        private static final long serialVersionUID = 4210302171279891828L;

        public String toFilterString() {
            StringBuffer buf = new StringBuffer();
            if (this.elementCount == 0) {
                return null;
            }
            if (this.elementCount == 1) {
                buf.append("(" + (String)this.elementData[0] + ")");
                return buf.toString();
            }
            buf.append("(&");
            for (int i = 0; i < this.elementCount; ++i) {
                buf.append("(" + (String)this.elementData[i] + ")");
            }
            buf.append(")");
            return buf.toString();
        }
    }
}

