/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.output;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.output.EnrollOutput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Map;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.pkcs.ContentInfo;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.pkcs.SignerInfo;
import org.mozilla.jss.netscape.security.util.CertPrettyPrint;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;

public class PKCS7Output
extends EnrollOutput {
    public static final String VAL_PRETTY_CERT = "pretty_cert";
    public static final String VAL_PKCS7 = "pkcs7";

    public PKCS7Output() {
        this.addValueName(VAL_PRETTY_CERT);
        this.addValueName(VAL_PKCS7);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_TEXT", (String[])new String[0]);
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws EProfileException {
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_PRETTY_CERT)) {
            return new Descriptor("pretty_print", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_CERT_PP", (String[])new String[0]));
        }
        if (name.equals(VAL_PKCS7)) {
            return new Descriptor("pretty_print", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OUTPUT_PKCS7_B64", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public String getValue(String name, Locale locale, Request request) throws EProfileException {
        CAEngine engine = CAEngine.getInstance();
        if (name.equals(VAL_PRETTY_CERT)) {
            X509CertImpl cert = request.getExtDataInCert("req_issued_cert");
            if (cert == null) {
                return null;
            }
            CertPrettyPrint prettyCert = new CertPrettyPrint((Certificate)cert);
            return prettyCert.toString(locale);
        }
        if (name.equals(VAL_PKCS7)) {
            try {
                X509CertImpl cert = request.getExtDataInCert("req_issued_cert");
                if (cert == null) {
                    return null;
                }
                CertificateAuthority ca = engine.getCA();
                CertificateChain cachain = ca.getCACertChain();
                X509Certificate[] cacerts = cachain.getChain();
                X509CertImpl[] userChain = new X509CertImpl[cacerts.length + 1];
                int m = 1;
                for (int n = 0; n < cacerts.length; ++n) {
                    userChain[m] = (X509CertImpl)cacerts[n];
                    ++m;
                }
                userChain[0] = cert;
                PKCS7 p7 = new PKCS7(new AlgorithmId[0], new ContentInfo(new byte[0]), (X509Certificate[])userChain, new SignerInfo[0]);
                byte[] p7Bytes = p7.getBytes();
                String p7Str = Utils.base64encode((byte[])p7Bytes, (boolean)true);
                return p7Str;
            }
            catch (Exception e) {
                return "";
            }
        }
        return null;
    }
}

