/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.JssSubsystem;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizedValidityDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(RandomizedValidityDefault.class);
    public static final String CONFIG_RANGE = "range";
    public static final String CONFIG_START_TIME = "startTime";
    public static final String CONFIG_NOT_BEFORE_RANDOM_BITS = "notBeforeRandomBits";
    public static final String CONFIG_NOT_AFTER_RANDOM_BITS = "startTimeRandomBits";
    public static final String VAL_NOT_BEFORE = "notBefore";
    public static final String VAL_NOT_AFTER = "notAfter";
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private long mDayInMS = 86400000L;
    private SecureRandom mRandom = null;

    public RandomizedValidityDefault() {
        this.addConfigName(CONFIG_RANGE);
        this.addConfigName(CONFIG_START_TIME);
        this.addConfigName(CONFIG_NOT_BEFORE_RANDOM_BITS);
        this.addConfigName(CONFIG_NOT_AFTER_RANDOM_BITS);
        this.addValueName(VAL_NOT_BEFORE);
        this.addValueName(VAL_NOT_AFTER);
        CAEngine engine = CAEngine.getInstance();
        JssSubsystem jssSubsystem = engine.getJSSSubsystem();
        this.mRandom = jssSubsystem.getRandomNumberGenerator();
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals(CONFIG_RANGE)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE}));
            }
        }
        if (name.equals(CONFIG_START_TIME)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_START_TIME}));
            }
        }
        if (name.equals(CONFIG_NOT_BEFORE_RANDOM_BITS)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NOT_BEFORE_RANDOM_BITS}));
            }
        }
        if (name.equals(CONFIG_NOT_AFTER_RANDOM_BITS)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_NOT_AFTER_RANDOM_BITS}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_RANGE)) {
            return new Descriptor("string", null, "365", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_START_TIME)) {
            return new Descriptor("string", null, "0", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_START_TIME", (String[])new String[0]));
        }
        if (name.equals(CONFIG_NOT_BEFORE_RANDOM_BITS)) {
            return new Descriptor("string", null, "10", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_BEFORE_RANDOM_BITS", (String[])new String[0]));
        }
        if (name.equals(CONFIG_NOT_AFTER_RANDOM_BITS)) {
            return new Descriptor("string", null, "10", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_AFTER_RANDOM_BITS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_NOT_BEFORE)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_BEFORE", (String[])new String[0]));
        }
        if (name.equals(VAL_NOT_AFTER)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_AFTER", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (value == null || value.equals("")) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NOT_BEFORE)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ParsePosition pos = new ParsePosition(0);
            Date date = formatter.parse(value, pos);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                validity.set(VAL_NOT_BEFORE, (Object)date);
            }
            catch (Exception e) {
                logger.error("RandomizedValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        } else if (name.equals(VAL_NOT_AFTER)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            ParsePosition pos = new ParsePosition(0);
            Date date = formatter.parse(value, pos);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                validity.set(VAL_NOT_AFTER, (Object)date);
            }
            catch (Exception e) {
                logger.error("RandomizedValidityDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NOT_BEFORE)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                return formatter.format((Date)validity.get(VAL_NOT_BEFORE));
            }
            catch (Exception e) {
                logger.warn("RandomizedValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException("Invalid valie");
            }
        }
        if (name.equals(VAL_NOT_AFTER)) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
            CertificateValidity validity = null;
            try {
                validity = (CertificateValidity)info.get("validity");
                return formatter.format((Date)validity.get(VAL_NOT_AFTER));
            }
            catch (Exception e) {
                logger.warn("RandomizedValidityDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_VALIDITY", (String[])new String[]{this.getConfig(CONFIG_RANGE)});
    }

    private int randomSecs(int numBits) {
        int maxSecs = 0;
        int secs = 0;
        if (numBits > 32) {
            numBits = 32;
            logger.debug("RandomizedValidityDefault randomSecs - number of bits limited to " + numBits);
        }
        if (numBits > 0) {
            maxSecs = (1 << numBits) - 1;
            int numBytes = (numBits + 7) / 8;
            byte[] randomBits = new byte[numBytes];
            this.mRandom.nextBytes(randomBits);
            for (int i = 0; i < numBytes; ++i) {
                secs <<= 8;
                secs |= randomBits[i] & 0xFF;
            }
            secs &= maxSecs;
        }
        logger.debug("RandomizedValidityDefault randomSecs  numBits=" + numBits + "  secs=" + secs + "  maxSecs=" + maxSecs);
        return secs;
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        String startTimeStr = this.getConfig(CONFIG_START_TIME);
        try {
            startTimeStr = this.mapPattern(request, startTimeStr);
        }
        catch (IOException e) {
            logger.warn("RandomizedValidityDefault: populate " + e.getMessage(), (Throwable)e);
        }
        if (startTimeStr == null || startTimeStr.equals("")) {
            startTimeStr = "60";
        }
        long startTime = Long.parseLong(startTimeStr);
        String notBeforeRandomBitsStr = this.getConfig(CONFIG_NOT_BEFORE_RANDOM_BITS);
        if (notBeforeRandomBitsStr == null || notBeforeRandomBitsStr.length() == 0) {
            notBeforeRandomBitsStr = "0";
        }
        int notBeforeRandomBits = Integer.parseInt(notBeforeRandomBitsStr);
        String notAfterRandomBitsStr = this.getConfig(CONFIG_NOT_AFTER_RANDOM_BITS);
        if (notAfterRandomBitsStr == null || notAfterRandomBitsStr.length() == 0) {
            notAfterRandomBitsStr = "0";
        }
        int notAfterRandomBits = Integer.parseInt(notAfterRandomBitsStr);
        int randomSeconds = this.randomSecs(notBeforeRandomBits);
        long currentTime = new Date().getTime();
        Date notBefore = new Date(currentTime + 1000L * startTime);
        logger.debug("RandomizedValidityDefault populate  notBefore           = " + notBefore);
        Date notBeforeRandomized = new Date(currentTime + 1000L * (startTime - (long)randomSeconds));
        logger.debug("RandomizedValidityDefault populate  notBeforeRandomized = " + notBeforeRandomized);
        int maxNotBeforeSecs = (1 << notBeforeRandomBits) - 1;
        Date notBeforeMax = new Date(currentTime + 1000L * (startTime - (long)maxNotBeforeSecs));
        logger.debug("RandomizedValidityDefault populate  notBeforeMax        = " + notBeforeMax);
        long notAfterValue = 0L;
        long notAfterValueRandomized = 0L;
        long notAfterValueMax = 0L;
        try {
            String rangeStr = this.getConfig(CONFIG_RANGE);
            rangeStr = this.mapPattern(request, rangeStr);
            notAfterValue = notBefore.getTime() + this.mDayInMS * (long)Integer.parseInt(rangeStr);
            notAfterValueRandomized = notBefore.getTime() + this.mDayInMS * (long)Integer.parseInt(rangeStr) + (long)(1000 * this.randomSecs(notAfterRandomBits));
            int maxNotAfterSecs = (1 << notAfterRandomBits) - 1;
            notAfterValueMax = notBefore.getTime() + this.mDayInMS * (long)Integer.parseInt(rangeStr) + (long)(1000 * maxNotAfterSecs);
        }
        catch (Exception e) {
            logger.error("RandomizedValidityDefault: populate " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{CONFIG_RANGE}));
        }
        Date notAfter = new Date(notAfterValue);
        logger.debug("RandomizedValidityDefault populate  notAfter            = " + notAfter);
        Date notAfterRandomized = new Date(notAfterValueRandomized);
        logger.debug("RandomizedValidityDefault populate  notAfterRandomized  = " + notAfterRandomized);
        Date notAfterMax = new Date(notAfterValueMax);
        logger.debug("RandomizedValidityDefault populate  notAfterMax         = " + notAfterMax);
        CertificateValidity validity = new CertificateValidity(notBeforeRandomized, notAfterRandomized);
        try {
            info.set("validity", (Object)validity);
        }
        catch (Exception e) {
            logger.error("RandomizedValidityDefault: populate " + e.getMessage(), (Throwable)e);
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_INVALID_PROPERTY", (String[])new String[]{"validity"}));
        }
    }
}

