/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldapconn;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import java.util.Hashtable;
import java.util.Properties;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapBoundConnection
extends LDAPConnection {
    public static Logger logger = LoggerFactory.getLogger(LdapBoundConnection.class);
    private static final long serialVersionUID = -2242077674357271559L;
    private boolean mAuthenticated;
    LdapBoundConnFactory connectionFactory;

    public LdapBoundConnection(LDAPSocketFactory socketFactory, LdapConnInfo connInfo, final LdapAuthInfo authInfo) throws EBaseException, LDAPException {
        super(socketFactory);
        boolean followReferrals = connInfo.getFollowReferrals();
        this.setOption(8, followReferrals);
        if (followReferrals && authInfo.getAuthType() != 2) {
            LDAPRebind rebindInfo = new LDAPRebind(){

                public LDAPRebindAuth getRebindAuthentication(String host, int port) {
                    return new LDAPRebindAuth(){

                        public String getDN() {
                            try {
                                return authInfo.getBindDN();
                            }
                            catch (EBaseException e) {
                                throw new RuntimeException("Unable to get bind DN: " + e.getMessage(), e);
                            }
                        }

                        public String getPassword() {
                            try {
                                return authInfo.getBindPassword();
                            }
                            catch (EBaseException e) {
                                throw new RuntimeException("Unable to get bind password: " + e.getMessage(), e);
                            }
                        }
                    };
                }
            };
            this.setOption(9, rebindInfo);
        }
        String hostname = connInfo.getHost();
        int port = connInfo.getPort();
        if (authInfo.getAuthType() == 2) {
            logger.debug("LdapBoundConnection: Connecting to " + hostname + ":" + port + " with client cert auth");
            super.connect(hostname, port);
        } else {
            int version = connInfo.getVersion();
            String bindDN = authInfo.getBindDN();
            String bindPassword = authInfo.getBindPassword();
            logger.debug("LdapBoundConnection: Connecting to " + hostname + ":" + port + " with basic auth as " + bindDN);
            super.connect(version, hostname, port, bindDN, bindPassword);
        }
    }

    public LdapBoundConnection(String hostname, int port, int version, LDAPSocketFactory factory, String bindDN, String bindPassword) throws LDAPException {
        super(factory);
        if (bindDN != null) {
            logger.debug("LdapBoundConnection: Connecting to " + hostname + ":" + port + " with basic auth as " + bindDN);
            super.connect(version, hostname, port, bindDN, bindPassword);
            return;
        }
        if (factory == null && bindDN == null) {
            throw new IllegalArgumentException("Missing authentication info");
        }
        logger.debug("LdapBoundConnection: Connecting to " + hostname + ":" + port + " with client cert auth");
        super.connect(version, hostname, port, null, null);
    }

    public void authenticate(int version, String dn, String pw) throws LDAPException {
        super.authenticate(version, dn, pw);
        this.mAuthenticated = true;
    }

    public void authenticate(String dn, String pw) throws LDAPException {
        super.authenticate(3, dn, pw);
        this.mAuthenticated = true;
    }

    public void authenticate(String dn, String[] mechs, Properties props, Object getter) throws LDAPException {
        super.authenticate(dn, mechs, (Hashtable)props, getter);
        this.mAuthenticated = true;
    }

    public void connect(String host, int port) throws LDAPException {
        throw new RuntimeException("this LdapBoundConnection is already connected: conn(host,port)");
    }

    public void connect(int version, String host, int port, String dn, String pw) throws LDAPException {
        throw new RuntimeException("this LdapBoundConnection is already connected: conn(version,h,p)");
    }
}

