/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.authentication;

import com.netscape.certsrv.authentication.AuthCredentials;
import com.netscape.certsrv.authentication.EAuthException;
import com.netscape.certsrv.authentication.EFormSubjectDN;
import com.netscape.certsrv.authentication.EInvalidCredentials;
import com.netscape.certsrv.authentication.EMissingCredential;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.ldap.LdapConnFactory;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.authentication.DNPattern;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LdapAnonConnFactory;
import com.netscape.cmscore.ldapconn.LdapBoundConnFactory;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthManagerConfig;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authentication.AuthenticationConfig;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirBasedAuthentication
extends AuthManager
implements IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(DirBasedAuthentication.class);
    protected static final String USER_DN = "userDN";
    protected static final String PROP_GROUPS_ENABLE = "groupsEnable";
    protected static final String PROP_GROUPS_BASEDN = "groupsBasedn";
    protected static final String PROP_GROUPS = "groups";
    protected static final String PROP_GROUP_OBJECT_CLASS = "groupObjectClass";
    protected static final String PROP_GROUP_USERID_NAME = "groupUseridName";
    protected static final String PROP_USERID_NAME = "useridName";
    protected static final String PROP_SEARCH_GROUP_USER_BY_USERDN = "searchGroupUserByUserdn";
    protected static final String PROP_DNPATTERN = "dnpattern";
    protected static final String PROP_LDAPSTRINGATTRS = "ldapStringAttributes";
    protected static final String PROP_LDAPBYTEATTRS = "ldapByteAttributes";
    protected static final String PROP_LDAP_BOUND_CONN = "ldapBoundConn";
    protected LDAPConfig mLdapConfig;
    protected String mBaseDN = null;
    protected boolean mGroupsEnable = false;
    protected String mGroups = null;
    protected String mGroupsBaseDN = null;
    protected String mGroupObjectClass = null;
    protected String mUserIDName = null;
    protected String mGroupUserIDName = null;
    protected boolean mSearchGroupUserByUserdn = true;
    protected boolean mBoundConnEnable = false;
    protected LdapConnFactory mConnFactory = null;
    protected DNPattern mPattern = null;
    protected String[] mLdapStringAttrs = null;
    protected String[] mLdapByteAttrs = null;
    protected String[] mLdapAttrs = null;
    protected String mTag;
    protected static String DEFAULT_DNPATTERN = "E=$attr.mail, CN=$attr.cn, O=$dn.o, C=$dn.c";
    protected static Vector<String> mExtendedPluginInfo = null;

    @Override
    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config) throws EBaseException {
        this.init(authenticationConfig, name, implName, config, true);
    }

    public void init(AuthenticationConfig authenticationConfig, String name, String implName, AuthManagerConfig config, boolean needBaseDN) throws EBaseException {
        logger.info("DirBasedAuthentication: Initializing " + name);
        this.authenticationConfig = authenticationConfig;
        this.mName = name;
        this.mImplName = implName;
        this.mConfig = config;
        String method = "DirBasedAuthentication: init: ";
        EngineConfig cs = this.engine.getConfig();
        this.mLdapConfig = this.mConfig.getLDAPConfig();
        if (needBaseDN) {
            this.mBaseDN = this.mLdapConfig.getBaseDN();
            if (this.mBaseDN == null || this.mBaseDN.trim().equals("")) {
                throw new EPropertyNotFound(CMS.getUserMessage("CMS_BASE_GET_PROPERTY_FAILED", "basedn"));
            }
            this.mGroupsEnable = this.mLdapConfig.getBoolean(PROP_GROUPS_ENABLE, false);
            logger.info("DirBasedAuthentication: Groups enable: " + this.mGroupsEnable);
            this.mGroupsBaseDN = this.mLdapConfig.getString(PROP_GROUPS_BASEDN, this.mBaseDN);
            logger.info("DirBasedAuthentication: Groups base DN: " + this.mGroupsBaseDN);
            this.mGroups = this.mLdapConfig.getString(PROP_GROUPS, "ou=groups");
            logger.info("DirBasedAuthentication: Groups: " + this.mGroups);
            this.mGroupObjectClass = this.mLdapConfig.getString(PROP_GROUP_OBJECT_CLASS, "groupofuniquenames");
            logger.info("DirBasedAuthentication: Group object class: " + this.mGroupObjectClass);
            this.mUserIDName = this.mLdapConfig.getString(PROP_USERID_NAME, "uid");
            logger.info("DirBasedAuthentication: User ID name: " + this.mUserIDName);
            this.mSearchGroupUserByUserdn = this.mLdapConfig.getBoolean(PROP_SEARCH_GROUP_USER_BY_USERDN, true);
            logger.info("DirBasedAuthentication: Search group user by user DN: " + this.mSearchGroupUserByUserdn);
            this.mGroupUserIDName = this.mLdapConfig.getString(PROP_GROUP_USERID_NAME, "cn");
            logger.info("DirBasedAuthentication: Group user ID name: " + this.mGroupUserIDName);
        }
        PKISocketConfig socketConfig = cs.getSocketConfig();
        this.mBoundConnEnable = this.mLdapConfig.getBoolean(PROP_LDAP_BOUND_CONN, false);
        logger.info("DirBasedAuthentication: Bound connection enable: " + this.mBoundConnEnable);
        if (this.mBoundConnEnable) {
            LDAPAuthenticationConfig authConfig = this.mLdapConfig.getAuthenticationConfig();
            this.mTag = this.mLdapConfig.getString("bindPWPrompt");
            logger.info("DirBasedAuthentication: Bind password prompt: " + this.mTag);
            LdapBoundConnFactory connFactory = new LdapBoundConnFactory(this.mTag);
            connFactory.setCMSEngine(this.engine);
            connFactory.init(socketConfig, this.mLdapConfig, this.engine.getPasswordStore());
            this.mConnFactory = connFactory;
        } else {
            LdapAnonConnFactory connFactory = new LdapAnonConnFactory("DirBasedAuthentication");
            connFactory.setCMSEngine(this.engine);
            connFactory.init(socketConfig, this.mLdapConfig);
            this.mConnFactory = connFactory;
        }
        String pattern = this.mConfig.getString(PROP_DNPATTERN, null);
        if (pattern == null || pattern.length() == 0) {
            pattern = DEFAULT_DNPATTERN;
        }
        logger.info("DirBasedAuthentication: DN pattern: " + pattern);
        this.mPattern = new DNPattern(pattern);
        String[] patternLdapAttrs = this.mPattern.getLdapAttrs();
        String ldapStringAttrs = this.mConfig.getString(PROP_LDAPSTRINGATTRS, null);
        if (ldapStringAttrs == null) {
            this.mLdapStringAttrs = patternLdapAttrs;
        } else {
            String[] pAttrs = new StringTokenizer(ldapStringAttrs, ",", false);
            int begin = 0;
            if (patternLdapAttrs != null && patternLdapAttrs.length > 0) {
                this.mLdapStringAttrs = new String[patternLdapAttrs.length + pAttrs.countTokens()];
                System.arraycopy(patternLdapAttrs, 0, this.mLdapStringAttrs, 0, patternLdapAttrs.length);
                begin = patternLdapAttrs.length;
            } else {
                this.mLdapStringAttrs = new String[pAttrs.countTokens()];
            }
            for (int i = begin; i < this.mLdapStringAttrs.length; ++i) {
                this.mLdapStringAttrs[i] = ((String)pAttrs.nextElement()).trim();
            }
        }
        logger.debug("DirBasedAuthentication: String attributes:");
        for (String attr : this.mLdapStringAttrs) {
            logger.debug("DirBasedAuthentication: - " + attr);
        }
        String ldapByteAttrs = this.mConfig.getString(PROP_LDAPBYTEATTRS, null);
        if (ldapByteAttrs == null) {
            this.mLdapByteAttrs = new String[0];
        } else {
            StringTokenizer byteAttrs = new StringTokenizer(ldapByteAttrs, ",", false);
            this.mLdapByteAttrs = new String[byteAttrs.countTokens()];
            for (int j = 0; j < this.mLdapByteAttrs.length; ++j) {
                this.mLdapByteAttrs[j] = ((String)byteAttrs.nextElement()).trim();
            }
        }
        logger.debug("DirBasedAuthentication: Byte attributes:");
        for (String attr : this.mLdapByteAttrs) {
            logger.debug("DirBasedAuthentication: - " + attr);
        }
        this.mLdapAttrs = new String[this.mLdapStringAttrs.length + this.mLdapByteAttrs.length];
        System.arraycopy(this.mLdapStringAttrs, 0, this.mLdapAttrs, 0, this.mLdapStringAttrs.length);
        System.arraycopy(this.mLdapByteAttrs, 0, this.mLdapAttrs, this.mLdapStringAttrs.length, this.mLdapByteAttrs.length);
        logger.info("DirBasedAuthentication: Initialization complete");
    }

    @Override
    public String getText(Locale locale) {
        return null;
    }

    @Override
    public Enumeration<String> getValueNames() {
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    @Override
    public boolean isValueWriteable(String name) {
        return false;
    }

    @Override
    public boolean isSSLClientRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AuthToken authenticate(AuthCredentials authCred) throws EMissingCredential, EInvalidCredentials, EBaseException {
        String userdn = null;
        LDAPConnection conn = null;
        AuthToken authToken = new AuthToken(this);
        String method = "DirBasedAuthentication: authenticate:";
        logger.debug(method + " begins...mBoundConnEnable=" + this.mBoundConnEnable);
        EngineConfig cs = this.engine.getConfig();
        PKISocketConfig socketConfig = cs.getSocketConfig();
        try {
            if (this.mConnFactory == null) {
                logger.debug(method + " mConnFactory null, getting conn factory");
                if (this.mBoundConnEnable) {
                    LDAPAuthenticationConfig authConfig = this.mLdapConfig.getAuthenticationConfig();
                    this.mTag = authConfig.getString("bindPWPrompt");
                    logger.debug(method + " getting ldap bound conn factory using id= " + this.mTag);
                    LdapBoundConnFactory connFactory = new LdapBoundConnFactory(this.mTag);
                    connFactory.setCMSEngine(this.engine);
                    connFactory.init(socketConfig, this.mLdapConfig, this.engine.getPasswordStore());
                    this.mConnFactory = connFactory;
                } else {
                    LdapAnonConnFactory connFactory = new LdapAnonConnFactory("DirBasedAuthentication");
                    connFactory.setCMSEngine(this.engine);
                    connFactory.init(socketConfig, this.mLdapConfig);
                    this.mConnFactory = connFactory;
                }
                if (this.mConnFactory != null) {
                    logger.debug(method + " mConnFactory gotten, calling getConn");
                    conn = this.mConnFactory.getConn();
                }
            } else {
                logger.debug(method + " mConnFactory class name = " + this.mConnFactory.getClass().getName());
                logger.debug(method + " mConnFactory not null, calling getConn");
                conn = this.mConnFactory.getConn();
            }
            logger.debug(method + " before authenticate() call");
            userdn = this.authenticate(conn, authCred, authToken);
            logger.debug(method + " after authenticate() call");
            authToken.set(USER_DN, userdn);
            X509CertInfo certInfo = new X509CertInfo();
            this.formCertInfo(conn, userdn, certInfo, authToken);
            try {
                CertificateSubjectName subjectname = (CertificateSubjectName)certInfo.get("subject");
                if (subjectname != null) {
                    authToken.set("tokenCertSubject", subjectname.toString());
                }
            }
            catch (CertificateException subjectname) {
            }
            catch (IOException subjectname) {
                // empty catch block
            }
            try {
                CertificateValidity validity = (CertificateValidity)certInfo.get("validity");
                if (validity != null) {
                    authToken.set("tokenCertNotBefore", (Date)validity.get("notBefore"));
                    authToken.set("tokenCertNotAfter", (Date)validity.get("notAfter"));
                }
            }
            catch (CertificateException validity) {
            }
            catch (IOException validity) {
                // empty catch block
            }
            try {
                CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
                if (extensions != null) {
                    authToken.set("tokenCertExts", extensions);
                }
            }
            catch (CertificateException certificateException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (conn == null) return authToken;
        }
        catch (Throwable throwable) {
            if (conn == null) throw throwable;
            this.mConnFactory.returnConn(conn);
            throw throwable;
        }
        this.mConnFactory.returnConn(conn);
        return authToken;
    }

    @Override
    public void populate(AuthToken token, Request request) throws EProfileException {
    }

    @Override
    public abstract String[] getRequiredCreds();

    @Override
    public void shutdown() {
        try {
            if (this.mConnFactory != null) {
                this.mConnFactory.reset();
            }
        }
        catch (ELdapException e) {
            logger.warn("DirBasedAuthentication: " + CMS.getLogMessage("CMS_AUTH_SHUTDOWN_ERROR", e.toString()), (Throwable)e);
        }
    }

    protected abstract String authenticate(LDAPConnection var1, AuthCredentials var2, AuthToken var3) throws EBaseException;

    protected void formCertInfo(LDAPConnection conn, String userdn, X509CertInfo certinfo, AuthToken token) throws EBaseException {
        String dn = null;
        try {
            if (conn != null) {
                logger.info("DirBasedAuthentication: Searching for " + userdn);
                String[] attrs = this.getLdapAttrs();
                if (attrs == null) {
                    logger.info("DirBasedAuthentication: - no attributes found");
                } else {
                    logger.info("DirBasedAuthentication: - attributes:");
                    for (String attr : attrs) {
                        logger.info("DirBasedAuthentication:   - " + attr);
                    }
                }
                LDAPSearchResults results = conn.search(userdn, 0, "(objectClass=*)", attrs, false);
                if (!results.hasMoreElements()) {
                    logger.error("DirBasedAuthentication: Unable to find user: " + userdn);
                    throw new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_LDAPATTRIBUTES_NOT_FOUND", new String[0]));
                }
                LDAPEntry entry = results.next();
                dn = this.formSubjectName(entry);
                logger.info("DirBasedAuthentication: DN: " + dn);
                this.setAuthTokenValues(entry, token);
            } else {
                dn = userdn;
            }
            if (dn.length() == 0) {
                EAuthException ex = new EAuthException(CMS.getUserMessage("CMS_AUTHENTICATION_EMPTY_DN_FORMED", this.mName));
                logger.error("DirBasedAuthentication: " + CMS.getLogMessage("CMS_AUTH_NO_DN_ERROR", ex.toString()));
                throw ex;
            }
            X500Name subjectdn = new X500Name(dn);
            certinfo.set("subject", (Object)new CertificateSubjectName(subjectdn));
        }
        catch (LDAPException e) {
            switch (e.getLDAPResultCode()) {
                case 81: {
                    logger.error("DirBasedAuthentication: " + CMS.getLogMessage("CMS_AUTH_NO_AUTH_ATTR_ERROR", new Object[0]));
                    throw new ELdapException(CMS.getUserMessage("CMS_LDAP_SERVER_UNAVAILABLE", conn.getHost(), "" + conn.getPort()));
                }
                case 9: 
                case 32: {
                    logger.error("DirBasedAuthentication: " + CMS.getLogMessage("CMS_AUTH_NO_USER_ENTRY_ERROR", userdn));
                }
            }
            logger.error("DirBasedAuthentication: " + CMS.getLogMessage("LDAP_ERROR", e.toString()));
            throw new ELdapException(CMS.getUserMessage("CMS_LDAP_OTHER_LDAP_EXCEPTION", e.errorCodeToString()));
        }
        catch (IOException e) {
            logger.error("DirBasedAuthentication: " + CMS.getLogMessage("CMS_AUTH_CREATE_SUBJECT_ERROR", userdn, e.getMessage()), (Throwable)e);
            throw new EFormSubjectDN(CMS.getUserMessage("CMS_AUTHENTICATION_FORM_SUBJECTDN_ERROR", new String[0]));
        }
        catch (CertificateException e) {
            logger.error("DirBasedAuthentication: " + CMS.getLogMessage("CMS_AUTH_CREATE_CERTINFO_ERROR", userdn, e.getMessage()));
            throw new EFormSubjectDN(CMS.getUserMessage("CMS_AUTHENTICATION_FORM_SUBJECTDN_ERROR", new String[0]));
        }
    }

    protected void setAuthTokenValues(LDAPEntry e, AuthToken tok) {
        for (int i = 0; i < this.mLdapStringAttrs.length; ++i) {
            this.setAuthTokenStringValue(this.mLdapStringAttrs[i], e, tok);
        }
        for (int j = 0; j < this.mLdapByteAttrs.length; ++j) {
            this.setAuthTokenByteValue(this.mLdapByteAttrs[j], e, tok);
        }
    }

    protected void setAuthTokenStringValue(String name, LDAPEntry entry, AuthToken tok) {
        LDAPAttribute values = entry.getAttribute(name);
        if (values == null) {
            return;
        }
        Vector<String> v = new Vector<String>();
        Enumeration e = values.getStringValues();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        Object[] a = new String[v.size()];
        v.copyInto(a);
        tok.set(name, (String[])a);
    }

    protected void setAuthTokenByteValue(String name, LDAPEntry entry, AuthToken tok) {
        LDAPAttribute values = entry.getAttribute(name);
        if (values == null) {
            return;
        }
        Vector<byte[]> v = new Vector<byte[]>();
        Enumeration e = values.getByteValues();
        while (e.hasMoreElements()) {
            v.addElement((byte[])e.nextElement());
        }
        byte[][] a = new byte[v.size()][];
        v.copyInto((Object[])a);
        tok.set(name, a);
    }

    protected String[] getLdapAttrs() {
        return this.mLdapAttrs;
    }

    protected String[] getLdapByteAttrs() {
        return this.mLdapByteAttrs;
    }

    protected String formSubjectName(LDAPEntry entry) throws EAuthException {
        if (this.mPattern.mPatternString == null) {
            return entry.getDN();
        }
        return this.mPattern.formDN(entry);
    }

    public String[] getExtendedPluginInfo() {
        return Utils.getStringArrayFromVector(mExtendedPluginInfo);
    }

    static {
        mExtendedPluginInfo = new Vector();
        mExtendedPluginInfo.add("dnpattern;string;Template for cert Subject Name. ($dn.xxx - get value from user's LDAP DN.  $attr.yyy - get value from LDAP attributes in user's entry.) Default: " + DEFAULT_DNPATTERN);
        mExtendedPluginInfo.add("ldapStringAttributes;string;Comma-separated list of LDAP attributes to copy from the user's LDAP entry into the AuthToken. e.g use 'mail' to copy user's email address for subjectAltName");
        mExtendedPluginInfo.add("ldapByteAttributes;string;Comma-separated list of binary LDAP attributes to copy from the user's LDAP entry into the AuthToken");
        mExtendedPluginInfo.add("ldap.ldapconn.host;string,required;LDAP host to connect to");
        mExtendedPluginInfo.add("ldap.ldapconn.port;number,required;LDAP port number (use 389, or 636 if SSL)");
        mExtendedPluginInfo.add("ldap.ldapconn.secureConn;boolean;Use SSL to connect to directory?");
        mExtendedPluginInfo.add("ldap.ldapconn.version;choice(3,2);LDAP protocol version");
        mExtendedPluginInfo.add("ldap.basedn;string,required;Base DN to start searching under. If your user's DN is 'uid=jsmith, o=company', you might want to use 'o=company' here");
        mExtendedPluginInfo.add("ldap.minConns;number;number of connections to keep open to directory server. Default 5.");
        mExtendedPluginInfo.add("ldap.maxConns;number;when needed, connection pool can grow to this many (multiplexed) connections. Default 1000.");
    }
}

