/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class CertID
implements ASN1Value {
    private AlgorithmIdentifier hashAlgorithm;
    private OCTET_STRING issuerNameHash;
    private OCTET_STRING issuerKeyHash;
    private INTEGER serialNumber;
    private SEQUENCE sequence = new SEQUENCE();
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();
    private static HashMap<OBJECT_IDENTIFIER, String> digestNames = new HashMap();

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public OCTET_STRING getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public OCTET_STRING getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public INTEGER getSerialNumber() {
        return this.serialNumber;
    }

    public CertID(AlgorithmIdentifier hashAlgorithm, OCTET_STRING issuerNameHash, OCTET_STRING issuerKeyHash, INTEGER serialNumber) {
        this.hashAlgorithm = hashAlgorithm;
        this.sequence.addElement((ASN1Value)hashAlgorithm);
        this.issuerNameHash = issuerNameHash;
        this.sequence.addElement((ASN1Value)issuerNameHash);
        this.issuerKeyHash = issuerKeyHash;
        this.sequence.addElement((ASN1Value)issuerKeyHash);
        this.serialNumber = serialNumber;
        this.sequence.addElement((ASN1Value)serialNumber);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public String getDigestName() {
        return digestNames.get(this.hashAlgorithm.getOID());
    }

    static {
        digestNames.put(new OBJECT_IDENTIFIER("1.2.840.113549.2.2"), "MD2");
        digestNames.put(new OBJECT_IDENTIFIER("1.2.840.113549.2.5"), "MD5");
        digestNames.put(new OBJECT_IDENTIFIER("1.3.14.3.2.26"), "SHA-1");
        digestNames.put(new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.2.4"), "SHA-224");
        digestNames.put(new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.2.1"), "SHA-256");
        digestNames.put(new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.2.2"), "SHA-384");
        digestNames.put(new OBJECT_IDENTIFIER("2.16.840.1.101.3.4.2.3"), "SHA-512");
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new CertID((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1), (OCTET_STRING)seq.elementAt(2), (INTEGER)seq.elementAt(3));
        }
    }
}

