/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.netscape.certsrv.util.JSONSerializer;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RESTMessage
implements JSONSerializer {
    protected Map<String, String> attributes = new LinkedHashMap<String, String>();
    protected String className;

    public RESTMessage() {
    }

    public RESTMessage(MultivaluedMap<String, String> form) {
        for (Map.Entry entry : form.entrySet()) {
            this.attributes.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
    }

    @JsonProperty(value="ClassName")
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @JsonIgnore
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    @JsonProperty(value="Attributes")
    public AttributeList getAttributeList() {
        AttributeList list = new AttributeList();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            Attribute attribute = new Attribute();
            attribute.name = entry.getKey();
            attribute.value = entry.getValue();
            list.attrs.add(attribute);
        }
        return list;
    }

    public void setAttributeList(AttributeList list) {
        this.attributes.clear();
        for (Attribute attribute : list.attrs) {
            this.attributes.put(attribute.name, attribute.value);
        }
    }

    @JsonIgnore
    public Collection<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RESTMessage other = (RESTMessage)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    public void toDOM(Document document, Element element) {
        if (this.className != null) {
            Element classNameElement = document.createElement("ClassName");
            classNameElement.appendChild(document.createTextNode(this.className));
            element.appendChild(classNameElement);
        }
        Element attributesElement = document.createElement("Attributes");
        element.appendChild(attributesElement);
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            Element attributeElement = document.createElement("Attribute");
            attributeElement.setAttribute("name", attribute.getKey());
            attributeElement.appendChild(document.createTextNode(attribute.getValue()));
            attributesElement.appendChild(attributeElement);
        }
    }

    public Element toDOM(Document document) {
        Element element = document.createElement("ResourceMessage");
        this.toDOM(document, element);
        return element;
    }

    public static void fromDOM(Element element, RESTMessage resourceMessage) {
        NodeList attributesList;
        NodeList classNameList = element.getElementsByTagName("ClassName");
        if (classNameList.getLength() > 0) {
            String value = classNameList.item(0).getTextContent();
            resourceMessage.setClassName(value);
        }
        if ((attributesList = element.getElementsByTagName("Attributes")).getLength() > 0) {
            Element attributesElement = (Element)attributesList.item(0);
            NodeList attributeList = attributesElement.getElementsByTagName("Attribute");
            int attributeCount = attributeList.getLength();
            for (int i = 0; i < attributeCount; ++i) {
                Element attributeElement = (Element)attributeList.item(i);
                String name = attributeElement.getAttribute("name");
                String value = attributeElement.getTextContent();
                resourceMessage.setAttribute(name, value);
            }
        }
    }

    public static RESTMessage fromDOM(Element element) {
        RESTMessage resourceMessage = new RESTMessage();
        RESTMessage.fromDOM(element, resourceMessage);
        return resourceMessage;
    }

    public String toXML() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = this.toDOM(document);
        document.appendChild(element);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource domSource = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        transformer.transform(domSource, streamResult);
        return sw.toString();
    }

    public static RESTMessage fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element element = document.getDocumentElement();
        return RESTMessage.fromDOM(element);
    }

    public String toString() {
        return super.toString();
    }

    @JsonSerialize(using=AttributeListSerializer.class)
    @JsonDeserialize(using=AttributeListDeserializer.class)
    public static class AttributeList {
        @JsonProperty(value="Attribute")
        public List<Attribute> attrs = new ArrayList<Attribute>();
    }

    public static class Attribute {
        public String name;
        public String value;
    }

    public static class AttributeListDeserializer
    extends StdDeserializer<AttributeList> {
        public AttributeListDeserializer() {
            this(null);
        }

        public AttributeListDeserializer(Class<?> vc) {
            super(vc);
        }

        public AttributeList deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            AttributeList list = new AttributeList();
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            JsonNode attributeNode = node.get("Attribute");
            for (JsonNode attr : attributeNode) {
                Attribute attribute = new Attribute();
                attribute.name = attr.get("name").asText();
                attribute.value = attr.get("value").asText();
                list.attrs.add(attribute);
            }
            return list;
        }
    }

    public static class AttributeListSerializer
    extends StdSerializer<AttributeList> {
        public AttributeListSerializer() {
            this(null);
        }

        public AttributeListSerializer(Class<AttributeList> t) {
            super(t);
        }

        public void serialize(AttributeList attributes, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonProcessingException {
            generator.writeStartObject();
            generator.writeArrayFieldStart("Attribute");
            for (Attribute attribute : attributes.attrs) {
                generator.writeStartObject();
                generator.writeStringField("name", attribute.name);
                generator.writeStringField("value", attribute.value);
                generator.writeEndObject();
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }
}

