/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import java.net.URISyntaxException;
import org.dogtagpki.acme.ACMEError;
import org.dogtagpki.acme.ACMEIdentifier;
import org.dogtagpki.acme.ValidationResult;

public class ACMEIdentifierValidator {
    public static ValidationResult validateSyntax(ACMEIdentifier id) {
        if (id.getType() == null) {
            throw new IllegalArgumentException("Programming error: type is null");
        }
        if (id.getValue() == null) {
            throw new IllegalArgumentException("Programming error: value is null");
        }
        switch (id.getType()) {
            case "dns": {
                return ACMEIdentifierValidator.validateSyntaxDNS(id.getValue());
            }
        }
        ACMEError error = new ACMEError();
        error.setType("urn:ietf:params:acme:error:unsupportedIdentifier");
        error.setDetail("Unsupported identifier type: " + id.getType());
        return ValidationResult.fail((ACMEError)error);
    }

    private static ValidationResult validateSyntaxDNS(String value) {
        String[] labels = value.split("\\.");
        if (labels.length < 1) {
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:malformed");
            error.setDetail("dns identifier is empty");
            return ValidationResult.fail((ACMEError)error);
        }
        boolean first = true;
        for (String label : labels) {
            if (first) {
                first = false;
                if (label.equals("*") && labels.length > 1) continue;
            }
            char[] cs = label.toCharArray();
            boolean allLetDigHyp = true;
            for (int j = 0; j < cs.length; ++j) {
                if (ACMEIdentifierValidator.isLetDigHyp(cs[j])) continue;
                allLetDigHyp = false;
                break;
            }
            if (cs.length >= 1 && cs.length <= 63 && ACMEIdentifierValidator.isLetDig(cs[0]) && ACMEIdentifierValidator.isLetDig(cs[cs.length - 1]) && allLetDigHyp) continue;
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:malformed");
            error.setDetail("invalid label in dns identifier: `" + label + "`");
            return ValidationResult.fail((ACMEError)error);
        }
        try {
            new URI("http", value, null, null);
        }
        catch (URISyntaxException e) {
            ACMEError error = new ACMEError();
            error.setType("urn:ietf:params:acme:error:malformed");
            error.setDetail("Failed to construct URI for DNS name " + value);
            return ValidationResult.fail((ACMEError)error);
        }
        return ValidationResult.ok();
    }

    private static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLetDig(char c) {
        return ACMEIdentifierValidator.isLetter(c) || ACMEIdentifierValidator.isDigit(c);
    }

    private static boolean isLetDigHyp(char c) {
        return ACMEIdentifierValidator.isLetDig(c) || c == '-';
    }
}

