/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.est;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.netscape.certsrv.base.ForbiddenException;
import com.netscape.certsrv.base.PKIException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.dogtagpki.est.ESTRequestAuthorizationData;
import org.dogtagpki.est.ESTRequestAuthorizer;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalProcessRequestAuthorizer
extends ESTRequestAuthorizer {
    public static Logger logger = LoggerFactory.getLogger(ExternalProcessRequestAuthorizer.class);
    static final String CONFIG_EXECUTABLE = "executable";
    static final String CONFIG_TIMEOUT = "timeout";
    static final long DEFAULT_TIMEOUT = 3L;
    static final String OPERATION_SIMPLEENROLL = "simpleenroll";
    static final String OPERATION_SIMPLEREENROLL = "simplereenroll";
    String executable;
    long timeout = 3L;

    @Override
    public void start() throws Throwable {
        logger.info("Initializing ExternalProcessRequestAuthorizer");
        this.executable = this.config.getParameter(CONFIG_EXECUTABLE);
        if (this.executable == null) {
            throw new RuntimeException("ExternalProcessRequestAuthorizer: 'executable' property missing");
        }
        String timeoutConfig = this.config.getParameter(CONFIG_TIMEOUT);
        if (timeoutConfig != null && !timeoutConfig.isEmpty()) {
            this.timeout = Integer.valueOf(timeoutConfig).longValue();
            if (this.timeout < 1L) {
                throw new IllegalArgumentException("Invalid timeout value: must be positive");
            }
        }
    }

    @Override
    public Object authorizeSimpleenroll(ESTRequestAuthorizationData data, PKCS10 csr) throws PKIException {
        return this.check(OPERATION_SIMPLEENROLL, data, csr, null);
    }

    @Override
    public Object authorizeSimplereenroll(ESTRequestAuthorizationData data, PKCS10 csr, X509Certificate toBeRenewed) throws PKIException {
        return this.check(OPERATION_SIMPLEREENROLL, data, csr, toBeRenewed);
    }

    String check(String op, ESTRequestAuthorizationData authzData, PKCS10 csr, X509Certificate toBeRenewed) throws PKIException {
        boolean timedOut;
        Process p;
        logger.debug("About to execute command: " + this.executable);
        ProcessBuilder pb = new ProcessBuilder(this.executable);
        Data data = new Data();
        data.operation = op;
        data.authzData = authzData;
        data.csr = csr;
        data.toBeRenewed = toBeRenewed;
        ObjectMapper mapper = new ObjectMapper();
        String stdout = "";
        String stderr = "";
        try {
            p = pb.start();
            mapper.writeValue(p.getOutputStream(), (Object)data);
            boolean bl = timedOut = !p.waitFor(this.timeout, TimeUnit.SECONDS);
            if (timedOut) {
                p.destroyForcibly();
            } else {
                stdout = IOUtils.toString((InputStream)p.getInputStream(), (String)"UTF-8");
                stderr = IOUtils.toString((InputStream)p.getErrorStream(), (String)"UTF-8");
            }
        }
        catch (Throwable e) {
            String msg = "Caught exception while executing command: " + this.executable;
            logger.error(msg + ": " + e.getMessage(), e);
            throw new ForbiddenException(msg, e);
        }
        if (timedOut) {
            throw new PKIException("Request validation timed out");
        }
        int exitValue = p.exitValue();
        logger.debug("ExternalProcessRequestAuthorizer: exit value: " + exitValue);
        logger.debug("ExternalProcessRequestAuthorizer: stdout: " + stdout);
        logger.debug("ExternalProcessRequestAuthorizer: stderr: " + stderr);
        if (exitValue != 0) {
            throw new ForbiddenException(stdout);
        }
        return stdout;
    }

    static class Data {
        @JsonProperty(value="operation")
        String operation;
        @JsonProperty(value="authzData")
        @JsonSerialize(using=ESTRequestAuthorizationDataSerializer.class)
        ESTRequestAuthorizationData authzData;
        PKCS10 csr;
        X509Certificate toBeRenewed;

        Data() {
        }

        @JsonProperty(value="csr")
        String getCSR() throws IOException {
            return Base64.encodeBase64String((byte[])this.csr.toByteArray());
        }

        @JsonProperty(value="toBeRenewed")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        String getToBeRenewed() throws CertificateEncodingException {
            if (null == this.toBeRenewed) {
                return null;
            }
            return Base64.encodeBase64String((byte[])this.toBeRenewed.getEncoded());
        }
    }

    public static class ESTRequestAuthorizationDataSerializer
    extends StdSerializer<ESTRequestAuthorizationData> {
        public ESTRequestAuthorizationDataSerializer() {
            this(null);
        }

        public ESTRequestAuthorizationDataSerializer(Class<ESTRequestAuthorizationData> t) {
            super(t);
        }

        public void serialize(ESTRequestAuthorizationData data, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("remoteAddr", data.remoteAddr);
            if (data.label.isPresent()) {
                generator.writeObjectField("label", (Object)data.label.get());
            }
            generator.writeObjectFieldStart("principal");
            generator.writeStringField("name", data.principal.getName());
            String[] roles = new String[]{};
            if (data.principal instanceof GenericPrincipal) {
                roles = ((GenericPrincipal)data.principal).getRoles();
            }
            generator.writeFieldName("roles");
            generator.writeStartArray();
            for (String role : roles) {
                generator.writeString(role);
            }
            generator.writeEndArray();
            generator.writeEndObject();
            if (data.clientCertChain != null) {
                generator.writeArrayFieldStart("clientCertChain");
                for (int i = 0; i < data.clientCertChain.length; ++i) {
                    try {
                        generator.writeString(Base64.encodeBase64String((byte[])data.clientCertChain[i].getEncoded()));
                        continue;
                    }
                    catch (CertificateEncodingException e) {
                        logger.error("ExternalProcessRequestAuthorizer: error encoding client certificate: " + e, (Throwable)e);
                        generator.writeNull();
                    }
                }
                generator.writeEndArray();
            }
            generator.writeEndObject();
        }
    }
}

