/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.certsrv.key.KeyData;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSKeyCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSKeyExportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSKeyExportCLI.class);
    public NSSKeyCLI nssKeyCLI;

    public NSSKeyExportCLI(NSSKeyCLI nssKeyCLI) {
        super("export", "Export key from NSS database", (CLI)nssKeyCLI);
        this.nssKeyCLI = nssKeyCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <key nickname>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "File to store the exported key");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "wrapper", true, "Nickname of the wrapper certificate");
        option.setArgName("nickname");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        block13: {
            String[] cmdArgs = cmd.getArgs();
            if (cmdArgs.length < 1) {
                throw new Exception("Missing key nickname");
            }
            String nickname = cmdArgs[0];
            String outputFile = cmd.getOptionValue("output");
            String wrapperNickname = cmd.getOptionValue("wrapper");
            if (wrapperNickname == null) {
                throw new Exception("Missing wrapper certificate nickname");
            }
            MainCLI mainCLI = (MainCLI)this.getRoot();
            mainCLI.init();
            CryptoManager cm = CryptoManager.getInstance();
            org.mozilla.jss.crypto.X509Certificate cert = cm.findCertByNickname(wrapperNickname);
            X509CertImpl certImpl = new X509CertImpl(cert.getEncoded());
            SymmetricKey tempKey = CryptoUtil.createDes3SessionKeyOnInternal();
            List listWrappedKeys = CryptoUtil.exportSharedSecret((String)nickname, (X509Certificate)certImpl, (SymmetricKey)tempKey);
            byte[] wrappedSessionKey = (byte[])listWrappedKeys.get(0);
            byte[] wrappedKey = (byte[])listWrappedKeys.get(1);
            KeyData keyData = new KeyData();
            keyData.setWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedSessionKey));
            keyData.setAdditionalWrappedPrivateData(Utils.base64encodeSingleLine((byte[])wrappedKey));
            logger.info("Wrapped session key: " + keyData.getWrappedPrivateData());
            logger.info("Wrapped secret key: " + keyData.getAdditionalWrappedPrivateData());
            if (outputFile != null) {
                try (FileWriter fw = new FileWriter(outputFile);
                     PrintWriter out = new PrintWriter(fw);){
                    out.println(keyData.toJSON());
                    break block13;
                }
            }
            System.out.println(keyData.toJSON());
        }
    }
}

