/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentNamespacesAPIService ContentNamespacesAPI service
type ContentNamespacesAPIService service

type ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest struct {
	ctx context.Context
	ApiService *ContentNamespacesAPIService
	ansibleAnsibleNamespaceMetadataHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest) Fields(fields []string) ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest) ExcludeFields(excludeFields []string) ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest) Execute() (*http.Response, error) {
	return r.ApiService.ContentAnsibleNamespacesAvatarExecute(r)
}

/*
ContentAnsibleNamespacesAvatar Method for ContentAnsibleNamespacesAvatar

Get the logo for the this namespace.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleNamespaceMetadataHref
 @return ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest
*/
func (a *ContentNamespacesAPIService) ContentAnsibleNamespacesAvatar(ctx context.Context, ansibleAnsibleNamespaceMetadataHref string) ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest {
	return ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleNamespaceMetadataHref: ansibleAnsibleNamespaceMetadataHref,
	}
}

// Execute executes the request
func (a *ContentNamespacesAPIService) ContentAnsibleNamespacesAvatarExecute(r ContentNamespacesAPIContentAnsibleNamespacesAvatarRequest) (*http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentNamespacesAPIService.ContentAnsibleNamespacesAvatar")
	if err != nil {
		return nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_namespace_metadata_href}avatar/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_namespace_metadata_href"+"}", parameterValueToString(r.ansibleAnsibleNamespaceMetadataHref, "ansibleAnsibleNamespaceMetadataHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		if localVarHTTPResponse.StatusCode == 302 {
			var v map[string]interface{}
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarHTTPResponse, newErr
			}
					newErr.error = formatErrorMessage(localVarHTTPResponse.Status, &v)
					newErr.model = v
		}
		return localVarHTTPResponse, newErr
	}

	return localVarHTTPResponse, nil
}

type ContentNamespacesAPIContentAnsibleNamespacesListRequest struct {
	ctx context.Context
	ApiService *ContentNamespacesAPIService
	company *string
	companyContains *string
	companyIcontains *string
	companyIn *[]string
	companyStartswith *string
	limit *int32
	metadataSha256 *string
	metadataSha256In *[]string
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where company matches value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) Company(company string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.company = &company
	return r
}

// Filter results where company contains value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) CompanyContains(companyContains string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.companyContains = &companyContains
	return r
}

// Filter results where company contains value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) CompanyIcontains(companyIcontains string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.companyIcontains = &companyIcontains
	return r
}

// Filter results where company is in a comma-separated list of values
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) CompanyIn(companyIn []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.companyIn = &companyIn
	return r
}

// Filter results where company starts with value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) CompanyStartswith(companyStartswith string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.companyStartswith = &companyStartswith
	return r
}

// Number of results to return per page.
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) Limit(limit int32) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.limit = &limit
	return r
}

// Filter results where metadata_sha256 matches value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) MetadataSha256(metadataSha256 string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.metadataSha256 = &metadataSha256
	return r
}

// Filter results where metadata_sha256 is in a comma-separated list of values
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) MetadataSha256In(metadataSha256In []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.metadataSha256In = &metadataSha256In
	return r
}

// Filter results where name matches value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) Name(name string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) NameContains(nameContains string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) NameIcontains(nameIcontains string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) NameIn(nameIn []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) NameStartswith(nameStartswith string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) Offset(offset int32) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;company&#x60; - Company * &#x60;-company&#x60; - Company (descending) * &#x60;email&#x60; - Email * &#x60;-email&#x60; - Email (descending) * &#x60;description&#x60; - Description * &#x60;-description&#x60; - Description (descending) * &#x60;resources&#x60; - Resources * &#x60;-resources&#x60; - Resources (descending) * &#x60;links&#x60; - Links * &#x60;-links&#x60; - Links (descending) * &#x60;avatar_sha256&#x60; - Avatar sha256 * &#x60;-avatar_sha256&#x60; - Avatar sha256 (descending) * &#x60;metadata_sha256&#x60; - Metadata sha256 * &#x60;-metadata_sha256&#x60; - Metadata sha256 (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) Ordering(ordering []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) PulpHrefIn(pulpHrefIn []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) PulpIdIn(pulpIdIn []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) RepositoryVersion(repositoryVersion string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// A list of fields to include in the response.
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) Fields(fields []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) ExcludeFields(excludeFields []string) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentNamespacesAPIContentAnsibleNamespacesListRequest) Execute() (*PaginatedansibleAnsibleNamespaceMetadataResponseList, *http.Response, error) {
	return r.ApiService.ContentAnsibleNamespacesListExecute(r)
}

/*
ContentAnsibleNamespacesList List ansible namespace metadatas

ViewSet for AnsibleNamespace.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentNamespacesAPIContentAnsibleNamespacesListRequest
*/
func (a *ContentNamespacesAPIService) ContentAnsibleNamespacesList(ctx context.Context) ContentNamespacesAPIContentAnsibleNamespacesListRequest {
	return ContentNamespacesAPIContentAnsibleNamespacesListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedansibleAnsibleNamespaceMetadataResponseList
func (a *ContentNamespacesAPIService) ContentAnsibleNamespacesListExecute(r ContentNamespacesAPIContentAnsibleNamespacesListRequest) (*PaginatedansibleAnsibleNamespaceMetadataResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedansibleAnsibleNamespaceMetadataResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentNamespacesAPIService.ContentAnsibleNamespacesList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/ansible/namespaces/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.company != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company", r.company, "")
	}
	if r.companyContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__contains", r.companyContains, "")
	}
	if r.companyIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__icontains", r.companyIcontains, "")
	}
	if r.companyIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__in", r.companyIn, "csv")
	}
	if r.companyStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "company__startswith", r.companyStartswith, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.metadataSha256 != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "metadata_sha256", r.metadataSha256, "")
	}
	if r.metadataSha256In != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "metadata_sha256__in", r.metadataSha256In, "csv")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentNamespacesAPIContentAnsibleNamespacesReadRequest struct {
	ctx context.Context
	ApiService *ContentNamespacesAPIService
	ansibleAnsibleNamespaceMetadataHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentNamespacesAPIContentAnsibleNamespacesReadRequest) Fields(fields []string) ContentNamespacesAPIContentAnsibleNamespacesReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentNamespacesAPIContentAnsibleNamespacesReadRequest) ExcludeFields(excludeFields []string) ContentNamespacesAPIContentAnsibleNamespacesReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentNamespacesAPIContentAnsibleNamespacesReadRequest) Execute() (*AnsibleAnsibleNamespaceMetadataResponse, *http.Response, error) {
	return r.ApiService.ContentAnsibleNamespacesReadExecute(r)
}

/*
ContentAnsibleNamespacesRead Inspect an ansible namespace metadata

ViewSet for AnsibleNamespace.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleAnsibleNamespaceMetadataHref
 @return ContentNamespacesAPIContentAnsibleNamespacesReadRequest
*/
func (a *ContentNamespacesAPIService) ContentAnsibleNamespacesRead(ctx context.Context, ansibleAnsibleNamespaceMetadataHref string) ContentNamespacesAPIContentAnsibleNamespacesReadRequest {
	return ContentNamespacesAPIContentAnsibleNamespacesReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleAnsibleNamespaceMetadataHref: ansibleAnsibleNamespaceMetadataHref,
	}
}

// Execute executes the request
//  @return AnsibleAnsibleNamespaceMetadataResponse
func (a *ContentNamespacesAPIService) ContentAnsibleNamespacesReadExecute(r ContentNamespacesAPIContentAnsibleNamespacesReadRequest) (*AnsibleAnsibleNamespaceMetadataResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleAnsibleNamespaceMetadataResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentNamespacesAPIService.ContentAnsibleNamespacesRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_ansible_namespace_metadata_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_ansible_namespace_metadata_href"+"}", parameterValueToString(r.ansibleAnsibleNamespaceMetadataHref, "ansibleAnsibleNamespaceMetadataHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
