/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class UniversalCharsetDecoder
extends CharsetDecoder {
    public UniversalCharsetDecoder(Charset cs) {
        super(cs, 0.25f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.remaining() >= 4) {
            in.mark();
            byte b0 = in.get();
            byte b1 = in.get();
            byte b2 = in.get();
            byte b3 = in.get();
            if (!(CodingErrorAction.REPORT != this.unmappableCharacterAction() || b0 == 0 && b1 == 0 || b2 == 0 && b3 == 0)) {
                return CoderResult.unmappableForLength(4);
            }
            char c = b2 == 0 && b3 == 0 ? (char)((b1 << 8 & 0xFF00) + (b0 & 0xFF)) : (char)((b2 << 8 & 0xFF00) + (b3 & 0xFF));
            if (out.remaining() < 1) {
                in.reset();
                return CoderResult.OVERFLOW;
            }
            out.put(c);
        }
        return CoderResult.UNDERFLOW;
    }
}

