/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.crypto.DigestAlgorithm;

public class CMACAlgorithm
extends DigestAlgorithm {
    private static Hashtable<OBJECT_IDENTIFIER, CMACAlgorithm> oidMap = new Hashtable();
    public static final CMACAlgorithm AES;
    public static final CMACAlgorithm AES128;
    public static final CMACAlgorithm AES192;
    public static final CMACAlgorithm AES256;

    protected CMACAlgorithm(int oidIndex, String name, OBJECT_IDENTIFIER oid, int outputSize) {
        super(oidIndex, name, oid, outputSize);
        if (oid != null && oidMap.get(oid) == null) {
            oidMap.put(oid, this);
        }
    }

    public static CMACAlgorithm fromOID(OBJECT_IDENTIFIER oid) throws NoSuchAlgorithmException {
        CMACAlgorithm alg = oidMap.get(oid);
        if (alg == null) {
            throw new NoSuchAlgorithmException("No such algorithm for OID: " + oid);
        }
        return alg;
    }

    static {
        AES128 = AES = new CMACAlgorithm(70, "AES-CMAC", null, 16);
        AES192 = AES;
        AES256 = AES;
    }
}

