/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import org.mozilla.jss.crypto.X509Certificate;

public class SSLSecurityStatus {
    int status;
    String cipher;
    int sessionKeySize;
    int sessionSecretSize;
    String issuer;
    String subject;
    String serialNumber;
    X509Certificate certificate;
    public final int STATUS_NOOPT = -1;
    public final int STATUS_OFF = 0;
    public final int STATUS_ON_HIGH = 1;
    public final int STATUS_ON_LOW = 2;
    @Deprecated
    public final int STATUS_FORTEZZA = 3;

    public SSLSecurityStatus(int status, String cipher, int sessionKeySize, int sessionSecretSize, String issuer, String subject, String serialNumber, X509Certificate certificate) {
        String noCert = "no certificate";
        this.status = status;
        this.cipher = cipher;
        this.sessionKeySize = sessionKeySize;
        this.sessionSecretSize = sessionSecretSize;
        this.certificate = certificate;
        this.issuer = noCert.equals(issuer) ? null : issuer;
        this.subject = noCert.equals(subject) ? null : subject;
        this.serialNumber = serialNumber;
    }

    public boolean isSecurityOn() {
        return this.status > 0;
    }

    public int getSecurityStatus() {
        return this.status;
    }

    public String getCipher() {
        return this.cipher;
    }

    public int getSessionKeySize() {
        return this.sessionKeySize;
    }

    public int getSessionSecretSize() {
        return this.sessionSecretSize;
    }

    public String getRemoteIssuer() {
        return this.issuer;
    }

    public String getRemoteSubject() {
        return this.subject;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public X509Certificate getPeerCertificate() {
        return this.certificate;
    }

    public String toString() {
        return "Status: " + (switch (this.status) {
            case -1 -> "NOOPT";
            case 0 -> "OFF";
            case 1 -> "ON HIGH";
            case 2 -> "ON LOW";
            case 3 -> "FORTEZZA";
            default -> "unknown";
        }) + "\nCipher: " + this.cipher + "\nSession key size: " + this.sessionKeySize + "\nSession secret size: " + this.sessionSecretSize + "\nIssuer: " + this.issuer + "\nSubject: " + this.subject + "\nSerial number: " + this.serialNumber + "\n";
    }
}

