// Code generated by goyacc -p expr -o pkg/logql/expr.y.go pkg/logql/expr.y. DO NOT EDIT.

//line pkg/logql/expr.y:2
package logql

import __yyfmt__ "fmt"

//line pkg/logql/expr.y:2
import (
	"github.com/grafana/loki/pkg/logql/log"
	"github.com/prometheus/prometheus/pkg/labels"
	"time"
)

//line pkg/logql/expr.y:12
type exprSymType struct {
	yys                   int
	Expr                  Expr
	Filter                labels.MatchType
	Grouping              *grouping
	Labels                []string
	LogExpr               LogSelectorExpr
	LogRangeExpr          *logRange
	Matcher               *labels.Matcher
	Matchers              []*labels.Matcher
	RangeAggregationExpr  SampleExpr
	RangeOp               string
	ConvOp                string
	Selector              []*labels.Matcher
	VectorAggregationExpr SampleExpr
	MetricExpr            SampleExpr
	VectorOp              string
	BinOpExpr             SampleExpr
	binOp                 string
	bytes                 uint64
	str                   string
	duration              time.Duration
	LiteralExpr           *literalExpr
	BinOpModifier         BinOpOptions
	LabelParser           *labelParserExpr
	LineFilters           *lineFilterExpr
	PipelineExpr          MultiStageExpr
	PipelineStage         StageExpr
	BytesFilter           log.LabelFilterer
	NumberFilter          log.LabelFilterer
	DurationFilter        log.LabelFilterer
	LabelFilter           log.LabelFilterer
	UnitFilter            log.LabelFilterer
	LineFormatExpr        *lineFmtExpr
	LabelFormatExpr       *labelFmtExpr
	LabelFormat           log.LabelFmt
	LabelsFormat          []log.LabelFmt
	UnwrapExpr            *unwrapExpr
}

const BYTES = 57346
const IDENTIFIER = 57347
const STRING = 57348
const NUMBER = 57349
const DURATION = 57350
const RANGE = 57351
const MATCHERS = 57352
const LABELS = 57353
const EQ = 57354
const RE = 57355
const NRE = 57356
const OPEN_BRACE = 57357
const CLOSE_BRACE = 57358
const OPEN_BRACKET = 57359
const CLOSE_BRACKET = 57360
const COMMA = 57361
const DOT = 57362
const PIPE_MATCH = 57363
const PIPE_EXACT = 57364
const OPEN_PARENTHESIS = 57365
const CLOSE_PARENTHESIS = 57366
const BY = 57367
const WITHOUT = 57368
const COUNT_OVER_TIME = 57369
const RATE = 57370
const SUM = 57371
const AVG = 57372
const MAX = 57373
const MIN = 57374
const COUNT = 57375
const STDDEV = 57376
const STDVAR = 57377
const BOTTOMK = 57378
const TOPK = 57379
const BYTES_OVER_TIME = 57380
const BYTES_RATE = 57381
const BOOL = 57382
const JSON = 57383
const REGEXP = 57384
const LOGFMT = 57385
const PIPE = 57386
const LINE_FMT = 57387
const LABEL_FMT = 57388
const UNWRAP = 57389
const AVG_OVER_TIME = 57390
const SUM_OVER_TIME = 57391
const MIN_OVER_TIME = 57392
const MAX_OVER_TIME = 57393
const STDVAR_OVER_TIME = 57394
const STDDEV_OVER_TIME = 57395
const QUANTILE_OVER_TIME = 57396
const DURATION_CONV = 57397
const DURATION_SECONDS_CONV = 57398
const OR = 57399
const AND = 57400
const UNLESS = 57401
const CMP_EQ = 57402
const NEQ = 57403
const LT = 57404
const LTE = 57405
const GT = 57406
const GTE = 57407
const ADD = 57408
const SUB = 57409
const MUL = 57410
const DIV = 57411
const MOD = 57412
const POW = 57413

var exprToknames = [...]string{
	"$end",
	"error",
	"$unk",
	"BYTES",
	"IDENTIFIER",
	"STRING",
	"NUMBER",
	"DURATION",
	"RANGE",
	"MATCHERS",
	"LABELS",
	"EQ",
	"RE",
	"NRE",
	"OPEN_BRACE",
	"CLOSE_BRACE",
	"OPEN_BRACKET",
	"CLOSE_BRACKET",
	"COMMA",
	"DOT",
	"PIPE_MATCH",
	"PIPE_EXACT",
	"OPEN_PARENTHESIS",
	"CLOSE_PARENTHESIS",
	"BY",
	"WITHOUT",
	"COUNT_OVER_TIME",
	"RATE",
	"SUM",
	"AVG",
	"MAX",
	"MIN",
	"COUNT",
	"STDDEV",
	"STDVAR",
	"BOTTOMK",
	"TOPK",
	"BYTES_OVER_TIME",
	"BYTES_RATE",
	"BOOL",
	"JSON",
	"REGEXP",
	"LOGFMT",
	"PIPE",
	"LINE_FMT",
	"LABEL_FMT",
	"UNWRAP",
	"AVG_OVER_TIME",
	"SUM_OVER_TIME",
	"MIN_OVER_TIME",
	"MAX_OVER_TIME",
	"STDVAR_OVER_TIME",
	"STDDEV_OVER_TIME",
	"QUANTILE_OVER_TIME",
	"DURATION_CONV",
	"DURATION_SECONDS_CONV",
	"OR",
	"AND",
	"UNLESS",
	"CMP_EQ",
	"NEQ",
	"LT",
	"LTE",
	"GT",
	"GTE",
	"ADD",
	"SUB",
	"MUL",
	"DIV",
	"MOD",
	"POW",
}
var exprStatenames = [...]string{}

const exprEofCode = 1
const exprErrCode = 2
const exprInitialStackSize = 16

//line pkg/logql/expr.y:345

//line yacctab:1
var exprExca = [...]int{
	-1, 1,
	1, -1,
	-2, 0,
}

const exprPrivate = 57344

const exprLast = 396

var exprAct = [...]int{

	70, 171, 53, 153, 145, 4, 179, 100, 63, 2,
	52, 45, 61, 56, 5, 217, 120, 214, 235, 66,
	14, 40, 41, 42, 43, 44, 45, 249, 11, 42,
	43, 44, 45, 252, 76, 235, 6, 213, 256, 244,
	17, 18, 28, 29, 31, 32, 30, 33, 34, 35,
	36, 19, 20, 214, 225, 91, 116, 118, 119, 227,
	94, 21, 22, 23, 24, 25, 26, 27, 92, 215,
	214, 224, 214, 247, 59, 124, 155, 118, 119, 15,
	16, 57, 58, 122, 129, 176, 130, 131, 132, 133,
	134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
	69, 128, 71, 72, 173, 117, 71, 72, 150, 46,
	47, 50, 51, 48, 49, 40, 41, 42, 43, 44,
	45, 60, 162, 59, 161, 156, 159, 160, 157, 158,
	57, 58, 178, 172, 225, 181, 170, 11, 174, 226,
	175, 59, 111, 110, 127, 123, 126, 68, 57, 58,
	186, 182, 183, 184, 37, 38, 39, 46, 47, 50,
	51, 48, 49, 40, 41, 42, 43, 44, 45, 209,
	60, 173, 211, 177, 216, 91, 219, 222, 94, 169,
	115, 212, 187, 223, 122, 220, 210, 167, 60, 167,
	228, 38, 39, 46, 47, 50, 51, 48, 49, 40,
	41, 42, 43, 44, 45, 255, 213, 251, 106, 232,
	106, 221, 167, 250, 233, 91, 236, 240, 106, 234,
	166, 241, 243, 91, 147, 215, 103, 125, 103, 185,
	59, 74, 147, 246, 168, 11, 103, 57, 58, 73,
	242, 214, 248, 6, 165, 253, 164, 17, 18, 28,
	29, 31, 32, 30, 33, 34, 35, 36, 19, 20,
	173, 106, 148, 146, 230, 231, 238, 239, 21, 22,
	23, 24, 25, 26, 27, 59, 170, 60, 163, 103,
	151, 59, 57, 58, 149, 59, 15, 16, 57, 58,
	113, 218, 57, 58, 75, 106, 106, 97, 99, 98,
	121, 104, 105, 217, 112, 173, 144, 114, 11, 147,
	147, 173, 109, 103, 103, 55, 123, 192, 101, 164,
	193, 191, 60, 189, 3, 163, 190, 188, 60, 254,
	245, 62, 60, 77, 78, 79, 80, 81, 82, 83,
	84, 85, 86, 87, 88, 89, 90, 148, 146, 146,
	106, 207, 152, 204, 208, 206, 205, 203, 201, 96,
	198, 202, 200, 199, 197, 180, 195, 95, 103, 196,
	194, 229, 65, 67, 154, 67, 154, 54, 107, 102,
	108, 93, 10, 9, 13, 8, 97, 99, 98, 237,
	104, 105, 12, 7, 64, 1,
}
var exprPact = [...]int{

	13, -1000, 97, -1000, -1000, 271, 13, -1000, -1000, -1000,
	-1000, 370, 124, 77, -1000, 232, 224, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -6, -6, -6,
	-6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
	-6, -6, 271, -1000, 109, 345, 306, -1000, -1000, -1000,
	-1000, 119, 118, 97, 288, 164, -1000, 44, 293, 220,
	123, 121, 78, -1000, -1000, 13, -1000, 13, 13, 13,
	13, 13, 13, 13, 13, 13, 13, 13, 13, 13,
	13, -1000, 300, -1000, 290, -1000, -1000, -1000, -1000, 278,
	-1000, -1000, -1000, 203, 274, 371, 64, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, 368, -1000, 272, 240, 238, 214,
	210, 160, 127, 122, 61, 154, 13, 360, 360, 133,
	49, 49, -39, -39, -60, -60, -60, -60, -45, -45,
	-45, -45, -45, -45, -1000, 290, 203, 203, 203, -1000,
	205, -1000, 131, -1000, 170, 319, 313, 362, 356, 354,
	349, 347, -1000, -1000, -1000, -1000, -1000, -1000, 81, 122,
	261, 28, 60, 256, 267, 187, 81, 13, 47, 115,
	-1000, 35, 213, 290, 291, -1000, 369, 259, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	185, -27, 261, -1000, 203, -1000, 26, 211, 208, 197,
	216, -1000, -1000, 15, -1000, 325, -1000, -1000, -1000, -1000,
	-1000, -1000, 81, -27, 290, -1000, -1000, 50, -1000, -1000,
	-17, 204, 198, 9, 81, -1000, -1000, 324, -27, -32,
	-1000, -1000, 196, -1000, 14, -1000, -1000,
}
var exprPgo = [...]int{

	0, 395, 8, 13, 0, 6, 324, 5, 16, 7,
	394, 393, 392, 389, 14, 385, 384, 383, 382, 294,
	381, 10, 2, 380, 379, 378, 4, 377, 367, 359,
	3, 352, 1, 318,
}
var exprR1 = [...]int{

	0, 1, 2, 2, 7, 7, 7, 7, 7, 6,
	6, 6, 8, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 8, 8, 32, 32, 32, 13,
	13, 11, 11, 11, 11, 15, 15, 15, 15, 15,
	3, 3, 3, 3, 14, 14, 14, 10, 10, 9,
	9, 9, 9, 21, 21, 22, 22, 22, 22, 22,
	27, 27, 20, 20, 20, 28, 30, 30, 31, 31,
	31, 29, 26, 26, 26, 26, 26, 26, 26, 26,
	33, 33, 25, 25, 25, 25, 25, 25, 25, 23,
	23, 23, 23, 23, 23, 23, 24, 24, 24, 24,
	24, 24, 24, 17, 17, 17, 17, 17, 17, 17,
	17, 17, 17, 17, 17, 17, 17, 17, 19, 19,
	18, 18, 18, 16, 16, 16, 16, 16, 16, 16,
	16, 16, 12, 12, 12, 12, 12, 12, 12, 12,
	12, 12, 12, 5, 5, 4, 4,
}
var exprR2 = [...]int{

	0, 1, 1, 1, 1, 1, 1, 1, 3, 1,
	2, 3, 2, 4, 3, 5, 3, 5, 3, 5,
	4, 6, 3, 4, 3, 2, 3, 6, 3, 1,
	1, 4, 6, 5, 7, 4, 5, 5, 6, 7,
	1, 1, 1, 1, 3, 3, 3, 1, 3, 3,
	3, 3, 3, 1, 2, 1, 2, 2, 2, 2,
	2, 3, 1, 1, 2, 2, 3, 3, 1, 3,
	3, 2, 1, 1, 1, 3, 2, 3, 3, 3,
	1, 1, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 0, 1,
	1, 2, 2, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 3, 4, 4,
}
var exprChk = [...]int{

	-1000, -1, -2, -6, -7, -14, 23, -11, -15, -17,
	-18, 15, -12, -16, 7, 66, 67, 27, 28, 38,
	39, 48, 49, 50, 51, 52, 53, 54, 29, 30,
	33, 31, 32, 34, 35, 36, 37, 57, 58, 59,
	66, 67, 68, 69, 70, 71, 60, 61, 64, 65,
	62, 63, -21, -22, -27, 44, -3, 21, 22, 14,
	61, -7, -6, -2, -10, 2, -9, 5, 23, 23,
	-4, 25, 26, 7, 7, -19, 40, -19, -19, -19,
	-19, -19, -19, -19, -19, -19, -19, -19, -19, -19,
	-19, -22, -3, -20, -26, -28, -29, 41, 43, 42,
	-9, -33, -24, 23, 45, 46, 5, -25, -23, 6,
	24, 24, 16, 2, 19, 16, 12, 61, 13, 14,
	-8, 7, -14, 23, -7, 7, 23, 23, 23, -2,
	-2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
	-2, -2, -2, -2, 6, -26, 58, 19, 57, 6,
	-26, 6, -31, -30, 5, 12, 61, 64, 65, 62,
	63, 60, -9, 6, 6, 6, 6, 2, 24, 19,
	9, -32, -21, 44, -14, -8, 24, 19, -7, -5,
	5, -5, -26, -26, -26, 24, 19, 12, 8, 4,
	7, 8, 4, 7, 8, 4, 7, 8, 4, 7,
	8, 4, 7, 8, 4, 7, 8, 4, 7, -4,
	-8, -32, -21, 9, 44, 9, -32, 47, 24, -32,
	-21, 24, -4, -7, 24, 19, 24, 24, -30, 2,
	5, 6, 24, -32, -26, 9, 5, -13, 55, 56,
	9, 24, 24, -32, 24, 5, -4, 23, -32, 44,
	9, 9, 24, -4, 5, 9, 24,
}
var exprDef = [...]int{

	0, -2, 1, 2, 3, 9, 0, 4, 5, 6,
	7, 0, 0, 0, 120, 0, 0, 132, 133, 134,
	135, 136, 137, 138, 139, 140, 141, 142, 123, 124,
	125, 126, 127, 128, 129, 130, 131, 118, 118, 118,
	118, 118, 118, 118, 118, 118, 118, 118, 118, 118,
	118, 118, 10, 53, 55, 0, 0, 40, 41, 42,
	43, 3, 2, 0, 0, 0, 47, 0, 0, 0,
	0, 0, 0, 121, 122, 0, 119, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 54, 0, 56, 57, 58, 59, 62, 63, 0,
	72, 73, 74, 0, 0, 0, 0, 80, 81, 60,
	8, 11, 44, 45, 0, 46, 0, 0, 0, 0,
	0, 0, 0, 0, 3, 120, 0, 0, 0, 103,
	104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
	114, 115, 116, 117, 61, 76, 0, 0, 0, 64,
	0, 65, 71, 68, 0, 0, 0, 0, 0, 0,
	0, 0, 48, 49, 50, 51, 52, 25, 31, 0,
	12, 0, 0, 0, 0, 0, 35, 0, 3, 0,
	143, 0, 77, 78, 79, 75, 0, 0, 87, 94,
	101, 86, 93, 100, 82, 89, 96, 83, 90, 97,
	84, 91, 98, 85, 92, 99, 88, 95, 102, 33,
	0, 14, 22, 16, 0, 18, 0, 0, 0, 0,
	0, 24, 37, 3, 36, 0, 145, 146, 69, 70,
	66, 67, 32, 23, 28, 20, 26, 0, 29, 30,
	13, 0, 0, 0, 38, 144, 34, 0, 15, 0,
	17, 19, 0, 39, 0, 21, 27,
}
var exprTok1 = [...]int{

	1,
}
var exprTok2 = [...]int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
	62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
}
var exprTok3 = [...]int{
	0,
}

var exprErrorMessages = [...]struct {
	state int
	token int
	msg   string
}{}

//line yaccpar:1

/*	parser for yacc output	*/

var (
	exprDebug        = 0
	exprErrorVerbose = false
)

type exprLexer interface {
	Lex(lval *exprSymType) int
	Error(s string)
}

type exprParser interface {
	Parse(exprLexer) int
	Lookahead() int
}

type exprParserImpl struct {
	lval  exprSymType
	stack [exprInitialStackSize]exprSymType
	char  int
}

func (p *exprParserImpl) Lookahead() int {
	return p.char
}

func exprNewParser() exprParser {
	return &exprParserImpl{}
}

const exprFlag = -1000

func exprTokname(c int) string {
	if c >= 1 && c-1 < len(exprToknames) {
		if exprToknames[c-1] != "" {
			return exprToknames[c-1]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func exprStatname(s int) string {
	if s >= 0 && s < len(exprStatenames) {
		if exprStatenames[s] != "" {
			return exprStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func exprErrorMessage(state, lookAhead int) string {
	const TOKSTART = 4

	if !exprErrorVerbose {
		return "syntax error"
	}

	for _, e := range exprErrorMessages {
		if e.state == state && e.token == lookAhead {
			return "syntax error: " + e.msg
		}
	}

	res := "syntax error: unexpected " + exprTokname(lookAhead)

	// To match Bison, suggest at most four expected tokens.
	expected := make([]int, 0, 4)

	// Look for shiftable tokens.
	base := exprPact[state]
	for tok := TOKSTART; tok-1 < len(exprToknames); tok++ {
		if n := base + tok; n >= 0 && n < exprLast && exprChk[exprAct[n]] == tok {
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}
	}

	if exprDef[state] == -2 {
		i := 0
		for exprExca[i] != -1 || exprExca[i+1] != state {
			i += 2
		}

		// Look for tokens that we accept or reduce.
		for i += 2; exprExca[i] >= 0; i += 2 {
			tok := exprExca[i]
			if tok < TOKSTART || exprExca[i+1] == 0 {
				continue
			}
			if len(expected) == cap(expected) {
				return res
			}
			expected = append(expected, tok)
		}

		// If the default action is to accept or reduce, give up.
		if exprExca[i+1] != 0 {
			return res
		}
	}

	for i, tok := range expected {
		if i == 0 {
			res += ", expecting "
		} else {
			res += " or "
		}
		res += exprTokname(tok)
	}
	return res
}

func exprlex1(lex exprLexer, lval *exprSymType) (char, token int) {
	token = 0
	char = lex.Lex(lval)
	if char <= 0 {
		token = exprTok1[0]
		goto out
	}
	if char < len(exprTok1) {
		token = exprTok1[char]
		goto out
	}
	if char >= exprPrivate {
		if char < exprPrivate+len(exprTok2) {
			token = exprTok2[char-exprPrivate]
			goto out
		}
	}
	for i := 0; i < len(exprTok3); i += 2 {
		token = exprTok3[i+0]
		if token == char {
			token = exprTok3[i+1]
			goto out
		}
	}

out:
	if token == 0 {
		token = exprTok2[1] /* unknown char */
	}
	if exprDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", exprTokname(token), uint(char))
	}
	return char, token
}

func exprParse(exprlex exprLexer) int {
	return exprNewParser().Parse(exprlex)
}

func (exprrcvr *exprParserImpl) Parse(exprlex exprLexer) int {
	var exprn int
	var exprVAL exprSymType
	var exprDollar []exprSymType
	_ = exprDollar // silence set and not used
	exprS := exprrcvr.stack[:]

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	exprstate := 0
	exprrcvr.char = -1
	exprtoken := -1 // exprrcvr.char translated into internal numbering
	defer func() {
		// Make sure we report no lookahead when not parsing.
		exprstate = -1
		exprrcvr.char = -1
		exprtoken = -1
	}()
	exprp := -1
	goto exprstack

ret0:
	return 0

ret1:
	return 1

exprstack:
	/* put a state and value onto the stack */
	if exprDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", exprTokname(exprtoken), exprStatname(exprstate))
	}

	exprp++
	if exprp >= len(exprS) {
		nyys := make([]exprSymType, len(exprS)*2)
		copy(nyys, exprS)
		exprS = nyys
	}
	exprS[exprp] = exprVAL
	exprS[exprp].yys = exprstate

exprnewstate:
	exprn = exprPact[exprstate]
	if exprn <= exprFlag {
		goto exprdefault /* simple state */
	}
	if exprrcvr.char < 0 {
		exprrcvr.char, exprtoken = exprlex1(exprlex, &exprrcvr.lval)
	}
	exprn += exprtoken
	if exprn < 0 || exprn >= exprLast {
		goto exprdefault
	}
	exprn = exprAct[exprn]
	if exprChk[exprn] == exprtoken { /* valid shift */
		exprrcvr.char = -1
		exprtoken = -1
		exprVAL = exprrcvr.lval
		exprstate = exprn
		if Errflag > 0 {
			Errflag--
		}
		goto exprstack
	}

exprdefault:
	/* default state action */
	exprn = exprDef[exprstate]
	if exprn == -2 {
		if exprrcvr.char < 0 {
			exprrcvr.char, exprtoken = exprlex1(exprlex, &exprrcvr.lval)
		}

		/* look through exception table */
		xi := 0
		for {
			if exprExca[xi+0] == -1 && exprExca[xi+1] == exprstate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			exprn = exprExca[xi+0]
			if exprn < 0 || exprn == exprtoken {
				break
			}
		}
		exprn = exprExca[xi+1]
		if exprn < 0 {
			goto ret0
		}
	}
	if exprn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			exprlex.Error(exprErrorMessage(exprstate, exprtoken))
			Nerrs++
			if exprDebug >= 1 {
				__yyfmt__.Printf("%s", exprStatname(exprstate))
				__yyfmt__.Printf(" saw %s\n", exprTokname(exprtoken))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for exprp >= 0 {
				exprn = exprPact[exprS[exprp].yys] + exprErrCode
				if exprn >= 0 && exprn < exprLast {
					exprstate = exprAct[exprn] /* simulate a shift of "error" */
					if exprChk[exprstate] == exprErrCode {
						goto exprstack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if exprDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", exprS[exprp].yys)
				}
				exprp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if exprDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", exprTokname(exprtoken))
			}
			if exprtoken == exprEofCode {
				goto ret1
			}
			exprrcvr.char = -1
			exprtoken = -1
			goto exprnewstate /* try again in the same state */
		}
	}

	/* reduction by production exprn */
	if exprDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", exprn, exprStatname(exprstate))
	}

	exprnt := exprn
	exprpt := exprp
	_ = exprpt // guard against "declared and not used"

	exprp -= exprR2[exprn]
	// exprp is now the index of $0. Perform the default action. Iff the
	// reduced production is ε, $1 is possibly out of range.
	if exprp+1 >= len(exprS) {
		nyys := make([]exprSymType, len(exprS)*2)
		copy(nyys, exprS)
		exprS = nyys
	}
	exprVAL = exprS[exprp+1]

	/* consult goto table to find next state */
	exprn = exprR1[exprn]
	exprg := exprPgo[exprn]
	exprj := exprg + exprS[exprp].yys + 1

	if exprj >= exprLast {
		exprstate = exprAct[exprg]
	} else {
		exprstate = exprAct[exprj]
		if exprChk[exprstate] != -exprn {
			exprstate = exprAct[exprg]
		}
	}
	// dummy call; replaced with literal code
	switch exprnt {

	case 1:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:104
		{
			exprlex.(*lexer).expr = exprDollar[1].Expr
		}
	case 2:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:107
		{
			exprVAL.Expr = exprDollar[1].LogExpr
		}
	case 3:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:108
		{
			exprVAL.Expr = exprDollar[1].MetricExpr
		}
	case 4:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:112
		{
			exprVAL.MetricExpr = exprDollar[1].RangeAggregationExpr
		}
	case 5:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:113
		{
			exprVAL.MetricExpr = exprDollar[1].VectorAggregationExpr
		}
	case 6:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:114
		{
			exprVAL.MetricExpr = exprDollar[1].BinOpExpr
		}
	case 7:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:115
		{
			exprVAL.MetricExpr = exprDollar[1].LiteralExpr
		}
	case 8:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:116
		{
			exprVAL.MetricExpr = exprDollar[2].MetricExpr
		}
	case 9:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:120
		{
			exprVAL.LogExpr = newMatcherExpr(exprDollar[1].Selector)
		}
	case 10:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:121
		{
			exprVAL.LogExpr = newPipelineExpr(newMatcherExpr(exprDollar[1].Selector), exprDollar[2].PipelineExpr)
		}
	case 11:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:122
		{
			exprVAL.LogExpr = exprDollar[2].LogExpr
		}
	case 12:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:126
		{
			exprVAL.LogRangeExpr = newLogRange(newMatcherExpr(exprDollar[1].Selector), exprDollar[2].duration, nil)
		}
	case 13:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:127
		{
			exprVAL.LogRangeExpr = newLogRange(newMatcherExpr(exprDollar[2].Selector), exprDollar[4].duration, nil)
		}
	case 14:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:128
		{
			exprVAL.LogRangeExpr = newLogRange(newMatcherExpr(exprDollar[1].Selector), exprDollar[2].duration, exprDollar[3].UnwrapExpr)
		}
	case 15:
		exprDollar = exprS[exprpt-5 : exprpt+1]
//line pkg/logql/expr.y:129
		{
			exprVAL.LogRangeExpr = newLogRange(newMatcherExpr(exprDollar[2].Selector), exprDollar[4].duration, exprDollar[5].UnwrapExpr)
		}
	case 16:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:130
		{
			exprVAL.LogRangeExpr = newLogRange(newMatcherExpr(exprDollar[1].Selector), exprDollar[3].duration, exprDollar[2].UnwrapExpr)
		}
	case 17:
		exprDollar = exprS[exprpt-5 : exprpt+1]
//line pkg/logql/expr.y:131
		{
			exprVAL.LogRangeExpr = newLogRange(newMatcherExpr(exprDollar[2].Selector), exprDollar[5].duration, exprDollar[3].UnwrapExpr)
		}
	case 18:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:132
		{
			exprVAL.LogRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(exprDollar[1].Selector), exprDollar[2].PipelineExpr), exprDollar[3].duration, nil)
		}
	case 19:
		exprDollar = exprS[exprpt-5 : exprpt+1]
//line pkg/logql/expr.y:133
		{
			exprVAL.LogRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(exprDollar[2].Selector), exprDollar[3].PipelineExpr), exprDollar[5].duration, nil)
		}
	case 20:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:134
		{
			exprVAL.LogRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(exprDollar[1].Selector), exprDollar[2].PipelineExpr), exprDollar[4].duration, exprDollar[3].UnwrapExpr)
		}
	case 21:
		exprDollar = exprS[exprpt-6 : exprpt+1]
//line pkg/logql/expr.y:135
		{
			exprVAL.LogRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(exprDollar[2].Selector), exprDollar[3].PipelineExpr), exprDollar[6].duration, exprDollar[4].UnwrapExpr)
		}
	case 22:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:136
		{
			exprVAL.LogRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(exprDollar[1].Selector), exprDollar[3].PipelineExpr), exprDollar[2].duration, nil)
		}
	case 23:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:137
		{
			exprVAL.LogRangeExpr = newLogRange(newPipelineExpr(newMatcherExpr(exprDollar[1].Selector), exprDollar[3].PipelineExpr), exprDollar[2].duration, exprDollar[4].UnwrapExpr)
		}
	case 24:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:138
		{
			exprVAL.LogRangeExpr = exprDollar[2].LogRangeExpr
		}
	case 26:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:143
		{
			exprVAL.UnwrapExpr = newUnwrapExpr(exprDollar[3].str, "")
		}
	case 27:
		exprDollar = exprS[exprpt-6 : exprpt+1]
//line pkg/logql/expr.y:144
		{
			exprVAL.UnwrapExpr = newUnwrapExpr(exprDollar[5].str, exprDollar[3].ConvOp)
		}
	case 28:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:145
		{
			exprVAL.UnwrapExpr = exprDollar[1].UnwrapExpr.addPostFilter(exprDollar[3].LabelFilter)
		}
	case 29:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:149
		{
			exprVAL.ConvOp = OpConvDuration
		}
	case 30:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:150
		{
			exprVAL.ConvOp = OpConvDurationSeconds
		}
	case 31:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:154
		{
			exprVAL.RangeAggregationExpr = newRangeAggregationExpr(exprDollar[3].LogRangeExpr, exprDollar[1].RangeOp, nil, nil)
		}
	case 32:
		exprDollar = exprS[exprpt-6 : exprpt+1]
//line pkg/logql/expr.y:155
		{
			exprVAL.RangeAggregationExpr = newRangeAggregationExpr(exprDollar[5].LogRangeExpr, exprDollar[1].RangeOp, nil, &exprDollar[3].str)
		}
	case 33:
		exprDollar = exprS[exprpt-5 : exprpt+1]
//line pkg/logql/expr.y:156
		{
			exprVAL.RangeAggregationExpr = newRangeAggregationExpr(exprDollar[3].LogRangeExpr, exprDollar[1].RangeOp, exprDollar[5].Grouping, nil)
		}
	case 34:
		exprDollar = exprS[exprpt-7 : exprpt+1]
//line pkg/logql/expr.y:157
		{
			exprVAL.RangeAggregationExpr = newRangeAggregationExpr(exprDollar[5].LogRangeExpr, exprDollar[1].RangeOp, exprDollar[7].Grouping, &exprDollar[3].str)
		}
	case 35:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:162
		{
			exprVAL.VectorAggregationExpr = mustNewVectorAggregationExpr(exprDollar[3].MetricExpr, exprDollar[1].VectorOp, nil, nil)
		}
	case 36:
		exprDollar = exprS[exprpt-5 : exprpt+1]
//line pkg/logql/expr.y:163
		{
			exprVAL.VectorAggregationExpr = mustNewVectorAggregationExpr(exprDollar[4].MetricExpr, exprDollar[1].VectorOp, exprDollar[2].Grouping, nil)
		}
	case 37:
		exprDollar = exprS[exprpt-5 : exprpt+1]
//line pkg/logql/expr.y:164
		{
			exprVAL.VectorAggregationExpr = mustNewVectorAggregationExpr(exprDollar[3].MetricExpr, exprDollar[1].VectorOp, exprDollar[5].Grouping, nil)
		}
	case 38:
		exprDollar = exprS[exprpt-6 : exprpt+1]
//line pkg/logql/expr.y:166
		{
			exprVAL.VectorAggregationExpr = mustNewVectorAggregationExpr(exprDollar[5].MetricExpr, exprDollar[1].VectorOp, nil, &exprDollar[3].str)
		}
	case 39:
		exprDollar = exprS[exprpt-7 : exprpt+1]
//line pkg/logql/expr.y:167
		{
			exprVAL.VectorAggregationExpr = mustNewVectorAggregationExpr(exprDollar[5].MetricExpr, exprDollar[1].VectorOp, exprDollar[7].Grouping, &exprDollar[3].str)
		}
	case 40:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:171
		{
			exprVAL.Filter = labels.MatchRegexp
		}
	case 41:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:172
		{
			exprVAL.Filter = labels.MatchEqual
		}
	case 42:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:173
		{
			exprVAL.Filter = labels.MatchNotRegexp
		}
	case 43:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:174
		{
			exprVAL.Filter = labels.MatchNotEqual
		}
	case 44:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:178
		{
			exprVAL.Selector = exprDollar[2].Matchers
		}
	case 45:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:179
		{
			exprVAL.Selector = exprDollar[2].Matchers
		}
	case 46:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:180
		{
		}
	case 47:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:184
		{
			exprVAL.Matchers = []*labels.Matcher{exprDollar[1].Matcher}
		}
	case 48:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:185
		{
			exprVAL.Matchers = append(exprDollar[1].Matchers, exprDollar[3].Matcher)
		}
	case 49:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:189
		{
			exprVAL.Matcher = mustNewMatcher(labels.MatchEqual, exprDollar[1].str, exprDollar[3].str)
		}
	case 50:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:190
		{
			exprVAL.Matcher = mustNewMatcher(labels.MatchNotEqual, exprDollar[1].str, exprDollar[3].str)
		}
	case 51:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:191
		{
			exprVAL.Matcher = mustNewMatcher(labels.MatchRegexp, exprDollar[1].str, exprDollar[3].str)
		}
	case 52:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:192
		{
			exprVAL.Matcher = mustNewMatcher(labels.MatchNotRegexp, exprDollar[1].str, exprDollar[3].str)
		}
	case 53:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:196
		{
			exprVAL.PipelineExpr = MultiStageExpr{exprDollar[1].PipelineStage}
		}
	case 54:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:197
		{
			exprVAL.PipelineExpr = append(exprDollar[1].PipelineExpr, exprDollar[2].PipelineStage)
		}
	case 55:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:201
		{
			exprVAL.PipelineStage = exprDollar[1].LineFilters
		}
	case 56:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:202
		{
			exprVAL.PipelineStage = exprDollar[2].LabelParser
		}
	case 57:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:203
		{
			exprVAL.PipelineStage = &labelFilterExpr{LabelFilterer: exprDollar[2].LabelFilter}
		}
	case 58:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:204
		{
			exprVAL.PipelineStage = exprDollar[2].LineFormatExpr
		}
	case 59:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:205
		{
			exprVAL.PipelineStage = exprDollar[2].LabelFormatExpr
		}
	case 60:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:209
		{
			exprVAL.LineFilters = newLineFilterExpr(nil, exprDollar[1].Filter, exprDollar[2].str)
		}
	case 61:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:210
		{
			exprVAL.LineFilters = newLineFilterExpr(exprDollar[1].LineFilters, exprDollar[2].Filter, exprDollar[3].str)
		}
	case 62:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:213
		{
			exprVAL.LabelParser = newLabelParserExpr(OpParserTypeJSON, "")
		}
	case 63:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:214
		{
			exprVAL.LabelParser = newLabelParserExpr(OpParserTypeLogfmt, "")
		}
	case 64:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:215
		{
			exprVAL.LabelParser = newLabelParserExpr(OpParserTypeRegexp, exprDollar[2].str)
		}
	case 65:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:218
		{
			exprVAL.LineFormatExpr = newLineFmtExpr(exprDollar[2].str)
		}
	case 66:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:221
		{
			exprVAL.LabelFormat = log.NewRenameLabelFmt(exprDollar[1].str, exprDollar[3].str)
		}
	case 67:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:222
		{
			exprVAL.LabelFormat = log.NewTemplateLabelFmt(exprDollar[1].str, exprDollar[3].str)
		}
	case 68:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:226
		{
			exprVAL.LabelsFormat = []log.LabelFmt{exprDollar[1].LabelFormat}
		}
	case 69:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:227
		{
			exprVAL.LabelsFormat = append(exprDollar[1].LabelsFormat, exprDollar[3].LabelFormat)
		}
	case 71:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:231
		{
			exprVAL.LabelFormatExpr = newLabelFmtExpr(exprDollar[2].LabelsFormat)
		}
	case 72:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:234
		{
			exprVAL.LabelFilter = log.NewStringLabelFilter(exprDollar[1].Matcher)
		}
	case 73:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:235
		{
			exprVAL.LabelFilter = exprDollar[1].UnitFilter
		}
	case 74:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:236
		{
			exprVAL.LabelFilter = exprDollar[1].NumberFilter
		}
	case 75:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:237
		{
			exprVAL.LabelFilter = exprDollar[2].LabelFilter
		}
	case 76:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:238
		{
			exprVAL.LabelFilter = log.NewAndLabelFilter(exprDollar[1].LabelFilter, exprDollar[2].LabelFilter)
		}
	case 77:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:239
		{
			exprVAL.LabelFilter = log.NewAndLabelFilter(exprDollar[1].LabelFilter, exprDollar[3].LabelFilter)
		}
	case 78:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:240
		{
			exprVAL.LabelFilter = log.NewAndLabelFilter(exprDollar[1].LabelFilter, exprDollar[3].LabelFilter)
		}
	case 79:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:241
		{
			exprVAL.LabelFilter = log.NewOrLabelFilter(exprDollar[1].LabelFilter, exprDollar[3].LabelFilter)
		}
	case 80:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:245
		{
			exprVAL.UnitFilter = exprDollar[1].DurationFilter
		}
	case 81:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:246
		{
			exprVAL.UnitFilter = exprDollar[1].BytesFilter
		}
	case 82:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:249
		{
			exprVAL.DurationFilter = log.NewDurationLabelFilter(log.LabelFilterGreaterThan, exprDollar[1].str, exprDollar[3].duration)
		}
	case 83:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:250
		{
			exprVAL.DurationFilter = log.NewDurationLabelFilter(log.LabelFilterGreaterThanOrEqual, exprDollar[1].str, exprDollar[3].duration)
		}
	case 84:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:251
		{
			exprVAL.DurationFilter = log.NewDurationLabelFilter(log.LabelFilterLesserThan, exprDollar[1].str, exprDollar[3].duration)
		}
	case 85:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:252
		{
			exprVAL.DurationFilter = log.NewDurationLabelFilter(log.LabelFilterLesserThanOrEqual, exprDollar[1].str, exprDollar[3].duration)
		}
	case 86:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:253
		{
			exprVAL.DurationFilter = log.NewDurationLabelFilter(log.LabelFilterNotEqual, exprDollar[1].str, exprDollar[3].duration)
		}
	case 87:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:254
		{
			exprVAL.DurationFilter = log.NewDurationLabelFilter(log.LabelFilterEqual, exprDollar[1].str, exprDollar[3].duration)
		}
	case 88:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:255
		{
			exprVAL.DurationFilter = log.NewDurationLabelFilter(log.LabelFilterEqual, exprDollar[1].str, exprDollar[3].duration)
		}
	case 89:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:259
		{
			exprVAL.BytesFilter = log.NewBytesLabelFilter(log.LabelFilterGreaterThan, exprDollar[1].str, exprDollar[3].bytes)
		}
	case 90:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:260
		{
			exprVAL.BytesFilter = log.NewBytesLabelFilter(log.LabelFilterGreaterThanOrEqual, exprDollar[1].str, exprDollar[3].bytes)
		}
	case 91:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:261
		{
			exprVAL.BytesFilter = log.NewBytesLabelFilter(log.LabelFilterLesserThan, exprDollar[1].str, exprDollar[3].bytes)
		}
	case 92:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:262
		{
			exprVAL.BytesFilter = log.NewBytesLabelFilter(log.LabelFilterLesserThanOrEqual, exprDollar[1].str, exprDollar[3].bytes)
		}
	case 93:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:263
		{
			exprVAL.BytesFilter = log.NewBytesLabelFilter(log.LabelFilterNotEqual, exprDollar[1].str, exprDollar[3].bytes)
		}
	case 94:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:264
		{
			exprVAL.BytesFilter = log.NewBytesLabelFilter(log.LabelFilterEqual, exprDollar[1].str, exprDollar[3].bytes)
		}
	case 95:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:265
		{
			exprVAL.BytesFilter = log.NewBytesLabelFilter(log.LabelFilterEqual, exprDollar[1].str, exprDollar[3].bytes)
		}
	case 96:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:269
		{
			exprVAL.NumberFilter = log.NewNumericLabelFilter(log.LabelFilterGreaterThan, exprDollar[1].str, mustNewFloat(exprDollar[3].str))
		}
	case 97:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:270
		{
			exprVAL.NumberFilter = log.NewNumericLabelFilter(log.LabelFilterGreaterThanOrEqual, exprDollar[1].str, mustNewFloat(exprDollar[3].str))
		}
	case 98:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:271
		{
			exprVAL.NumberFilter = log.NewNumericLabelFilter(log.LabelFilterLesserThan, exprDollar[1].str, mustNewFloat(exprDollar[3].str))
		}
	case 99:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:272
		{
			exprVAL.NumberFilter = log.NewNumericLabelFilter(log.LabelFilterLesserThanOrEqual, exprDollar[1].str, mustNewFloat(exprDollar[3].str))
		}
	case 100:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:273
		{
			exprVAL.NumberFilter = log.NewNumericLabelFilter(log.LabelFilterNotEqual, exprDollar[1].str, mustNewFloat(exprDollar[3].str))
		}
	case 101:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:274
		{
			exprVAL.NumberFilter = log.NewNumericLabelFilter(log.LabelFilterEqual, exprDollar[1].str, mustNewFloat(exprDollar[3].str))
		}
	case 102:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:275
		{
			exprVAL.NumberFilter = log.NewNumericLabelFilter(log.LabelFilterEqual, exprDollar[1].str, mustNewFloat(exprDollar[3].str))
		}
	case 103:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:281
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("or", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 104:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:282
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("and", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 105:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:283
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("unless", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 106:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:284
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("+", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 107:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:285
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("-", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 108:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:286
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("*", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 109:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:287
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("/", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 110:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:288
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("%", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 111:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:289
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("^", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 112:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:290
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("==", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 113:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:291
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("!=", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 114:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:292
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr(">", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 115:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:293
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr(">=", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 116:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:294
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("<", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 117:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:295
		{
			exprVAL.BinOpExpr = mustNewBinOpExpr("<=", exprDollar[3].BinOpModifier, exprDollar[1].Expr, exprDollar[4].Expr)
		}
	case 118:
		exprDollar = exprS[exprpt-0 : exprpt+1]
//line pkg/logql/expr.y:299
		{
			exprVAL.BinOpModifier = BinOpOptions{}
		}
	case 119:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:300
		{
			exprVAL.BinOpModifier = BinOpOptions{ReturnBool: true}
		}
	case 120:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:304
		{
			exprVAL.LiteralExpr = mustNewLiteralExpr(exprDollar[1].str, false)
		}
	case 121:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:305
		{
			exprVAL.LiteralExpr = mustNewLiteralExpr(exprDollar[2].str, false)
		}
	case 122:
		exprDollar = exprS[exprpt-2 : exprpt+1]
//line pkg/logql/expr.y:306
		{
			exprVAL.LiteralExpr = mustNewLiteralExpr(exprDollar[2].str, true)
		}
	case 123:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:310
		{
			exprVAL.VectorOp = OpTypeSum
		}
	case 124:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:311
		{
			exprVAL.VectorOp = OpTypeAvg
		}
	case 125:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:312
		{
			exprVAL.VectorOp = OpTypeCount
		}
	case 126:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:313
		{
			exprVAL.VectorOp = OpTypeMax
		}
	case 127:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:314
		{
			exprVAL.VectorOp = OpTypeMin
		}
	case 128:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:315
		{
			exprVAL.VectorOp = OpTypeStddev
		}
	case 129:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:316
		{
			exprVAL.VectorOp = OpTypeStdvar
		}
	case 130:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:317
		{
			exprVAL.VectorOp = OpTypeBottomK
		}
	case 131:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:318
		{
			exprVAL.VectorOp = OpTypeTopK
		}
	case 132:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:322
		{
			exprVAL.RangeOp = OpRangeTypeCount
		}
	case 133:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:323
		{
			exprVAL.RangeOp = OpRangeTypeRate
		}
	case 134:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:324
		{
			exprVAL.RangeOp = OpRangeTypeBytes
		}
	case 135:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:325
		{
			exprVAL.RangeOp = OpRangeTypeBytesRate
		}
	case 136:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:326
		{
			exprVAL.RangeOp = OpRangeTypeAvg
		}
	case 137:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:327
		{
			exprVAL.RangeOp = OpRangeTypeSum
		}
	case 138:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:328
		{
			exprVAL.RangeOp = OpRangeTypeMin
		}
	case 139:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:329
		{
			exprVAL.RangeOp = OpRangeTypeMax
		}
	case 140:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:330
		{
			exprVAL.RangeOp = OpRangeTypeStdvar
		}
	case 141:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:331
		{
			exprVAL.RangeOp = OpRangeTypeStddev
		}
	case 142:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:332
		{
			exprVAL.RangeOp = OpRangeTypeQuantile
		}
	case 143:
		exprDollar = exprS[exprpt-1 : exprpt+1]
//line pkg/logql/expr.y:337
		{
			exprVAL.Labels = []string{exprDollar[1].str}
		}
	case 144:
		exprDollar = exprS[exprpt-3 : exprpt+1]
//line pkg/logql/expr.y:338
		{
			exprVAL.Labels = append(exprDollar[1].Labels, exprDollar[3].str)
		}
	case 145:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:342
		{
			exprVAL.Grouping = &grouping{without: false, groups: exprDollar[3].Labels}
		}
	case 146:
		exprDollar = exprS[exprpt-4 : exprpt+1]
//line pkg/logql/expr.y:343
		{
			exprVAL.Grouping = &grouping{without: true, groups: exprDollar[3].Labels}
		}
	}
	goto exprstack /* stack new state and value */
}
