import { initializeAgent } from './initialize';
import { mockConfig, MockTransport } from './utils/tests';
describe('agent', () => {
    it(`can be started paused and doesn't ingest events until unpaused`, () => {
        const transport = new MockTransport();
        const config = mockConfig({
            paused: true,
            transports: [transport],
        });
        const agent = initializeAgent(config);
        agent.api.pushLog(['test']);
        expect(transport.items).toHaveLength(0);
        agent.unpause();
        agent.api.pushLog(['test2']);
        expect(transport.items).toHaveLength(1);
        const item = transport.items[0];
        expect(item.payload.message).toEqual('test2');
    });
    it('can be started unpaused, then paused and unpaused again', () => {
        var _a, _b;
        const transport = new MockTransport();
        const config = mockConfig({
            transports: [transport],
        });
        const agent = initializeAgent(config);
        agent.api.pushLog(['test1']);
        expect(transport.items).toHaveLength(1);
        agent.pause();
        agent.api.pushLog(['test2']);
        expect(transport.items).toHaveLength(1);
        agent.unpause();
        agent.api.pushLog(['test3']);
        const items = transport.items;
        expect((_a = items[0]) === null || _a === void 0 ? void 0 : _a.payload.message).toEqual('test1');
        expect((_b = items[1]) === null || _b === void 0 ? void 0 : _b.payload.message).toEqual('test3');
    });
});
//# sourceMappingURL=agent.test.js.map