﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/inspector2/model/ExploitObserved.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Inspector2
{
namespace Model
{

ExploitObserved::ExploitObserved() : 
    m_firstSeenHasBeenSet(false),
    m_lastSeenHasBeenSet(false)
{
}

ExploitObserved::ExploitObserved(JsonView jsonValue) : 
    m_firstSeenHasBeenSet(false),
    m_lastSeenHasBeenSet(false)
{
  *this = jsonValue;
}

ExploitObserved& ExploitObserved::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("firstSeen"))
  {
    m_firstSeen = jsonValue.GetDouble("firstSeen");

    m_firstSeenHasBeenSet = true;
  }

  if(jsonValue.ValueExists("lastSeen"))
  {
    m_lastSeen = jsonValue.GetDouble("lastSeen");

    m_lastSeenHasBeenSet = true;
  }

  return *this;
}

JsonValue ExploitObserved::Jsonize() const
{
  JsonValue payload;

  if(m_firstSeenHasBeenSet)
  {
   payload.WithDouble("firstSeen", m_firstSeen.SecondsWithMSPrecision());
  }

  if(m_lastSeenHasBeenSet)
  {
   payload.WithDouble("lastSeen", m_lastSeen.SecondsWithMSPrecision());
  }

  return payload;
}

} // namespace Model
} // namespace Inspector2
} // namespace Aws
