// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This test is auto generated by: //utils/eigen:convolution

// RUN: bef_executor %s.bef | FileCheck %s --dump-input=always

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 0
  %filter_index   = tfrt.constant.i32 1
  %bias_index     = tfrt.constant.i32 2
  %expected_index = tfrt.constant.i32 3

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 4
  %filter_index   = tfrt.constant.i32 5
  %bias_index     = tfrt.constant.i32 6
  %expected_index = tfrt.constant.i32 7

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 8
  %filter_index   = tfrt.constant.i32 9
  %bias_index     = tfrt.constant.i32 10
  %expected_index = tfrt.constant.i32 11

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 12
  %filter_index   = tfrt.constant.i32 13
  %bias_index     = tfrt.constant.i32 14
  %expected_index = tfrt.constant.i32 15

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 16
  %filter_index   = tfrt.constant.i32 17
  %bias_index     = tfrt.constant.i32 18
  %expected_index = tfrt.constant.i32 19

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 20
  %filter_index   = tfrt.constant.i32 21
  %bias_index     = tfrt.constant.i32 22
  %expected_index = tfrt.constant.i32 23

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 24
  %filter_index   = tfrt.constant.i32 25
  %bias_index     = tfrt.constant.i32 26
  %expected_index = tfrt.constant.i32 27

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 28
  %filter_index   = tfrt.constant.i32 29
  %bias_index     = tfrt.constant.i32 30
  %expected_index = tfrt.constant.i32 31

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 32
  %filter_index   = tfrt.constant.i32 33
  %bias_index     = tfrt.constant.i32 34
  %expected_index = tfrt.constant.i32 35

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 36
  %filter_index   = tfrt.constant.i32 37
  %bias_index     = tfrt.constant.i32 38
  %expected_index = tfrt.constant.i32 39

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 40
  %filter_index   = tfrt.constant.i32 41
  %bias_index     = tfrt.constant.i32 42
  %expected_index = tfrt.constant.i32 43

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 44
  %filter_index   = tfrt.constant.i32 45
  %bias_index     = tfrt.constant.i32 46
  %expected_index = tfrt.constant.i32 47

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 48
  %filter_index   = tfrt.constant.i32 49
  %bias_index     = tfrt.constant.i32 50
  %expected_index = tfrt.constant.i32 51

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 52
  %filter_index   = tfrt.constant.i32 53
  %bias_index     = tfrt.constant.i32 54
  %expected_index = tfrt.constant.i32 55

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 56
  %filter_index   = tfrt.constant.i32 57
  %bias_index     = tfrt.constant.i32 58
  %expected_index = tfrt.constant.i32 59

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 60
  %filter_index   = tfrt.constant.i32 61
  %bias_index     = tfrt.constant.i32 62
  %expected_index = tfrt.constant.i32 63

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 64
  %filter_index   = tfrt.constant.i32 65
  %bias_index     = tfrt.constant.i32 66
  %expected_index = tfrt.constant.i32 67

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 68
  %filter_index   = tfrt.constant.i32 69
  %bias_index     = tfrt.constant.i32 70
  %expected_index = tfrt.constant.i32 71

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 72
  %filter_index   = tfrt.constant.i32 73
  %bias_index     = tfrt.constant.i32 74
  %expected_index = tfrt.constant.i32 75

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 76
  %filter_index   = tfrt.constant.i32 77
  %bias_index     = tfrt.constant.i32 78
  %expected_index = tfrt.constant.i32 79

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 80
  %filter_index   = tfrt.constant.i32 81
  %bias_index     = tfrt.constant.i32 82
  %expected_index = tfrt.constant.i32 83

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 84
  %filter_index   = tfrt.constant.i32 85
  %bias_index     = tfrt.constant.i32 86
  %expected_index = tfrt.constant.i32 87

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 88
  %filter_index   = tfrt.constant.i32 89
  %bias_index     = tfrt.constant.i32 90
  %expected_index = tfrt.constant.i32 91

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 92
  %filter_index   = tfrt.constant.i32 93
  %bias_index     = tfrt.constant.i32 94
  %expected_index = tfrt.constant.i32 95

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 96
  %filter_index   = tfrt.constant.i32 97
  %bias_index     = tfrt.constant.i32 98
  %expected_index = tfrt.constant.i32 99

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 100
  %filter_index   = tfrt.constant.i32 101
  %bias_index     = tfrt.constant.i32 102
  %expected_index = tfrt.constant.i32 103

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 104
  %filter_index   = tfrt.constant.i32 105
  %bias_index     = tfrt.constant.i32 106
  %expected_index = tfrt.constant.i32 107

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 108
  %filter_index   = tfrt.constant.i32 109
  %bias_index     = tfrt.constant.i32 110
  %expected_index = tfrt.constant.i32 111

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 112
  %filter_index   = tfrt.constant.i32 113
  %bias_index     = tfrt.constant.i32 114
  %expected_index = tfrt.constant.i32 115

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 116
  %filter_index   = tfrt.constant.i32 117
  %bias_index     = tfrt.constant.i32 118
  %expected_index = tfrt.constant.i32 119

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 120
  %filter_index   = tfrt.constant.i32 121
  %bias_index     = tfrt.constant.i32 122
  %expected_index = tfrt.constant.i32 123

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 124
  %filter_index   = tfrt.constant.i32 125
  %bias_index     = tfrt.constant.i32 126
  %expected_index = tfrt.constant.i32 127

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 128
  %filter_index   = tfrt.constant.i32 129
  %bias_index     = tfrt.constant.i32 130
  %expected_index = tfrt.constant.i32 131

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 132
  %filter_index   = tfrt.constant.i32 133
  %bias_index     = tfrt.constant.i32 134
  %expected_index = tfrt.constant.i32 135

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 136
  %filter_index   = tfrt.constant.i32 137
  %bias_index     = tfrt.constant.i32 138
  %expected_index = tfrt.constant.i32 139

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 140
  %filter_index   = tfrt.constant.i32 141
  %bias_index     = tfrt.constant.i32 142
  %expected_index = tfrt.constant.i32 143

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 144
  %filter_index   = tfrt.constant.i32 145
  %bias_index     = tfrt.constant.i32 146
  %expected_index = tfrt.constant.i32 147

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 148
  %filter_index   = tfrt.constant.i32 149
  %bias_index     = tfrt.constant.i32 150
  %expected_index = tfrt.constant.i32 151

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 152
  %filter_index   = tfrt.constant.i32 153
  %bias_index     = tfrt.constant.i32 154
  %expected_index = tfrt.constant.i32 155

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 156
  %filter_index   = tfrt.constant.i32 157
  %bias_index     = tfrt.constant.i32 158
  %expected_index = tfrt.constant.i32 159

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 160
  %filter_index   = tfrt.constant.i32 161
  %bias_index     = tfrt.constant.i32 162
  %expected_index = tfrt.constant.i32 163

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 164
  %filter_index   = tfrt.constant.i32 165
  %bias_index     = tfrt.constant.i32 166
  %expected_index = tfrt.constant.i32 167

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 168
  %filter_index   = tfrt.constant.i32 169
  %bias_index     = tfrt.constant.i32 170
  %expected_index = tfrt.constant.i32 171

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 172
  %filter_index   = tfrt.constant.i32 173
  %bias_index     = tfrt.constant.i32 174
  %expected_index = tfrt.constant.i32 175

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 176
  %filter_index   = tfrt.constant.i32 177
  %bias_index     = tfrt.constant.i32 178
  %expected_index = tfrt.constant.i32 179

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 180
  %filter_index   = tfrt.constant.i32 181
  %bias_index     = tfrt.constant.i32 182
  %expected_index = tfrt.constant.i32 183

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 184
  %filter_index   = tfrt.constant.i32 185
  %bias_index     = tfrt.constant.i32 186
  %expected_index = tfrt.constant.i32 187

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 188
  %filter_index   = tfrt.constant.i32 189
  %bias_index     = tfrt.constant.i32 190
  %expected_index = tfrt.constant.i32 191

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 192
  %filter_index   = tfrt.constant.i32 193
  %bias_index     = tfrt.constant.i32 194
  %expected_index = tfrt.constant.i32 195

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 196
  %filter_index   = tfrt.constant.i32 197
  %bias_index     = tfrt.constant.i32 198
  %expected_index = tfrt.constant.i32 199

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 200
  %filter_index   = tfrt.constant.i32 201
  %bias_index     = tfrt.constant.i32 202
  %expected_index = tfrt.constant.i32 203

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 204
  %filter_index   = tfrt.constant.i32 205
  %bias_index     = tfrt.constant.i32 206
  %expected_index = tfrt.constant.i32 207

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 208
  %filter_index   = tfrt.constant.i32 209
  %bias_index     = tfrt.constant.i32 210
  %expected_index = tfrt.constant.i32 211

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 212
  %filter_index   = tfrt.constant.i32 213
  %bias_index     = tfrt.constant.i32 214
  %expected_index = tfrt.constant.i32 215

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 216
  %filter_index   = tfrt.constant.i32 217
  %bias_index     = tfrt.constant.i32 218
  %expected_index = tfrt.constant.i32 219

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 220
  %filter_index   = tfrt.constant.i32 221
  %bias_index     = tfrt.constant.i32 222
  %expected_index = tfrt.constant.i32 223

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 224
  %filter_index   = tfrt.constant.i32 225
  %bias_index     = tfrt.constant.i32 226
  %expected_index = tfrt.constant.i32 227

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 228
  %filter_index   = tfrt.constant.i32 229
  %bias_index     = tfrt.constant.i32 230
  %expected_index = tfrt.constant.i32 231

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 232
  %filter_index   = tfrt.constant.i32 233
  %bias_index     = tfrt.constant.i32 234
  %expected_index = tfrt.constant.i32 235

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 236
  %filter_index   = tfrt.constant.i32 237
  %bias_index     = tfrt.constant.i32 238
  %expected_index = tfrt.constant.i32 239

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 240
  %filter_index   = tfrt.constant.i32 241
  %bias_index     = tfrt.constant.i32 242
  %expected_index = tfrt.constant.i32 243

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 244
  %filter_index   = tfrt.constant.i32 245
  %bias_index     = tfrt.constant.i32 246
  %expected_index = tfrt.constant.i32 247

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 248
  %filter_index   = tfrt.constant.i32 249
  %bias_index     = tfrt.constant.i32 250
  %expected_index = tfrt.constant.i32 251

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 252
  %filter_index   = tfrt.constant.i32 253
  %bias_index     = tfrt.constant.i32 254
  %expected_index = tfrt.constant.i32 255

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 256
  %filter_index   = tfrt.constant.i32 257
  %bias_index     = tfrt.constant.i32 258
  %expected_index = tfrt.constant.i32 259

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 260
  %filter_index   = tfrt.constant.i32 261
  %bias_index     = tfrt.constant.i32 262
  %expected_index = tfrt.constant.i32 263

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 264
  %filter_index   = tfrt.constant.i32 265
  %bias_index     = tfrt.constant.i32 266
  %expected_index = tfrt.constant.i32 267

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 268
  %filter_index   = tfrt.constant.i32 269
  %bias_index     = tfrt.constant.i32 270
  %expected_index = tfrt.constant.i32 271

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 272
  %filter_index   = tfrt.constant.i32 273
  %bias_index     = tfrt.constant.i32 274
  %expected_index = tfrt.constant.i32 275

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 276
  %filter_index   = tfrt.constant.i32 277
  %bias_index     = tfrt.constant.i32 278
  %expected_index = tfrt.constant.i32 279

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 280
  %filter_index   = tfrt.constant.i32 281
  %bias_index     = tfrt.constant.i32 282
  %expected_index = tfrt.constant.i32 283

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 284
  %filter_index   = tfrt.constant.i32 285
  %bias_index     = tfrt.constant.i32 286
  %expected_index = tfrt.constant.i32 287

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 288
  %filter_index   = tfrt.constant.i32 289
  %bias_index     = tfrt.constant.i32 290
  %expected_index = tfrt.constant.i32 291

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 292
  %filter_index   = tfrt.constant.i32 293
  %bias_index     = tfrt.constant.i32 294
  %expected_index = tfrt.constant.i32 295

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 296
  %filter_index   = tfrt.constant.i32 297
  %bias_index     = tfrt.constant.i32 298
  %expected_index = tfrt.constant.i32 299

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 300
  %filter_index   = tfrt.constant.i32 301
  %bias_index     = tfrt.constant.i32 302
  %expected_index = tfrt.constant.i32 303

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 304
  %filter_index   = tfrt.constant.i32 305
  %bias_index     = tfrt.constant.i32 306
  %expected_index = tfrt.constant.i32 307

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 308
  %filter_index   = tfrt.constant.i32 309
  %bias_index     = tfrt.constant.i32 310
  %expected_index = tfrt.constant.i32 311

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 312
  %filter_index   = tfrt.constant.i32 313
  %bias_index     = tfrt.constant.i32 314
  %expected_index = tfrt.constant.i32 315

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 316
  %filter_index   = tfrt.constant.i32 317
  %bias_index     = tfrt.constant.i32 318
  %expected_index = tfrt.constant.i32 319

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 320
  %filter_index   = tfrt.constant.i32 321
  %bias_index     = tfrt.constant.i32 322
  %expected_index = tfrt.constant.i32 323

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 324
  %filter_index   = tfrt.constant.i32 325
  %bias_index     = tfrt.constant.i32 326
  %expected_index = tfrt.constant.i32 327

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 328
  %filter_index   = tfrt.constant.i32 329
  %bias_index     = tfrt.constant.i32 330
  %expected_index = tfrt.constant.i32 331

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 332
  %filter_index   = tfrt.constant.i32 333
  %bias_index     = tfrt.constant.i32 334
  %expected_index = tfrt.constant.i32 335

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 336
  %filter_index   = tfrt.constant.i32 337
  %bias_index     = tfrt.constant.i32 338
  %expected_index = tfrt.constant.i32 339

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 340
  %filter_index   = tfrt.constant.i32 341
  %bias_index     = tfrt.constant.i32 342
  %expected_index = tfrt.constant.i32 343

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 344
  %filter_index   = tfrt.constant.i32 345
  %bias_index     = tfrt.constant.i32 346
  %expected_index = tfrt.constant.i32 347

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 348
  %filter_index   = tfrt.constant.i32 349
  %bias_index     = tfrt.constant.i32 350
  %expected_index = tfrt.constant.i32 351

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 352
  %filter_index   = tfrt.constant.i32 353
  %bias_index     = tfrt.constant.i32 354
  %expected_index = tfrt.constant.i32 355

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 356
  %filter_index   = tfrt.constant.i32 357
  %bias_index     = tfrt.constant.i32 358
  %expected_index = tfrt.constant.i32 359

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 360
  %filter_index   = tfrt.constant.i32 361
  %bias_index     = tfrt.constant.i32 362
  %expected_index = tfrt.constant.i32 363

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 364
  %filter_index   = tfrt.constant.i32 365
  %bias_index     = tfrt.constant.i32 366
  %expected_index = tfrt.constant.i32 367

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 368
  %filter_index   = tfrt.constant.i32 369
  %bias_index     = tfrt.constant.i32 370
  %expected_index = tfrt.constant.i32 371

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 372
  %filter_index   = tfrt.constant.i32 373
  %bias_index     = tfrt.constant.i32 374
  %expected_index = tfrt.constant.i32 375

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 376
  %filter_index   = tfrt.constant.i32 377
  %bias_index     = tfrt.constant.i32 378
  %expected_index = tfrt.constant.i32 379

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x8_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 380
  %filter_index   = tfrt.constant.i32 381
  %bias_index     = tfrt.constant.i32 382
  %expected_index = tfrt.constant.i32 383

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 384
  %filter_index   = tfrt.constant.i32 385
  %bias_index     = tfrt.constant.i32 386
  %expected_index = tfrt.constant.i32 387

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 388
  %filter_index   = tfrt.constant.i32 389
  %bias_index     = tfrt.constant.i32 390
  %expected_index = tfrt.constant.i32 391

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 392
  %filter_index   = tfrt.constant.i32 393
  %bias_index     = tfrt.constant.i32 394
  %expected_index = tfrt.constant.i32 395

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 396
  %filter_index   = tfrt.constant.i32 397
  %bias_index     = tfrt.constant.i32 398
  %expected_index = tfrt.constant.i32 399

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 400
  %filter_index   = tfrt.constant.i32 401
  %bias_index     = tfrt.constant.i32 402
  %expected_index = tfrt.constant.i32 403

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 404
  %filter_index   = tfrt.constant.i32 405
  %bias_index     = tfrt.constant.i32 406
  %expected_index = tfrt.constant.i32 407

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 408
  %filter_index   = tfrt.constant.i32 409
  %bias_index     = tfrt.constant.i32 410
  %expected_index = tfrt.constant.i32 411

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 412
  %filter_index   = tfrt.constant.i32 413
  %bias_index     = tfrt.constant.i32 414
  %expected_index = tfrt.constant.i32 415

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 416
  %filter_index   = tfrt.constant.i32 417
  %bias_index     = tfrt.constant.i32 418
  %expected_index = tfrt.constant.i32 419

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 420
  %filter_index   = tfrt.constant.i32 421
  %bias_index     = tfrt.constant.i32 422
  %expected_index = tfrt.constant.i32 423

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 424
  %filter_index   = tfrt.constant.i32 425
  %bias_index     = tfrt.constant.i32 426
  %expected_index = tfrt.constant.i32 427

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 428
  %filter_index   = tfrt.constant.i32 429
  %bias_index     = tfrt.constant.i32 430
  %expected_index = tfrt.constant.i32 431

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 432
  %filter_index   = tfrt.constant.i32 433
  %bias_index     = tfrt.constant.i32 434
  %expected_index = tfrt.constant.i32 435

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 436
  %filter_index   = tfrt.constant.i32 437
  %bias_index     = tfrt.constant.i32 438
  %expected_index = tfrt.constant.i32 439

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 440
  %filter_index   = tfrt.constant.i32 441
  %bias_index     = tfrt.constant.i32 442
  %expected_index = tfrt.constant.i32 443

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 444
  %filter_index   = tfrt.constant.i32 445
  %bias_index     = tfrt.constant.i32 446
  %expected_index = tfrt.constant.i32 447

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 448
  %filter_index   = tfrt.constant.i32 449
  %bias_index     = tfrt.constant.i32 450
  %expected_index = tfrt.constant.i32 451

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 452
  %filter_index   = tfrt.constant.i32 453
  %bias_index     = tfrt.constant.i32 454
  %expected_index = tfrt.constant.i32 455

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 456
  %filter_index   = tfrt.constant.i32 457
  %bias_index     = tfrt.constant.i32 458
  %expected_index = tfrt.constant.i32 459

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 460
  %filter_index   = tfrt.constant.i32 461
  %bias_index     = tfrt.constant.i32 462
  %expected_index = tfrt.constant.i32 463

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 464
  %filter_index   = tfrt.constant.i32 465
  %bias_index     = tfrt.constant.i32 466
  %expected_index = tfrt.constant.i32 467

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 468
  %filter_index   = tfrt.constant.i32 469
  %bias_index     = tfrt.constant.i32 470
  %expected_index = tfrt.constant.i32 471

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 472
  %filter_index   = tfrt.constant.i32 473
  %bias_index     = tfrt.constant.i32 474
  %expected_index = tfrt.constant.i32 475

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 476
  %filter_index   = tfrt.constant.i32 477
  %bias_index     = tfrt.constant.i32 478
  %expected_index = tfrt.constant.i32 479

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 480
  %filter_index   = tfrt.constant.i32 481
  %bias_index     = tfrt.constant.i32 482
  %expected_index = tfrt.constant.i32 483

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 484
  %filter_index   = tfrt.constant.i32 485
  %bias_index     = tfrt.constant.i32 486
  %expected_index = tfrt.constant.i32 487

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 488
  %filter_index   = tfrt.constant.i32 489
  %bias_index     = tfrt.constant.i32 490
  %expected_index = tfrt.constant.i32 491

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 492
  %filter_index   = tfrt.constant.i32 493
  %bias_index     = tfrt.constant.i32 494
  %expected_index = tfrt.constant.i32 495

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 496
  %filter_index   = tfrt.constant.i32 497
  %bias_index     = tfrt.constant.i32 498
  %expected_index = tfrt.constant.i32 499

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 500
  %filter_index   = tfrt.constant.i32 501
  %bias_index     = tfrt.constant.i32 502
  %expected_index = tfrt.constant.i32 503

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 504
  %filter_index   = tfrt.constant.i32 505
  %bias_index     = tfrt.constant.i32 506
  %expected_index = tfrt.constant.i32 507

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 508
  %filter_index   = tfrt.constant.i32 509
  %bias_index     = tfrt.constant.i32 510
  %expected_index = tfrt.constant.i32 511

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 512
  %filter_index   = tfrt.constant.i32 513
  %bias_index     = tfrt.constant.i32 514
  %expected_index = tfrt.constant.i32 515

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 516
  %filter_index   = tfrt.constant.i32 517
  %bias_index     = tfrt.constant.i32 518
  %expected_index = tfrt.constant.i32 519

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 520
  %filter_index   = tfrt.constant.i32 521
  %bias_index     = tfrt.constant.i32 522
  %expected_index = tfrt.constant.i32 523

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 524
  %filter_index   = tfrt.constant.i32 525
  %bias_index     = tfrt.constant.i32 526
  %expected_index = tfrt.constant.i32 527

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 528
  %filter_index   = tfrt.constant.i32 529
  %bias_index     = tfrt.constant.i32 530
  %expected_index = tfrt.constant.i32 531

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 532
  %filter_index   = tfrt.constant.i32 533
  %bias_index     = tfrt.constant.i32 534
  %expected_index = tfrt.constant.i32 535

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 536
  %filter_index   = tfrt.constant.i32 537
  %bias_index     = tfrt.constant.i32 538
  %expected_index = tfrt.constant.i32 539

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 540
  %filter_index   = tfrt.constant.i32 541
  %bias_index     = tfrt.constant.i32 542
  %expected_index = tfrt.constant.i32 543

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 544
  %filter_index   = tfrt.constant.i32 545
  %bias_index     = tfrt.constant.i32 546
  %expected_index = tfrt.constant.i32 547

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 548
  %filter_index   = tfrt.constant.i32 549
  %bias_index     = tfrt.constant.i32 550
  %expected_index = tfrt.constant.i32 551

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 552
  %filter_index   = tfrt.constant.i32 553
  %bias_index     = tfrt.constant.i32 554
  %expected_index = tfrt.constant.i32 555

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 556
  %filter_index   = tfrt.constant.i32 557
  %bias_index     = tfrt.constant.i32 558
  %expected_index = tfrt.constant.i32 559

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 560
  %filter_index   = tfrt.constant.i32 561
  %bias_index     = tfrt.constant.i32 562
  %expected_index = tfrt.constant.i32 563

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 564
  %filter_index   = tfrt.constant.i32 565
  %bias_index     = tfrt.constant.i32 566
  %expected_index = tfrt.constant.i32 567

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 568
  %filter_index   = tfrt.constant.i32 569
  %bias_index     = tfrt.constant.i32 570
  %expected_index = tfrt.constant.i32 571

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 572
  %filter_index   = tfrt.constant.i32 573
  %bias_index     = tfrt.constant.i32 574
  %expected_index = tfrt.constant.i32 575

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 576
  %filter_index   = tfrt.constant.i32 577
  %bias_index     = tfrt.constant.i32 578
  %expected_index = tfrt.constant.i32 579

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 580
  %filter_index   = tfrt.constant.i32 581
  %bias_index     = tfrt.constant.i32 582
  %expected_index = tfrt.constant.i32 583

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 584
  %filter_index   = tfrt.constant.i32 585
  %bias_index     = tfrt.constant.i32 586
  %expected_index = tfrt.constant.i32 587

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 588
  %filter_index   = tfrt.constant.i32 589
  %bias_index     = tfrt.constant.i32 590
  %expected_index = tfrt.constant.i32 591

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 592
  %filter_index   = tfrt.constant.i32 593
  %bias_index     = tfrt.constant.i32 594
  %expected_index = tfrt.constant.i32 595

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 596
  %filter_index   = tfrt.constant.i32 597
  %bias_index     = tfrt.constant.i32 598
  %expected_index = tfrt.constant.i32 599

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 600
  %filter_index   = tfrt.constant.i32 601
  %bias_index     = tfrt.constant.i32 602
  %expected_index = tfrt.constant.i32 603

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 604
  %filter_index   = tfrt.constant.i32 605
  %bias_index     = tfrt.constant.i32 606
  %expected_index = tfrt.constant.i32 607

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 608
  %filter_index   = tfrt.constant.i32 609
  %bias_index     = tfrt.constant.i32 610
  %expected_index = tfrt.constant.i32 611

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 612
  %filter_index   = tfrt.constant.i32 613
  %bias_index     = tfrt.constant.i32 614
  %expected_index = tfrt.constant.i32 615

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 616
  %filter_index   = tfrt.constant.i32 617
  %bias_index     = tfrt.constant.i32 618
  %expected_index = tfrt.constant.i32 619

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 620
  %filter_index   = tfrt.constant.i32 621
  %bias_index     = tfrt.constant.i32 622
  %expected_index = tfrt.constant.i32 623

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 624
  %filter_index   = tfrt.constant.i32 625
  %bias_index     = tfrt.constant.i32 626
  %expected_index = tfrt.constant.i32 627

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 628
  %filter_index   = tfrt.constant.i32 629
  %bias_index     = tfrt.constant.i32 630
  %expected_index = tfrt.constant.i32 631

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 632
  %filter_index   = tfrt.constant.i32 633
  %bias_index     = tfrt.constant.i32 634
  %expected_index = tfrt.constant.i32 635

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 636
  %filter_index   = tfrt.constant.i32 637
  %bias_index     = tfrt.constant.i32 638
  %expected_index = tfrt.constant.i32 639

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 640
  %filter_index   = tfrt.constant.i32 641
  %bias_index     = tfrt.constant.i32 642
  %expected_index = tfrt.constant.i32 643

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 644
  %filter_index   = tfrt.constant.i32 645
  %bias_index     = tfrt.constant.i32 646
  %expected_index = tfrt.constant.i32 647

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 648
  %filter_index   = tfrt.constant.i32 649
  %bias_index     = tfrt.constant.i32 650
  %expected_index = tfrt.constant.i32 651

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 652
  %filter_index   = tfrt.constant.i32 653
  %bias_index     = tfrt.constant.i32 654
  %expected_index = tfrt.constant.i32 655

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 656
  %filter_index   = tfrt.constant.i32 657
  %bias_index     = tfrt.constant.i32 658
  %expected_index = tfrt.constant.i32 659

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 660
  %filter_index   = tfrt.constant.i32 661
  %bias_index     = tfrt.constant.i32 662
  %expected_index = tfrt.constant.i32 663

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 664
  %filter_index   = tfrt.constant.i32 665
  %bias_index     = tfrt.constant.i32 666
  %expected_index = tfrt.constant.i32 667

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 668
  %filter_index   = tfrt.constant.i32 669
  %bias_index     = tfrt.constant.i32 670
  %expected_index = tfrt.constant.i32 671

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 672
  %filter_index   = tfrt.constant.i32 673
  %bias_index     = tfrt.constant.i32 674
  %expected_index = tfrt.constant.i32 675

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 676
  %filter_index   = tfrt.constant.i32 677
  %bias_index     = tfrt.constant.i32 678
  %expected_index = tfrt.constant.i32 679

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 680
  %filter_index   = tfrt.constant.i32 681
  %bias_index     = tfrt.constant.i32 682
  %expected_index = tfrt.constant.i32 683

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 684
  %filter_index   = tfrt.constant.i32 685
  %bias_index     = tfrt.constant.i32 686
  %expected_index = tfrt.constant.i32 687

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 688
  %filter_index   = tfrt.constant.i32 689
  %bias_index     = tfrt.constant.i32 690
  %expected_index = tfrt.constant.i32 691

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 692
  %filter_index   = tfrt.constant.i32 693
  %bias_index     = tfrt.constant.i32 694
  %expected_index = tfrt.constant.i32 695

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 696
  %filter_index   = tfrt.constant.i32 697
  %bias_index     = tfrt.constant.i32 698
  %expected_index = tfrt.constant.i32 699

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 700
  %filter_index   = tfrt.constant.i32 701
  %bias_index     = tfrt.constant.i32 702
  %expected_index = tfrt.constant.i32 703

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 704
  %filter_index   = tfrt.constant.i32 705
  %bias_index     = tfrt.constant.i32 706
  %expected_index = tfrt.constant.i32 707

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 708
  %filter_index   = tfrt.constant.i32 709
  %bias_index     = tfrt.constant.i32 710
  %expected_index = tfrt.constant.i32 711

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 712
  %filter_index   = tfrt.constant.i32 713
  %bias_index     = tfrt.constant.i32 714
  %expected_index = tfrt.constant.i32 715

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 716
  %filter_index   = tfrt.constant.i32 717
  %bias_index     = tfrt.constant.i32 718
  %expected_index = tfrt.constant.i32 719

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 720
  %filter_index   = tfrt.constant.i32 721
  %bias_index     = tfrt.constant.i32 722
  %expected_index = tfrt.constant.i32 723

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 724
  %filter_index   = tfrt.constant.i32 725
  %bias_index     = tfrt.constant.i32 726
  %expected_index = tfrt.constant.i32 727

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 728
  %filter_index   = tfrt.constant.i32 729
  %bias_index     = tfrt.constant.i32 730
  %expected_index = tfrt.constant.i32 731

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 732
  %filter_index   = tfrt.constant.i32 733
  %bias_index     = tfrt.constant.i32 734
  %expected_index = tfrt.constant.i32 735

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 736
  %filter_index   = tfrt.constant.i32 737
  %bias_index     = tfrt.constant.i32 738
  %expected_index = tfrt.constant.i32 739

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 740
  %filter_index   = tfrt.constant.i32 741
  %bias_index     = tfrt.constant.i32 742
  %expected_index = tfrt.constant.i32 743

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 744
  %filter_index   = tfrt.constant.i32 745
  %bias_index     = tfrt.constant.i32 746
  %expected_index = tfrt.constant.i32 747

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 748
  %filter_index   = tfrt.constant.i32 749
  %bias_index     = tfrt.constant.i32 750
  %expected_index = tfrt.constant.i32 751

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 752
  %filter_index   = tfrt.constant.i32 753
  %bias_index     = tfrt.constant.i32 754
  %expected_index = tfrt.constant.i32 755

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 756
  %filter_index   = tfrt.constant.i32 757
  %bias_index     = tfrt.constant.i32 758
  %expected_index = tfrt.constant.i32 759

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 760
  %filter_index   = tfrt.constant.i32 761
  %bias_index     = tfrt.constant.i32 762
  %expected_index = tfrt.constant.i32 763

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x8_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 764
  %filter_index   = tfrt.constant.i32 765
  %bias_index     = tfrt.constant.i32 766
  %expected_index = tfrt.constant.i32 767

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 768
  %filter_index   = tfrt.constant.i32 769
  %bias_index     = tfrt.constant.i32 770
  %expected_index = tfrt.constant.i32 771

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 772
  %filter_index   = tfrt.constant.i32 773
  %bias_index     = tfrt.constant.i32 774
  %expected_index = tfrt.constant.i32 775

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 776
  %filter_index   = tfrt.constant.i32 777
  %bias_index     = tfrt.constant.i32 778
  %expected_index = tfrt.constant.i32 779

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 780
  %filter_index   = tfrt.constant.i32 781
  %bias_index     = tfrt.constant.i32 782
  %expected_index = tfrt.constant.i32 783

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 784
  %filter_index   = tfrt.constant.i32 785
  %bias_index     = tfrt.constant.i32 786
  %expected_index = tfrt.constant.i32 787

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 788
  %filter_index   = tfrt.constant.i32 789
  %bias_index     = tfrt.constant.i32 790
  %expected_index = tfrt.constant.i32 791

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 792
  %filter_index   = tfrt.constant.i32 793
  %bias_index     = tfrt.constant.i32 794
  %expected_index = tfrt.constant.i32 795

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 796
  %filter_index   = tfrt.constant.i32 797
  %bias_index     = tfrt.constant.i32 798
  %expected_index = tfrt.constant.i32 799

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 800
  %filter_index   = tfrt.constant.i32 801
  %bias_index     = tfrt.constant.i32 802
  %expected_index = tfrt.constant.i32 803

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 804
  %filter_index   = tfrt.constant.i32 805
  %bias_index     = tfrt.constant.i32 806
  %expected_index = tfrt.constant.i32 807

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 808
  %filter_index   = tfrt.constant.i32 809
  %bias_index     = tfrt.constant.i32 810
  %expected_index = tfrt.constant.i32 811

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 812
  %filter_index   = tfrt.constant.i32 813
  %bias_index     = tfrt.constant.i32 814
  %expected_index = tfrt.constant.i32 815

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 816
  %filter_index   = tfrt.constant.i32 817
  %bias_index     = tfrt.constant.i32 818
  %expected_index = tfrt.constant.i32 819

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 820
  %filter_index   = tfrt.constant.i32 821
  %bias_index     = tfrt.constant.i32 822
  %expected_index = tfrt.constant.i32 823

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 824
  %filter_index   = tfrt.constant.i32 825
  %bias_index     = tfrt.constant.i32 826
  %expected_index = tfrt.constant.i32 827

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 828
  %filter_index   = tfrt.constant.i32 829
  %bias_index     = tfrt.constant.i32 830
  %expected_index = tfrt.constant.i32 831

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 832
  %filter_index   = tfrt.constant.i32 833
  %bias_index     = tfrt.constant.i32 834
  %expected_index = tfrt.constant.i32 835

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 836
  %filter_index   = tfrt.constant.i32 837
  %bias_index     = tfrt.constant.i32 838
  %expected_index = tfrt.constant.i32 839

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 840
  %filter_index   = tfrt.constant.i32 841
  %bias_index     = tfrt.constant.i32 842
  %expected_index = tfrt.constant.i32 843

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 844
  %filter_index   = tfrt.constant.i32 845
  %bias_index     = tfrt.constant.i32 846
  %expected_index = tfrt.constant.i32 847

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 848
  %filter_index   = tfrt.constant.i32 849
  %bias_index     = tfrt.constant.i32 850
  %expected_index = tfrt.constant.i32 851

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 852
  %filter_index   = tfrt.constant.i32 853
  %bias_index     = tfrt.constant.i32 854
  %expected_index = tfrt.constant.i32 855

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 856
  %filter_index   = tfrt.constant.i32 857
  %bias_index     = tfrt.constant.i32 858
  %expected_index = tfrt.constant.i32 859

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 860
  %filter_index   = tfrt.constant.i32 861
  %bias_index     = tfrt.constant.i32 862
  %expected_index = tfrt.constant.i32 863

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 864
  %filter_index   = tfrt.constant.i32 865
  %bias_index     = tfrt.constant.i32 866
  %expected_index = tfrt.constant.i32 867

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 868
  %filter_index   = tfrt.constant.i32 869
  %bias_index     = tfrt.constant.i32 870
  %expected_index = tfrt.constant.i32 871

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 872
  %filter_index   = tfrt.constant.i32 873
  %bias_index     = tfrt.constant.i32 874
  %expected_index = tfrt.constant.i32 875

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 876
  %filter_index   = tfrt.constant.i32 877
  %bias_index     = tfrt.constant.i32 878
  %expected_index = tfrt.constant.i32 879

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 880
  %filter_index   = tfrt.constant.i32 881
  %bias_index     = tfrt.constant.i32 882
  %expected_index = tfrt.constant.i32 883

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 884
  %filter_index   = tfrt.constant.i32 885
  %bias_index     = tfrt.constant.i32 886
  %expected_index = tfrt.constant.i32 887

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 888
  %filter_index   = tfrt.constant.i32 889
  %bias_index     = tfrt.constant.i32 890
  %expected_index = tfrt.constant.i32 891

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 892
  %filter_index   = tfrt.constant.i32 893
  %bias_index     = tfrt.constant.i32 894
  %expected_index = tfrt.constant.i32 895

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 896
  %filter_index   = tfrt.constant.i32 897
  %bias_index     = tfrt.constant.i32 898
  %expected_index = tfrt.constant.i32 899

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 900
  %filter_index   = tfrt.constant.i32 901
  %bias_index     = tfrt.constant.i32 902
  %expected_index = tfrt.constant.i32 903

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 904
  %filter_index   = tfrt.constant.i32 905
  %bias_index     = tfrt.constant.i32 906
  %expected_index = tfrt.constant.i32 907

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 908
  %filter_index   = tfrt.constant.i32 909
  %bias_index     = tfrt.constant.i32 910
  %expected_index = tfrt.constant.i32 911

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 912
  %filter_index   = tfrt.constant.i32 913
  %bias_index     = tfrt.constant.i32 914
  %expected_index = tfrt.constant.i32 915

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 916
  %filter_index   = tfrt.constant.i32 917
  %bias_index     = tfrt.constant.i32 918
  %expected_index = tfrt.constant.i32 919

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 920
  %filter_index   = tfrt.constant.i32 921
  %bias_index     = tfrt.constant.i32 922
  %expected_index = tfrt.constant.i32 923

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 924
  %filter_index   = tfrt.constant.i32 925
  %bias_index     = tfrt.constant.i32 926
  %expected_index = tfrt.constant.i32 927

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 928
  %filter_index   = tfrt.constant.i32 929
  %bias_index     = tfrt.constant.i32 930
  %expected_index = tfrt.constant.i32 931

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 932
  %filter_index   = tfrt.constant.i32 933
  %bias_index     = tfrt.constant.i32 934
  %expected_index = tfrt.constant.i32 935

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 936
  %filter_index   = tfrt.constant.i32 937
  %bias_index     = tfrt.constant.i32 938
  %expected_index = tfrt.constant.i32 939

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 940
  %filter_index   = tfrt.constant.i32 941
  %bias_index     = tfrt.constant.i32 942
  %expected_index = tfrt.constant.i32 943

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 944
  %filter_index   = tfrt.constant.i32 945
  %bias_index     = tfrt.constant.i32 946
  %expected_index = tfrt.constant.i32 947

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 948
  %filter_index   = tfrt.constant.i32 949
  %bias_index     = tfrt.constant.i32 950
  %expected_index = tfrt.constant.i32 951

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 952
  %filter_index   = tfrt.constant.i32 953
  %bias_index     = tfrt.constant.i32 954
  %expected_index = tfrt.constant.i32 955

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 956
  %filter_index   = tfrt.constant.i32 957
  %bias_index     = tfrt.constant.i32 958
  %expected_index = tfrt.constant.i32 959

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 960
  %filter_index   = tfrt.constant.i32 961
  %bias_index     = tfrt.constant.i32 962
  %expected_index = tfrt.constant.i32 963

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 964
  %filter_index   = tfrt.constant.i32 965
  %bias_index     = tfrt.constant.i32 966
  %expected_index = tfrt.constant.i32 967

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 968
  %filter_index   = tfrt.constant.i32 969
  %bias_index     = tfrt.constant.i32 970
  %expected_index = tfrt.constant.i32 971

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 972
  %filter_index   = tfrt.constant.i32 973
  %bias_index     = tfrt.constant.i32 974
  %expected_index = tfrt.constant.i32 975

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 976
  %filter_index   = tfrt.constant.i32 977
  %bias_index     = tfrt.constant.i32 978
  %expected_index = tfrt.constant.i32 979

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 980
  %filter_index   = tfrt.constant.i32 981
  %bias_index     = tfrt.constant.i32 982
  %expected_index = tfrt.constant.i32 983

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 984
  %filter_index   = tfrt.constant.i32 985
  %bias_index     = tfrt.constant.i32 986
  %expected_index = tfrt.constant.i32 987

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 988
  %filter_index   = tfrt.constant.i32 989
  %bias_index     = tfrt.constant.i32 990
  %expected_index = tfrt.constant.i32 991

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 992
  %filter_index   = tfrt.constant.i32 993
  %bias_index     = tfrt.constant.i32 994
  %expected_index = tfrt.constant.i32 995

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 996
  %filter_index   = tfrt.constant.i32 997
  %bias_index     = tfrt.constant.i32 998
  %expected_index = tfrt.constant.i32 999

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1000
  %filter_index   = tfrt.constant.i32 1001
  %bias_index     = tfrt.constant.i32 1002
  %expected_index = tfrt.constant.i32 1003

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1004
  %filter_index   = tfrt.constant.i32 1005
  %bias_index     = tfrt.constant.i32 1006
  %expected_index = tfrt.constant.i32 1007

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1008
  %filter_index   = tfrt.constant.i32 1009
  %bias_index     = tfrt.constant.i32 1010
  %expected_index = tfrt.constant.i32 1011

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1012
  %filter_index   = tfrt.constant.i32 1013
  %bias_index     = tfrt.constant.i32 1014
  %expected_index = tfrt.constant.i32 1015

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1016
  %filter_index   = tfrt.constant.i32 1017
  %bias_index     = tfrt.constant.i32 1018
  %expected_index = tfrt.constant.i32 1019

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1020
  %filter_index   = tfrt.constant.i32 1021
  %bias_index     = tfrt.constant.i32 1022
  %expected_index = tfrt.constant.i32 1023

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1024
  %filter_index   = tfrt.constant.i32 1025
  %bias_index     = tfrt.constant.i32 1026
  %expected_index = tfrt.constant.i32 1027

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1028
  %filter_index   = tfrt.constant.i32 1029
  %bias_index     = tfrt.constant.i32 1030
  %expected_index = tfrt.constant.i32 1031

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1032
  %filter_index   = tfrt.constant.i32 1033
  %bias_index     = tfrt.constant.i32 1034
  %expected_index = tfrt.constant.i32 1035

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1036
  %filter_index   = tfrt.constant.i32 1037
  %bias_index     = tfrt.constant.i32 1038
  %expected_index = tfrt.constant.i32 1039

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1040
  %filter_index   = tfrt.constant.i32 1041
  %bias_index     = tfrt.constant.i32 1042
  %expected_index = tfrt.constant.i32 1043

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1044
  %filter_index   = tfrt.constant.i32 1045
  %bias_index     = tfrt.constant.i32 1046
  %expected_index = tfrt.constant.i32 1047

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1048
  %filter_index   = tfrt.constant.i32 1049
  %bias_index     = tfrt.constant.i32 1050
  %expected_index = tfrt.constant.i32 1051

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1052
  %filter_index   = tfrt.constant.i32 1053
  %bias_index     = tfrt.constant.i32 1054
  %expected_index = tfrt.constant.i32 1055

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1056
  %filter_index   = tfrt.constant.i32 1057
  %bias_index     = tfrt.constant.i32 1058
  %expected_index = tfrt.constant.i32 1059

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1060
  %filter_index   = tfrt.constant.i32 1061
  %bias_index     = tfrt.constant.i32 1062
  %expected_index = tfrt.constant.i32 1063

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1064
  %filter_index   = tfrt.constant.i32 1065
  %bias_index     = tfrt.constant.i32 1066
  %expected_index = tfrt.constant.i32 1067

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1068
  %filter_index   = tfrt.constant.i32 1069
  %bias_index     = tfrt.constant.i32 1070
  %expected_index = tfrt.constant.i32 1071

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1072
  %filter_index   = tfrt.constant.i32 1073
  %bias_index     = tfrt.constant.i32 1074
  %expected_index = tfrt.constant.i32 1075

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1076
  %filter_index   = tfrt.constant.i32 1077
  %bias_index     = tfrt.constant.i32 1078
  %expected_index = tfrt.constant.i32 1079

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1080
  %filter_index   = tfrt.constant.i32 1081
  %bias_index     = tfrt.constant.i32 1082
  %expected_index = tfrt.constant.i32 1083

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1084
  %filter_index   = tfrt.constant.i32 1085
  %bias_index     = tfrt.constant.i32 1086
  %expected_index = tfrt.constant.i32 1087

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1088
  %filter_index   = tfrt.constant.i32 1089
  %bias_index     = tfrt.constant.i32 1090
  %expected_index = tfrt.constant.i32 1091

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1092
  %filter_index   = tfrt.constant.i32 1093
  %bias_index     = tfrt.constant.i32 1094
  %expected_index = tfrt.constant.i32 1095

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1096
  %filter_index   = tfrt.constant.i32 1097
  %bias_index     = tfrt.constant.i32 1098
  %expected_index = tfrt.constant.i32 1099

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1100
  %filter_index   = tfrt.constant.i32 1101
  %bias_index     = tfrt.constant.i32 1102
  %expected_index = tfrt.constant.i32 1103

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1104
  %filter_index   = tfrt.constant.i32 1105
  %bias_index     = tfrt.constant.i32 1106
  %expected_index = tfrt.constant.i32 1107

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1108
  %filter_index   = tfrt.constant.i32 1109
  %bias_index     = tfrt.constant.i32 1110
  %expected_index = tfrt.constant.i32 1111

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1112
  %filter_index   = tfrt.constant.i32 1113
  %bias_index     = tfrt.constant.i32 1114
  %expected_index = tfrt.constant.i32 1115

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1116
  %filter_index   = tfrt.constant.i32 1117
  %bias_index     = tfrt.constant.i32 1118
  %expected_index = tfrt.constant.i32 1119

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1120
  %filter_index   = tfrt.constant.i32 1121
  %bias_index     = tfrt.constant.i32 1122
  %expected_index = tfrt.constant.i32 1123

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1124
  %filter_index   = tfrt.constant.i32 1125
  %bias_index     = tfrt.constant.i32 1126
  %expected_index = tfrt.constant.i32 1127

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1128
  %filter_index   = tfrt.constant.i32 1129
  %bias_index     = tfrt.constant.i32 1130
  %expected_index = tfrt.constant.i32 1131

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1132
  %filter_index   = tfrt.constant.i32 1133
  %bias_index     = tfrt.constant.i32 1134
  %expected_index = tfrt.constant.i32 1135

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1136
  %filter_index   = tfrt.constant.i32 1137
  %bias_index     = tfrt.constant.i32 1138
  %expected_index = tfrt.constant.i32 1139

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1140
  %filter_index   = tfrt.constant.i32 1141
  %bias_index     = tfrt.constant.i32 1142
  %expected_index = tfrt.constant.i32 1143

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1144
  %filter_index   = tfrt.constant.i32 1145
  %bias_index     = tfrt.constant.i32 1146
  %expected_index = tfrt.constant.i32 1147

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x8_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1148
  %filter_index   = tfrt.constant.i32 1149
  %bias_index     = tfrt.constant.i32 1150
  %expected_index = tfrt.constant.i32 1151

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1152
  %filter_index   = tfrt.constant.i32 1153
  %bias_index     = tfrt.constant.i32 1154
  %expected_index = tfrt.constant.i32 1155

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1156
  %filter_index   = tfrt.constant.i32 1157
  %bias_index     = tfrt.constant.i32 1158
  %expected_index = tfrt.constant.i32 1159

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1160
  %filter_index   = tfrt.constant.i32 1161
  %bias_index     = tfrt.constant.i32 1162
  %expected_index = tfrt.constant.i32 1163

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1164
  %filter_index   = tfrt.constant.i32 1165
  %bias_index     = tfrt.constant.i32 1166
  %expected_index = tfrt.constant.i32 1167

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1168
  %filter_index   = tfrt.constant.i32 1169
  %bias_index     = tfrt.constant.i32 1170
  %expected_index = tfrt.constant.i32 1171

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1172
  %filter_index   = tfrt.constant.i32 1173
  %bias_index     = tfrt.constant.i32 1174
  %expected_index = tfrt.constant.i32 1175

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1176
  %filter_index   = tfrt.constant.i32 1177
  %bias_index     = tfrt.constant.i32 1178
  %expected_index = tfrt.constant.i32 1179

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1180
  %filter_index   = tfrt.constant.i32 1181
  %bias_index     = tfrt.constant.i32 1182
  %expected_index = tfrt.constant.i32 1183

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1184
  %filter_index   = tfrt.constant.i32 1185
  %bias_index     = tfrt.constant.i32 1186
  %expected_index = tfrt.constant.i32 1187

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1188
  %filter_index   = tfrt.constant.i32 1189
  %bias_index     = tfrt.constant.i32 1190
  %expected_index = tfrt.constant.i32 1191

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1192
  %filter_index   = tfrt.constant.i32 1193
  %bias_index     = tfrt.constant.i32 1194
  %expected_index = tfrt.constant.i32 1195

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1196
  %filter_index   = tfrt.constant.i32 1197
  %bias_index     = tfrt.constant.i32 1198
  %expected_index = tfrt.constant.i32 1199

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1200
  %filter_index   = tfrt.constant.i32 1201
  %bias_index     = tfrt.constant.i32 1202
  %expected_index = tfrt.constant.i32 1203

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1204
  %filter_index   = tfrt.constant.i32 1205
  %bias_index     = tfrt.constant.i32 1206
  %expected_index = tfrt.constant.i32 1207

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1208
  %filter_index   = tfrt.constant.i32 1209
  %bias_index     = tfrt.constant.i32 1210
  %expected_index = tfrt.constant.i32 1211

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1212
  %filter_index   = tfrt.constant.i32 1213
  %bias_index     = tfrt.constant.i32 1214
  %expected_index = tfrt.constant.i32 1215

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1216
  %filter_index   = tfrt.constant.i32 1217
  %bias_index     = tfrt.constant.i32 1218
  %expected_index = tfrt.constant.i32 1219

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1220
  %filter_index   = tfrt.constant.i32 1221
  %bias_index     = tfrt.constant.i32 1222
  %expected_index = tfrt.constant.i32 1223

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1224
  %filter_index   = tfrt.constant.i32 1225
  %bias_index     = tfrt.constant.i32 1226
  %expected_index = tfrt.constant.i32 1227

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1228
  %filter_index   = tfrt.constant.i32 1229
  %bias_index     = tfrt.constant.i32 1230
  %expected_index = tfrt.constant.i32 1231

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1232
  %filter_index   = tfrt.constant.i32 1233
  %bias_index     = tfrt.constant.i32 1234
  %expected_index = tfrt.constant.i32 1235

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1236
  %filter_index   = tfrt.constant.i32 1237
  %bias_index     = tfrt.constant.i32 1238
  %expected_index = tfrt.constant.i32 1239

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1240
  %filter_index   = tfrt.constant.i32 1241
  %bias_index     = tfrt.constant.i32 1242
  %expected_index = tfrt.constant.i32 1243

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1244
  %filter_index   = tfrt.constant.i32 1245
  %bias_index     = tfrt.constant.i32 1246
  %expected_index = tfrt.constant.i32 1247

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1248
  %filter_index   = tfrt.constant.i32 1249
  %bias_index     = tfrt.constant.i32 1250
  %expected_index = tfrt.constant.i32 1251

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1252
  %filter_index   = tfrt.constant.i32 1253
  %bias_index     = tfrt.constant.i32 1254
  %expected_index = tfrt.constant.i32 1255

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1256
  %filter_index   = tfrt.constant.i32 1257
  %bias_index     = tfrt.constant.i32 1258
  %expected_index = tfrt.constant.i32 1259

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1260
  %filter_index   = tfrt.constant.i32 1261
  %bias_index     = tfrt.constant.i32 1262
  %expected_index = tfrt.constant.i32 1263

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1264
  %filter_index   = tfrt.constant.i32 1265
  %bias_index     = tfrt.constant.i32 1266
  %expected_index = tfrt.constant.i32 1267

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1268
  %filter_index   = tfrt.constant.i32 1269
  %bias_index     = tfrt.constant.i32 1270
  %expected_index = tfrt.constant.i32 1271

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1272
  %filter_index   = tfrt.constant.i32 1273
  %bias_index     = tfrt.constant.i32 1274
  %expected_index = tfrt.constant.i32 1275

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1276
  %filter_index   = tfrt.constant.i32 1277
  %bias_index     = tfrt.constant.i32 1278
  %expected_index = tfrt.constant.i32 1279

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1280
  %filter_index   = tfrt.constant.i32 1281
  %bias_index     = tfrt.constant.i32 1282
  %expected_index = tfrt.constant.i32 1283

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1284
  %filter_index   = tfrt.constant.i32 1285
  %bias_index     = tfrt.constant.i32 1286
  %expected_index = tfrt.constant.i32 1287

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1288
  %filter_index   = tfrt.constant.i32 1289
  %bias_index     = tfrt.constant.i32 1290
  %expected_index = tfrt.constant.i32 1291

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1292
  %filter_index   = tfrt.constant.i32 1293
  %bias_index     = tfrt.constant.i32 1294
  %expected_index = tfrt.constant.i32 1295

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1296
  %filter_index   = tfrt.constant.i32 1297
  %bias_index     = tfrt.constant.i32 1298
  %expected_index = tfrt.constant.i32 1299

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1300
  %filter_index   = tfrt.constant.i32 1301
  %bias_index     = tfrt.constant.i32 1302
  %expected_index = tfrt.constant.i32 1303

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1304
  %filter_index   = tfrt.constant.i32 1305
  %bias_index     = tfrt.constant.i32 1306
  %expected_index = tfrt.constant.i32 1307

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1308
  %filter_index   = tfrt.constant.i32 1309
  %bias_index     = tfrt.constant.i32 1310
  %expected_index = tfrt.constant.i32 1311

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1312
  %filter_index   = tfrt.constant.i32 1313
  %bias_index     = tfrt.constant.i32 1314
  %expected_index = tfrt.constant.i32 1315

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1316
  %filter_index   = tfrt.constant.i32 1317
  %bias_index     = tfrt.constant.i32 1318
  %expected_index = tfrt.constant.i32 1319

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1320
  %filter_index   = tfrt.constant.i32 1321
  %bias_index     = tfrt.constant.i32 1322
  %expected_index = tfrt.constant.i32 1323

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1324
  %filter_index   = tfrt.constant.i32 1325
  %bias_index     = tfrt.constant.i32 1326
  %expected_index = tfrt.constant.i32 1327

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1328
  %filter_index   = tfrt.constant.i32 1329
  %bias_index     = tfrt.constant.i32 1330
  %expected_index = tfrt.constant.i32 1331

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1332
  %filter_index   = tfrt.constant.i32 1333
  %bias_index     = tfrt.constant.i32 1334
  %expected_index = tfrt.constant.i32 1335

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1336
  %filter_index   = tfrt.constant.i32 1337
  %bias_index     = tfrt.constant.i32 1338
  %expected_index = tfrt.constant.i32 1339

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1340
  %filter_index   = tfrt.constant.i32 1341
  %bias_index     = tfrt.constant.i32 1342
  %expected_index = tfrt.constant.i32 1343

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1344
  %filter_index   = tfrt.constant.i32 1345
  %bias_index     = tfrt.constant.i32 1346
  %expected_index = tfrt.constant.i32 1347

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1348
  %filter_index   = tfrt.constant.i32 1349
  %bias_index     = tfrt.constant.i32 1350
  %expected_index = tfrt.constant.i32 1351

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1352
  %filter_index   = tfrt.constant.i32 1353
  %bias_index     = tfrt.constant.i32 1354
  %expected_index = tfrt.constant.i32 1355

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1356
  %filter_index   = tfrt.constant.i32 1357
  %bias_index     = tfrt.constant.i32 1358
  %expected_index = tfrt.constant.i32 1359

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1360
  %filter_index   = tfrt.constant.i32 1361
  %bias_index     = tfrt.constant.i32 1362
  %expected_index = tfrt.constant.i32 1363

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1364
  %filter_index   = tfrt.constant.i32 1365
  %bias_index     = tfrt.constant.i32 1366
  %expected_index = tfrt.constant.i32 1367

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1368
  %filter_index   = tfrt.constant.i32 1369
  %bias_index     = tfrt.constant.i32 1370
  %expected_index = tfrt.constant.i32 1371

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1372
  %filter_index   = tfrt.constant.i32 1373
  %bias_index     = tfrt.constant.i32 1374
  %expected_index = tfrt.constant.i32 1375

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1376
  %filter_index   = tfrt.constant.i32 1377
  %bias_index     = tfrt.constant.i32 1378
  %expected_index = tfrt.constant.i32 1379

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1380
  %filter_index   = tfrt.constant.i32 1381
  %bias_index     = tfrt.constant.i32 1382
  %expected_index = tfrt.constant.i32 1383

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1384
  %filter_index   = tfrt.constant.i32 1385
  %bias_index     = tfrt.constant.i32 1386
  %expected_index = tfrt.constant.i32 1387

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1388
  %filter_index   = tfrt.constant.i32 1389
  %bias_index     = tfrt.constant.i32 1390
  %expected_index = tfrt.constant.i32 1391

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1392
  %filter_index   = tfrt.constant.i32 1393
  %bias_index     = tfrt.constant.i32 1394
  %expected_index = tfrt.constant.i32 1395

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1396
  %filter_index   = tfrt.constant.i32 1397
  %bias_index     = tfrt.constant.i32 1398
  %expected_index = tfrt.constant.i32 1399

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1400
  %filter_index   = tfrt.constant.i32 1401
  %bias_index     = tfrt.constant.i32 1402
  %expected_index = tfrt.constant.i32 1403

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1404
  %filter_index   = tfrt.constant.i32 1405
  %bias_index     = tfrt.constant.i32 1406
  %expected_index = tfrt.constant.i32 1407

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1408
  %filter_index   = tfrt.constant.i32 1409
  %bias_index     = tfrt.constant.i32 1410
  %expected_index = tfrt.constant.i32 1411

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1412
  %filter_index   = tfrt.constant.i32 1413
  %bias_index     = tfrt.constant.i32 1414
  %expected_index = tfrt.constant.i32 1415

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1416
  %filter_index   = tfrt.constant.i32 1417
  %bias_index     = tfrt.constant.i32 1418
  %expected_index = tfrt.constant.i32 1419

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1420
  %filter_index   = tfrt.constant.i32 1421
  %bias_index     = tfrt.constant.i32 1422
  %expected_index = tfrt.constant.i32 1423

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1424
  %filter_index   = tfrt.constant.i32 1425
  %bias_index     = tfrt.constant.i32 1426
  %expected_index = tfrt.constant.i32 1427

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1428
  %filter_index   = tfrt.constant.i32 1429
  %bias_index     = tfrt.constant.i32 1430
  %expected_index = tfrt.constant.i32 1431

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1432
  %filter_index   = tfrt.constant.i32 1433
  %bias_index     = tfrt.constant.i32 1434
  %expected_index = tfrt.constant.i32 1435

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1436
  %filter_index   = tfrt.constant.i32 1437
  %bias_index     = tfrt.constant.i32 1438
  %expected_index = tfrt.constant.i32 1439

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1440
  %filter_index   = tfrt.constant.i32 1441
  %bias_index     = tfrt.constant.i32 1442
  %expected_index = tfrt.constant.i32 1443

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1444
  %filter_index   = tfrt.constant.i32 1445
  %bias_index     = tfrt.constant.i32 1446
  %expected_index = tfrt.constant.i32 1447

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1448
  %filter_index   = tfrt.constant.i32 1449
  %bias_index     = tfrt.constant.i32 1450
  %expected_index = tfrt.constant.i32 1451

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1452
  %filter_index   = tfrt.constant.i32 1453
  %bias_index     = tfrt.constant.i32 1454
  %expected_index = tfrt.constant.i32 1455

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1456
  %filter_index   = tfrt.constant.i32 1457
  %bias_index     = tfrt.constant.i32 1458
  %expected_index = tfrt.constant.i32 1459

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1460
  %filter_index   = tfrt.constant.i32 1461
  %bias_index     = tfrt.constant.i32 1462
  %expected_index = tfrt.constant.i32 1463

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1464
  %filter_index   = tfrt.constant.i32 1465
  %bias_index     = tfrt.constant.i32 1466
  %expected_index = tfrt.constant.i32 1467

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1468
  %filter_index   = tfrt.constant.i32 1469
  %bias_index     = tfrt.constant.i32 1470
  %expected_index = tfrt.constant.i32 1471

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1472
  %filter_index   = tfrt.constant.i32 1473
  %bias_index     = tfrt.constant.i32 1474
  %expected_index = tfrt.constant.i32 1475

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1476
  %filter_index   = tfrt.constant.i32 1477
  %bias_index     = tfrt.constant.i32 1478
  %expected_index = tfrt.constant.i32 1479

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1480
  %filter_index   = tfrt.constant.i32 1481
  %bias_index     = tfrt.constant.i32 1482
  %expected_index = tfrt.constant.i32 1483

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1484
  %filter_index   = tfrt.constant.i32 1485
  %bias_index     = tfrt.constant.i32 1486
  %expected_index = tfrt.constant.i32 1487

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1488
  %filter_index   = tfrt.constant.i32 1489
  %bias_index     = tfrt.constant.i32 1490
  %expected_index = tfrt.constant.i32 1491

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1492
  %filter_index   = tfrt.constant.i32 1493
  %bias_index     = tfrt.constant.i32 1494
  %expected_index = tfrt.constant.i32 1495

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1496
  %filter_index   = tfrt.constant.i32 1497
  %bias_index     = tfrt.constant.i32 1498
  %expected_index = tfrt.constant.i32 1499

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1500
  %filter_index   = tfrt.constant.i32 1501
  %bias_index     = tfrt.constant.i32 1502
  %expected_index = tfrt.constant.i32 1503

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1504
  %filter_index   = tfrt.constant.i32 1505
  %bias_index     = tfrt.constant.i32 1506
  %expected_index = tfrt.constant.i32 1507

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1508
  %filter_index   = tfrt.constant.i32 1509
  %bias_index     = tfrt.constant.i32 1510
  %expected_index = tfrt.constant.i32 1511

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1512
  %filter_index   = tfrt.constant.i32 1513
  %bias_index     = tfrt.constant.i32 1514
  %expected_index = tfrt.constant.i32 1515

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1516
  %filter_index   = tfrt.constant.i32 1517
  %bias_index     = tfrt.constant.i32 1518
  %expected_index = tfrt.constant.i32 1519

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1520
  %filter_index   = tfrt.constant.i32 1521
  %bias_index     = tfrt.constant.i32 1522
  %expected_index = tfrt.constant.i32 1523

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1524
  %filter_index   = tfrt.constant.i32 1525
  %bias_index     = tfrt.constant.i32 1526
  %expected_index = tfrt.constant.i32 1527

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1528
  %filter_index   = tfrt.constant.i32 1529
  %bias_index     = tfrt.constant.i32 1530
  %expected_index = tfrt.constant.i32 1531

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x9x10_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1532
  %filter_index   = tfrt.constant.i32 1533
  %bias_index     = tfrt.constant.i32 1534
  %expected_index = tfrt.constant.i32 1535

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1536
  %filter_index   = tfrt.constant.i32 1537
  %bias_index     = tfrt.constant.i32 1538
  %expected_index = tfrt.constant.i32 1539

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1540
  %filter_index   = tfrt.constant.i32 1541
  %bias_index     = tfrt.constant.i32 1542
  %expected_index = tfrt.constant.i32 1543

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1544
  %filter_index   = tfrt.constant.i32 1545
  %bias_index     = tfrt.constant.i32 1546
  %expected_index = tfrt.constant.i32 1547

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1548
  %filter_index   = tfrt.constant.i32 1549
  %bias_index     = tfrt.constant.i32 1550
  %expected_index = tfrt.constant.i32 1551

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1552
  %filter_index   = tfrt.constant.i32 1553
  %bias_index     = tfrt.constant.i32 1554
  %expected_index = tfrt.constant.i32 1555

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1556
  %filter_index   = tfrt.constant.i32 1557
  %bias_index     = tfrt.constant.i32 1558
  %expected_index = tfrt.constant.i32 1559

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1560
  %filter_index   = tfrt.constant.i32 1561
  %bias_index     = tfrt.constant.i32 1562
  %expected_index = tfrt.constant.i32 1563

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1564
  %filter_index   = tfrt.constant.i32 1565
  %bias_index     = tfrt.constant.i32 1566
  %expected_index = tfrt.constant.i32 1567

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1568
  %filter_index   = tfrt.constant.i32 1569
  %bias_index     = tfrt.constant.i32 1570
  %expected_index = tfrt.constant.i32 1571

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1572
  %filter_index   = tfrt.constant.i32 1573
  %bias_index     = tfrt.constant.i32 1574
  %expected_index = tfrt.constant.i32 1575

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1576
  %filter_index   = tfrt.constant.i32 1577
  %bias_index     = tfrt.constant.i32 1578
  %expected_index = tfrt.constant.i32 1579

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1580
  %filter_index   = tfrt.constant.i32 1581
  %bias_index     = tfrt.constant.i32 1582
  %expected_index = tfrt.constant.i32 1583

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1584
  %filter_index   = tfrt.constant.i32 1585
  %bias_index     = tfrt.constant.i32 1586
  %expected_index = tfrt.constant.i32 1587

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1588
  %filter_index   = tfrt.constant.i32 1589
  %bias_index     = tfrt.constant.i32 1590
  %expected_index = tfrt.constant.i32 1591

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1592
  %filter_index   = tfrt.constant.i32 1593
  %bias_index     = tfrt.constant.i32 1594
  %expected_index = tfrt.constant.i32 1595

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1596
  %filter_index   = tfrt.constant.i32 1597
  %bias_index     = tfrt.constant.i32 1598
  %expected_index = tfrt.constant.i32 1599

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1600
  %filter_index   = tfrt.constant.i32 1601
  %bias_index     = tfrt.constant.i32 1602
  %expected_index = tfrt.constant.i32 1603

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1604
  %filter_index   = tfrt.constant.i32 1605
  %bias_index     = tfrt.constant.i32 1606
  %expected_index = tfrt.constant.i32 1607

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1608
  %filter_index   = tfrt.constant.i32 1609
  %bias_index     = tfrt.constant.i32 1610
  %expected_index = tfrt.constant.i32 1611

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1612
  %filter_index   = tfrt.constant.i32 1613
  %bias_index     = tfrt.constant.i32 1614
  %expected_index = tfrt.constant.i32 1615

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1616
  %filter_index   = tfrt.constant.i32 1617
  %bias_index     = tfrt.constant.i32 1618
  %expected_index = tfrt.constant.i32 1619

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1620
  %filter_index   = tfrt.constant.i32 1621
  %bias_index     = tfrt.constant.i32 1622
  %expected_index = tfrt.constant.i32 1623

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1624
  %filter_index   = tfrt.constant.i32 1625
  %bias_index     = tfrt.constant.i32 1626
  %expected_index = tfrt.constant.i32 1627

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1628
  %filter_index   = tfrt.constant.i32 1629
  %bias_index     = tfrt.constant.i32 1630
  %expected_index = tfrt.constant.i32 1631

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1632
  %filter_index   = tfrt.constant.i32 1633
  %bias_index     = tfrt.constant.i32 1634
  %expected_index = tfrt.constant.i32 1635

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1636
  %filter_index   = tfrt.constant.i32 1637
  %bias_index     = tfrt.constant.i32 1638
  %expected_index = tfrt.constant.i32 1639

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1640
  %filter_index   = tfrt.constant.i32 1641
  %bias_index     = tfrt.constant.i32 1642
  %expected_index = tfrt.constant.i32 1643

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1644
  %filter_index   = tfrt.constant.i32 1645
  %bias_index     = tfrt.constant.i32 1646
  %expected_index = tfrt.constant.i32 1647

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1648
  %filter_index   = tfrt.constant.i32 1649
  %bias_index     = tfrt.constant.i32 1650
  %expected_index = tfrt.constant.i32 1651

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1652
  %filter_index   = tfrt.constant.i32 1653
  %bias_index     = tfrt.constant.i32 1654
  %expected_index = tfrt.constant.i32 1655

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1656
  %filter_index   = tfrt.constant.i32 1657
  %bias_index     = tfrt.constant.i32 1658
  %expected_index = tfrt.constant.i32 1659

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1660
  %filter_index   = tfrt.constant.i32 1661
  %bias_index     = tfrt.constant.i32 1662
  %expected_index = tfrt.constant.i32 1663

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1664
  %filter_index   = tfrt.constant.i32 1665
  %bias_index     = tfrt.constant.i32 1666
  %expected_index = tfrt.constant.i32 1667

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1668
  %filter_index   = tfrt.constant.i32 1669
  %bias_index     = tfrt.constant.i32 1670
  %expected_index = tfrt.constant.i32 1671

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1672
  %filter_index   = tfrt.constant.i32 1673
  %bias_index     = tfrt.constant.i32 1674
  %expected_index = tfrt.constant.i32 1675

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1676
  %filter_index   = tfrt.constant.i32 1677
  %bias_index     = tfrt.constant.i32 1678
  %expected_index = tfrt.constant.i32 1679

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1680
  %filter_index   = tfrt.constant.i32 1681
  %bias_index     = tfrt.constant.i32 1682
  %expected_index = tfrt.constant.i32 1683

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1684
  %filter_index   = tfrt.constant.i32 1685
  %bias_index     = tfrt.constant.i32 1686
  %expected_index = tfrt.constant.i32 1687

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1688
  %filter_index   = tfrt.constant.i32 1689
  %bias_index     = tfrt.constant.i32 1690
  %expected_index = tfrt.constant.i32 1691

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1692
  %filter_index   = tfrt.constant.i32 1693
  %bias_index     = tfrt.constant.i32 1694
  %expected_index = tfrt.constant.i32 1695

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1696
  %filter_index   = tfrt.constant.i32 1697
  %bias_index     = tfrt.constant.i32 1698
  %expected_index = tfrt.constant.i32 1699

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1700
  %filter_index   = tfrt.constant.i32 1701
  %bias_index     = tfrt.constant.i32 1702
  %expected_index = tfrt.constant.i32 1703

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1704
  %filter_index   = tfrt.constant.i32 1705
  %bias_index     = tfrt.constant.i32 1706
  %expected_index = tfrt.constant.i32 1707

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1708
  %filter_index   = tfrt.constant.i32 1709
  %bias_index     = tfrt.constant.i32 1710
  %expected_index = tfrt.constant.i32 1711

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1712
  %filter_index   = tfrt.constant.i32 1713
  %bias_index     = tfrt.constant.i32 1714
  %expected_index = tfrt.constant.i32 1715

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1716
  %filter_index   = tfrt.constant.i32 1717
  %bias_index     = tfrt.constant.i32 1718
  %expected_index = tfrt.constant.i32 1719

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1720
  %filter_index   = tfrt.constant.i32 1721
  %bias_index     = tfrt.constant.i32 1722
  %expected_index = tfrt.constant.i32 1723

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1724
  %filter_index   = tfrt.constant.i32 1725
  %bias_index     = tfrt.constant.i32 1726
  %expected_index = tfrt.constant.i32 1727

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1728
  %filter_index   = tfrt.constant.i32 1729
  %bias_index     = tfrt.constant.i32 1730
  %expected_index = tfrt.constant.i32 1731

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1732
  %filter_index   = tfrt.constant.i32 1733
  %bias_index     = tfrt.constant.i32 1734
  %expected_index = tfrt.constant.i32 1735

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1736
  %filter_index   = tfrt.constant.i32 1737
  %bias_index     = tfrt.constant.i32 1738
  %expected_index = tfrt.constant.i32 1739

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1740
  %filter_index   = tfrt.constant.i32 1741
  %bias_index     = tfrt.constant.i32 1742
  %expected_index = tfrt.constant.i32 1743

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1744
  %filter_index   = tfrt.constant.i32 1745
  %bias_index     = tfrt.constant.i32 1746
  %expected_index = tfrt.constant.i32 1747

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1748
  %filter_index   = tfrt.constant.i32 1749
  %bias_index     = tfrt.constant.i32 1750
  %expected_index = tfrt.constant.i32 1751

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1752
  %filter_index   = tfrt.constant.i32 1753
  %bias_index     = tfrt.constant.i32 1754
  %expected_index = tfrt.constant.i32 1755

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1756
  %filter_index   = tfrt.constant.i32 1757
  %bias_index     = tfrt.constant.i32 1758
  %expected_index = tfrt.constant.i32 1759

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1760
  %filter_index   = tfrt.constant.i32 1761
  %bias_index     = tfrt.constant.i32 1762
  %expected_index = tfrt.constant.i32 1763

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1764
  %filter_index   = tfrt.constant.i32 1765
  %bias_index     = tfrt.constant.i32 1766
  %expected_index = tfrt.constant.i32 1767

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1768
  %filter_index   = tfrt.constant.i32 1769
  %bias_index     = tfrt.constant.i32 1770
  %expected_index = tfrt.constant.i32 1771

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1772
  %filter_index   = tfrt.constant.i32 1773
  %bias_index     = tfrt.constant.i32 1774
  %expected_index = tfrt.constant.i32 1775

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1776
  %filter_index   = tfrt.constant.i32 1777
  %bias_index     = tfrt.constant.i32 1778
  %expected_index = tfrt.constant.i32 1779

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1780
  %filter_index   = tfrt.constant.i32 1781
  %bias_index     = tfrt.constant.i32 1782
  %expected_index = tfrt.constant.i32 1783

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1784
  %filter_index   = tfrt.constant.i32 1785
  %bias_index     = tfrt.constant.i32 1786
  %expected_index = tfrt.constant.i32 1787

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1788
  %filter_index   = tfrt.constant.i32 1789
  %bias_index     = tfrt.constant.i32 1790
  %expected_index = tfrt.constant.i32 1791

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1792
  %filter_index   = tfrt.constant.i32 1793
  %bias_index     = tfrt.constant.i32 1794
  %expected_index = tfrt.constant.i32 1795

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1796
  %filter_index   = tfrt.constant.i32 1797
  %bias_index     = tfrt.constant.i32 1798
  %expected_index = tfrt.constant.i32 1799

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 8 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1800
  %filter_index   = tfrt.constant.i32 1801
  %bias_index     = tfrt.constant.i32 1802
  %expected_index = tfrt.constant.i32 1803

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1804
  %filter_index   = tfrt.constant.i32 1805
  %bias_index     = tfrt.constant.i32 1806
  %expected_index = tfrt.constant.i32 1807

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1808
  %filter_index   = tfrt.constant.i32 1809
  %bias_index     = tfrt.constant.i32 1810
  %expected_index = tfrt.constant.i32 1811

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1812
  %filter_index   = tfrt.constant.i32 1813
  %bias_index     = tfrt.constant.i32 1814
  %expected_index = tfrt.constant.i32 1815

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1816
  %filter_index   = tfrt.constant.i32 1817
  %bias_index     = tfrt.constant.i32 1818
  %expected_index = tfrt.constant.i32 1819

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1820
  %filter_index   = tfrt.constant.i32 1821
  %bias_index     = tfrt.constant.i32 1822
  %expected_index = tfrt.constant.i32 1823

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1824
  %filter_index   = tfrt.constant.i32 1825
  %bias_index     = tfrt.constant.i32 1826
  %expected_index = tfrt.constant.i32 1827

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1828
  %filter_index   = tfrt.constant.i32 1829
  %bias_index     = tfrt.constant.i32 1830
  %expected_index = tfrt.constant.i32 1831

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1832
  %filter_index   = tfrt.constant.i32 1833
  %bias_index     = tfrt.constant.i32 1834
  %expected_index = tfrt.constant.i32 1835

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1836
  %filter_index   = tfrt.constant.i32 1837
  %bias_index     = tfrt.constant.i32 1838
  %expected_index = tfrt.constant.i32 1839

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1840
  %filter_index   = tfrt.constant.i32 1841
  %bias_index     = tfrt.constant.i32 1842
  %expected_index = tfrt.constant.i32 1843

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1844
  %filter_index   = tfrt.constant.i32 1845
  %bias_index     = tfrt.constant.i32 1846
  %expected_index = tfrt.constant.i32 1847

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1848
  %filter_index   = tfrt.constant.i32 1849
  %bias_index     = tfrt.constant.i32 1850
  %expected_index = tfrt.constant.i32 1851

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1852
  %filter_index   = tfrt.constant.i32 1853
  %bias_index     = tfrt.constant.i32 1854
  %expected_index = tfrt.constant.i32 1855

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1856
  %filter_index   = tfrt.constant.i32 1857
  %bias_index     = tfrt.constant.i32 1858
  %expected_index = tfrt.constant.i32 1859

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1860
  %filter_index   = tfrt.constant.i32 1861
  %bias_index     = tfrt.constant.i32 1862
  %expected_index = tfrt.constant.i32 1863

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1864
  %filter_index   = tfrt.constant.i32 1865
  %bias_index     = tfrt.constant.i32 1866
  %expected_index = tfrt.constant.i32 1867

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1868
  %filter_index   = tfrt.constant.i32 1869
  %bias_index     = tfrt.constant.i32 1870
  %expected_index = tfrt.constant.i32 1871

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1872
  %filter_index   = tfrt.constant.i32 1873
  %bias_index     = tfrt.constant.i32 1874
  %expected_index = tfrt.constant.i32 1875

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1876
  %filter_index   = tfrt.constant.i32 1877
  %bias_index     = tfrt.constant.i32 1878
  %expected_index = tfrt.constant.i32 1879

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1880
  %filter_index   = tfrt.constant.i32 1881
  %bias_index     = tfrt.constant.i32 1882
  %expected_index = tfrt.constant.i32 1883

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1884
  %filter_index   = tfrt.constant.i32 1885
  %bias_index     = tfrt.constant.i32 1886
  %expected_index = tfrt.constant.i32 1887

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1888
  %filter_index   = tfrt.constant.i32 1889
  %bias_index     = tfrt.constant.i32 1890
  %expected_index = tfrt.constant.i32 1891

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 6 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1892
  %filter_index   = tfrt.constant.i32 1893
  %bias_index     = tfrt.constant.i32 1894
  %expected_index = tfrt.constant.i32 1895

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1896
  %filter_index   = tfrt.constant.i32 1897
  %bias_index     = tfrt.constant.i32 1898
  %expected_index = tfrt.constant.i32 1899

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 6 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1900
  %filter_index   = tfrt.constant.i32 1901
  %bias_index     = tfrt.constant.i32 1902
  %expected_index = tfrt.constant.i32 1903

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 3 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1904
  %filter_index   = tfrt.constant.i32 1905
  %bias_index     = tfrt.constant.i32 1906
  %expected_index = tfrt.constant.i32 1907

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1908
  %filter_index   = tfrt.constant.i32 1909
  %bias_index     = tfrt.constant.i32 1910
  %expected_index = tfrt.constant.i32 1911

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 9 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1912
  %filter_index   = tfrt.constant.i32 1913
  %bias_index     = tfrt.constant.i32 1914
  %expected_index = tfrt.constant.i32 1915

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x9x7x10_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1916
  %filter_index   = tfrt.constant.i32 1917
  %bias_index     = tfrt.constant.i32 1918
  %expected_index = tfrt.constant.i32 1919

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1920
  %filter_index   = tfrt.constant.i32 1921
  %bias_index     = tfrt.constant.i32 1922
  %expected_index = tfrt.constant.i32 1923

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1924
  %filter_index   = tfrt.constant.i32 1925
  %bias_index     = tfrt.constant.i32 1926
  %expected_index = tfrt.constant.i32 1927

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1928
  %filter_index   = tfrt.constant.i32 1929
  %bias_index     = tfrt.constant.i32 1930
  %expected_index = tfrt.constant.i32 1931

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1932
  %filter_index   = tfrt.constant.i32 1933
  %bias_index     = tfrt.constant.i32 1934
  %expected_index = tfrt.constant.i32 1935

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1936
  %filter_index   = tfrt.constant.i32 1937
  %bias_index     = tfrt.constant.i32 1938
  %expected_index = tfrt.constant.i32 1939

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1940
  %filter_index   = tfrt.constant.i32 1941
  %bias_index     = tfrt.constant.i32 1942
  %expected_index = tfrt.constant.i32 1943

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1944
  %filter_index   = tfrt.constant.i32 1945
  %bias_index     = tfrt.constant.i32 1946
  %expected_index = tfrt.constant.i32 1947

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1948
  %filter_index   = tfrt.constant.i32 1949
  %bias_index     = tfrt.constant.i32 1950
  %expected_index = tfrt.constant.i32 1951

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1952
  %filter_index   = tfrt.constant.i32 1953
  %bias_index     = tfrt.constant.i32 1954
  %expected_index = tfrt.constant.i32 1955

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1956
  %filter_index   = tfrt.constant.i32 1957
  %bias_index     = tfrt.constant.i32 1958
  %expected_index = tfrt.constant.i32 1959

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1960
  %filter_index   = tfrt.constant.i32 1961
  %bias_index     = tfrt.constant.i32 1962
  %expected_index = tfrt.constant.i32 1963

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1964
  %filter_index   = tfrt.constant.i32 1965
  %bias_index     = tfrt.constant.i32 1966
  %expected_index = tfrt.constant.i32 1967

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1968
  %filter_index   = tfrt.constant.i32 1969
  %bias_index     = tfrt.constant.i32 1970
  %expected_index = tfrt.constant.i32 1971

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1972
  %filter_index   = tfrt.constant.i32 1973
  %bias_index     = tfrt.constant.i32 1974
  %expected_index = tfrt.constant.i32 1975

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1976
  %filter_index   = tfrt.constant.i32 1977
  %bias_index     = tfrt.constant.i32 1978
  %expected_index = tfrt.constant.i32 1979

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1980
  %filter_index   = tfrt.constant.i32 1981
  %bias_index     = tfrt.constant.i32 1982
  %expected_index = tfrt.constant.i32 1983

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1984
  %filter_index   = tfrt.constant.i32 1985
  %bias_index     = tfrt.constant.i32 1986
  %expected_index = tfrt.constant.i32 1987

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1988
  %filter_index   = tfrt.constant.i32 1989
  %bias_index     = tfrt.constant.i32 1990
  %expected_index = tfrt.constant.i32 1991

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1992
  %filter_index   = tfrt.constant.i32 1993
  %bias_index     = tfrt.constant.i32 1994
  %expected_index = tfrt.constant.i32 1995

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 1996
  %filter_index   = tfrt.constant.i32 1997
  %bias_index     = tfrt.constant.i32 1998
  %expected_index = tfrt.constant.i32 1999

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2000
  %filter_index   = tfrt.constant.i32 2001
  %bias_index     = tfrt.constant.i32 2002
  %expected_index = tfrt.constant.i32 2003

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2004
  %filter_index   = tfrt.constant.i32 2005
  %bias_index     = tfrt.constant.i32 2006
  %expected_index = tfrt.constant.i32 2007

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2008
  %filter_index   = tfrt.constant.i32 2009
  %bias_index     = tfrt.constant.i32 2010
  %expected_index = tfrt.constant.i32 2011

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_1x1_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2012
  %filter_index   = tfrt.constant.i32 2013
  %bias_index     = tfrt.constant.i32 2014
  %expected_index = tfrt.constant.i32 2015

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2016
  %filter_index   = tfrt.constant.i32 2017
  %bias_index     = tfrt.constant.i32 2018
  %expected_index = tfrt.constant.i32 2019

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2020
  %filter_index   = tfrt.constant.i32 2021
  %bias_index     = tfrt.constant.i32 2022
  %expected_index = tfrt.constant.i32 2023

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2024
  %filter_index   = tfrt.constant.i32 2025
  %bias_index     = tfrt.constant.i32 2026
  %expected_index = tfrt.constant.i32 2027

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2028
  %filter_index   = tfrt.constant.i32 2029
  %bias_index     = tfrt.constant.i32 2030
  %expected_index = tfrt.constant.i32 2031

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2032
  %filter_index   = tfrt.constant.i32 2033
  %bias_index     = tfrt.constant.i32 2034
  %expected_index = tfrt.constant.i32 2035

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2036
  %filter_index   = tfrt.constant.i32 2037
  %bias_index     = tfrt.constant.i32 2038
  %expected_index = tfrt.constant.i32 2039

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2040
  %filter_index   = tfrt.constant.i32 2041
  %bias_index     = tfrt.constant.i32 2042
  %expected_index = tfrt.constant.i32 2043

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2044
  %filter_index   = tfrt.constant.i32 2045
  %bias_index     = tfrt.constant.i32 2046
  %expected_index = tfrt.constant.i32 2047

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2048
  %filter_index   = tfrt.constant.i32 2049
  %bias_index     = tfrt.constant.i32 2050
  %expected_index = tfrt.constant.i32 2051

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2052
  %filter_index   = tfrt.constant.i32 2053
  %bias_index     = tfrt.constant.i32 2054
  %expected_index = tfrt.constant.i32 2055

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2056
  %filter_index   = tfrt.constant.i32 2057
  %bias_index     = tfrt.constant.i32 2058
  %expected_index = tfrt.constant.i32 2059

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2060
  %filter_index   = tfrt.constant.i32 2061
  %bias_index     = tfrt.constant.i32 2062
  %expected_index = tfrt.constant.i32 2063

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2064
  %filter_index   = tfrt.constant.i32 2065
  %bias_index     = tfrt.constant.i32 2066
  %expected_index = tfrt.constant.i32 2067

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2068
  %filter_index   = tfrt.constant.i32 2069
  %bias_index     = tfrt.constant.i32 2070
  %expected_index = tfrt.constant.i32 2071

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2072
  %filter_index   = tfrt.constant.i32 2073
  %bias_index     = tfrt.constant.i32 2074
  %expected_index = tfrt.constant.i32 2075

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2076
  %filter_index   = tfrt.constant.i32 2077
  %bias_index     = tfrt.constant.i32 2078
  %expected_index = tfrt.constant.i32 2079

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2080
  %filter_index   = tfrt.constant.i32 2081
  %bias_index     = tfrt.constant.i32 2082
  %expected_index = tfrt.constant.i32 2083

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2084
  %filter_index   = tfrt.constant.i32 2085
  %bias_index     = tfrt.constant.i32 2086
  %expected_index = tfrt.constant.i32 2087

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2088
  %filter_index   = tfrt.constant.i32 2089
  %bias_index     = tfrt.constant.i32 2090
  %expected_index = tfrt.constant.i32 2091

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2092
  %filter_index   = tfrt.constant.i32 2093
  %bias_index     = tfrt.constant.i32 2094
  %expected_index = tfrt.constant.i32 2095

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2096
  %filter_index   = tfrt.constant.i32 2097
  %bias_index     = tfrt.constant.i32 2098
  %expected_index = tfrt.constant.i32 2099

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2100
  %filter_index   = tfrt.constant.i32 2101
  %bias_index     = tfrt.constant.i32 2102
  %expected_index = tfrt.constant.i32 2103

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2104
  %filter_index   = tfrt.constant.i32 2105
  %bias_index     = tfrt.constant.i32 2106
  %expected_index = tfrt.constant.i32 2107

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2108
  %filter_index   = tfrt.constant.i32 2109
  %bias_index     = tfrt.constant.i32 2110
  %expected_index = tfrt.constant.i32 2111

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2112
  %filter_index   = tfrt.constant.i32 2113
  %bias_index     = tfrt.constant.i32 2114
  %expected_index = tfrt.constant.i32 2115

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2116
  %filter_index   = tfrt.constant.i32 2117
  %bias_index     = tfrt.constant.i32 2118
  %expected_index = tfrt.constant.i32 2119

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2120
  %filter_index   = tfrt.constant.i32 2121
  %bias_index     = tfrt.constant.i32 2122
  %expected_index = tfrt.constant.i32 2123

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2124
  %filter_index   = tfrt.constant.i32 2125
  %bias_index     = tfrt.constant.i32 2126
  %expected_index = tfrt.constant.i32 2127

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2128
  %filter_index   = tfrt.constant.i32 2129
  %bias_index     = tfrt.constant.i32 2130
  %expected_index = tfrt.constant.i32 2131

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2132
  %filter_index   = tfrt.constant.i32 2133
  %bias_index     = tfrt.constant.i32 2134
  %expected_index = tfrt.constant.i32 2135

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2136
  %filter_index   = tfrt.constant.i32 2137
  %bias_index     = tfrt.constant.i32 2138
  %expected_index = tfrt.constant.i32 2139

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2140
  %filter_index   = tfrt.constant.i32 2141
  %bias_index     = tfrt.constant.i32 2142
  %expected_index = tfrt.constant.i32 2143

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2144
  %filter_index   = tfrt.constant.i32 2145
  %bias_index     = tfrt.constant.i32 2146
  %expected_index = tfrt.constant.i32 2147

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2148
  %filter_index   = tfrt.constant.i32 2149
  %bias_index     = tfrt.constant.i32 2150
  %expected_index = tfrt.constant.i32 2151

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2152
  %filter_index   = tfrt.constant.i32 2153
  %bias_index     = tfrt.constant.i32 2154
  %expected_index = tfrt.constant.i32 2155

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2156
  %filter_index   = tfrt.constant.i32 2157
  %bias_index     = tfrt.constant.i32 2158
  %expected_index = tfrt.constant.i32 2159

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2160
  %filter_index   = tfrt.constant.i32 2161
  %bias_index     = tfrt.constant.i32 2162
  %expected_index = tfrt.constant.i32 2163

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2164
  %filter_index   = tfrt.constant.i32 2165
  %bias_index     = tfrt.constant.i32 2166
  %expected_index = tfrt.constant.i32 2167

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2168
  %filter_index   = tfrt.constant.i32 2169
  %bias_index     = tfrt.constant.i32 2170
  %expected_index = tfrt.constant.i32 2171

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2172
  %filter_index   = tfrt.constant.i32 2173
  %bias_index     = tfrt.constant.i32 2174
  %expected_index = tfrt.constant.i32 2175

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2176
  %filter_index   = tfrt.constant.i32 2177
  %bias_index     = tfrt.constant.i32 2178
  %expected_index = tfrt.constant.i32 2179

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2180
  %filter_index   = tfrt.constant.i32 2181
  %bias_index     = tfrt.constant.i32 2182
  %expected_index = tfrt.constant.i32 2183

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 6 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2184
  %filter_index   = tfrt.constant.i32 2185
  %bias_index     = tfrt.constant.i32 2186
  %expected_index = tfrt.constant.i32 2187

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 7 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2188
  %filter_index   = tfrt.constant.i32 2189
  %bias_index     = tfrt.constant.i32 2190
  %expected_index = tfrt.constant.i32 2191

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2192
  %filter_index   = tfrt.constant.i32 2193
  %bias_index     = tfrt.constant.i32 2194
  %expected_index = tfrt.constant.i32 2195

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2196
  %filter_index   = tfrt.constant.i32 2197
  %bias_index     = tfrt.constant.i32 2198
  %expected_index = tfrt.constant.i32 2199

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2200
  %filter_index   = tfrt.constant.i32 2201
  %bias_index     = tfrt.constant.i32 2202
  %expected_index = tfrt.constant.i32 2203

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_2x3_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2204
  %filter_index   = tfrt.constant.i32 2205
  %bias_index     = tfrt.constant.i32 2206
  %expected_index = tfrt.constant.i32 2207

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2208
  %filter_index   = tfrt.constant.i32 2209
  %bias_index     = tfrt.constant.i32 2210
  %expected_index = tfrt.constant.i32 2211

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2212
  %filter_index   = tfrt.constant.i32 2213
  %bias_index     = tfrt.constant.i32 2214
  %expected_index = tfrt.constant.i32 2215

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2216
  %filter_index   = tfrt.constant.i32 2217
  %bias_index     = tfrt.constant.i32 2218
  %expected_index = tfrt.constant.i32 2219

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2220
  %filter_index   = tfrt.constant.i32 2221
  %bias_index     = tfrt.constant.i32 2222
  %expected_index = tfrt.constant.i32 2223

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2224
  %filter_index   = tfrt.constant.i32 2225
  %bias_index     = tfrt.constant.i32 2226
  %expected_index = tfrt.constant.i32 2227

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2228
  %filter_index   = tfrt.constant.i32 2229
  %bias_index     = tfrt.constant.i32 2230
  %expected_index = tfrt.constant.i32 2231

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2232
  %filter_index   = tfrt.constant.i32 2233
  %bias_index     = tfrt.constant.i32 2234
  %expected_index = tfrt.constant.i32 2235

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c4_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2236
  %filter_index   = tfrt.constant.i32 2237
  %bias_index     = tfrt.constant.i32 2238
  %expected_index = tfrt.constant.i32 2239

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 4 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2240
  %filter_index   = tfrt.constant.i32 2241
  %bias_index     = tfrt.constant.i32 2242
  %expected_index = tfrt.constant.i32 2243

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2244
  %filter_index   = tfrt.constant.i32 2245
  %bias_index     = tfrt.constant.i32 2246
  %expected_index = tfrt.constant.i32 2247

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2248
  %filter_index   = tfrt.constant.i32 2249
  %bias_index     = tfrt.constant.i32 2250
  %expected_index = tfrt.constant.i32 2251

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2252
  %filter_index   = tfrt.constant.i32 2253
  %bias_index     = tfrt.constant.i32 2254
  %expected_index = tfrt.constant.i32 2255

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2256
  %filter_index   = tfrt.constant.i32 2257
  %bias_index     = tfrt.constant.i32 2258
  %expected_index = tfrt.constant.i32 2259

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2260
  %filter_index   = tfrt.constant.i32 2261
  %bias_index     = tfrt.constant.i32 2262
  %expected_index = tfrt.constant.i32 2263

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2264
  %filter_index   = tfrt.constant.i32 2265
  %bias_index     = tfrt.constant.i32 2266
  %expected_index = tfrt.constant.i32 2267

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c8_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2268
  %filter_index   = tfrt.constant.i32 2269
  %bias_index     = tfrt.constant.i32 2270
  %expected_index = tfrt.constant.i32 2271

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 8 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2272
  %filter_index   = tfrt.constant.i32 2273
  %bias_index     = tfrt.constant.i32 2274
  %expected_index = tfrt.constant.i32 2275

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2276
  %filter_index   = tfrt.constant.i32 2277
  %bias_index     = tfrt.constant.i32 2278
  %expected_index = tfrt.constant.i32 2279

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 5 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2280
  %filter_index   = tfrt.constant.i32 2281
  %bias_index     = tfrt.constant.i32 2282
  %expected_index = tfrt.constant.i32 2283

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 8 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_valid_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2284
  %filter_index   = tfrt.constant.i32 2285
  %bias_index     = tfrt.constant.i32 2286
  %expected_index = tfrt.constant.i32 2287

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 3 : i64, 4 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "valid",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_1x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_1x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2288
  %filter_index   = tfrt.constant.i32 2289
  %bias_index     = tfrt.constant.i32 2290
  %expected_index = tfrt.constant.i32 2291

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_1x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_1x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2292
  %filter_index   = tfrt.constant.i32 2293
  %bias_index     = tfrt.constant.i32 2294
  %expected_index = tfrt.constant.i32 2295

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 7 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [1 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_2x1'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_2x1() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2296
  %filter_index   = tfrt.constant.i32 2297
  %bias_index     = tfrt.constant.i32 2298
  %expected_index = tfrt.constant.i32 2299

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 9 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 1 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}

// CHECK-LABEL: --- Running 'test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_2x2'
func.func @test_conv2d_in_1x7x9x10_f_3x2_c10_padding_same_s_2x2() {
  %ch0 = tfrt.new.chain

  %path = "tfrt_test.get_string"() {
      value = "backends/common/mlir_tests/compat/eigen/test_data/conv2d_bias_f32.btf"
  } : () -> !tfrt.string

  %input_index    = tfrt.constant.i32 2300
  %filter_index   = tfrt.constant.i32 2301
  %bias_index     = tfrt.constant.i32 2302
  %expected_index = tfrt.constant.i32 2303

  %input = "btf.read_dense_tensor.f32.4"(%path, %input_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %filter = "btf.read_dense_tensor.f32.4"(%path, %filter_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %bias = "btf.read_dense_tensor.f32.1"(%path, %bias_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %expected = "btf.read_dense_tensor.f32.4"(%path, %expected_index)
    : (!tfrt.string, i32) -> (!t.tensor)

  %output = "tfrt_dht.create_uninitialized_tensor.f32.4"()
    { shape = [1 : i64, 4 : i64, 5 : i64, 10 : i64] }
    : () -> !t.tensor

  %ch2 = "eigen.conv2d.bias.f32"(%input, %filter, %bias, %output, %ch0)
    { padding = "same",  strides = [2 : i64, 2 : i64] }
    : (!t.tensor, !t.tensor, !t.tensor,
       !t.tensor, !tfrt.chain) -> !tfrt.chain

  %cmp, %ch3 = "tfrt_dht.tensor_allclose.3ulp.f32"(%expected, %output, %ch2)
    : (!t.tensor, !t.tensor, !tfrt.chain) -> (i1, !tfrt.chain)

  // CHECK: int1 = 1
  tfrt.print.i1 %cmp, %ch2

  tfrt.return
}
