// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_ESSL_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

std::ostream &operator<<(std::ostream &os, const sh::ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {3019, 1118, 3223, 1568, 1798, 3245, 1559, 3376, 2226, 1798,
                              2620, 1473, 3337, 3219, 2102, 3002, 738,  200,  1868, 1223,
                              3043, 1978, 169,  2910, 2392, 1025, 2508, 1820, 2346, 1327,
                              2178, 2161, 3049, 2557, 1035, 2352, 2994, 737,  2654, 1355};
constexpr int mangledkT2[] = {636,  476,  59,   2516, 2477, 1705, 1379, 862,  2286, 3305,
                              1088, 1317, 2329, 1813, 2096, 912,  1320, 860,  1960, 1317,
                              2313, 3371, 1402, 2011, 1445, 2703, 1237, 2629, 2853, 427,
                              379,  2302, 557,  1933, 1117, 360,  307,  812,  733,  887};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1519, 0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    427,  0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    112,  0,    975,  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    1198, 0,    1468, 0,    0,    0,    1061, 0,    0,    0,    0,
    2205, 418,  0,    0,    0,    188,  0,    0,    0,    0,    0,    0,    0,    0,    2924, 2735,
    0,    0,    0,    0,    0,    1028, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    1969, 0,    0,    3121, 633,  0,    0,    0,    552,  0,    0,    0,    0,    1891, 0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    523,  2938, 492,  1190, 3362, 0,    0,
    0,    0,    494,  0,    0,    0,    0,    0,    0,    0,    0,    0,    1534, 0,    1160, 0,
    0,    1379, 520,  0,    0,    0,    0,    0,    592,  0,    3361, 0,    0,    0,    0,    2809,
    657,  798,  0,    217,  0,    3149, 0,    0,    1034, 0,    1856, 0,    0,    0,    3343, 0,
    0,    808,  0,    0,    0,    0,    1326, 0,    0,    1239, 0,    0,    0,    0,    0,    262,
    0,    494,  0,    0,    0,    0,    0,    2128, 0,    2399, 0,    2001, 0,    0,    1266, 699,
    0,    3011, 0,    0,    0,    0,    0,    0,    0,    1591, 0,    0,    0,    351,  0,    0,
    0,    0,    0,    1142, 0,    0,    79,   205,  0,    0,    0,    310,  405,  2406, 0,    0,
    3218, 0,    1960, 0,    0,    0,    0,    1605, 0,    3203, 0,    0,    0,    0,    0,    860,
    0,    0,    0,    1444, 0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    24,   0,    2725, 0,    0,    0,    0,    0,    0,    0,    1018, 0,    0,    0,    0,    0,
    0,    0,    2477, 1492, 0,    0,    0,    0,    0,    0,    462,  0,    0,    0,    0,    314,
    0,    0,    0,    0,    3367, 0,    0,    0,    1266, 0,    1797, 0,    797,  0,    0,    0,
    0,    0,    0,    0,    3106, 0,    0,    0,    227,  0,    0,    310,  855,  2245, 0,    3189,
    67,   0,    0,    0,    0,    0,    506,  0,    0,    0,    0,    0,    0,    1172, 0,    0,
    858,  0,    0,    2470, 0,    520,  0,    0,    511,  1805, 0,    1476, 3075, 0,    1434, 1226,
    0,    0,    356,  99,   0,    0,    2765, 0,    0,    0,    0,    753,  0,    255,  0,    900,
    1508, 0,    215,  0,    1244, 0,    3179, 1275, 0,    0,    0,    0,    0,    0,    3146, 0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    570,  0,    1438, 0,    0,    0,
    0,    2085, 0,    0,    0,    850,  140,  0,    0,    2869, 0,    0,    0,    0,    0,    0,
    869,  0,    0,    0,    0,    0,    0,    0,    0,    794,  115,  0,    0,    0,    0,    0,
    75,   0,    3223, 0,    0,    2643, 0,    0,    0,    2926, 0,    0,    0,    1566, 0,    3272,
    0,    0,    0,    0,    1305, 1452, 0,    0,    0,    3223, 288,  0,    0,    290,  2536, 114,
    0,    531,  0,    3249, 452,  2164, 0,    752,  0,    0,    0,    37,   440,  0,    0,    97,
    1237, 28,   0,    3302, 0,    2993, 0,    0,    499,  0,    0,    0,    254,  2056, 0,    0,
    303,  0,    0,    0,    2959, 1731, 0,    0,    2403, 0,    152,  535,  210,  0,    0,    0,
    0,    0,    0,    2153, 0,    68,   0,    0,    3370, 0,    1742, 0,    0,    0,    0,    0,
    0,    0,    0,    287,  520,  0,    0,    0,    387,  3143, 0,    0,    685,  0,    471,  0,
    0,    1244, 0,    0,    636,  0,    2932, 2209, 0,    840,  118,  0,    0,    194,  0,    0,
    0,    0,    0,    0,    0,    704,  416,  0,    0,    2650, 0,    1464, 485,  0,    0,    0,
    1211, 2937, 3353, 0,    3202, 1285, 0,    0,    3121, 0,    0,    784,  363,  1100, 1192, 0,
    0,    0,    0,    0,    3324, 3109, 2628, 2261, 0,    711,  0,    1769, 0,    0,    2208, 2435,
    165,  770,  91,   664,  0,    2900, 0,    0,    0,    0,    0,    0,    0,    2712, 2568, 2859,
    823,  8,    659,  0,    2912, 0,    944,  1913, 899,  170,  755,  0,    0,    0,    0,    2987,
    0,    0,    0,    0,    0,    0,    0,    0,    1450, 1493, 0,    0,    0,    0,    102,  609,
    161,  565,  0,    3170, 0,    0,    3119, 889,  0,    0,    0,    3063, 0,    0,    872,  0,
    0,    0,    0,    0,    1082, 870,  1330, 273,  1254, 0,    0,    2772, 0,    0,    0,    746,
    1999, 2083, 0,    0,    1018, 0,    2880, 0,    2714, 0,    1084, 0,    2916, 0,    0,    2892,
    0,    0,    0,    0,    768,  0,    0,    0,    0,    1230, 1064, 1491, 50,   455,  0,    678,
    0,    0,    1190, 0,    289,  0,    0,    616,  0,    0,    386,  0,    3131, 0,    1720, 0,
    23,   295,  0,    0,    218,  0,    326,  666,  2008, 0,    369,  0,    0,    0,    2760, 799,
    390,  0,    0,    1112, 595,  0,    0,    0,    0,    0,    24,   0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    2964, 0,    0,    93,   0,    1258,
    1357, 26,   1684, 3053, 0,    2856, 0,    680,  0,    0,    0,    0,    3123, 842,  3342, 3132,
    0,    0,    149,  2710, 0,    0,    0,    613,  0,    0,    0,    0,    1577, 0,    0,    3201,
    0,    0,    0,    715,  354,  0,    0,    11,   2162, 983,  0,    2857, 0,    1313, 27,   491,
    1995, 0,    2067, 0,    0,    0,    654,  0,    0,    1668, 915,  312,  724,  0,    0,    221,
    2976, 0,    245,  543,  0,    0,    0,    0,    0,    369,  0,    1152, 1394, 0,    0,    0,
    0,    1466, 0,    1364, 0,    0,    21,   423,  0,    333,  0,    374,  248,  2903, 0,    1463,
    0,    1028, 0,    3283, 1489, 1314, 0,    2769, 0,    0,    0,    316,  135,  0,    907,  0,
    3005, 0,    829,  1332, 146,  0,    38,   168,  0,    0,    0,    0,    0,    1179, 0,    0,
    0,    0,    2167, 1840, 0,    846,  0,    0,    0,    2680, 540,  0,    0,    0,    643,  0,
    0,    361,  0,    0,    0,    3381, 0,    0,    0,    0,    3038, 0,    0,    0,    864,  0,
    0,    0,    894,  2129, 0,    0,    0,    1416, 0,    617,  0,    0,    204,  673,  0,    2874,
    0,    279,  0,    2704, 0,    2012, 0,    0,    393,  1042, 0,    1122, 2966, 172,  364,  0,
    801,  1289, 0,    1437, 0,    1215, 0,    1639, 0,    0,    3358, 978,  519,  2030, 0,    0,
    704,  0,    0,    502,  0,    2746, 436,  1499, 0,    822,  0,    0,    1618, 0,    2669, 2693,
    1111, 1980, 0,    695,  0,    0,    0,    0,    0,    0,    0,    0,    3021, 425,  0,    0,
    0,    1199, 0,    1052, 774,  0,    0,    1330, 1522, 318,  1524, 0,    1613, 0,    0,    0,
    0,    1814, 1273, 0,    3179, 0,    3307, 0,    261,  0,    0,    3340, 882,  368,  0,    1213,
    0,    0,    0,    0,    58,   1179, 0,    0,    0,    0,    651,  859,  3012, 0,    0,    1151,
    1403, 1341, 0,    525,  0,    2045, 3245, 0,    103,  0,    0,    0,    0,    0,    2931, 0,
    0,    42,   994,  0,    0,    2172, 2906, 0,    1473, 0,    1406, 652,  1184, 2707, 1121, 189,
    2394, 0,    766,  300,  0,    0,    0,    0,    0,    0,    0,    0,    1463, 2753, 0,    0,
    1720, 520,  0,    0,    2935, 0,    289,  1,    0,    1601, 0,    0,    0,    1213, 0,    725,
    0,    1424, 1146, 0,    1369, 330,  0,    0,    0,    0,    2250, 0,    3059, 0,    2619, 0,
    125,  0,    0,    1701, 0,    0,    0,    30,   0,    1725, 736,  0,    0,    0,    0,    0,
    0,    346,  775,  3208, 0,    0,    0,    0,    0,    0,    0,    0,    0,    1141, 3277, 0,
    0,    0,    659,  0,    653,  2044, 2397, 0,    1655, 1354, 0,    0,    1384, 2075, 0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    883,  454,  1515, 0,    877,  0,    0,    240,
    2,    0,    0,    0,    0,    0,    992,  0,    1095, 2784, 1696, 0,    0,    2126, 0,    3362,
    0,    395,  51,   0,    1868, 0,    1589, 2650, 0,    0,    229,  0,    628,  80,   0,    0,
    0,    93,   0,    0,    2306, 0,    0,    0,    0,    0,    0,    285,  435,  0,    0,    0,
    445,  1149, 0,    0,    82,   0,    1583, 0,    0,    820,  639,  479,  0,    757,  3313, 3109,
    0,    0,    205,  110,  0,    0,    0,    0,    0,    0,    0,    0,    0,    572,  2268, 1025,
    0,    0,    648,  0,    223,  0,    0,    0,    0,    0,    690,  883,  0,    692,  878,  0,
    1254, 1562, 0,    0,    613,  0,    0,    0,    0,    1306, 1247, 1026, 44,   0,    0,    0,
    0,    1510, 3218, 3212, 0,    0,    788,  163,  860,  0,    0,    0,    671,  0,    200,  2648,
    578,  1638, 2545, 0,    3278, 145,  0,    0,    0,    0,    0,    186,  0,    0,    1223, 3342,
    2578, 0,    0,    979,  0,    2955, 2790, 0,    0,    419,  0,    1897, 0,    0,    609,  1079,
    0,    0,    0,    2639, 1392, 1149, 144,  713,  0,    1242, 0,    196,  0,    0,    1359, 274,
    0,    0,    0,    2229, 834,  1428, 0,    135,  3338, 0,    848,  3204, 1373, 117,  2660, 0,
    3305, 981,  0,    1332, 0,    1627, 0,    186,  1069, 0,    1472, 532,  0,    0,    0,    3198,
    0,    0,    965,  0,    0,    560,  0,    0,    2243, 0,    0,    750,  2277, 0,    1432, 0,
    0,    0,    0,    0,    1456, 583,  347,  0,    1539, 0,    302,  0,    1574, 2811, 0,    3047,
    0,    0,    2236, 0,    0,    0,    648,  102,  846,  604,  795,  59,   1548, 0,    2288, 0,
    54,   0,    2563, 3228, 0,    1250, 1170, 3110, 853,  0,    3043, 0,    0,    2244, 0,    2900,
    0,    0,    1460, 569,  0,    0,    630,  0,    1516, 874,  270,  0,    0,    583,  2401, 531,
    1091, 638,  1379, 0,    0,    0,    0,    0,    818,  730,  3,    0,    0,    0,    0,    30,
    0,    0,    0,    775,  0,    0,    3049, 817,  403,  0,    0,    1093, 255,  210,  2244, 0,
    0,    0,    0,    358,  0,    0,    1359, 618,  3122, 0,    0,    3126, 457,  466,  1242, 0,
    108,  1185, 268,  120,  403,  42,   1326, 2127, 1216, 345,  823,  0,    0,    1600, 1312, 0,
    3185, 3179, 0,    0,    0,    2526, 0,    0,    0,    0,    1503, 0,    495,  1635, 0,    0,
    1324, 0,    1451, 423,  579,  0,    0,    0,    1542, 601,  0,    1874, 0,    1473, 887,  0,
    1239, 842,  3365, 0,    0,    382,  2954, 2,    0,    2321, 0,    0,    0,    263,  0,    569,
    0,    0,    0,    0,    1225, 0,    0,    1087, 345,  0,    197,  1738, 595,  0,    398,  1112,
    0,    0,    0,    0,    0,    0,    0,    754,  0,    0,    0,    0,    0,    2329, 0,    0,
    0,    3050, 0,    1560, 786,  3082, 414,  398,  803,  201,  885,  353,  0,    2294, 0,    233,
    703,  911,  938,  0,    0,    0,    0,    0,    0,    362,  0,    1445, 1076, 0,    550,  1384,
    0,    1118, 599,  0,    0,    1231, 0,    0,    0,    1633, 740,  0,    1102, 0,    0,    1906,
    2215, 693,  0,    2932, 2069, 0,    0,    0,    0,    2635, 34,   2834, 2977, 0,    691,  0,
    1370, 712,  559,  0,    450,  929,  3237, 3310, 1125, 0,    0,    0,    3045, 0,    3084, 2105,
    705,  0,    1926, 0,    469,  0,    0,    0,    2748, 0,    1089, 93,   0,    1600, 643,  0,
    3290, 1308, 0,    1299, 0,    0,    0,    0,    0,    306,  0,    0,    1384, 0,    0,    0,
    0,    0,    0,    1098, 1292, 0,    0,    346,  419,  0,    1508, 0,    1,    0,    0,    0,
    1680, 1191, 0,    580,  1561, 0,    1405, 719,  0,    0,    0,    1556, 0,    0,    1392, 0,
    0,    1502, 3098, 3027, 755,  679,  0,    0,    960,  241,  0,    2998, 0,    0,    0,    592,
    895,  0,    3,    1006, 1079, 2253, 0,    0,    0,    3185, 121,  0,    61,   1495, 2406, 1592,
    1238, 0,    0,    0,    0,    327,  0,    0,    0,    388,  0,    0,    0,    0,    557,  3200,
    0,    515,  0,    3384, 0,    0,    0,    0,    1461, 0,    2933, 0,    0,    978,  988,  0,
    619,  1905, 2933, 0,    274,  47,   183,  0,    1754, 1310, 0,    0,    60,   119,  0,    1115,
    806,  504,  0,    0,    3239, 0,    1391, 649,  0,    2532, 0,    0,    0,    720,  0,    1046,
    3189, 2979, 997,  2746, 0,    0,    781,  0,    78,   3348, 1667, 0,    9,    0,    778,  1023,
    943,  1330, 403,  855,  0,    1189, 750,  1515, 0,    908,  1472, 0,    610,  3175, 0,    1003,
    455,  319,  0,    1374, 0,    3362, 0,    1116, 1650, 2116, 1011, 575,  531,  1396, 0,    0,
    0,    0,    0,    1126, 0,    0,    680,  1880, 590,  0,    598,  2474, 0,    1286, 0,    0,
    0,    988,  566,  768,  1657, 1318, 0,    804,  2739, 473,  0,    0,    0,    0,    0,    94,
    0,    0,    0,    3314, 0,    541,  0,    0,    448,  251,  2433, 0,    320,  0,    0,    2952,
    184,  932,  0,    376,  0,    0,    2614, 0,    2269, 436,  1244, 1891, 0,    0,    341,  171,
    0,    667,  642,  445,  675,  304,  3242, 0,    1126, 422,  703,  570,  0,    0,    771,  0,
    653,  889,  781,  0,    1378, 643,  504,  0,    0,    0,    580,  0,    1408, 0,    3302, 2846,
    503,  2282, 1450, 1119, 1272, 98,   0,    0,    0,    0,    0,    1538, 3146, 240,  1071, 661,
    518,  391,  876,  3040, 0,    0,    0,    0,    265,  1221, 1852, 0,    637,  0,    2544, 0,
    0,    1586, 0,    0,    990,  0,    0,    2124, 1815, 0,    0,    0,    454,  0,    0,    103,
    0,    714,  3153, 199,  1400, 0,    559,  0,    575,  1118, 0,    2770, 0,    0,    1867, 2859,
    0,    1031, 1255, 1533, 3347, 0,    230,  0,    0,    0,    66,   0,    0,    1922, 0,    1573,
    0,    2571, 878,  0,    2345, 0,    914,  0,    18,   286,  0,    31,   0,    1021, 178,  2828,
    0,    880,  1482, 2938, 618,  616,  173,  0,    356,  2568, 2877, 1413, 3141, 0,    0,    3384,
    0,    0,    595,  0,    0,    3023, 3250, 0,    0,    106,  3167, 0,    1249, 1639, 556,  92,
    682,  0,    0,    0,    2578, 0,    171,  715,  0,    0,    0,    0,    0,    0,    526,  1110,
    0,    0,    132,  0,    0,    561,  0,    0,    102,  0,    0,    0,    709,  0,    0,    1807,
    604,  0,    2660, 1494, 174,  478,  283,  3084, 3199, 2962, 0,    528,  0,    0,    1294, 1301,
    0,    0,    0,    0,    280,  3105, 1058, 0,    0,    208,  2671, 1299, 1380, 0,    3068, 330,
    779,  0,    0,    0,    0,    1227, 0,    242,  0,    387,  0,    1185, 2876, 0,    463,  0,
    12,   22,   0,    310,  3184, 0,    549,  0,    0,    922,  0,    458,  3242, 374,  0,    1286,
    1578, 629,  1157, 74,   0,    311,  187,  2258, 1225, 31,   3209, 0,    989,  0,    0,    1145,
    2856, 121,  441,  0,    1119, 410,  1122, 0,    279,  424,  894,  0,    765,  0,    0,    621,
    289,  3257, 2187, 1354, 272,  3384, 3298, 0,    2254, 0,    3238, 0,    1343, 0,    0,    878,
    0,    0,    0,    1271, 0,    0,    966,  0,    2571, 0,    1296, 0,    0,    0,    2115, 0,
    0,    0,    0,    0,    1086, 361,  3099, 1113, 0,    877,  3103, 1096, 0,    496,  0,    0,
    1307, 0,    0,    0,    0,    0,    3114, 686,  2610, 0,    0,    3115, 634,  0,    40,   3137,
    1155, 173,  1277, 0,    3244, 318,  985,  306,  0,    1959, 0,    0,    1220, 1458, 826,  0,
    877,  560,  453,  0,    0,    647,  297,  3175, 0,    0,    225,  0,    0,    2169, 396,  2834,
    958,  0,    176,  1365, 1626, 2551, 0,    1260, 1159, 523,  0,    638,  0,    2599, 1652, 0,
    0,    1063, 0,    3255, 0,    1249, 0,    1056, 0,    991,  3384, 711,  390,  1123, 1803, 0,
    169,  1837, 700,  1120, 1048, 0,    104,  2405, 743,  510,  1288, 0,    2177, 1193, 239,  3136,
    2146, 402,  2159, 0,    891,  0,    0,    0,    0,    0,    1482, 162,  0,    1162, 1167, 1184,
    0,    2987, 0,    0,    0,    3277, 2208, 881,  0,    0,    144,  58,   0,    36,   3140, 0,
    0,    948,  128,  263,  0,    313,  0,    276,  1302, 42,   0,    0,    1862, 710,  518,  0,
    0,    2357, 77,   0,    1540, 3378, 0,    107,  0,    0,    2972, 0,    0,    0,    0,    593,
    404,  0,    0,    0,    1415, 0,    843,  0,    0,    0,    2375, 671,  0,    0,    1593, 0,
    0,    1310, 645,  0,    1374, 3100, 0,    0,    666,  0,    1338, 0,    0,    0,    0,    0,
    1234, 0,    780,  927,  0,    0,    17,   0,    1085, 3375, 0,    0,    3363, 2928, 512,  0,
    205,  2155, 0,    563,  586,  0,    0,    0,    0,    0,    1534, 1567, 0,    1587, 979,  1100,
    1686, 1510, 0,    84,   13,   1576, 0,    0,    1107, 444,  0,    1246, 3155, 2174, 490,  0,
    0,    469,  0,    719,  0,    1197, 0,    2049, 303,  1402, 0,    899,  626,  2668, 1280, 2678,
    1395, 0,    1154, 1776, 1573, 0,    0,    1075, 963,  0,    347,  1068, 0,    575,  157,  684,
    3222, 0,    0,    3054, 0,    1227, 0,    651,  0,    1467, 1488, 1155, 0,    1065, 0,    2991,
    2964, 0,    386,  228,  0,    642,  146,  343,  2896, 1082, 0,    0,    118,  423,  1162, 3283,
    0,    0,    1131, 3385, 527,  2698, 0,    1286, 0,    0,    0,    382,  114,  2038, 3151, 3275,
    757,  583,  1317, 0,    865,  0,    0,    0,    164,  0,    3107, 585,  1557, 0,    3315, 205,
    1550, 0,    2576, 3377, 0,    959,  1553, 3292, 1459, 2026, 0,    0,    0,    1298, 1610, 0,
    0,    0,    136,  0,    878,  0,    69,   1080, 0,    0,    0,    1543, 3181, 190,  0,    0,
    1026, 0,    1353, 420,  291,  3192, 1439, 1192, 0,    0,    544,  324,  0,    185,  1271, 859,
    1485, 0,    3380, 681,  1531, 3006, 0,    385,  3298, 0,    0,    763,  1356, 347,  187,  611,
    3386, 0,    1255, 0,    0,    0,    673,  0,    647,  184,  0,    0,    0,    0,    0,    0,
    0,    334,  479,  0,    420,  384,  0,    0,    0,    0,    1241, 0,    908,  3089, 769,  0,
    1143, 0,    764,  685,  0,    1201, 0,    926,  85,   0,    0,    343,  0,    0,    0,    612,
    835,  0,    1500, 1110, 861,  1101, 0,    326,  0,    298,  0,    3038, 635,  701,  470,  51,
    0,    0,    534,  0,    0,    0,    148,  0,    1129, 3022, 192,  1448, 3324, 0,    631,  991,
    2962, 0,    399,  0,    2576, 1423, 1941, 0,    1269, 0,    175,  1222, 0,    669,  214,  3295,
    0,    0,    733,  179,  0,    538,  667,  0,    1280, 805,  2918, 0,    446,  1069, 0,    0,
    0,    474,  1090, 0,    1315, 0,    1624, 517,  813,  1337, 861,  0,    0,    0,    394,  0,
    2724, 1309, 1165, 0,    439,  893,  405,  0,    2638, 0,    0,    0,    0,    0,    2001, 755,
    0,    0,    0,    587,  122,  0,    816,  1619, 0,    0,    0,    0,    0,    1233, 1243, 0,
    1019, 579,  0,    138,  0,    645,  1432, 2811, 0,    0,    0,    807,  0,    0,    2142, 3044,
    0,    969,  0,    1057, 0,    1366, 484,  0,    3058, 0,    196,  0,    0,    0,    51,   1604,
    0,    1245, 190,  2468, 754,  0,    0,    0,    0,    0,    0,    1662, 819,  2577, 3253, 371,
    785,  334,  1602, 0,    1506, 0,    81,   2486, 0,    0,    0,    1479, 815,  0,    0,    2300,
    3253, 0,    0,    0,    0,    0,    0,    0,    0,    323,  0,    3094, 0,    2908, 1187, 0,
    261,  654,  1044, 0,    3048, 3014, 0,    287,  0,    0,    0,    0,    231,  104,  878,  0,
    1067, 0,    0,    3161, 438,  0,    0,    1078, 2660, 0,    3149, 0,    0,    0,    0,    462,
    0,    2678, 0,    0,    0,    0,    0,    227,  0,    0,    1436, 1165, 2965, 242,  0,    0,
    210,  989,  0,    2744, 464,  3376, 0,    0,    0,    0,    0,    524,  1520, 2609, 1019, 0,
    612,  1497, 1541, 280,  1357, 2033, 0,    475,  805,  1059, 0,    232,  1517, 3087, 364,  1276,
    30,   0,    2329, 2943, 0,    0,    0,    3118, 3182, 0,    2670, 117,  951,  0,    484,  1030,
    0,    0,    1619, 886,  1108, 728,  1074, 845,  2703, 1405, 1629, 2624, 1703, 0,    0,    2861,
    1769, 620,  862,  0,    1013, 935,  1293, 1558, 1525, 0,    1212, 637,  2796, 1047, 1260, 3142,
    177,  0,    0,    0,    0,    1180, 174,  221,  306,  0,    1121, 2493, 105,  689,  1471, 3326,
    0,    0,    1041, 802,  0,    0,    0,    3066, 0,    0,    355,  0,    3044, 2314, 6,    2908,
    0,    75,   0,    734,  982,  2223, 0,    246,  1262, 950,  1201, 412,  1637, 0,    3226, 2368,
    570,  1587, 293,  1109, 0,    414,  1461, 0,    520,  2,    0,    0,    0,    0,    35,   0,
    3339, 1043, 443,  202,  0,    0,    576,  0,    0,    783,  0,    0,    1949, 1568, 0,    0,
    250,  0,    0,    2742, 0,    0,    0,    0,    428,  0,    928,  562,  696,  3079, 0,    431,
    0,    1636, 1031, 2363, 0,    1484, 1361, 187,  1106, 0,    1813, 148,  78,   684,  0,    0,
    0,    0,    0,    1597, 0,    490,  581,  365,  1525, 1774, 398,  1479, 369,  2560, 0,    0,
    1255, 0,    1603, 0,    562,  1033, 0,    679,  1369, 0,    0,    0,    0,    3316, 0,    0,
    0,    748,  0,    140,  442,  0,    351,  678,  634,  614,  0,    2055, 537,  0,    315,  0,
    1027, 0,    1389, 0,    690,  0,    1375, 1247, 17,   0,    973,  601,  2808, 833,  1569, 283,
    2924, 0,    0,    70,   0,    0,    0,    1480, 426,  1044, 0,    1377, 1200, 0,    869,  765,
    1474, 0,    718,  234,  247,  1061, 0,    193,  0,    3343, 0,    755,  34,   0,    0,    3160,
    2522, 846,  0,    0,    1481, 498,  1554, 0,    652,  1437, 315};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 3387;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 40)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 3387;
}

constexpr int unmangledkT1[] = {97,  232, 70,  143, 5,  244, 156, 165, 149, 104, 52,  212, 55,
                                198, 123, 166, 207, 15, 8,   16,  124, 239, 1,   141, 27,  12};
constexpr int unmangledkT2[] = {48, 53,  154, 47,  98,  132, 124, 230, 240, 185, 66, 210, 53,
                                31, 224, 146, 247, 121, 189, 168, 78,  241, 152, 70, 40,  220};
constexpr int unmangledkG[]  = {
    0,   70,  0,   0,   0,   153, 203, 210, 0,   220, 24,  0,   141, 0,   0,   0,   4,   75,
    0,   0,   0,   76,  0,   0,   266, 0,   0,   249, 102, 0,   125, 49,  196, 0,   62,  0,
    0,   239, 0,   0,   0,   0,   0,   12,  0,   24,  99,  83,  42,  74,  0,   0,   0,   120,
    0,   173, 0,   103, 0,   21,  0,   35,  127, 193, 24,  36,  56,  0,   179, 0,   214, 143,
    147, 0,   245, 8,   0,   43,  101, 244, 53,  0,   153, 0,   0,   135, 180, 216, 0,   241,
    0,   93,  223, 0,   0,   102, 50,  150, 118, 0,   259, 182, 0,   102, 83,  0,   52,  21,
    0,   245, 0,   0,   27,  38,  47,  0,   0,   0,   143, 0,   0,   91,  0,   0,   265, 133,
    0,   43,  0,   171, 0,   149, 0,   90,  130, 0,   106, 0,   0,   0,   8,   101, 146, 181,
    121, 0,   0,   148, 128, 142, 226, 258, 0,   60,  66,  94,  248, 106, 0,   0,   114, 220,
    5,   0,   245, 85,  55,  229, 216, 87,  0,   139, 0,   0,   56,  0,   152, 30,  152, 10,
    257, 0,   0,   0,   10,  54,  117, 0,   161, 241, 0,   32,  96,  0,   228, 0,   133, 237,
    251, 145, 0,   179, 82,  0,   0,   0,   0,   92,  47,  0,   239, 62,  119, 221, 91,  14,
    74,  0,   0,   0,   45,  0,   117, 0,   156, 145, 0,   47,  236, 6,   39,  43,  148, 231,
    0,   0,   40,  45,  118, 89,  62,  178, 0,   0,   122, 58,  190, 0,   219, 246, 113, 259,
    190, 64,  112, 171, 220, 33,  238, 136, 133, 0,   41,  0,   141, 0,   68};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 267;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 26)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 267;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
