// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gio_sys;
use glib::object::Cast;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;
use InetAddress;
use SocketAddress;
use SocketConnectable;

glib_wrapper! {
    pub struct InetSocketAddress(Object<gio_sys::GInetSocketAddress, gio_sys::GInetSocketAddressClass, InetSocketAddressClass>) @extends SocketAddress, @implements SocketConnectable;

    match fn {
        get_type => || gio_sys::g_inet_socket_address_get_type(),
    }
}

impl InetSocketAddress {
    pub fn new<P: IsA<InetAddress>>(address: &P, port: u16) -> InetSocketAddress {
        unsafe {
            SocketAddress::from_glib_full(gio_sys::g_inet_socket_address_new(
                address.as_ref().to_glib_none().0,
                port,
            ))
            .unsafe_cast()
        }
    }

    pub fn new_from_string(address: &str, port: u32) -> InetSocketAddress {
        unsafe {
            SocketAddress::from_glib_full(gio_sys::g_inet_socket_address_new_from_string(
                address.to_glib_none().0,
                port,
            ))
            .unsafe_cast()
        }
    }
}

unsafe impl Send for InetSocketAddress {}
unsafe impl Sync for InetSocketAddress {}

pub const NONE_INET_SOCKET_ADDRESS: Option<&InetSocketAddress> = None;

pub trait InetSocketAddressExt: 'static {
    fn get_address(&self) -> Option<InetAddress>;

    fn get_flowinfo(&self) -> u32;

    fn get_port(&self) -> u16;

    fn get_scope_id(&self) -> u32;
}

impl<O: IsA<InetSocketAddress>> InetSocketAddressExt for O {
    fn get_address(&self) -> Option<InetAddress> {
        unsafe {
            from_glib_none(gio_sys::g_inet_socket_address_get_address(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_flowinfo(&self) -> u32 {
        unsafe { gio_sys::g_inet_socket_address_get_flowinfo(self.as_ref().to_glib_none().0) }
    }

    fn get_port(&self) -> u16 {
        unsafe { gio_sys::g_inet_socket_address_get_port(self.as_ref().to_glib_none().0) }
    }

    fn get_scope_id(&self) -> u32 {
        unsafe { gio_sys::g_inet_socket_address_get_scope_id(self.as_ref().to_glib_none().0) }
    }
}

impl fmt::Display for InetSocketAddress {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "InetSocketAddress")
    }
}
