/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import netscape.ldap.util.BadFilterException;
import netscape.ldap.util.LDAPFilter;
import netscape.ldap.util.LDAPFilterList;
import netscape.ldap.util.LDAPIntFilterSet;

public class LDAPFilterDescriptor {
    private Vector<LDAPIntFilterSet> m_vFilterSet = new Vector();
    private String m_strLine;
    private int m_nLine;
    private String m_strPrefix;
    private String m_strAffix;
    private LDAPIntFilterSet m_tmpFilterSet = null;
    private String m_strLastMatchPattern = null;
    private String m_strLastDelimiter = null;
    private static final int DEFAULT_SCOPE = 2;

    public LDAPFilterDescriptor(String strFile) throws FileNotFoundException, BadFilterException {
        DataInputStream inputStream = new DataInputStream(new FileInputStream(strFile));
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        this.init(reader);
    }

    public LDAPFilterDescriptor(StringBuffer strBuffer) throws BadFilterException {
        this.init(strBuffer);
    }

    public LDAPFilterDescriptor(URL url) throws IOException, BadFilterException {
        URLConnection urlc = url.openConnection();
        DataInputStream inputStream = new DataInputStream(urlc.getInputStream());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        this.init(reader);
    }

    private void init(Object inputObj) throws BadFilterException {
        Pattern patData;
        Pattern patComment;
        String strCommentPattern = "^\\s*#|$";
        String strDataPattern = "\\s*(?:\"([^\"]*)\")|([^\\s]*)\\s*";
        Vector<String> vStrings = new Vector<String>(5);
        try {
            patComment = Pattern.compile(strCommentPattern);
            patData = Pattern.compile(strDataPattern);
        }
        catch (PatternSyntaxException e) {
            System.out.println("FATAL Error, couldn't compile pattern");
            System.out.println("  " + e.getMessage());
            return;
        }
        this.m_nLine = 0;
        try {
            if (inputObj instanceof StringBuffer) {
                StringBuffer ibuffer = (StringBuffer)inputObj;
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < ibuffer.length(); ++i) {
                    if (ibuffer.charAt(i) == '\n') {
                        this.m_strLine = buffer.toString();
                        ++this.m_nLine;
                        this.setFilter(patComment, patData, vStrings);
                        buffer = new StringBuffer();
                        continue;
                    }
                    buffer.append(ibuffer.charAt(i));
                }
            } else {
                while ((this.m_strLine = ((BufferedReader)inputObj).readLine()) != null) {
                    ++this.m_nLine;
                    this.setFilter(patComment, patData, vStrings);
                }
            }
            if (this.m_tmpFilterSet != null) {
                this.m_vFilterSet.addElement(this.m_tmpFilterSet);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setFilter(Pattern patComment, Pattern patData, Vector<String> vStrings) throws IOException, BadFilterException {
        LDAPFilter tmpFilter = null;
        if (!patComment.matcher(this.m_strLine).lookingAt()) {
            Matcher dataMatcher = patData.matcher(this.m_strLine);
            if (!vStrings.isEmpty()) {
                vStrings.removeAllElements();
            }
            while (dataMatcher.find()) {
                int groupCount = dataMatcher.groupCount();
                for (int i = 1; i <= groupCount; ++i) {
                    if (dataMatcher.group(i) == null || dataMatcher.group(i).equals("")) continue;
                    vStrings.addElement(dataMatcher.group(i));
                }
            }
            switch (vStrings.size()) {
                case 1: {
                    if (this.m_tmpFilterSet != null) {
                        this.m_vFilterSet.addElement(this.m_tmpFilterSet);
                    }
                    this.m_tmpFilterSet = new LDAPIntFilterSet(vStrings.elementAt(0));
                    break;
                }
                case 2: {
                    if (this.m_strLastMatchPattern != null && this.m_strLastDelimiter != null) {
                        tmpFilter = new LDAPFilter(this.m_strLastMatchPattern, this.m_strLastDelimiter, vStrings.elementAt(0), vStrings.elementAt(1), 2);
                        tmpFilter.setLine(this.m_nLine);
                        if (this.m_tmpFilterSet != null) {
                            this.m_tmpFilterSet.appendFilter(tmpFilter);
                            break;
                        }
                        throw this.MakeException("Attempting to add a filter to a null filterset");
                    }
                    throw this.MakeException("Attempting to create a relative filter with no preceeding full filter");
                }
                case 3: {
                    if (this.m_strLastMatchPattern != null && this.m_strLastDelimiter != null) {
                        tmpFilter = new LDAPFilter(this.m_strLastMatchPattern, this.m_strLastDelimiter, vStrings.elementAt(0), vStrings.elementAt(1), vStrings.elementAt(2));
                        tmpFilter.setLine(this.m_nLine);
                        if (this.m_tmpFilterSet != null) {
                            this.m_tmpFilterSet.appendFilter(tmpFilter);
                            break;
                        }
                        throw this.MakeException("Attempting to add a filter to a null filterset");
                    }
                    throw this.MakeException("Attempting to create a relative filter with no preceeding full filter");
                }
                case 4: {
                    tmpFilter = new LDAPFilter(vStrings.elementAt(0), vStrings.elementAt(1), vStrings.elementAt(2), vStrings.elementAt(3), 2);
                    tmpFilter.setLine(this.m_nLine);
                    this.m_strLastMatchPattern = vStrings.elementAt(0);
                    this.m_strLastDelimiter = vStrings.elementAt(1);
                    if (this.m_tmpFilterSet != null) {
                        this.m_tmpFilterSet.newFilter(tmpFilter);
                        break;
                    }
                    throw this.MakeException("Attempting to add a filter to a null filterset");
                }
                case 5: {
                    tmpFilter = new LDAPFilter(vStrings.elementAt(0), vStrings.elementAt(1), vStrings.elementAt(2), vStrings.elementAt(3), vStrings.elementAt(4));
                    tmpFilter.setLine(this.m_nLine);
                    this.m_strLastMatchPattern = vStrings.elementAt(0);
                    this.m_strLastDelimiter = vStrings.elementAt(1);
                    if (this.m_tmpFilterSet != null) {
                        this.m_tmpFilterSet.newFilter(tmpFilter);
                        break;
                    }
                    throw this.MakeException("Attempting to add a filter to a null filterset");
                }
                default: {
                    throw this.MakeException("Wrong number of tokens (" + vStrings.size() + ")");
                }
            }
        }
    }

    private BadFilterException MakeException(String strMsg) {
        return new BadFilterException("BadFilterException while creating Filters,\nLine Number: " + this.m_nLine + ",\n --> " + this.m_strLine + "\nThe error is: " + strMsg, this.m_nLine);
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(4000);
        for (int i = 0; i < this.m_vFilterSet.size(); ++i) {
            strBuf.append("Filter Set number: " + i + "\n");
            strBuf.append(this.m_vFilterSet.elementAt(i).toString() + "\n");
            strBuf.append("\n");
        }
        return strBuf.toString();
    }

    public LDAPFilterList getFilters(String strTagPat, String strValue) throws IllegalArgumentException {
        Pattern patTag;
        strTagPat = strTagPat.trim();
        strValue = strValue.trim();
        if (strTagPat == null || strTagPat.equals("")) {
            throw new IllegalArgumentException("The Tag Pattern can not be null");
        }
        if (strValue == null || strValue.equals("")) {
            throw new IllegalArgumentException("The Value can not be null");
        }
        LDAPFilterList retList = new LDAPFilterList();
        try {
            patTag = Pattern.compile(strTagPat);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("The parameter: " + strTagPat + " is not valid");
        }
        boolean bMatched = false;
        int i = 0;
        while (!bMatched) {
            Vector<LDAPFilter> vMatchingFilters = this.m_vFilterSet.elementAt(i).getFilters(patTag, strValue);
            if (vMatchingFilters.size() > 0) {
                for (int j = 0; j < vMatchingFilters.size(); ++j) {
                    LDAPFilter tmpFilter = (LDAPFilter)vMatchingFilters.elementAt(j).clone();
                    tmpFilter.setupFilter(strValue, this.m_strPrefix, this.m_strAffix);
                    bMatched = true;
                    retList.add(tmpFilter);
                }
                return retList;
            }
            ++i;
        }
        return null;
    }

    public void setFilterAffixes(String strPrefix, String strAffix) {
        this.m_strPrefix = strPrefix;
        this.m_strAffix = strAffix;
    }
}

