/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.math.BigInteger;
import org.mozilla.jss.ssl.SSLProtocolVariant;
import org.mozilla.jss.ssl.SSLSocket;
import org.mozilla.jss.ssl.SSLVersion;
import org.mozilla.jss.ssl.SSLVersionRange;

public class Policy {
    public static boolean ENFORCING_KEY_SIZES = false;
    public static int RSA_MINIMUM_KEY_SIZE = Policy.getRSAMinimumKeySize();
    public static BigInteger RSA_MINIMUM_PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    public static int DH_MINIMUM_KEY_SIZE = Policy.getDHMinimumKeySize();
    public static int DSA_MINIMUM_KEY_SIZE = Policy.getDSAMinimumKeySize();
    public static SSLVersionRange TLS_VERSION_RANGE = Policy.getTLSVersionRange();
    public static SSLVersion TLS_MINIMUM_VERSION = TLS_VERSION_RANGE.getMinVersion();
    public static SSLVersion TLS_MAXIMUM_VERSION = TLS_VERSION_RANGE.getMaxVersion();

    private static SSLVersionRange getTLSVersionRange() {
        SSLVersionRange range = new SSLVersionRange(SSLVersion.minSupported(), SSLVersion.maxSupported());
        try {
            return SSLSocket.boundSSLVersionRange(SSLProtocolVariant.STREAM, range);
        }
        catch (Exception e) {
            return range;
        }
    }

    private static native int getRSAMinimumKeySize();

    private static native int getDHMinimumKeySize();

    private static native int getDSAMinimumKeySize();
}

