/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertificatePolicySet;

public class PolicyConstraint {
    private static final byte TAG_SET = 0;
    private static final byte TAG_REQUIRE = 1;
    private static final byte TAG_INHIBIT = 2;
    private CertificatePolicySet set = null;
    private int require = -1;
    private int inhibit = -1;

    public PolicyConstraint(CertificatePolicySet set, int require, int inhibit) {
        this.set = set;
        this.require = require;
        this.inhibit = inhibit;
    }

    public PolicyConstraint(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Sequence tag missing for PolicyConstraint.");
        }
        DerInputStream in = val.data;
        block5: while (in != null && in.available() != 0) {
            DerValue next = in.getDerValue();
            switch (next.tag & 0x1F) {
                case 0: {
                    this.set = new CertificatePolicySet(next.data);
                    continue block5;
                }
                case 1: {
                    next = next.data.getDerValue();
                    this.require = next.getInteger().toInt();
                    continue block5;
                }
                case 2: {
                    next = next.data.getDerValue();
                    this.inhibit = next.getInteger().toInt();
                    continue block5;
                }
            }
            throw new IOException("Invalid tag option for PolicyConstraint.");
        }
    }

    public String toString() {
        String s = this.set != null ? "PolicyConstraint: [\n  PolicySet:[" + this.set.toString() + "]\n  Require:" + this.require + "\n  Inhibit:" + this.inhibit + "\n]\n" : "PolicyConstraint: [\n  PolicySet:[null]\n  Require:" + this.require + "\n  Inhibit:" + this.inhibit + "\n]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp;
        DerOutputStream tagged = new DerOutputStream();
        if (this.set != null) {
            tmp = new DerOutputStream();
            this.set.encode(tmp);
            tagged.write(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        }
        if (this.require != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(new BigInt(this.require));
            tagged.write(DerValue.createTag((byte)-128, true, (byte)1), tmp);
        }
        if (this.inhibit != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(new BigInt(this.inhibit));
            tagged.write(DerValue.createTag((byte)-128, true, (byte)2), tmp);
        }
        out.write((byte)48, tagged);
    }
}

